

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerSetCostThreshold.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerSetCostThreshold.sp,v $ $Id: SQLServerSetCostThreshold.sp,v 1.1.2.1 2020/12/07 15:27:11 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLServerSetCostThreshold')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerSetCostThreshold <<<'
	drop procedure SQLServerSetCostThreshold
END
IF EXISTS (select * from GxQscripts where name='SQLServerSetCostThreshold')
	delete from GxQscripts where name = 'SQLServerSetCostThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerSetCostThreshold')
	delete from GXDBVersions where aliasname = 'SQLServerSetCostThreshold'
GO
print '... Creating Procedure: SQLServerSetCostThreshold'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLServerSetCostThreshold
--  User Input arguments
-- opType Settings:
--		1 - compute and set default Default Cost Threshold
--		2 - override Cost Threshold with inputted value and @inCostThreshold is required >=20 and <=50
  @opType INT = 1,
-- -1 means not set
  @inCostThreshold INT = -1,
  @help INT = 0
AS
BEGIN
	SET NOCOUNT ON
	IF (@help <> 0)
	BEGIN
		PRINT 'Usage: '
		PRINT '	EXEC SQLServerSetCostThreshold @opType=1, @inCostThreshold=-1, @help=0'
		PRINT '		@opType: '
		PRINT '			1 - compute and set default MAXDOP'
		PRINT '			2 - override Cost Threshold with inputted value, requires @inCostThreshold >=20 and <=50'
		PRINT '		@inCostThreshold: >=20 and <= 50 required if @opType=2'
		PRINT '		@help: This usage message if <> 0'
		RETURN 0
	END
	-- Validate inputs
	IF (@opType NOT IN (1,2))
	BEGIN
		PRINT 'SQLServerSetCostThreshold: Error - invalid @opType'
		RETURN 1
	END
	IF (@opType = 2 AND (@inCostThreshold < 20 OR @inCostThreshold > 50))
	BEGIN
		PRINT 'SQLServerSetCostThreshold: Error - invalid @inCostThreshold <20 OR >50'
		RETURN 1
	END
	-- Local Variables
	DECLARE @sqlCmd NVARCHAR(MAX) = N''
	DECLARE @sqlReConfig NVARCHAR(32) = 'RECONFIGURE WITH OVERRIDE;'
	DECLARE @rc INT = 0
	DECLARE @sqlConfigXML XML = NULL
	DECLARE @sqlConfigId INT = NULL
	DECLARE @xmlCfgCostThres INT = 0
	DECLARE @xmlCfgDT DATETIME
	DECLARE @xmlCfgOpType INT = -1
	DECLARE @nowDT DATETIME = GETUTCDATE()
	DECLARE @now INT = DATEDIFF(SECOND, '01/01/1970', @nowDT)
	DECLARE @ComputedCostThres INT = 0
	DECLARE @SetCostThres INT = 0
	DECLARE @sqlCostThres INT
	DECLARE @sqlAdvOpt INT
	-- Warnings
	DECLARE @sqlAffinity INT = NULL
	DECLARE @sqlAffinity64 INT = NULL
	DECLARE @sqlCPUBoost INT = NULL
	DECLARE @xmlAffinity XML = NULL
	DECLARE @xmlCPUBoost XML = NULL
	DECLARE @csDbName SYSNAME = 'commserv'
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	-- Will only compute Cost Threshold on SQL Server 2014+
	IF (@releaseNumber < 12)    -- 12->SQL2014
	BEGIN
		PRINT 'SQLServerSetCostThreshold: usage not supported on this version of SQL Server'
		RETURN 1
	END
	-- Get current SQL Server Config XML Document for CSDb and parse it
	IF (DB_NAME() = @csDbName)
	BEGIN
		-- Since SP may be in another CV database, create SQL script to commserv database value
		SET @sqlCmd = N'
			SELECT
				@sqlConfigId = g.id,
				@sqlConfigXML = g.value
			FROM GXGlobalParam g WITH(NOLOCK)
			WHERE
				g.name = N''SQLServerConfigXML''
				AND g.modified = 0
		'
		EXEC @rc = sp_executesql @stmt = @sqlCmd, @params = N'@sqlConfigXML XML OUTPUT, @sqlConfigId INT OUTPUT', @sqlConfigXML = @sqlConfigXML OUTPUT, @sqlConfigId = @sqlConfigId OUTPUT
		--SELECT @sqlConfigXML insqlConfigXML
		IF (@rc = 0 AND @sqlConfigXML IS NOT NULL)
		BEGIN
			SELECT
				@xmlCfgDT = s.value('@DateTime', 'DATETIME'),
				@xmlCfgOpType = s.value('@OpType', 'INT'),
				@xmlCfgCostThres = s.value('@CostThreshold', 'INT')
			FROM
				@sqlConfigXML.nodes('/SQLServerConfigSettings/CostThreshold') d(s)
		END
	END
	-- Get current CPU Affinity Settings
	SELECT
		@sqlAffinity = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'affinity mask'
	SELECT
		@sqlAffinity64 = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'affinity64 mask'
	IF (@sqlAffinity > 0 OR @sqlAffinity64 > 0)
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Warning manual Processor Affinity configured on this SQL Server'
		SET @xmlAffinity = (
			SELECT
				@nowDT '@DateTime',
				'Warning' '@message',
				@sqlAffinity '@affinityMask',
				@sqlAffinity64 '@affinity64Mask'
			FOR XML PATH('CPUAffinity'), TYPE
		)
	END
	-- Get current CPU Priority Boost
	SELECT
		@sqlCPUBoost = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'priority boost'
	IF (@sqlCPUBoost > 0)
	BEGIN
		PRINT 'SQLServerSetMAXDOP: Warning CPU Priority Boost configured on this SQL Server'
		SET @xmlCPUBoost = (
			SELECT
				@nowDT '@DateTime',
				'Warning' '@message',
				@sqlCPUBoost '@priorityBoost'
			FOR XML PATH('CPUBoost'), TYPE
		)
	END
	-- Get the currently set SQL Server Cost Threshold
	SELECT
		@sqlCostThres = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'cost threshold for parallelism'
	-- May need to enable this option to change MAXDOP
	SELECT
		@sqlAdvOpt = CAST(value_in_use AS INT)
	FROM master.sys.configurations
	WHERE
		name = 'show advanced options'
	-- If Cost Threshold default to 5 increase to 20 by default
	-- Perform the requested operation type
	IF (@opType = 1)
	BEGIN
		SET @SetCostThres = (
			CASE
				WHEN @sqlCostThres <= 5 THEN 20		-- SQL default configure changing
				WHEN @xmlCfgCostThres <> @sqlCostThres THEN @sqlCostThres		-- someone has tuned SQL Server outside of this utility leave it
				ELSE @sqlCostThres	-- equal and nothing to change
			END
		)
	END
	ELSE
	BEGIN
		-- Override Cost Threshold Setting
		-- Validate the inputted MAXDOP does not exceed CPUs on NUMAs
		SET @SetCostThres = @inCostThreshold
	END
	--SELECT @SetCostThres SetCostThres
	-- Set SQL Server Cost Threshold
	IF (@SetCostThres <> @sqlCostThres)
	BEGIN
		-- Value to set is different then the current running SQL Server Cost Threshold
		IF (@sqlAdvOpt <> 1)
		BEGIN
			-- Need to enable this option to change Cost Threshold
			SET @sqlCmd = 'EXEC sp_configure ''show advanced options'', 1;'
			EXEC(@sqlCmd)
			EXEC(@sqlReConfig)
		END
		SET @sqlCmd = 'EXEC sp_configure ''cost threshold for parallelism'', ' + CAST(@SetCostThres AS NVARCHAR(12)) + ';'
		EXEC(@sqlCmd)
		EXEC(@sqlReConfig)
		IF (@sqlAdvOpt <> 1)
		BEGIN
			-- Need to disable this option back to its default setting
			SET @sqlCmd = 'EXEC sp_configure ''show advanced options'', 0;'
			EXEC(@sqlCmd)
			EXEC(@sqlReConfig)
		END
	END
	ELSE
	BEGIN
		-- values are equal nothing to change
		PRINT 'SQLServerSetCostThreshold: Current running SQL Server Cost Threshold is fine!'
		IF (@sqlConfigXML IS NOT NULL)
		BEGIN
			RETURN 0
		END
	END
	-- Update Commserv GXGlobalParam Configuration for SQLServerConfigXML
	DECLARE @insXMLCfg TINYINT = 0
	IF (DB_NAME() = @csDbName)
	BEGIN
		IF (@sqlConfigXML IS NULL)
		BEGIN
			SET @sqlConfigXML = (
				SELECT
					@nowDT '@DateTime',
					@opType '@OpType',
					@SetCostThres '@CostThreshold'
				FOR XML PATH('CostThreshold'), ROOT('SQLServerConfigSettings'), TYPE
			)
			SET @insXMLCfg = 1
		END
		ELSE
		BEGIN
			IF (@SetCostThres <> @sqlCostThres)
			BEGIN
				DECLARE @costThresXML XML
				SET @costThresXML = (
					SELECT
						@nowDT '@DateTime',
						@opType '@OpType',
						@SetCostThres '@CostThreshold'
					FOR XML PATH('CostThreshold'), TYPE
				)
				IF (@xmlCfgOpType <> -1)
				BEGIN
					-- Delete existing Cost Threshold node from SQLServerConfigSettings XML
					SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/CostThreshold)[1]')
				END
				-- Insert new node
				SET @sqlConfigXML.modify('insert sql:variable("@costThresXML") into (/SQLServerConfigSettings)[1]')
				SET @sqlCmd = N'
					UPDATE g
						SET modified = ' + CAST(@now AS NVARCHAR(12)) +  N'
					FROM GXGlobalParam g WITH(NOLOCK)
					WHERE
						g.id = ' + CAST(@sqlConfigId AS NVARCHAR(12)) + N'
				'
				EXEC @rc = sp_executesql @stmt = @sqlCmd
				SET @insXMLCfg = 1
			END
		END
		--SELECT @sqlConfigXML sqlConfigXML
		IF (@sqlConfigXML IS NOT NULL)
		BEGIN
			SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/CPUAffinity)[1]')
			SET @sqlConfigXML.modify('insert sql:variable("@xmlAffinity") into (/SQLServerConfigSettings)[1]')
		END
		IF (@xmlCPUBoost IS NOT NULL)
		BEGIN
			SET @sqlConfigXML.modify('delete (/SQLServerConfigSettings/CPUBoost)[1]')
			SET @sqlConfigXML.modify('insert sql:variable("@xmlCPUBoost") into (/SQLServerConfigSettings)[1]')
		END
		IF (@insXMLCfg = 1)
		BEGIN
			SET @sqlCmd = N'
				INSERT INTO GXGlobalParam (name, value, created, modified)
					VALUES (N''SQLServerConfigXML'', ''' + CAST(@sqlConfigXML AS NVARCHAR(MAX)) + N''', ' +  CAST(@now AS NVARCHAR(12)) + N', 0)
			'
			EXEC @rc = sp_executesql @stmt = @sqlCmd
		END
	END
	RETURN 0
END

IF EXISTS (select * from GxQscripts where name = 'SQLServerSetCostThreshold')
	delete from GxQscripts where name = 'SQLServerSetCostThreshold'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerSetCostThreshold')
	delete from GXDBVersions where aliasname = 'SQLServerSetCostThreshold'
GO

insert into GXDBVersions values(2, 'SQLServerSetCostThreshold',  '00010001000200010000', 'SQLServerSetCostThreshold', '00010001000200010000')
GO

