

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerRelocateTempDb.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerRelocateTempDb.sp,v $ $Id: SQLServerRelocateTempDb.sp,v 1.1.2.3 2020/11/06 19:13:07 abilbrey Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLServerRelocateTempDb')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerRelocateTempDb <<<'
	drop procedure SQLServerRelocateTempDb
END
IF EXISTS (select * from GxQscripts where name='SQLServerRelocateTempDb')
	delete from GxQscripts where name = 'SQLServerRelocateTempDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerRelocateTempDb')
	delete from GXDBVersions where aliasname = 'SQLServerRelocateTempDb'
GO
print '... Creating Procedure: SQLServerRelocateTempDb'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLServerRelocateTempDb
  @path NVARCHAR(512),
  @help INT = 0
AS
SET NOCOUNT ON
BEGIN
	-- This SP is used to move the TempDb data and log files from their current folder to a new drive and / or folder
	IF (@help <> 0)
	BEGIN
		PRINT 'SQLServerRelocateTempDb Usage:
	@path - Required argument and must be a valid directory path and contain no other files or directories.
	        It is the new directory location that TempDb will be moved to.  After reconfiguring TempDb to
			the new location, SQL Server must be restarted to complete the actual TempDb move.
	@help=1 - Prints the usage message.
'
		RETURN 0
	END
	-- Determine if Windows or Linux SQL Server
	DECLARE @windows TINYINT = 1
    DECLARE @linux TINYINT = 2
    DECLARE @AruzeSQLMangedInstance TINYINT = 3
	DECLARE @sqlVersion		NVARCHAR(MAX),
			@osType			TINYINT,
			@newLine		NVARCHAR(4),
			@pathSep		NVARCHAR(2)
	EXEC SQLServerOSType @sqlVersion OUTPUT, @osType OUTPUT, @newLine OUTPUT, @pathSep OUTPUT
	DECLARE @errorMsg	NVARCHAR(1024) = N''
	DECLARE @errorCode	INT = 0
	IF (@osType = @AruzeSQLMangedInstance)
	BEGIN
		SET @errorMsg = N'SQLServerRelocateTempDb: No TempDb on Azure SQL Managed Instance'
		SET @errorCode = 1
		PRINT @errorMsg
		SELECT @errorCode errorCode, @errorMsg errorMsg
		RETURN @errorCode
	END
	IF (@path <> N'')
	BEGIN
		DECLARE @sepPos INT = 0
		IF (@osType = @windows)
		BEGIN
			-- Search for Linux separator
			SET @sepPos = CHARINDEX(N'/', @path, 0)
			IF (@sepPos > 0)
			BEGIN
				SET @errorMsg = N'SQLServerRelocateTempDb: Windows TempDb Path contains Linux Separators [' + @path + ']'
				SET @errorCode = 1
			END
		END
		ELSE
		BEGIN
			-- Search for Windows separator
			SET @sepPos = CHARINDEX(N'\', @path, 0)
			IF (@sepPos > 0)
			BEGIN
				SET @errorMsg = N'SQLServerRelocateTempDb: Linux TempDb Path contains Windows Separators [' + @path + ']'
				SET @errorCode = 1
			END
		END
		IF (@errorCode <> 0)
		BEGIN
			PRINT @errorMsg
			SELECT @errorCode errorCode, @errorMsg errorMsg
			RETURN @errorCode
		END
	END
	-- Verify the inputted directory path exists
	DECLARE @FileExists TABLE (
		fileExists		INT,
		dirExists		INT,
		parentExists	INT
	)
	INSERT INTO @FileExists (fileExists, dirExists, parentExists)
		EXEC master.dbo.xp_fileexist @path
	DECLARE @dirExists INT = 0
	SELECT TOP 1
		@dirExists = dirExists
	FROM @FileExists
	IF (@dirExists <> 1)
	BEGIN
		SET @errorMsg = N'SQLServerRelocateTempDb: Directory does not exists [' + @path + N']'
		SET @errorCode = 1
		PRINT @errorMsg
		SELECT @errorCode errorCode, @errorMsg errorMsg
		RETURN @errorCode
	END
	-- Verify that folder is empty, do not want to move TempDb data and log files to a folder with other files present.
	IF OBJECT_ID('TempDb..#files') IS NOT NULL
		DROP TABLE #files
	CREATE TABLE #files (
		filename		NVARCHAR(512),
		depth			INT,
		fileType		INT
	)
	INSERT INTO #files (filename, depth, fileType)
		EXEC master.dbo.xp_dirtree @path, 1, 1
	IF EXISTS(SELECT 1 FROM #files)
	BEGIN
		-- Folder is NOT empty
		SET @errorMsg = N'SQLServerRelocateTempDb: Directory contains other files and for TempDb files it must be empty [' + @path + N']'
		SET @errorCode = 1
		PRINT @errorMsg
		SELECT @errorCode errorCode, @errorMsg errorMsg
		RETURN @errorCode
	END
	-- Does path end with \ or /?
	DECLARE @lastChar NVARCHAR(5)
	SET @lastChar = SUBSTRING(@path, LEN(@path), 1)
	IF (@lastChar <> @pathSep)
	BEGIN
		SET @path += @pathSep		-- adding \ to end of directory path
	END
	-- Generate TempDb ALTER DATABASE commands to move TempDb data and log files
	DECLARE @sqlCmd NVARCHAR(MAX) = N''
	SELECT
		@sqlCmd += N' ALTER DATABASE tempdb MODIFY FILE (NAME = [' + f.name + N'],'
				+ ' FILENAME = ''' + @path + f.name
				+ CASE WHEN f.type = 1 THEN N'.ldf' ELSE N'.mdf' END
				+ N''') ; ' + @newLine
	FROM sys.master_files f
	WHERE f.database_id = DB_ID(N'tempdb');
	PRINT N'SQLServerRelocateTempDb: TempDb move SQL Command statement [
' + @sqlCmd + N'
]'
	-- Execute it!
	BEGIN TRY
		EXEC(@sqlCmd)
	END TRY
	BEGIN CATCH
		--(CATCH_HANDLING_MACRO)
		SET @errorCode = 1
		SET @errorMsg = 'INSIDE CATCH BLOCK WITH FOLLOWING ERROR: ' + @newLine
		SET @errorMsg += '   ERROR CODE: ' + CAST(ERROR_NUMBER() AS NVARCHAR(12)) + @newLine
		SET @errorMsg += '   SQL SCRIPT: SQLServerRelocateTempDb' + @newLine
		SET @errorMsg += '   ERROR LINE NO: ' + CAST(ERROR_LINE() AS NVARCHAR(12)) + @newLine
		SET @errorMsg += '   ERROR MESSAGE: ' + ERROR_MESSAGE() + @newLine
		SET @errorMsg += '   ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS NVARCHAR(12)) + @newLine
		SET @errorMsg += '   ERROR STATE: ' + CAST(ERROR_STATE() AS NVARCHAR(12)) + @newLine + @newLine
		PRINT @errorMsg
		SELECT @errorCode errorCode, @errorMsg errorMsg
		RETURN @errorCode
	END CATCH
	PRINT N'SQLServerRelocateTempDb: Note SQL Server now requires a restart for TempDb files to be actually moved. New TempDb Path [' + @path + N']'
	SET @errorMsg = N'Success: Note SQL Server now requires a restart for TempDb files to be actually moved. New TempDb Path [' + @path + N']'
	SELECT @errorCode errorCode, @errorMsg errorMsg
	RETURN @errorCode
END
GO

IF EXISTS (select * from GxQscripts where name = 'SQLServerRelocateTempDb')
	delete from GxQscripts where name = 'SQLServerRelocateTempDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerRelocateTempDb')
	delete from GXDBVersions where aliasname = 'SQLServerRelocateTempDb'
GO

insert into GXDBVersions values(2, 'SQLServerRelocateTempDb',  '00010001000200030000', 'SQLServerRelocateTempDb', '00010001000200030000')
GO

