

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerOSType.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerOSType.sp,v $ $Id: SQLServerOSType.sp,v 1.1.2.2 2020/11/06 19:13:10 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLServerOSType')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerOSType <<<'
	drop procedure SQLServerOSType
END
IF EXISTS (select * from GxQscripts where name='SQLServerOSType')
	delete from GxQscripts where name = 'SQLServerOSType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerOSType')
	delete from GXDBVersions where aliasname = 'SQLServerOSType'
GO
print '... Creating Procedure: SQLServerOSType'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLServerOSType
  @sqlVersion NVARCHAR(MAX) OUTPUT,
-- windows=1, linux=2, AruzeSQLMangedInstance=3
  @osType TINYINT OUTPUT,
  @newLine NVARCHAR(4) OUTPUT,
  @pathSep NVARCHAR(2) OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	-- Is this Azure SQL Managed Instance
	DECLARE @isAzure TINYINT = IIF((CAST(SERVERPROPERTY('EngineEdition') AS TINYINT) = 8), 1, 0)
	-- Determine if Windows, Linux, or Azure SQL Server
	DECLARE @windows TINYINT = 1
    DECLARE @linux TINYINT = 2
	DECLARE @AruzeSQLMangedInstance TINYINT = 3
	SET @sqlVersion = @@VERSION
	IF (@isAzure = 0)
	BEGIN
		SET @osType = IIF((@sqlVersion LIKE '%Linux%'), @linux, @windows)
		SET @newLine = IIF((@osType = @windows), (NCHAR(13) + NCHAR(10)), NCHAR(10))        -- CRLF(Windows), LF(Linux newline)
		SET @pathSep = IIF((@osType = @windows), N'\', N'/')
	END
	ELSE
	BEGIN
		SET @osType = @AruzeSQLMangedInstance
		SET @newLine = NCHAR(13) + NCHAR(10)
		SET @pathSep = N'/'	--Azure Blob separator is like URL
	END
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'SQLServerOSType')
	delete from GxQscripts where name = 'SQLServerOSType'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerOSType')
	delete from GXDBVersions where aliasname = 'SQLServerOSType'
GO

insert into GXDBVersions values(2, 'SQLServerOSType',  '00010001000200020000', 'SQLServerOSType', '00010001000200020000')
GO

