

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerConfigurationXMLMonitor.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerConfigurationXMLMonitor.sp,v $ $Id: SQLServerConfigurationXMLMonitor.sp,v 1.1.2.1 2020/05/15 18:45:33 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SQLServerConfigurationXMLMonitor')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerConfigurationXMLMonitor <<<'
	drop procedure SQLServerConfigurationXMLMonitor
END
IF EXISTS (select * from GxQscripts where name='SQLServerConfigurationXMLMonitor')
	delete from GxQscripts where name = 'SQLServerConfigurationXMLMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerConfigurationXMLMonitor')
	delete from GXDBVersions where aliasname = 'SQLServerConfigurationXMLMonitor'
GO
print '... Creating Procedure: SQLServerConfigurationXMLMonitor'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SQLServerConfigurationXMLMonitor
  @errorCode INT OUTPUT,
  @errorMsg VARCHAR(1024) OUTPUT,
  @allowXpCmdShell INT = 1
AS
BEGIN
	SET NOCOUNT ON
	SET @errorCode = 0
	SET @errorMsg = 'Success'
	-- Get SQL Server Configuration XML document
	DECLARE @output XML
	DECLARE @noXP INT = IIF(@allowXpCmdShell = 1, 0, 1)
	EXEC SQLServerConfigurationXML
				@i_collectIndexFrag = 1,
				@i_noCmdShellExe = @noXP,
				@i_isOutputXML = 1,
				@i_outputXML = @output OUTPUT
	BEGIN TRY
		DECLARE @nowUTC DATETIME = GETUTCDATE()
		DECLARE @nowUnix INT = dbo.GetUnixTime(@nowUTC)
		DECLARE @ninetyDaysAgo DATETIME = DATEADD(day, -90, @nowUTC)
		DECLARE @pruneDt INT = dbo.GetUnixTime(@ninetyDaysAgo)
		BEGIN TRAN SQLServerCfgXMLMonitorTran
		UPDATE gp
			SET modified = @nowUnix
		FROM GXGlobalParam gp
		WHERE
			gp.name = N'SQLServerConfigurationXMLMonitor'
			AND gp.modified = 0
		-- Age off old data
		DELETE gp
		FROM GXGlobalParam gp
		WHERE
			gp.name = N'SQLServerConfigurationXMLMonitor'
			AND gp.modified <= @pruneDt
		INSERT INTO GXGlobalParam (name, value, created, modified)
			VALUES (N'SQLServerConfigurationXMLMonitor', CAST(@output AS NVARCHAR(MAX)), @nowUnix, 0)
		COMMIT TRAN SQLServerCfgXMLMonitorTran
	END TRY
	BEGIN CATCH
		ROLLBACK TRAN SQLServerCfgXMLMonitorTran
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorMsg = ERROR_MESSAGE()
		RETURN 1
	END CATCH
	RETURN 0
END

IF EXISTS (select * from GxQscripts where name = 'SQLServerConfigurationXMLMonitor')
	delete from GxQscripts where name = 'SQLServerConfigurationXMLMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerConfigurationXMLMonitor')
	delete from GXDBVersions where aliasname = 'SQLServerConfigurationXMLMonitor'
GO

insert into GXDBVersions values(2, 'SQLServerConfigurationXMLMonitor',  '00010001000200010000', 'SQLServerConfigurationXMLMonitor', '00010001000200010000')
GO

