

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerConfigurationXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerConfigurationXML.sp,v $ $Id: SQLServerConfigurationXML.sp,v 1.1.2.18 2020/12/19 05:03:21 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLServerConfigurationXML')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerConfigurationXML <<<'
	drop procedure SQLServerConfigurationXML
END
IF EXISTS (select * from GxQscripts where name='SQLServerConfigurationXML')
	delete from GxQscripts where name = 'SQLServerConfigurationXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerConfigurationXML')
	delete from GXDBVersions where aliasname = 'SQLServerConfigurationXML'
GO
print '... Creating Procedure: SQLServerConfigurationXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLServerConfigurationXML
  @i_collectIndexFrag INT = 0,
  @i_noCmdShellExe INT = 0,
  @i_isOutputXML INT = 0,
  @i_outputXML XML = NULL OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @outputXml XML = NULL;
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	-- Determine if Windows, Linux, Azure SQL Server
	DECLARE @windows TINYINT = 1
    DECLARE @linux TINYINT = 2
    DECLARE @AruzeSQLMangedInstance TINYINT = 3
	DECLARE @sqlVersion		NVARCHAR(MAX),
			@osType			TINYINT,
			@newLine		NVARCHAR(4),
			@pathSep		NVARCHAR(2)
	EXEC SQLServerOSType @sqlVersion OUTPUT, @osType OUTPUT, @newLine OUTPUT, @pathSep OUTPUT
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	-- Determine OS Platform
	DECLARE @osPlatform NVARCHAR(32)
	DECLARE @osName NVARCHAR(128)
	DECLARE @osRelease NVARCHAR(32)
	IF (@releaseNumber >= 14)		-- SQL 2017+
	BEGIN
		SELECT
			@osPlatform = os. host_platform,
			@osName = os.host_distribution,
			@osRelease = os.host_release
		FROM sys.dm_os_host_info os WITH(NOLOCK)
	END
	DECLARE @rcnt INT = 0
	DECLARE @now DATETIME = GETUTCDATE()
	DECLARE @SocketCount INT = 0;
	DECLARE @PhyicalCoreCount INT = 0;
	DECLARE @LogicalCoreCount INT = 0;
	DECLARE @TotalRAMGb BIGINT = 0;
	DECLARE @SqlSeverMaxDOPCurrent INT = 0;
	DECLARE @MaxSqlServerMemoryCurrent INT = 0;
	DECLARE @MinSqlServerMemoryCurrent INT = 0;
	DECLARE @ManageVolumePriv INT = 0;
	DECLARE @MaxWorkerThreads INT = 0;
	DECLARE @SqlSeverCostThresholdCurrent INT = 0;
	DECLARE @SqlSeverPriorityBoostCurrent INT = 0;
	DECLARE @SystemInfo XML
	DECLARE @cpuType VARCHAR(256) = ''
	DECLARE @systemType VARCHAR(256) = ''
	DECLARE @maker VARCHAR(256) = ''
	DECLARE @biosDate VARCHAR(256) = ''
	DECLARE @cvHome1 VARCHAR(512) = ''
	DECLARE @cvHome2 VARCHAR(512) = ''
	DECLARE @evHome1 VARCHAR(512) = ''
	DECLARE @evHome2 VARCHAR(512) = ''
	IF (@osType = @windows)
	BEGIN
		IF OBJECT_ID ('master.sys.xp_regread') IS NOT NULL
		BEGIN
			-- Get Hardware Platform Information
			EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
									   @key = 'HARDWARE\DESCRIPTION\System\CentralProcessor\0',
									   @value_name = 'ProcessorNameString',
									   @value = @cpuType OUTPUT;
			EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
									   @key = 'HARDWARE\DESCRIPTION\System\BIOS',
									   @value_name = 'SystemProductName',
									   @value = @systemType OUTPUT;
			EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
									   @key = 'HARDWARE\DESCRIPTION\System\BIOS',
									   @value_name = 'BIOSReleaseDate',
									   @value = @biosDate OUTPUT;
			EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
									   @key = 'HARDWARE\DESCRIPTION\System\BIOS',
									   @value_name = 'SystemManufacturer',
									   @value = @maker OUTPUT;
			SET @SystemInfo = (
				SELECT
					@maker '@Manufacturer',
					@systemType '@System',
					@cpuType '@CPUInfo',
					@biosDate '@BIOSDate'
				FOR XML PATH ('Hardware'), TYPE
			)
			-- Get Application Folder Paths
			EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
									   @key = 'SOFTWARE\CommVault Systems\Galaxy\Instance001\Base',
									   @value_name = 'dBASEHOME',
									   @value = @cvHome1 OUTPUT;
			-- Check if path exist and variable set before reading others needed
			IF (@cvHome1 IS NOT NULL AND @cvHome1 <> '')
			BEGIN
				EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
										   @key = 'SOFTWARE\CommVault Systems\Galaxy\Instance002\Base',
										   @value_name = 'dBASEHOME',
										   @value = @cvHome2 OUTPUT;
				EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
										   @key = 'SOFTWARE\CommVault Systems\Galaxy\Instance001\EventManager',
										   @value_name = 'dEVLOGDIR',
										   @value = @evHome1 OUTPUT;
				EXEC master.sys.xp_regread @rootkey = 'HKEY_LOCAL_MACHINE',
										   @key = 'SOFTWARE\CommVault Systems\Galaxy\Instance002\EventManager',
										   @value_name = 'dEVLOGDIR',
										   @value = @evHome2 OUTPUT;
			END
		END
	END
	-- Azure and Linux does not support registry SPs
	--ELSE IF (@osType = @linux)
	--BEGIN
	--END
	--  see if xp_cmdshell is enabled, so we can try to use PowerShell to determine the real core count
	DECLARE @cfg TABLE (
		cfgId int
		, name varchar(255) primary key
		, minimum int
		, maximum int
		, config_value int
		, run_value int
	);
	INSERT INTO @cfg
		SELECT
			configuration_id,
			name,
			CAST(minimum AS INT),
			CAST(maximum AS INT),
			CAST(value AS INT) config_value,
			CAST(value_in_use AS INT) run_value
		FROM master.sys.configurations
		WHERE name IN (
				'xp_cmdshell',		-- Note not supported on Linux
				'max degree of parallelism',
				'max server memory (MB)',
				'min server memory (MB)',
				'max worker threads',
				'affinity mask',
				'affinity64 mask',
				'cost threshold for parallelism',
				'priority boost'
			);
	--select * from @cfg
	DECLARE @isEnabled INT = 0;
	IF (@osType = @windows)
	BEGIN
		SELECT @isEnabled = 1
		FROM @cfg
		WHERE name = 'xp_cmdshell'
			AND run_value = 1;
	END
	SELECT @SqlSeverMaxDOPCurrent = config_value
	FROM @cfg
	WHERE name = 'max degree of parallelism';
	SELECT @MaxSqlServerMemoryCurrent = config_value
	FROM @cfg
	WHERE name = 'max server memory (MB)';
	SELECT @MinSqlServerMemoryCurrent = config_value
	FROM @cfg
	WHERE name = 'min server memory (MB)';
	SELECT @SqlSeverCostThresholdCurrent = config_value
	FROM @cfg
	WHERE name = 'cost threshold for parallelism';
	SELECT @SqlSeverPriorityBoostCurrent = config_value
	FROM @cfg
	WHERE name = 'priority boost';
	DECLARE @tmpEnabled BIT = 0;
	IF @isEnabled = 0 AND @i_noCmdShellExe = 0 AND @osType = @windows
	BEGIN
		EXEC sp_configure 'xp_cmdshell', 1
		RECONFIGURE
		SET @tmpEnabled = 1
	END
	DECLARE @dkInfo TABLE (
		driveLetter			VARCHAR(10),
		freeSpace			BIGINT,
		totalSpace			BIGINT,
		-- Collect Drive Latency
		ReadLatencyMS		INT DEFAULT 0,
		WriteLatencyMS		INT DEFAULT 0,
		OverallLatencyMS	INT DEFAULT 0
	)
	IF @osType = @windows AND (@isEnabled = 1 OR @tmpEnabled = 1)
	BEGIN
		CREATE TABLE #cmdshell
		(
			txt VARCHAR(1024)
		);
		INSERT INTO #cmdshell (txt)
		EXEC xp_cmdshell 'powershell -OutputFormat Text -NoLogo -Command "& {Get-WmiObject -namespace "root\CIMV2" -class Win32_Processor -Property "NumberOfCores","NumberOfLogicalProcessors"} | select "NumberOfCores","NumberOfLogicalProcessors" | Format-List"';
		INSERT INTO #cmdshell (txt)
		EXEC xp_cmdshell 'powershell -OutputFormat Text -NoLogo -Command "& {Get-WmiObject -namespace "root\CIMV2" -class Win32_PhysicalMemory -Property "Capacity"} | select "Capacity" | Format-List"';
--select * from #cmdshell where txt IS NOT NULL
		SELECT @SocketCount = COUNT(*)
		FROM #cmdshell
		WHERE
			txt LIKE 'NumberOfCores%'
		SELECT @PhyicalCoreCount += CAST(SUBSTRING(txt, CHARINDEX(':', txt)+1, LEN(txt)) AS INT)
		FROM #cmdshell
		WHERE
			txt LIKE 'NumberOfCores%'
		SELECT @LogicalCoreCount += CAST(SUBSTRING(txt, CHARINDEX(':', txt)+1, LEN(txt)) AS INT)
		FROM #cmdshell
		WHERE
			txt LIKE 'NumberOfLogicalProcessors%'
		SELECT @TotalRAMGb += (CAST(SUBSTRING(txt, CHARINDEX(':', txt)+1, LEN(txt)) AS BIGINT) / (1024 * 1024 * 1024))
		FROM #cmdshell
		WHERE
			txt LIKE 'Capacity%'
		TRUNCATE TABLE #cmdshell
		INSERT INTO #cmdshell (txt)
			EXEC xp_cmdshell 'powershell -OutputFormat Text -NoLogo -Command "& {Get-WmiObject -namespace "root\CIMV2" -class Win32_LogicalDisk -Filter "DriveType=3" -Property "DeviceID","FreeSpace","Size"} | select "DeviceID","FreeSpace","Size" | convertto-csv -NoTypeInformation"';
		INSERT INTO @dkInfo (driveLetter, freeSpace, totalSpace)
			SELECT
				   m.n.value('d[1]','varchar(10)') AS disk,
				   m.n.value('d[2]','bigint') AS free,
				   m.n.value('d[3]','bigint') AS size
			FROM
			(
				   SELECT CAST('<disk><d>' + REPLACE(REPLACE(txt, '"', ''),',','</d><d>') + '</d></disk>' AS XML) AS x
				   FROM #cmdshell
				   WHERE txt NOT LIKE '%DeviceID%'
			)t
			CROSS APPLY x.nodes('/disk') m(n)
		TRUNCATE TABLE #cmdshell
		INSERT INTO #cmdshell (txt)
			EXEC xp_cmdshell 'whoami /priv'
		IF EXISTS (SELECT 1 FROM #cmdshell WHERE txt LIKE '%SeManageVolumePrivilege%Enabled%')
		BEGIN
			SET @ManageVolumePriv = 1
		END
		--select * from #cmdshell
		DROP TABLE #cmdshell;
	END
	ELSE IF (@osType = @linux)
	BEGIN
		SELECT
			@PhyicalCoreCount = IIF(((cpu_count - hyperthread_ratio) <= 0), 1, (cpu_count - hyperthread_ratio)),
			@LogicalCoreCount = cpu_count,
			@TotalRAMGb = CAST(ROUND(((physical_memory_kb / 1024.0) / 1024.0), 0) AS INT),		-- fix computation for Linux from MB to GB
			@SocketCount = (cpu_count / hyperthread_ratio)
		FROM sys.dm_os_sys_info WITH(NOLOCK)
		INSERT INTO @dkInfo (driveLetter, freeSpace, totalSpace)
			SELECT
				d.fixed_drive_path driveLetter,
				d.free_space_in_bytes freeDiskSpace,
				ISNULL((
					SELECT TOP 1
						s.total_bytes
					FROM sys.master_files AS f  WITH(NOLOCK)
						CROSS APPLY sys.dm_os_volume_stats(f.database_id, f.file_id) s
					WHERE
						s.volume_mount_point = d.fixed_drive_path
				), -1) totalDiskSpace			-- -1 unknown total size from SQL - cannot be determine since no databases on the drive
			FROM sys.dm_os_enumerate_fixed_drives d WITH(NOLOCK)		-- Supported on SQL 2017+
			WHERE
				d.drive_type = 3		-- Fixed Drive Type
	END
	UPDATE d
		SET ReadLatencyMS = t.ReadLatencyMS,
			WriteLatencyMS = t.WriteLatencyMS,
			OverallLatencyMS = t.OverallLatencyMS
	FROM @dkInfo d
		LEFT OUTER JOIN (
			SELECT
				tab.Drive,
				CASE
					WHEN num_of_reads = 0 THEN 0
					ELSE (io_stall_read_ms/num_of_reads)
				END AS ReadLatencyMS,
				CASE
					WHEN num_of_writes = 0 THEN 0
					ELSE (io_stall_write_ms/num_of_writes)
				END AS WriteLatencyMS,
				CASE
					WHEN (num_of_reads = 0 AND num_of_writes = 0) THEN 0
					ELSE (io_stall/(num_of_reads + num_of_writes))
				END AS OverallLatencyMS
			FROM (
					SELECT
						LEFT(UPPER(mf.physical_name), 2) AS Drive,
						SUM(num_of_reads) AS num_of_reads,
						SUM(io_stall_read_ms) AS io_stall_read_ms,
						SUM(num_of_writes) AS num_of_writes,
						SUM(io_stall_write_ms) AS io_stall_write_ms,
						SUM(num_of_bytes_read) AS num_of_bytes_read,
						SUM(num_of_bytes_written) AS num_of_bytes_written,
						SUM(io_stall) AS io_stall,
						vs.volume_mount_point
					FROM sys.dm_io_virtual_file_stats(NULL, NULL) AS vfs
					INNER JOIN sys.master_files AS mf WITH (NOLOCK) ON
						vfs.database_id = mf.database_id
						AND vfs.file_id = mf.file_id
					CROSS APPLY sys.dm_os_volume_stats(mf.database_id, mf.[file_id]) AS vs
					GROUP BY
					LEFT(UPPER(mf.physical_name), 2),
					vs.volume_mount_point
				) tab
		)  t ON
			t.Drive = d.driveLetter
	WHERE
		t.Drive IS NOT NULL
	IF @osType = @windows AND @tmpEnabled = 1
	BEGIN
		EXEC sp_configure 'xp_cmdshell', 0
		RECONFIGURE
	END
	-- SQL Server Licensed CPU log message
	IF OBJECT_ID('TempDb..#license') IS NOT NULL
		DROP TABLE #license
	CREATE TABLE #license  (
		logDt		DATETIME,
		processInfo	NVARCHAR(128),
		logMsg		NVARCHAR(1024)
	)
	INSERT INTO #license
		EXEC sp_readerrorlog 0,1,'licensing'
	DECLARE @cpuLicensedLogMsg NVARCHAR(1024) = N''
	SELECT TOP 1
		@cpuLicensedLogMsg = logMsg
	FROM #license
	-- OS Memory Configuration
	DECLARE @osMemoryCfg XML = (
		SELECT
			system_memory_state_desc [@Status],
			total_physical_memory_kb / 1024 AS [Memory/@PhysicalMemoryMB],
			available_physical_memory_kb / 1024 AS [Memory/@AvailableMemoryMB],
			total_page_file_kb / 1024 AS [Memory/@TotalPageFileMB],
			available_page_file_kb / 1024 AS [Memory/@AvailablePageFileMB],
			system_cache_kb / 1024 AS [Memory/@SystemCacheMB]
		FROM sys.dm_os_sys_memory WITH(NOLOCK)
		FOR XML PATH('OSMemory'), TYPE
	)
	-- OS NUMAs vs SQL Server NUMAs (OS and Soft)
	DECLARE @NumaNodes	INT = (
		SELECT MAX(c.memory_node_id) + 1
		FROM sys.dm_os_memory_clerks c
		WHERE memory_node_id < 64
	);
	--	   This will recommend a MAXDOP setting appropriate for your machine's NUMA memory
	--	   configuration.  You will need to evaluate this setting in a non-production
	--	   environment before moving it to production.
	--
	--	   MAXDOP can be configured using:
	--	   EXEC sp_configure 'max degree of parallelism',X;
	--	   RECONFIGURE
	--
	--	   If this instance is hosting a Sharepoint database, you MUST specify MAXDOP=1
	--	   (URL wrapped for readability)
	--	   http:--blogs.msdn.com/b/rcormier/archive/2012/10/25/
	--	   you-shall-configure-your-maxdop-when-using-sharepoint-2013.aspx
	--
	--	   Biztalk (all versions, including 2010):
	--	   MAXDOP = 1 is only required on the BizTalk Message Box
	--	   database server(s), and must not be changed; all other servers hosting other
	--	   BizTalk Server databases may return this value to 0 if set.
	--	   http:--support.microsoft.com/kb/899000
	-- Note another SP is implemented for computing and setting MAXDOP on Commservers called SQLServerSetMAXDOP
	DECLARE @SqlSeverMaxDOPNew INT = 0;
	-- 3/4 of Total Cores in Machine
	SET @SqlSeverMaxDOPNew = @PhyicalCoreCount * 0.75;
	-- if @SqlSeverMaxDOPNew is greater than the per NUMA node Core Count, set @SqlSeverMaxDOPNew = per NUMA node core count
	IF @SqlSeverMaxDOPNew > (@PhyicalCoreCount / @NumaNodes)
	BEGIN
		SET @SqlSeverMaxDOPNew = (@PhyicalCoreCount / @NumaNodes) * 0.75;
	END
	--	Reduce @SqlSeverMaxDOPNew to an even number
	SET @SqlSeverMaxDOPNew = @SqlSeverMaxDOPNew - (@SqlSeverMaxDOPNew % 2);
	-- Cap MAXDOP at 8, according to Microsoft
	IF @SqlSeverMaxDOPNew > 8
	BEGIN
		SET @SqlSeverMaxDOPNew = 8;
	END
	-- Database info
	IF OBJECT_ID('tempdb.dbo.#dbInfo') IS NOT NULL
		DROP TABLE #dbInfo
	CREATE TABLE #dbInfo (
		name		SYSNAME,
		size		VARCHAR(128),
		owner		SYSNAME,
		dbId		INT,
		created		DATE,
		status		VARCHAR(512),
		level		INT,
		drive		VARCHAR(6) DEFAULT '',
		logDrive	VARCHAR(6) DEFAULT ''
	)
	INSERT INTO #dbInfo(name, size, owner, dbId, created, status, level)
		EXEC sp_helpdb
	IF OBJECT_ID('tempdb.dbo.#dbFiles') IS NOT NULL
		DROP TABLE #dbFiles
	CREATE TABLE #dbFiles (
		dbId		INT,
		fileId		INT,
		space		XML,
		PRIMARY KEY (dbId, fileId)
	)
	DECLARE curDBs CURSOR FAST_FORWARD FOR
		SELECT name FROM #dbInfo
	DECLARE @dbName SYSNAME
	DECLARE @sqlCmd NVARCHAR(MAX)
	OPEN curDBs
	FETCH NEXT FROM curDBs INTO @dbName
	WHILE (@@FETCH_STATUS = 0)
	BEGIN
		-- Need to USE statement for the FILEPROPERTY() to work properly
		SET @sqlCmd = '
		USE [' + @dbName + '];
		UPDATE d SET drive = (SELECT TOP 1 SUBSTRING(f.physical_name, 1, 2) FROM sys.database_files f WHERE f.file_id = 1),
			logDrive = (SELECT TOP 1 SUBSTRING(l.physical_name, 1, 2) FROM sys.database_files l WHERE l.type = 1)
		FROM  #dbInfo d
		WHERE d.dbId = DB_ID();'
		SET @sqlCmd += '
			INSERT INTO #dbFiles (dbId, fileId, space)
				SELECT
					DB_ID(),
					f.file_id,
					(
						SELECT
							(mf.size / 128) [@totalMB],
							(FILEPROPERTY(mf.name, ''SpaceUsed'') /128) [@usedMB],
							((mf.size - FILEPROPERTY(mf.name,''SpaceUsed'')) / 128) [@freeMB],
							CAST(((((mf.size - FILEPROPERTY(mf.name,''SpaceUsed'')) / 128.0) / (mf.size / 128.0)) * 100) AS INT) [@pctFree],
							CASE mf.max_size
								WHEN -1 THEN ''Unlimited''
								WHEN 0 THEN ''No Growth''
								WHEN 268435456 THEN ''Log file will grow to a maximum size of 2 TB''
								ELSE CAST((max_size / 128) AS VARCHAR(12))
							END [@maxSize],
							CASE mf.is_percent_growth
								WHEN 0 THEN ''false''
								ELSE ''true''
							END [@isPercentGrowth],
							CASE
								WHEN mf.growth = 0 THEN ''No Growth''
								WHEN mf.is_percent_growth = 1 THEN CAST(mf.growth AS VARCHAR(12)) + ''%''
								ELSE CAST((mf.growth / 128) AS VARCHAR(12))
							END [@growthSize]
						FROM
							sys.database_files AS mf WITH(NOLOCK)
						WHERE
							mf.file_id = f.file_id
						FOR XML PATH(''Space''), TYPE
					)
				FROM  sys.database_files f;'
		--print @sqlCmd
		EXEC(@sqlCmd)
		FETCH NEXT FROM curDBs INTO @dbName
	END
	CLOSE curDBs
	DEALLOCATE curDBs
	-- Current TempDb Info
	DECLARE @tempDbDriveLetter VARCHAR(12) = ''
	SELECT
		@tempDbDriveLetter = SUBSTRING(physical_name, 0, 3)
	FROM tempdb.sys.database_files
	WHERE
		type = 0
		AND file_id = 1
	DECLARE @tempDbDataFileCntCurrent INT = 0
	SELECT
		@tempDbDataFileCntCurrent = COUNT(physical_name)
	FROM tempdb.sys.database_files
	WHERE type = 0
	DECLARE @tempDbDataFileCntNew INT = 0
	IF @tempDbDataFileCntCurrent < 8
	BEGIN
		IF @tempDbDataFileCntCurrent = 1
		BEGIN
			IF (@PhyicalCoreCount + @LogicalCoreCount) > 8
			BEGIN
				SET @tempDbDataFileCntNew = 8
			END
			ELSE
			BEGIN
				SET @tempDbDataFileCntNew = (@PhyicalCoreCount + @LogicalCoreCount)
			END
		END
	END
	ELSE
	BEGIN
		SET @tempDbDataFileCntNew = @tempDbDataFileCntCurrent
	END
	DECLARE @TempDbLogFileSizeMg INT = 0
	DECLARE @TempDbDataFileSizeMb INT = 0
	DECLARE @TempDbSizeMb INT = 0
	SELECT
		@TempDbDataFileSizeMb = SUM(CASE type
			WHEN 0 THEN ((size * 8) / 1024)
		END),
		@TempDbLogFileSizeMg = SUM(CASE type
				WHEN 1 THEN ((size * 8) / 1024)
		END) ,
		@TempDbSizeMb = SUM(((size * 8) / 1024))
	FROM tempdb.sys.database_files
	-- does tempdb share disk with other databases?
	DECLARE @tempdbDiskShared INT = 0;
	SELECT
		@tempdbDiskShared = COUNT(d.name)
	FROM #dbInfo d
	WHERE d.drive = @tempDbDriveLetter
		AND d.name NOT LIKE '%tempDb%'
	-- Changes to support SP in other databases beside the CSDb
	DECLARE @o_csInfoXML XML
	IF (DB_NAME() = 'commserv' AND OBJECT_ID('SQLServerCommserverInfo') IS NOT NULL)
	BEGIN
		DECLARE @csInfoCmd NVARCHAR(MAX) = N'EXEC SQLServerCommserverInfo @o_csInfoXML OUTPUT'
		EXEC sp_executesql @csInfoCmd, N'@o_csInfoXML XML OUTPUT', @o_csInfoXML OUTPUT
	END
	-- Table for Table row and space info
	IF OBJECT_ID('tempdb.dbo.#TableSizeInfo') IS NOT NULL
		DROP TABLE #TableSizeInfo
	CREATE TABLE #TableSizeInfo (
		name		SYSNAME,
		rows		VARCHAR(15),
		reserved	VARCHAR(18),
		data		VARCHAR(18),
		index_size	VARCHAR(18),
		unused		VARCHAR(18)
	)
	EXEC sp_MSForEachTable 'INSERT INTO #TableSizeInfo EXEC sp_spaceused ''?'' '
	-- Table for N Top largest tables based on size
	IF OBJECT_ID('tempdb.dbo.#TableSizeInfo2') IS NOT NULL
		DROP TABLE #TableSizeInfo2
	CREATE TABLE #TableSizeInfo2 (
		name		SYSNAME,
		rows		BIGINT,
		spaceUsedMB	DECIMAL(10,1)
	)
	INSERT INTO #TableSizeInfo2
		SELECT TOP 10
			name,
			CONVERT(BIGINT, rows),
			CAST((ROUND((CONVERT(BIGINT, LEFT(reserved, LEN(reserved)-3)) / 1024.0), 1, 0)) AS DECIMAL(10,1))
		FROM #TableSizeInfo
		ORDER BY
			3 DESC,
			2 DESC,
			1
	-- Table for N Top largest tables based on row count
	IF OBJECT_ID('tempdb.dbo.#TableSizeInfo3') IS NOT NULL
		DROP TABLE #TableSizeInfo3
	CREATE TABLE #TableSizeInfo3 (
		name		SYSNAME,
		rows		BIGINT,
		spaceUsedMB	DECIMAL(10,1)
	)
	INSERT INTO #TableSizeInfo3
		SELECT TOP 10
			name,
			CONVERT(BIGINT, rows),
			CAST((ROUND((CONVERT(BIGINT, LEFT(reserved, LEN(reserved)-3)) / 1024.0), 1, 0)) AS DECIMAL(10,1))
		FROM #TableSizeInfo
		ORDER BY
			2 DESC,
			3 DESC,
			1
	IF OBJECT_ID('tempdb.dbo.#TableSizeInfo') IS NOT NULL
		DROP TABLE #TableSizeInfo
	-- get a list of trace flags enabled
	DECLARE @traceTbl TABLE (
		traceFlag		INT,
		status			INT,
		global			INT,
		session			INT
	)
	INSERT INTO  @traceTbl
		EXEC('DBCC TRACESTATUS')
	DECLARE @sqlServerTbl TABLE (
		idx		INT,
		name	VARCHAR(128),
		iValue	INT,
		cValue	VARCHAR(256)
	)
	INSERT INTO @sqlServerTbl
		EXEC xp_msver
	-- Compute Wait Stats
	-- Removed CTE due to Linux continously picking updated rows due to how quickly the table was being modified and reporting the same
	-- wait type multiple times because the task count was increasing quickly so changed to taking a snapshot and save to table variable to avoid issue.
	DECLARE @PreWaitStats TABLE (
		wait_type				NVARCHAR(128),
		waiting_tasks_count		BIGINT,
		wait_time_s				DECIMAL(12, 2),
		avg_wait_time_ms		DECIMAL(12, 2),
		pct						DECIMAL(12, 2),
		rn						INT
	)
	INSERT INTO @PreWaitStats
		SELECT
			wait_type,
			waiting_tasks_count,
			wait_time_ms / 1000.0 AS wait_time_s,
			(wait_time_ms * 1.0) / waiting_tasks_count avg_wait_time_ms,
			100.0 * wait_time_ms / SUM(wait_time_ms) OVER () AS pct,
			ROW_NUMBER() OVER (
				ORDER BY wait_time_ms DESC,
					wait_type
			) AS rn
		FROM sys.dm_os_wait_stats
		WHERE
			waiting_tasks_count > 0
			AND wait_type NOT IN (
				-- Update wait states we do not care about capturing
				N'BROKER_EVENTHANDLER', N'BROKER_RECEIVE_WAITFOR', N'BROKER_TASK_STOP',
				N'BROKER_TO_FLUSH', N'BROKER_TRANSMITTER', N'CHECKPOINT_QUEUE',
				N'CHKPT', N'CLR_AUTO_EVENT', N'CLR_MANUAL_EVENT', N'CLR_SEMAPHORE',
				N'DBMIRROR_DBM_EVENT', N'DBMIRROR_EVENTS_QUEUE', N'DBMIRROR_WORKER_QUEUE',
				N'DBMIRRORING_CMD', N'DIRTY_PAGE_POLL', N'DISPATCHER_QUEUE_SEMAPHORE',
				N'EXECSYNC', N'FSAGENT', N'FT_IFTS_SCHEDULER_IDLE_WAIT', N'FT_IFTSHC_MUTEX',
				N'HADR_CLUSAPI_CALL', N'HADR_FILESTREAM_IOMGR_IOCOMPLETION', N'HADR_LOGCAPTURE_WAIT',
				N'HADR_NOTIFICATION_DEQUEUE', N'HADR_TIMER_TASK', N'HADR_WORK_QUEUE',
				N'KSOURCE_WAKEUP', N'LAZYWRITER_SLEEP', N'LOGMGR_QUEUE', N'ONDEMAND_TASK_QUEUE',
				N'PREEMPTIVE_OS_QUERYREGISTRY',
				N'PREEMPTIVE_HADR_LEASE_MECHANISM', N'PREEMPTIVE_SP_SERVER_DIAGNOSTICS',
				N'PWAIT_ALL_COMPONENTS_INITIALIZED',
				N'QDS_PERSIST_TASK_MAIN_LOOP_SLEEP',
				N'QDS_CLEANUP_STALE_QUERIES_TASK_MAIN_LOOP_SLEEP', N'REQUEST_FOR_DEADLOCK_SEARCH',
				N'RESOURCE_QUEUE', N'SERVER_IDLE_CHECK', N'SLEEP_BPOOL_FLUSH', N'SLEEP_DBSTARTUP',
				N'SLEEP_DCOMSTARTUP', N'SLEEP_MASTERDBREADY', N'SLEEP_MASTERMDREADY',
				N'SLEEP_MASTERUPGRADED', N'SLEEP_MSDBSTARTUP', N'SLEEP_SYSTEMTASK', N'SLEEP_TASK',
				N'SLEEP_TEMPDBSTARTUP', N'SNI_HTTP_ACCEPT', N'SP_SERVER_DIAGNOSTICS_SLEEP',
				N'SQLTRACE_BUFFER_FLUSH', N'SQLTRACE_INCREMENTAL_FLUSH_SLEEP', N'SQLTRACE_WAIT_ENTRIES',
				N'WAIT_FOR_RESULTS', N'WAITFOR', N'WAITFOR_TASKSHUTDOWN', N'WAIT_XTP_HOST_WAIT',
				N'WAIT_XTP_OFFLINE_CKPT_NEW_LOG', N'WAIT_XTP_CKPT_CLOSE', N'XE_DISPATCHER_JOIN',
				N'XE_DISPATCHER_WAIT', N'XE_TIMER_EVENT'
			)
	DECLARE @WaitStats TABLE (
		waitType		NVARCHAR(128),
		waitTimeS		DECIMAL(12, 2),
		taskCount		BIGINT,
		avgWaitTimeMS	DECIMAL(12, 2),
		pct				DECIMAL(12, 2),
		runningPct		DECIMAL(12, 2),
		waitInfoURL		VARCHAR(MAX)	-- make easier to lookup wait state meanings
	)
	INSERT @WaitStats
		SELECT
			W1.wait_type,
			CAST(W1.wait_time_s AS DECIMAL(12, 2)) AS wait_time_s,
			W1.waiting_tasks_count,
			CAST(W1.avg_wait_time_ms AS DECIMAL(12, 2)) AS avg_wait_time_ms,
			CAST(W1.pct AS DECIMAL(12, 2)) AS pct,
			CAST(SUM(W2.pct) AS DECIMAL(12, 2)) AS running_pct,
			'https://www.sqlskills.com/help/waits/' + W1.wait_type AS waitInfoURL
		FROM @PreWaitStats AS W1
			INNER JOIN @PreWaitStats AS W2 ON W2.rn <= W1.rn
		WHERE
			W1.wait_time_s >= 1.0
		GROUP BY W1.rn,
			W1.wait_type,
			W1.wait_time_s,
			W1.waiting_tasks_count,
			W1.avg_wait_time_ms,
			W1.pct
		HAVING SUM(W2.pct) - W1.pct <= 95;-- percentage threshold
	-- Compute CPU Licensing
	-- Fix for CTE refreshing in the middle of execution
	IF OBJECT_ID('TempDb..#CPULicensing') IS NOT NULL
		DROP TABLE #CPULicensing
	CREATE TABLE #CPULicensing (
		numaId		INT,
		status		NVARCHAR(60),
		coreCount	INT
	)
	INSERT INTO #CPULicensing
		SELECT
		   s.parent_node_id numaId,
		   s.status,
		   COUNT(*) coreCount
		FROM sys.dm_os_schedulers s
		WHERE s.status NOT LIKE '%DAC%'
		GROUP BY
		   s.parent_node_id,
		   s.status
	DECLARE @coreLicenses XML = ''
    ;WITH CPULicensing (numaId, status, coreCount) AS (
		-- To keep changes to a miminal
		SELECT
			numaId,
			status,
			coreCount
		FROM #CPULicensing
	),
	NUMA (numaId) AS (
		SELECT DISTINCT
		   numaId
		FROM CPULicensing
	),
	MaxNumaCores (maxCores) AS (
	   SELECT
		  MAX(l.coreCount) maxCores
	   FROM CPULicensing l
	   WHERE l.status = 'VISIBLE ONLINE'
	)
		SELECT @coreLicenses = (
								SELECT
									@SqlSeverPriorityBoostCurrent '@priorityBoost',
									(
										SELECT
											SUM(l.coreCount) coreCount
										FROM CPULicensing l
										WHERE l.status = 'VISIBLE ONLINE'
									)  '@Licensed',
									(
										SELECT
											COUNT(DISTINCT l.numaId) numaCount
										FROM CPULicensing l
										WHERE l.status = 'VISIBLE ONLINE'
									)  '@NUMADistribution',
									ISNULL((
										SELECT
											SUM(l.coreCount) coreCount
										FROM CPULicensing l
										WHERE l.status = 'VISIBLE OFFLINE'
									), 0)  '@Extra',
									(
										SELECT
											n.numaId '@Id',
											c.cntr_value '@PageLifeExpectancySeconds',	-- PLE per NUMA
											(
												SELECT
													l.status '@Status',
													l.coreCount '@Cores'
												FROM CPULicensing l
												WHERE l.numaId = n.numaId
												FOR XML PATH('Config'), TYPE
											)
										FROM NUMA n
											LEFT OUTER JOIN sys.dm_os_performance_counters c WITH (NOLOCK) ON
												N'00' + CAST(n.numaId AS NVARCHAR(12)) = c.instance_name		-- bug on Linux
												AND c.object_name LIKE N'%Buffer Node%' -- Handles named instances
												AND c.counter_name = N'Page life expectancy'
										ORDER BY
											n.numaId ASC
										FOR XML PATH('NUMA'), TYPE
									),
									(
										SELECT
											parent_node_id  '@numaId',
											COUNT(DISTINCT scheduler_id) '@schedulers',
											SUM(current_tasks_count) '@totalCurrentTask',
											SUM(runnable_tasks_count) '@totalWaitingTask',
											SUM(current_workers_count) '@totalActiveWorkers',
											AVG(load_factor) '@avgLoadFactor'
										FROM sys.dm_os_schedulers
										WHERE scheduler_id < 255
											  AND status = 'VISIBLE ONLINE'
										GROUP BY
											parent_node_id
										FOR XML PATH('SchedulerDetails'), ROOT('Schedulers'), TYPE
									),
									(
									   SELECT
										  CASE
											-- https:--www.sqlskills.com/blogs/glenn/balancing-your-available-sql-server-core-licenses-evenly-across-numa-nodes/
											 WHEN (SELECT COUNT(*) FROM NUMA) <> (SELECT COUNT(DISTINCT l.numaId) FROM CPULicensing l WHERE l.status = 'VISIBLE ONLINE') THEN
												    (SELECT
													   'Core Licensing NOT Balanced across all NUMAs [' + CAST((SELECT COUNT(*) FROM NUMA) AS VARCHAR(12)) + '], re-balance?'
												    FOR XML PATH('Recommendation'), TYPE)
											 ELSE NULL
										  END
									)
									-- No longer supported on SQL Server 2014+
									--(
									--   SELECT
									--	  CASE
									--		 WHEN (SELECT maxCores FROM MaxNumaCores) > 8 THEN
									--			    (SELECT
									--				   'May require Trace Flag 8048 when more than 8 Cores per NUMA [' + CAST((SELECT maxCores FROM MaxNumaCores) AS VARCHAR(12)) + ']?'
									--			    FOR XML PATH('Recommendation'), TYPE)
									--		 ELSE NULL
									--	  END
									--)
								FOR XML PATH('CoreLicensing'), TYPE
		)
	-- Compute Application Index Fragmentation Percentage Windows
	DECLARE @WindowIdxFragReport XML = NULL
	IF (@i_collectIndexFrag > 0)
	BEGIN
		SET @WindowIdxFragReport = (
			SELECT
				DB_NAME() '@database',
				(
					SELECT
						--ROW_NUMBER() over (ORDER BY CAST(avg_fragmentation_in_percent / 10 AS INT)) '@window',
						(CAST(avg_fragmentation_in_percent / 10 AS INT) * 10) '@fragmentationPct',
						COUNT(*) '@indexCount'
					FROM sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, NULL) S
					INNER JOIN sys.indexes I ON I.object_id = S.object_id
						AND I.index_id = S.index_id
						AND I.type > 0
					GROUP BY CAST(avg_fragmentation_in_percent / 10 AS INT)
					ORDER BY 1 ASC
					FOR XML PATH('Window'), TYPE
				)
			FOR XML PATH('IndexFragmentation'), TYPE
		)
	END
	-- Collect the High SP Performance Issues
	DECLARE @spPerf XML = NULL
	SET @sqlCmd = N''
	IF (@releaseNumber > 12)	-- 12->SQL2014
	BEGIN
		-- SQL2016+
		SET @sqlCmd = '
			SELECT
				(SELECT TOP 5
					qs.execution_count [@exeCount],
					o.name [@spName],
					qs.creation_time [@creationTime],
					qs.last_execution_time [@lastExeTime],
					CAST(((qs.total_worker_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@cpuTimeMS],
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@elTimeMS],
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) [Time/@multiplier],
					-- Start SQL2016
					qs.last_used_threads [Usage/@threadCnt],
					qs.total_dop [Usage/@totalDOP],
					qs.last_grant_kb [Usage/@lastMemoryGrantKB],
					-- End SQL2016
					CHAR(10) + SUBSTRING(q.TEXT, (qs.statement_start_offset / 2) + 1,
											CASE
												WHEN statement_end_offset = - 1
													OR statement_end_offset = 0
													THEN (DATALENGTH(q.TEXT) - qs.statement_start_offset / 2) + 1
												ELSE ((qs.statement_end_offset - qs.statement_start_offset) / 2) + 1
											END) + CHAR(10) [spStatement/SqlText]
				FROM sys.dm_exec_query_stats qs
					CROSS APPLY sys.dm_exec_sql_text(qs.plan_handle) AS q
					CROSS APPLY sys.dm_exec_query_plan(qs.plan_handle) qp
					INNER JOIN sys.sysobjects o ON
						o.id = q.objectid
				WHERE
					qs.total_worker_time > qs.total_elapsed_time
					AND CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) > 1.3		-- >multipler > 1.3
				ORDER BY
					qs.execution_count DESC,
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) DESC
				FOR XML PATH(''SP''), ROOT(''HighCPUUsage''), TYPE),
				(SELECT TOP 5
					qs.execution_count [@exeCount],
					o.name [@spName],
					qs.creation_time [@creationTime],
					qs.last_execution_time [@lastExeTime],
					CAST(((qs.total_worker_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@cpuTimeMS],
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@elTimeMS],
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) [Time/@multiplier],
					-- Start SQL2016
					qs.last_used_threads [Usage/@threadCnt],
					qs.total_dop [Usage/@totalDOP],
					qs.last_grant_kb [Usage/@lastMemoryGrantKB],
					-- End SQL2016
					CHAR(10) + SUBSTRING(q.TEXT, (qs.statement_start_offset / 2) + 1,
											CASE
												WHEN statement_end_offset = - 1
													OR statement_end_offset = 0
													THEN (DATALENGTH(q.TEXT) - qs.statement_start_offset / 2) + 1
												ELSE ((qs.statement_end_offset - qs.statement_start_offset) / 2) + 1
											END) + CHAR(10) [spStatement/SqlText]
				FROM sys.dm_exec_query_stats qs
					CROSS APPLY sys.dm_exec_sql_text(qs.plan_handle) AS q
					CROSS APPLY sys.dm_exec_query_plan(qs.plan_handle) qp
					INNER JOIN sys.sysobjects o ON
						o.id = q.objectid
				WHERE
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) > 3000.0		-- >3 seconds
				ORDER BY
					qs.execution_count DESC,
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) DESC
				FOR XML PATH(''SP''), ROOT(''HighElapseTime''), TYPE)
			FOR XML PATH(''StoredProcedurePerformance''), TYPE
		'
	END
	ELSE
	BEGIN
		-- SQL2014 and earlier
		SET @sqlCmd = '
			SELECT
				(SELECT TOP 5
					qs.execution_count [@exeCount],
					o.name [@spName],
					qs.creation_time [@creationTime],
					qs.last_execution_time [@lastExeTime],
					CAST(((qs.total_worker_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@cpuTimeMS],
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@elTimeMS],
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) [Time/@multiplier],
					CHAR(10) + SUBSTRING(q.TEXT, (qs.statement_start_offset / 2) + 1,
											CASE
												WHEN statement_end_offset = - 1
													OR statement_end_offset = 0
													THEN (DATALENGTH(q.TEXT) - qs.statement_start_offset / 2) + 1
												ELSE ((qs.statement_end_offset - qs.statement_start_offset) / 2) + 1
											END) + CHAR(10) [spStatement/SqlText]
				FROM sys.dm_exec_query_stats qs
					CROSS APPLY sys.dm_exec_sql_text(qs.plan_handle) AS q
					CROSS APPLY sys.dm_exec_query_plan(qs.plan_handle) qp
					INNER JOIN sys.sysobjects o ON
						o.id = q.objectid
				WHERE
					qs.total_worker_time > qs.total_elapsed_time
					AND CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) > 1.3		-- >multipler > 1.3
				ORDER BY
					qs.execution_count DESC,
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) DESC
				FOR XML PATH(''SP''), ROOT(''HighCPUUsage''), TYPE),
				(SELECT TOP 5
					qs.execution_count [@exeCount],
					o.name [@spName],
					qs.creation_time [@creationTime],
					qs.last_execution_time [@lastExeTime],
					CAST(((qs.total_worker_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@cpuTimeMS],
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) [Time/@elTimeMS],
					CAST(((qs.total_worker_time * 1.0) / (qs.total_elapsed_time * 1.0)) AS DECIMAL(10,2)) [Time/@multiplier],
					CHAR(10) + SUBSTRING(q.TEXT, (qs.statement_start_offset / 2) + 1,
											CASE
												WHEN statement_end_offset = - 1
													OR statement_end_offset = 0
													THEN (DATALENGTH(q.TEXT) - qs.statement_start_offset / 2) + 1
												ELSE ((qs.statement_end_offset - qs.statement_start_offset) / 2) + 1
											END) + CHAR(10) [spStatement/SqlText]
				FROM sys.dm_exec_query_stats qs
					CROSS APPLY sys.dm_exec_sql_text(qs.plan_handle) AS q
					CROSS APPLY sys.dm_exec_query_plan(qs.plan_handle) qp
					INNER JOIN sys.sysobjects o ON
						o.id = q.objectid
				WHERE
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) > 3000.0		-- >3 seconds
				ORDER BY
					qs.execution_count DESC,
					CAST(((qs.total_elapsed_time * 1.0) / 1000.0 / qs.execution_count) AS DECIMAL(10,2)) DESC
				FOR XML PATH(''SP''), ROOT(''HighElapseTime''), TYPE)
			FOR XML PATH(''StoredProcedurePerformance''), TYPE
		'
	END
	DECLARE @xmlTbl TABLE (data	XML)
	INSERT INTO @xmlTbl (data)
		EXEC(@sqlCmd)
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt > 0)
	BEGIN
		SELECT @spPerf = data FROM @xmlTbl
	END
	SET @outputXML = (
		SELECT
			CASE @i_noCmdShellExe
				WHEN 0 THEN NULL
				ELSE 'DISABLED'
			END '@xpCmdShellStatus',
			@now '@collectionTime',
			@osName '@OSName',
			@osRelease '@OSRelease',
			@o_csInfoXML,
			(SELECT
				@TotalRAMGb '@TotalRAMGb',
				@SocketCount '@Sockets',
				@PhyicalCoreCount '@PhyicalCoreCount',
				@LogicalCoreCount '@LogicalCoreCount',
				--(@PhyicalCoreCount + @LogicalCoreCount) '@TotalCoreCount',
				@NumaNodes '@NumaNodes',
				@SystemInfo,	-- Hardware Platform Information
				@osMemoryCfg,
				(SELECT
					(SELECT
						CASE
							WHEN @cvHome1 IS NOT NULL AND @cvHome1 <> '' THEN @cvHome1
							ELSE NULL
						END 'Instance001/@Path',
						CASE
							WHEN @evHome1 IS NOT NULL AND @evHome1 <> '' THEN @evHome1
							ELSE NULL
						END 'Instance001/@LogPath',
						CASE
							WHEN @cvHome2 IS NOT NULL AND @cvHome2 <> '' THEN @cvHome2
							ELSE NULL
						END 'Instance002/@Path',
						CASE
							WHEN @evHome2 IS NOT NULL AND @evHome2 <> '' THEN @evHome2
							ELSE NULL
						END 'Instance002/@LogPath'
					FOR XML PATH('ApplicationPaths'), TYPE),
					(SELECT
						d.driveLetter '@DriveLetter',
						d.freeSpace / (1024 * 1024) '@FreeSpaceMb',
						d.totalSpace / (1024 * 1024) '@TotalSizeMb',
						d.ReadLatencyMS '@ReadLatencyMS',
						d.WriteLatencyMS '@WriteLatencyMS',
						d.OverallLatencyMS '@OverallLatencyMS'
					FROM @dkInfo d
					FOR XML PATH('Disk'), type)
				FOR XML PATH('Disks'), type),
				(
					SELECT
						'If VM Setup with Sockets greater-than 4, SQL Server only licenses the CPUs in the first 4 Sockets and so the VM is probably NOT configured properly.'
					WHERE
						@SocketCount > 4
					FOR XML PATH('Recommendation'), TYPE
				)
			FOR XML PATH('System'), type),
			(SELECT
				@@servername '@SqlServerInstance',
				(SELECT
					t.cValue
				FROM @sqlServerTbl t
				WHERE t.name = 'ProductVersion') '@Version',
				@ManageVolumePriv '@SeManageVolumePrivilegeEnabled',
				(SELECT
					cntr_value AS MemoryGrantsPending
				FROM sys.dm_os_performance_counters c WITH (NOLOCK)
				WHERE
					c.object_name LIKE N'%Memory Manager%' -- Handles named instances
					AND c.counter_name = N'Memory Grants Pending') AS '@MemoryGrantsPending',
				(SELECT
					sqlserver_start_time '@StartDate',
					DATEDIFF(hour, sqlserver_start_time, GETDATE()) '@UpTimeHours',
					virtual_machine_type_desc '@VMType'
				FROM
					sys.dm_os_sys_info WITH (NOLOCK)
				FOR XML PATH('RunTime'), TYPE),
				@coreLicenses,
				(SELECT
					@newline +
					@sqlVersion + @newline +
					@cpuLicensedLogMsg + @newline
				FOR XML PATH('Edition'), TYPE),
				CASE
					WHEN @ManageVolumePriv = 0 AND @osType = @windows THEN
						(SELECT
							'Enable Instant File Initiation via SeManageVolumePrivilege for better performance initializing database data files during growth phases.'
						FOR XML PATH('Recommendation'), TYPE)
					ELSE NULL
				END,
				(SELECT
					tt.traceFlag '@flag',
					tt.status '@status',
					tt.global '@global',
					tt.session '@session'
				FROM @traceTbl tt
				FOR XML PATH('TraceFlag'), ROOT('TraceStatus'), TYPE),
				(SELECT
					(SELECT
						@MaxSqlServerMemoryCurrent '@MaxSqlServerMemoryMb',
						@MinSqlServerMemoryCurrent '@MinSqlServerMemoryMb'
					FOR XML PATH('Current'), type),
					(SELECT
						(CAST((@TotalRAMGb *.5) AS INT) * 1024) '@MaxSqlServerMemoryMb',			-- set SQL Server max memory to 50% of System RAM at minimum
						(CAST(((@TotalRAMGb *.5) * .25) AS INT) * 1024) '@MinSqlServerMemoryMb'	-- set SQL Server min memory to 25% of max memory
					FOR XML PATH('New'), type),
					(SELECT
						'Change SQL Server Memory Setting to the new recommended settings.'
					WHERE @MaxSqlServerMemoryCurrent <> (CAST((@TotalRAMGb *.5) AS INT) * 1024)
						OR @MinSqlServerMemoryCurrent <> (CAST(((@TotalRAMGb *.5) * .25) AS INT) * 1024)
					FOR XML PATH('Recommendation'), type)
				FOR XML PATH('MemoryCfg'), type),
				(SELECT
					@SqlSeverMaxDOPCurrent '@Current',
					CASE
						WHEN @SqlSeverMaxDOPCurrent = 4 THEN NULL
						WHEN @SqlSeverMaxDOPCurrent = 0 AND @SqlSeverMaxDOPNew >= 4 THEN 4
						WHEN @SqlSeverMaxDOPCurrent = @SqlSeverMaxDOPNew THEN NULL
						WHEN @SqlSeverMaxDOPNew >= 4 THEN 4
						ELSE @SqlSeverMaxDOPNew
					END '@New',
					(SELECT
						'Max recommended SQL Server MAXDOP Setting is ' + CAST(@SqlSeverMaxDOPNew AS VARCHAR(12)) + '. Commserver max recommended setting is 4'
					WHERE
						(
							@SqlSeverMaxDOPCurrent <> @SqlSeverMaxDOPNew
							AND @SqlSeverMaxDOPCurrent <> 4
						)
						OR (
							@SqlSeverMaxDOPCurrent = 0
						)
					FOR XML PATH('Recommendation'), type)
				FOR XML PATH('MaxDOPCfg'), type),
				(SELECT
					@SqlSeverCostThresholdCurrent  '@Current'
				FOR XML PATH('CostThresholdCfg'), type),
				(SELECT
					cfgId, name, minimum, maximum, config_value configValue, run_value runValue
				FROM @cfg
				WHERE name IN (
						'max worker threads',
						'affinity mask',
						'affinity64 mask'
					)
				FOR XML RAW, ROOT('OtherCfgs'), type),
				(SELECT
					(SELECT COUNT(dbId) FROM #dbInfo) '@Count',
					(SELECT
						d.dbId '@dbId',
						d.name '@Name',
						sd.compatibility_level '@CompLevel',
						LTRIM(d.size) '@Size',
						d.created '@Created',
						d.drive '@DriveLetter',
						d.logDrive '@logDriveLetter',
						sd.target_recovery_time_in_seconds '@recoveryTimeSec',
						sd.is_broker_enabled '@isServiceBrokerEnabled',
						d.status 'Status',
						sd.log_reuse_wait 'LogReuse/@WaitType',
						sd.log_reuse_wait_desc 'LogReuse/@WaitDesc',
						sd.target_recovery_time_in_seconds 'Recovery/@TimeSeconds',
						sd.page_verify_option 'Recovery/@PageVerifyType',
						sd.page_verify_option_desc 'Recovery/@PageVerifyDesc'
					FROM #dbInfo d
						INNER JOIN sys.databases sd ON
							sd.database_id = d.dbId
					ORDER BY d.dbId ASC
					FOR XML PATH('Database'), type)
				FOR XML PATH('Databases'), type),
				(SELECT
					(SELECT
						file_id '@fileId',
						name '@deviceName',
						(size / 128) '@totalMB',
						(FILEPROPERTY(name, 'SpaceUsed') /128) '@usedMB',
						((size - FILEPROPERTY(name, 'SpaceUsed')) / 128) '@freeMB',
						CAST(((((size - FILEPROPERTY(name, 'SpaceUsed')) / 128.0) / (size / 128.0)) * 100) AS INT) '@pctFree',
						physical_name '@filename'
					FROM tempdb.sys.database_files
					FOR XML PATH('File'), ROOT('Files'), type),
					(SELECT
						@tempDbDataFileCntCurrent '@CurrentCount',
						@tempDbDataFileCntNew '@NewCount'
					FOR XML PATH('DataFiles'), type),
					CASE
						WHEN @tempDbDataFileCntCurrent < @tempDbDataFileCntNew THEN (
							SELECT
								'Re-size TempDb from ' + CAST(@tempDbDataFileCntCurrent AS VARCHAR(12)) + ' data files to ' + CAST(@tempDbDataFileCntNew AS VARCHAR(12)) + ' data files.'
							WHERE @tempDbDataFileCntCurrent <> @tempDbDataFileCntNew
							FOR XML PATH('Recommendation'), type)
						ELSE NULL
					END,
					(SELECT
						'Relocate TempDb to its own disk drive for better performance.  Drive [' + @tempDbDriveLetter + '] shared with ' + CAST(@tempdbDiskShared AS VARCHAR(12)) + ' Databases.'
					WHERE @tempdbDiskShared <> 0
					FOR XML PATH('Recommendation'), type)
				WHERE @tempdbDiskShared <> 0
					OR  @tempDbDataFileCntCurrent <> @tempDbDataFileCntNew
				FOR XML PATH('TempDbCfg'), type),
				-- cleaned up to make more readable in XML format
				(SELECT
					(SELECT TOP 1
						pc.cntr_value
					FROM sys.dm_os_performance_counters pc
					WHERE pc.OBJECT_NAME like N'%Buffer Manager%'
						AND pc.counter_name = N'Page life expectancy') '@pageLifeExpectancySeconds',
					(SELECT
						db.dbId '@dbId',
						db.name '@DbName',
						(SELECT
							mf.file_id '@fileId',
							mf.name '@logical',
							mf.physical_name '@dbFile',
							dbf.space.query('.'),
--							(mf.size / 128) 'Space/@totalMB',
--							(FILEPROPERTY(mf.name, 'SpaceUsed') /128) 'Space/@usedMB',
--							((mf.size - FILEPROPERTY(mf.name,'SpaceUsed')) / 128) 'Space/@freeMB',
--							CAST(((((mf.size - FILEPROPERTY(mf.name,'SpaceUsed')) / 128.0) / (mf.size / 128.0)) * 100) AS INT) 'Space/@pctFree',
--							CASE mf.max_size
--								WHEN -1 THEN 'Unlimited'
--								WHEN 0 THEN 'No Growth'
--								WHEN 268435456 THEN 'Log file will grow to a maximum size of 2 TB'
--								ELSE CAST((max_size / 128) AS VARCHAR(12))
--							END 'Space/@maxSize',
--							CASE mf.is_percent_growth
--								WHEN 0 THEN 'false'
--								ELSE 'true'
--							END 'Space/@isPercentGrowth',
--							CASE
--								WHEN mf.growth = 0 THEN 'No Growth'
--								WHEN mf.is_percent_growth = 1 THEN CAST(mf.growth AS VARCHAR(12)) + '%'
--								ELSE CAST((mf.growth / 128) AS VARCHAR(12))
--							END 'Space/@growthSize',
							(SELECT
								num_of_reads 'Totals/@ReadIOs',
								num_of_writes 'Totals/@WriteIOs',
								fs.num_of_reads + fs.num_of_writes AS 'Totals/@TotalIOs',
								fs.io_stall_read_ms 'Stalls/@ReadIOsMS',
								fs.io_stall_write_ms 'Stalls/@WriteIOsMS',
								fs.io_stall_read_ms + fs.io_stall_write_ms 'Stalls/@TotalIOMS',
								CAST(fs.io_stall_read_ms / (1.0 + fs.num_of_reads) AS NUMERIC(10, 1)) 'AvgStalls/@ReadIOsMS',
								CAST(fs.io_stall_write_ms / (1.0 + fs.num_of_writes) AS NUMERIC(10, 1)) 'AvgStalls/@WriteIOsMS',
								CAST((fs.io_stall_read_ms + fs.io_stall_write_ms) / (1.0 + fs.num_of_reads + fs.num_of_writes) AS NUMERIC(10, 1)) 'AvgStalls/@TotalIOsMS'
							FOR XML PATH('IOStats'), TYPE)
						FROM
							sys.dm_io_virtual_file_stats(NULL, NULL) AS fs
							INNER JOIN sys.master_files AS mf WITH(NOLOCK) ON
								fs.database_id = mf.database_id
								AND fs.[file_id] = mf.[file_id]
							INNER JOIN #dbFiles dbf ON
								dbf.dbId = fs.database_id
								AND dbf.fileId = mf.[file_id]
						WHERE
							fs.database_id = db.dbid
						FOR XML PATH('File'), ROOT('DbFiles'), TYPE)
					FROM
						sys.sysdatabases db WITH(NOLOCK)
					FOR XML PATH('Database'), TYPE)
				FOR XML PATH('DatabaseIOStats'), TYPE),
				(CASE (SELECT SUM(waiter_count) FROM sys.dm_exec_query_resource_semaphores)
					WHEN 0 THEN NULL
					ELSE (
						SELECT
							(SELECT
								qrs.pool_id '@pool_id',
								qrs.resource_semaphore_id '@resource_semaphore_id',
								qrs.target_memory_kb '@target_memory_kb',
								qrs.max_target_memory_kb '@max_target_memory_kb',
								qrs.available_memory_kb '@available_memory_kb',
								qrs.granted_memory_kb '@granted_memory_kb',
								qrs.grantee_count '@grantee_count',
								qrs.waiter_count '@waiter_count'
							FROM sys.dm_exec_query_resource_semaphores qrs
							FOR XML PATH('Waiter'), ROOT('Waiters'), TYPE),
							(SELECT
								qmg.session_id '@session_id',
								qmg.scheduler_id '@scheduler_id',
								qmg.dop '@dop',
								qmg.request_time '@request_time',
								qmg.requested_memory_kb '@requested_memory_kb',
								qmg.required_memory_kb '@required_memory_kb',
								qmg.granted_memory_kb '@granted_memory_kb',
								qmg.used_memory_kb '@used_memory_kb',
								qmg.max_used_memory_kb '@max_used_memory_kb',
								qmg.query_cost '@query_cost',
								qmg.pool_id '@pool_id'
							FROM sys.dm_exec_query_memory_grants  qmg
							FOR XML PATH('MemoryGrant'), ROOT('MemoryGrants'), TYPE),
							(SELECT
								'SQL Server under memory pressure, increase SQL Server Max Memory?'
							FOR XML PATH('Recommendation'), TYPE)
						FOR XML PATH('MemoryStats'), TYPE
					)
				END),
				(SELECT
					(SELECT
						ws.waitType '@waitType',
						ws.waitTimeS '@waitTimeSecs',
						ws.taskCount '@taskCount',
						ws.avgWaitTimeMS '@avgWaitTimeMS',
						ws.pct '@percentage',
						ws.runningPct '@runningPercentage',
						IIF((@i_isOutputXML <> 0), NULL, ws.waitInfoURL) '@waitInfoURL'	-- MS Outlook mucks with URL Address messing it up for emailing the XML Cfg Document
					FROM @WaitStats ws
					FOR XML PATH('WaitType'), TYPE)
				FOR XML PATH('WaitStats'), TYPE)
			FOR XML PATH('SQLServer'), TYPE),
			(SELECT
				(SELECT SUM(spaceUsedMB) FROM #TableSizeInfo2) '@totalSpaceUsedMB',
				(SELECT
					RANK() OVER(ORDER BY spaceUsedMB DESC) '@rank',
					name '@name',
					rows '@rows',
					spaceUsedMB '@spaceUsedMB'
				FROM #TableSizeInfo2
				FOR XML PATH('Table'), TYPE)
			FOR XML PATH('LargestTablesBySpace'), TYPE),
			(SELECT
				(SELECT SUM(rows) FROM #TableSizeInfo3) '@totalRowCount',
				(SELECT
					RANK() OVER(ORDER BY rows DESC) '@rank',
					name '@name',
					rows '@rows',
					spaceUsedMB '@spaceUsedMB'
				FROM #TableSizeInfo3
				FOR XML PATH('Table'), TYPE)
			FOR XML PATH('LargestTablesByRowCount'), TYPE),
			@WindowIdxFragReport,
			@spPerf
		FOR XML PATH('SQLServerConfigurationReport')
	)
	IF(@i_isOutputXML <> 0)
	BEGIN
		SET @i_outputXML = @outputXML
	END
	ELSE
	BEGIN
		SELECT @outputXML sqlServerConfigurationReport
	END
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'SQLServerConfigurationXML')
	delete from GxQscripts where name = 'SQLServerConfigurationXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerConfigurationXML')
	delete from GXDBVersions where aliasname = 'SQLServerConfigurationXML'
GO

insert into GXDBVersions values(2, 'SQLServerConfigurationXML',  '00010001000200180000', 'SQLServerConfigurationXML', '00010001000200180000')
GO

