

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLServerCommserverInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLServerCommserverInfo.sp,v $ $Id: SQLServerCommserverInfo.sp,v 1.1.2.1.20.2 2021/01/20 02:47:08 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLServerCommserverInfo')
BEGIN
	print '>>> Drop Stored Procedure: SQLServerCommserverInfo <<<'
	drop procedure SQLServerCommserverInfo
END
IF EXISTS (select * from GxQscripts where name='SQLServerCommserverInfo')
	delete from GxQscripts where name = 'SQLServerCommserverInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerCommserverInfo')
	delete from GXDBVersions where aliasname = 'SQLServerCommserverInfo'
GO
print '... Creating Procedure: SQLServerCommserverInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLServerCommserverInfo
  @csInfoXML XML OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @csId INT = 2
	DECLARE @csName NVARCHAR(256) = ''
	DECLARE @release INT = 0
	DECLARE @ccNumber INT = 0
	DECLARE @csGUID NVARCHAR(60) = ''
	DECLARE @clientCount INT = 0
	DECLARE @clientCountDecfg INT = 0
	DECLARE @dbMaintLevel INT = 0
	DECLARE @dbMaintTime DATETIME
	DECLARE @dbMaintLevelName VARCHAR(64) = ''
	-- Collect Commserver basic information
	SELECT
		@csName = c.name,
		@release = (c.releaseId - 5),
		@csGUID = c.guid
	FROM APP_Client c WITH(NOLOCK)
	WHERE c.id = @csId
	SELECT
		@clientCount = COUNT(id),
		@clientCountDecfg = SUM(CASE
									WHEN (status & (2|4)) > 0 THEN 1	-- uninstalled / deleted
									ELSE 0
								END
							)
	FROM APP_Client c WITH(NOLOCK)
	SELECT
		@ccNumber = cc.number
	FROM APP_CommCell cc WITH(NOLOCK)
	WHERE
		cc.clientId = @csId
	-- Last DbMaintenance performed
	SELECT
		@dbMaintLevel = value
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = N'FullDBMaintenanceLevel'
	DECLARE @dbSep VARCHAR(2) = ''
	IF ((@dbMaintLevel & 8) > 0)
	BEGIN
		SET @dbMaintLevelName = 'CHECKDB'
		SET @dbSep = '|'
	END
	IF ((@dbMaintLevel & 16) > 0)
	BEGIN
		SET @dbMaintLevelName += @dbSep + 'FULL'
		SET @dbSep = '|'
	END
	IF ((@dbMaintLevel & 32) > 0)
	BEGIN
		SET @dbMaintLevelName += @dbSep + 'RECOMMENDED'
		SET @dbSep = '|'
	END
	IF ((@dbMaintLevel & 64) > 0)
	BEGIN
		SET @dbMaintLevelName += @dbSep + 'REINDEXALL'
		SET @dbSep = '|'
	END
	IF ((@dbMaintLevel & 128) > 0)
	BEGIN
		SET @dbMaintLevelName += @dbSep + 'SHRINKDB'
		SET @dbSep = '|'
	END
	SELECT
		@dbMaintTime = dbo.GetDateTime(value)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = N'FullDBMaintenanceTime'
	-- Get Commserver JM Load XML
	DECLARE @jmLoadXML XML = ''		-- initialize to capture in argument output
	EXEC JMComputeJobLoadReport @inReportHours=6, @outXMLOutput=@jmLoadXML OUTPUT
	-- Create Commserv Report XML
	SET @csInfoXML = (
		SELECT
			@csName '@Name',
			@release '@Release',
			@csGUID '@GUID',
			@ccNumber '@Number',
			@clientCount '@clientCount',
			@clientCountDecfg '@clientsDeconfig',
			(
				SELECT
					@dbMaintLevelName '@level',
					@dbMaintTime '@date'
				WHERE
					@dbMaintLevelName <> ''
				FOR XML PATH('DbMaintenance'), TYPE
			),
			(
				SELECT
					(
						SELECT
							cp.attrVal
						FROM APP_ClientProp cp WITH(NOLOCK)
						WHERE
							cp.modified = 0
							AND cp.componentNameId = @csId
							AND cp.attrName = N'SP Version and patch Info'
					) '@ServicePack',
					(
						SELECT
							p.id '@id',
							p.Name '@Name'
						FROM simInstalledPackages ip2 WITH(NOLOCK)
							INNER JOIN simPackage p WITH(NOLOCK) ON
								ip2.simPackageID = p.id
						WHERE
							ip2.clientId = @csId
						FOR XML PATH('Package'), ROOT('PackageList'), TYPE
					)
				FOR XML PATH('Packages'), TYPE
			),
			@jmLoadXML
		FOR XML PATH('CommserverInfo'), TYPE
	)
	RETURN 0
END

IF EXISTS (select * from GxQscripts where name = 'SQLServerCommserverInfo')
	delete from GxQscripts where name = 'SQLServerCommserverInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLServerCommserverInfo')
	delete from GXDBVersions where aliasname = 'SQLServerCommserverInfo'
GO

insert into GXDBVersions values(2, 'SQLServerCommserverInfo',  'v1.1.2.1.20.2', 'SQLServerCommserverInfo', 'v1.1.2.1.20.2')
GO

