

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLRepairOrphanedDBUsers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
-- This proc needs to execute as sqladmin_cv login and not as dbo to be able to
-- successfully call sp_change_users_login with UPDATE_ONE.
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SQLRepairOrphanedDBUsers')
BEGIN
	print '>>> Drop Stored Procedure: SQLRepairOrphanedDBUsers <<<'
	drop procedure SQLRepairOrphanedDBUsers
END
IF EXISTS (select * from GxQscripts where name='SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO
print '... Creating Procedure: SQLRepairOrphanedDBUsers'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SQLRepairOrphanedDBUsers
  @dbName NVARCHAR(255)
AS
  DECLARE @RepairedUserName NVARCHAR(128)
BEGIN TRY
	-- Remember results because this is a two pass op.
	CREATE TABLE #OrphanedUsers
	(UserName NVARCHAR(128), UserSID varbinary(85))
	-- Find out who all got orphaned.
	INSERT INTO #OrphanedUsers
	EXEC sp_change_users_login 'REPORT'
	-- Eliminate people we dont care about.
	DELETE FROM #OrphanedUsers
	WHERE UserName NOT IN ('sqladmin_cv', 'sqlexec_cv')
	-- Do sqladmin_cv.
	IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqladmin_cv')
	EXEC sp_change_users_login 'UPDATE_ONE', 'sqladmin_cv', 'sqladmin_cv'
	-- Do sqlexec_cv.
	IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = 'sqlexec_cv')
	EXEC sp_change_users_login 'UPDATE_ONE', 'sqlexec_cv', 'sqlexec_cv'
	-- Let the caller know what's up.
	SELECT UserName
	FROM #OrphanedUsers
	-- Clean up.
	DROP TABLE #OrphanedUsers
	-- Make sure the requested db is found.
	IF DB_ID (@dbName) IS NULL
	BEGIN
		PRINT 'INFO: Database [' + @dbName + '] not found.'
		RETURN
	END
	DECLARE @dynamicQuery NVARCHAR(1000)
	DECLARE @userCount INT
	SET @dynamicQuery = N'SELECT @userCount=COUNT(*) FROM ' + @dbName + '.sys.sysusers WHERE name = ''sqlexec_cv''';
	EXECUTE sp_executesql @dynamicQuery, N'@userCount int OUTPUT', @userCount = @userCount OUTPUT
	SELECT  @userCount AS userCount
	if @userCount = 0
	begin
		DECLARE @sqlCommand varchar(1000)
		set @sqlcommand =
		'use [' + @dbName + '];
		CREATE USER sqlexec_cv FOR LOGIN sqlexec_cv;
		CREATE ROLE db_cvexecutor
		EXEC sp_addrolemember ''db_datareader'', ''db_cvexecutor''
		EXEC sp_addrolemember ''db_datawriter'', ''db_cvexecutor''
		-- Be able to execute stored procedures.
		GRANT EXECUTE on schema::dbo TO db_cvexecutor
		EXEC sp_addrolemember ''db_cvexecutor'', ''sqlexec_cv''
		'
		exec (@sqlcommand)
	end
	else
	begin
	     set @sqlcommand =
         'use [' + @dbName + '];
              CREATE TABLE #OrphanedUsers(UserName NVARCHAR(128), UserSID varbinary(85))
              -- Find out who all got orphaned.
              INSERT INTO #OrphanedUsers
              EXEC sp_change_users_login ''REPORT''
              -- Eliminate people we dont care about.
              DELETE FROM #OrphanedUsers
              WHERE UserName NOT IN (''sqlexec_cv'')
              -- Do sqlexec_cv.
              IF EXISTS (SELECT * FROM #OrphanedUsers WHERE UserName = ''sqlexec_cv'')
              EXEC sp_change_users_login ''UPDATE_ONE'', ''sqlexec_cv'', ''sqlexec_cv''
              -- Clean up.
              DROP TABLE #OrphanedUsers
              '
        exec (@sqlcommand)
	end
	-- sqlexec_cv needs ALTER permission on historydb..mmresource
	IF @dbName = 'HistoryDB'
	BEGIN
	if not exists (	select 1
					from sys.database_permissions P
					JOIN sys.tables T ON P.major_id = T.object_id
					JOIN sysusers U ON U.uid = P.grantee_principal_id
					WHERE P.permission_name = 'ALTER' AND U.name='sqlexec_cv' AND T.name = 'MMResource' AND STATE='G' )
	begin
		DECLARE @sqlgrant varchar(255) = '
		use [' + @dbName + '];
		grant alter on MMResource to sqlexec_cv';
		exec(@sqlgrant)
	end
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	DECLARE @ErrMsg NVARCHAR(4000) = ERROR_MESSAGE()
	DECLARE @ErrSev INT = ERROR_SEVERITY()
	DECLARE @ErrState INT = ERROR_STATE()
	RAISERROR (@ErrMsg, @ErrSev, @ErrState)
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SQLRepairOrphanedDBUsers')
	delete from GxQscripts where name = 'SQLRepairOrphanedDBUsers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLRepairOrphanedDBUsers')
	delete from GXDBVersions where aliasname = 'SQLRepairOrphanedDBUsers'
GO

insert into GXDBVersions values(2, 'SQLRepairOrphanedDBUsers',  '00000000000000000000', 'SQLRepairOrphanedDBUsers', '00000000000000000000')
GO

