

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLActiveTempDbXMLMonitor.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLActiveTempDbXMLMonitor.sp,v $ $Id: SQLActiveTempDbXMLMonitor.sp,v 1.1.2.1 2020/11/06 21:57:09 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLActiveTempDbXMLMonitor')
BEGIN
	print '>>> Drop Stored Procedure: SQLActiveTempDbXMLMonitor <<<'
	drop procedure SQLActiveTempDbXMLMonitor
END
IF EXISTS (select * from GxQscripts where name='SQLActiveTempDbXMLMonitor')
	delete from GxQscripts where name = 'SQLActiveTempDbXMLMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLActiveTempDbXMLMonitor')
	delete from GXDBVersions where aliasname = 'SQLActiveTempDbXMLMonitor'
GO
print '... Creating Procedure: SQLActiveTempDbXMLMonitor'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLActiveTempDbXMLMonitor
  @errorCode INT OUTPUT,
  @errorMsg VARCHAR(1024) OUTPUT
AS
BEGIN
	SET NOCOUNT ON
	SET @errorCode = 0
	SET @errorMsg = 'Success'
	-- Get SQL Server TempDb XML document
	DECLARE @output XML
	EXEC SQLActiveTempDbLogGrowthXML
				@i_isOutputXML = 1,
				@i_outputXML = @output OUTPUT
	DECLARE @nowUTC DATETIME = GETUTCDATE()
	DECLARE @nowUnix INT = dbo.GetUnixTime(@nowUTC)
	DECLARE @ninetyDaysAgo DATETIME = DATEADD(day, -30, @nowUTC)
	DECLARE @pruneDt INT = dbo.GetUnixTime(@ninetyDaysAgo)
	BEGIN TRY
		BEGIN TRAN SQLActiveTempDbXMLMonitorTran
		UPDATE gp
			SET modified = @nowUnix
		FROM GXGlobalParam gp
		WHERE
			gp.name = N'SQLActiveTempDbXMLMonitor'
			AND gp.modified = 0
		-- Age off old data
		DELETE gp
		FROM GXGlobalParam gp
		WHERE
			gp.name = N'SQLActiveTempDbXMLMonitor'
			AND gp.modified <= @pruneDt
		INSERT INTO GXGlobalParam (name, value, created, modified)
			VALUES (N'SQLActiveTempDbXMLMonitor', CAST(@output AS NVARCHAR(MAX)), @nowUnix, 0)
		COMMIT TRAN SQLActiveTempDbXMLMonitorTran
	END TRY
	BEGIN CATCH
		ROLLBACK TRAN SQLActiveTempDbXMLMonitorTran
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorMsg = ERROR_MESSAGE()
		RETURN 1
	END CATCH
	RETURN 0
END

IF EXISTS (select * from GxQscripts where name = 'SQLActiveTempDbXMLMonitor')
	delete from GxQscripts where name = 'SQLActiveTempDbXMLMonitor'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLActiveTempDbXMLMonitor')
	delete from GXDBVersions where aliasname = 'SQLActiveTempDbXMLMonitor'
GO

insert into GXDBVersions values(2, 'SQLActiveTempDbXMLMonitor',  '00010001000200010000', 'SQLActiveTempDbXMLMonitor', '00010001000200010000')
GO

