

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SQLActiveTempDbLogGrowthXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SQLActiveTempDbLogGrowthXML.sp,v $ $Id: SQLActiveTempDbLogGrowthXML.sp,v 1.1.2.3 2020/11/21 16:53:26 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SQLActiveTempDbLogGrowthXML')
BEGIN
	print '>>> Drop Stored Procedure: SQLActiveTempDbLogGrowthXML <<<'
	drop procedure SQLActiveTempDbLogGrowthXML
END
IF EXISTS (select * from GxQscripts where name='SQLActiveTempDbLogGrowthXML')
	delete from GxQscripts where name = 'SQLActiveTempDbLogGrowthXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLActiveTempDbLogGrowthXML')
	delete from GXDBVersions where aliasname = 'SQLActiveTempDbLogGrowthXML'
GO
print '... Creating Procedure: SQLActiveTempDbLogGrowthXML'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SQLActiveTempDbLogGrowthXML
  @i_isOutputXML INT = 0,
  @i_outputXML XML = NULL OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @outputXml XML = NULL;
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @now DATETIME = GETDATE()
	DECLARE @utc DATETIME = GETUTCDATE()
	IF OBJECT_ID('TempDb..#TempDbTran') IS NOT NULL
		DROP TABLE #TempDbTran
	CREATE TABLE #TempDbTran (
	   [type]	VARCHAR(32),
	   [value]	VARCHAR(64)
	)
	IF OBJECT_ID('TempDb..#TempDbTranInfo') IS NOT NULL
		DROP TABLE #TempDbTranInfo
	CREATE TABLE #TempDbTranInfo (
	   spid				INT,
	   startTime		DATETIME,
	   elapseSeconds	INT DEFAULT 0
	)
	-- Tunables
	DECLARE @maxMinutesUntilKill INT = 10
	DECLARE @killSPID BIT = 1				-- Kill SPID true or false
	DECLARE @rcnt INT = 0
	DECLARE @maxSeconds INT = (60 * @maxMinutesUntilKill)		-- max time to allow transaction TempDb VLF lock
	DECLARE @sqlCmd NVARCHAR(MAX)
	-- Get Transaction currently holding TempDb VLF Lock
	INSERT INTO #TempDbTran
	   EXEC ('USE TempDb; DBCC OPENTRAN WITH TABLERESULTS, NO_INFOMSGS');
	SET @rcnt = @@ROWCOUNT
	DECLARE @curTempDbTranSpid XML = NULL
	IF (@rcnt > 0)
	BEGIN
		INSERT INTO #TempDbTranInfo (spid, startTime)
			SELECT
				(SELECT
					CAST([value] AS INT)
				FROM #TempDbTran
				WHERE
					[type] = 'OLDACT_SPID') spid,
				(SELECT
					CAST([value] AS DATETIME)
				FROM #TempDbTran
				WHERE
					[type] = 'OLDACT_STARTTIME') startTime
		UPDATE #TempDbTranInfo
			SET elapseSeconds = DATEDIFF(second, startTime, @now)
		SET @curTempDbTranSpid = (
			SELECT
				t.spid '@spid',
				t.startTime '@tranStartTime',
				t.elapseSeconds '@tranDurationSec'
			FROM #TempDbTranInfo t
			FOR XML PATH('TempDbTran'), TYPE
		)
	END
	-- Get current TempDb data and log file sizes
	DECLARE @tempDbNode XML = (
		SELECT
			([Data File(s) Size (KB)]/1024) '@dataSizeMB',
			([Log File(s) Size (KB)]/1024) '@logSizeMB',
			([Log File(s) Used Size (KB)]/1024) '@logSpaceUsedSizeMB',
			((([Log File(s) Used Size (KB)]/1024.0) / ([Log File(s) Size (KB)]/1024.0)) * 100) '@logPercentageUsed',
			(
				SELECT
					CASE mf.is_percent_growth
						WHEN 0 THEN 'false'
						ELSE 'true'
					END [@isLogPercentGrowth],
					CASE mf.max_size
						WHEN -1 THEN -1		-- Unlimited
						WHEN 0 THEN 0		-- No Growth
						WHEN 268435456 THEN -2	-- Log file will grow to a maximum size of 2 TB
						ELSE CAST(((mf.max_size * 8) / 1024) AS VARCHAR(12))
					END [@maxLogSizeMB],
					'0:No Growth, -1:Unlimited, -2:Log file will grow to a maximum size of 2 TB' [@key],
					CASE
						WHEN mf.growth = 0 THEN 0			-- No Growth
						WHEN mf.is_percent_growth = 1 THEN mf.growth	-- percentage
						ELSE ((mf.growth * 8) / 1024)
					END [@logGrowthSizeMB]
				FROM sys.master_files AS mf WITH(NOLOCK)
				WHERE
					mf.database_id = 2		-- tempdb
					AND mf.type = 1			-- log file
				FOR XML PATH('Growth'), TYPE
			)
		FROM (
				SELECT *
				FROM sys.dm_os_performance_counters
				WHERE
					counter_name IN (
						'Data File(s) Size (KB)',
						'Log File(s) Size (KB)',
						'Log File(s) Used Size (KB)'
					)
					AND instance_name = 'tempdb'
					AND instance_name = 'tempdb'
			) q
		PIVOT
		(
			MAX(cntr_value) FOR counter_name IN (
				[Data File(s) Size (KB)],
				[LOG File(s) Size (KB)],
				[Log File(s) Used Size (KB)]
			)
		) p
		FOR XML PATH('TempDbSize'), TYPE
	)
	IF OBJECT_ID('TempDb..#spidInfo') IS NOT NULL
		DROP TABLE #spidInfo
	CREATE TABLE #spidInfo (
		spid			INT,
		reqId			INT,
		loginTime		DATETIME,
		blocked			INT,
		dbId			INT,
		dbName			SYSNAME,
		--cpu				INT,
		openTran		INT,
		status			VARCHAR(128),
		hostname		VARCHAR(255),
		pgmName			VARCHAR(255),
		loginName		SYSNAME,
		sqlStatement	NVARCHAR(MAX),
		sqlText			NVARCHAR(MAX),
		tranStartTime	DATETIME DEFAULT NULL,
		tranDurationSec	INT NULL DEFAULT NULL,
		tranName		SYSNAME NULL DEFAULT NULL,
		isUserTran		TINYINT NULL DEFAULT NULL,
		openTranCnt		INT NULL DEFAULT NULL,
		tranType		INT NULL DEFAULT NULL,
		tranTypeName	SYSNAME NULL DEFAULT NULL,
		tranState		INT NULL DEFAULT NULL,
		tranStateName	SYSNAME NULL DEFAULT NULL,
		tempDbLogSpaceKb	BIGINT NULL DEFAULT NULL,
		tempDbAllocs	BIGINT NULL DEFAULT NULL,
		tempDbCurrentUsage	BIGINT NULL DEFAULT NULL,
		PRIMARY KEY CLUSTERED (spid, reqId) WITH (IGNORE_DUP_KEY = ON)
	)
	INSERT INTO #spidInfo (spid, reqId, loginTime, blocked, dbId, dbName, openTran, status, hostname, pgmName, loginName, sqlStatement, sqlText, tempDbAllocs, tempDbCurrentUsage)
		SELECT DISTINCT
			p.spid '@spid',
			p.request_id '@reqId',
			p.login_time '@loginTime',
			p.blocked '@blocked',
			p.dbId '@dbId',
			DB_NAME(p.dbId) '@dbName',
			--p.cpu '@cpuMS',
			p.open_tran '@openTran',
			RTRIM(p.status) '@status',
			RTRIM(p.hostname) '@hostname',
			RTRIM(p.program_name) '@pgmName',
			RTRIM(p.loginame) '@loginName',
			(
				CASE
					WHEN t.text IS NULL THEN NULL
					ELSE (
						ISNULL(
							NULLIF(
								SUBSTRING(
									t.text,
									er.statement_start_offset / 2,
									CASE
										WHEN er.statement_end_offset < er.statement_start_offset THEN 0
										ELSE (er.statement_end_offset - er.statement_start_offset ) / 2
									END
								), ''
							), (SUBSTRING(CAST(t.text AS NVARCHAR(MAX)), 0, 100) + N'....')
						) + NCHAR(13) + NCHAR(10)
					)
				END
			),
			(
				CASE
					WHEN t.text IS NULL THEN NULL
					ELSE (
						SUBSTRING(CAST(t.text AS NVARCHAR(MAX)), 0, 100) + N'....' + NCHAR(13) + NCHAR(10)
					)
				END
			),
			u.allocations,
			IIF((u.currentUsage IS NOT NULL AND u.currentUsage > 0), u.currentUsage, NULL)
		FROM sys.sysprocesses p
			LEFT OUTER JOIN sys.dm_exec_requests er ON
				er.session_id = p.spid
			OUTER APPLY sys.dm_exec_sql_text(er.sql_handle) t
			LEFT JOIN (
				SELECT
					q.session_id,
					SUM(q.allocations) allocations,
					SUM(q.currentUsage) currentUsage
				FROM (
						SELECT
							tsu.session_id,
							(tsu.user_objects_alloc_page_count + tsu.internal_objects_alloc_page_count) allocations,
							(tsu.user_objects_alloc_page_count + tsu.internal_objects_alloc_page_count) - (tsu.user_objects_dealloc_page_count + tsu.internal_objects_dealloc_page_count) currentUsage
						FROM sys.dm_db_task_space_usage AS tsu
						WHERE
							tsu.database_id = 2
						UNION ALL
						SELECT
							ssu.session_id,
							(ssu.user_objects_alloc_page_count + ssu.internal_objects_alloc_page_count) allocations,
							(ssu.user_objects_alloc_page_count + ssu.internal_objects_alloc_page_count) - (ssu.user_objects_dealloc_page_count + ssu.internal_objects_dealloc_page_count) currentUsage
						FROM sys.dm_db_session_space_usage AS ssu
						WHERE
							ssu.database_id = 2
					) AS q
				WHERE
					q.currentUsage > 0
					OR q.allocations > 0
				GROUP BY
					q.session_id
			) u ON
				u.session_id = p.spid
		WHERE
			p.spid > 50					-- do not capture SQL Server system processes / sessions
			AND p.spid <> @@SPID		-- do not capture this executing session
			AND (
				p.status <> 'sleeping'
				OR p.open_tran > 0		-- show sessions with transaction even if sleeping
				--OR u.allocations > 0
				--OR u.currentUsage > 0
			)
	UPDATE p
		SET
			tranStartTime = at.transaction_begin_time,
			tranDurationSec = DATEDIFF(ss, at.transaction_begin_time, GETDATE()),
			tranName = at.name,
			isUserTran = st.is_user_transaction,
			openTranCnt = st.open_transaction_count,
			tranType = at.transaction_type,
			tranTypeName = CASE at.transaction_type
								WHEN 1 THEN 'RD/WR'
								WHEN 2 THEN 'RO'
								WHEN 3 THEN 'SYS'
								WHEN 4 THEN 'DTC'
							END,
			tranState = at.transaction_state,
			tranStateName = CASE at.transaction_state
								WHEN 0 THEN 'Initializing'
								WHEN 1 THEN 'Initialized'
								WHEN 2 THEN 'Active'
								WHEN 3 THEN 'Ended, RO'
								WHEN 4 THEN 'Commit, DTC'
								WHEN 5 THEN 'Prepared'
								WHEN 6 THEN 'Committed'
								WHEN 7 THEN 'Rolling Back'
								WHEN 8 THEN 'Rolled Back'
							END,
			TempDbLogSpaceKb = (
				CASE tdt.database_transaction_log_bytes_reserved
					WHEN 0 THEN NULL
					ELSE (tdt.database_transaction_log_bytes_reserved / 1024.0)
				END
			)
	FROM #spidInfo p
		INNER JOIN sys.dm_tran_session_transactions st ON
			st.session_id = p.spid
		LEFT JOIN sys.dm_tran_active_transactions at ON
			at.transaction_id = st.transaction_id
		LEFT JOIN sys.dm_tran_database_transactions tdt ON
			tdt.database_id = 2			-- tempdb
			AND tdt.transaction_id = st.transaction_id
	-- Generate an XML Document for active SPIDs using TempDb
	SET @i_outputXML = (
		SELECT
			@now '@localTime',
			@utc '@utcTime',
			@tempDbNode,
			@curTempDbTranSpid,
			(
				SELECT
					p.spid '@spid',
					p.reqId '@reqId',
					p.loginTime '@loginTime',
					p.blocked '@blocked',
					p.dbId '@dbId',
					p.dbName '@dbName',
					p.openTran '@openTran',
					p.status '@status',
					p.hostname '@hostname',
					p.pgmName '@pgmName',
					p.loginName '@loginName',
					p.tranStartTime '@tranStartTime',
					p.tranDurationSec '@tranDurationSec',
					p.tranName '@tranName',
					p.isUserTran '@isUserTran',
					p.openTranCnt '@openTranCnt',
					p.tranType '@tranType',
					p.tranTypeName '@tranTypeName',
					p.tranState '@tranState',
					p.tranStateName '@tranStateName',
					p.TempDbLogSpaceKb '@TempDbLogSpaceKb',
					p.tempDbAllocs '@tempDbAllocsPages',
					p.TempDbCurrentUsage '@TempDbCurrentUsagePages',
					-- added wrapper nodes so that the contents can be queried, cannot query comment nodes directly!
					CAST(('<statement><?sqlStatement -- ' +  NCHAR(13) + NCHAR(10) + p.sqlStatement + NCHAR(13) + NCHAR(10) + '--?></statement>') AS XML),
					CAST(('<text><?sqlText -- ' +  NCHAR(13) + NCHAR(10) + p.sqlText + NCHAR(13) + NCHAR(10) + '--?></text>') AS XML)
				FROM #spidInfo p
				ORDER BY p.tranDurationSec DESC
				FOR XML PATH('SPID'), TYPE
			)
		FOR XML PATH('ActiveSPIDs'), TYPE
	)
	IF(@i_isOutputXML = 0)
	BEGIN
		SELECT @i_outputXML sqlActiveTempDbLogGrowthReport
	END
	RETURN
END
GO

IF EXISTS (select * from GxQscripts where name = 'SQLActiveTempDbLogGrowthXML')
	delete from GxQscripts where name = 'SQLActiveTempDbLogGrowthXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SQLActiveTempDbLogGrowthXML')
	delete from GXDBVersions where aliasname = 'SQLActiveTempDbLogGrowthXML'
GO

insert into GXDBVersions values(2, 'SQLActiveTempDbLogGrowthXML',  '00010001000200030000', 'SQLActiveTempDbLogGrowthXML', '00010001000200030000')
GO

