

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_UpdateImportParams.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "SProv_UpdateImportParams"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_UpdateImportParams <<<'

IF EXISTS (select * from sysobjects where name='SProv_UpdateImportParams')
	drop procedure SProv_UpdateImportParams
IF EXISTS (select * from GxQscripts where name='SProv_UpdateImportParams')
	delete from GxQscripts where name = 'SProv_UpdateImportParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_UpdateImportParams')
	delete from GXDBVersions where aliasname = 'SProv_UpdateImportParams'
GO
print '... Creating Procedure: SProv_UpdateImportParams'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_UpdateImportParams
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256),
  @xmlop XML OUTPUT
AS
  DECLARE @o_xmlop XML
SET NOCOUNT ON
DECLARE @userId INT
DECLARE @opType INT
DECLARE @errorCode INT = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
DECLARE @lunList XML
DECLARE @userName NVARCHAR(1024) = ''
SET @userId = (SELECT R.ref.value('@userId', 'INT') FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref))
SET @opType = (SELECT R.ref.value('@operation', 'INT') FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref))
SET @userName = (SELECT name FROM UMUsers WHERE id = @userId)
DECLARE @osMap TABLE
(
	osId INT,
	osName nvarchar(1024)
)
--insert os info
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
The OS List here SHOULD match the list in createStorage.jsp file.
The OS types are hardcoded. Initially it was driven by simoperatingsystem tbl.
As all the NetApp OS types were not present in the table, We decided to hardcode the os types.
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
INSERT INTO @osMap (osId, osName) VALUES    (1, 'vmware'),
											(2, 'hyper_v'),
											(3, 'windows_2008'),
											(4, 'windows_gpt'),
											(5, 'windows'),
											(6, 'linux'),
											(7, 'xen'),
											(8, 'solaris'),
											(9, 'solaris_efi'),
											(10, 'hpux'),
											(11, 'aix'),
											(12, 'netware'),
											(13, 'openvms')
DECLARE @lunTbl TABLE
(
	lunId INT,
	lunName NVARCHAR(1024),
	lunPath NVARCHAR(2048),
	volumeId INT,
	spoolId INT,
	arraynum INT,
	osId INT,
	osName nvarchar(1024),
	status INT
)
DECLARE @smendpt TABLE
(
	endPtId INT,
	ClientId INT,
	address NVARCHAR(2048),
	addressType INT,
	dbId INT
)
DECLARE @lunMapping TABLE
(
	lunId INT,
	epId INT,
	clientId INT,
	addressType INT,
	dbId INT
)
INSERT INTO @lunTbl
	SELECT
	R.ref.value('@lunId', 'INT'),
	R.ref.value('@lunName', 'nvarchar(1024)'),
	R.ref.value('@lunPath', 'nvarchar(1024)'),
	R.ref.value('@volumeId', 'INT'),
	R.ref.value('@storagePoolId', 'INT'),
	R.ref.value('@arrayNum', 'INT'),
	0,
	R.ref.value('@osTypeName', 'nvarchar(1024)'),
	R.ref.value('@status', 'INT')
	FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
--update osId
UPDATE @lunTbl
	   SET osId = osMp.osId
	   FROM @osMap osMp INNER JOIN @lunTbl ON osMp.osName = [@lunTbl].osName
--Process only those LUNs whose status is not SPROV_LS_IMP_FAILED
INSERT INTO @smendpt
	SELECT
	R.ref.value('@endPointId', 'INT'),
	1,
	R.ref.value('@address', 'nvarchar(2048)'),
	R.ref.value('@addressType', 'INT'),
	0
	FROM
	@xmlText.nodes('/StorageProvisioning_MMSProvInfo/endPointList') R(ref)
INSERT INTO @lunMapping
	SELECT
	R.ref.value('@lunId', 'INT'),
	R.ref.value('@endPointId', 'nvarchar(1024)'), 1, 0, 0
	FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList/mountList') R(ref)
--Search if the EP already exists and update  the DbId
UPDATE @smendpt
	SET dbId = SMEndPt.Id
	FROM SMEndPoint SMEndPt
	inner join @smendpt ON
	[@smendpt].address = SMEndPt.Address
--Insert new End Points
INSERT INTO SMEndPoint(ClientId, AddressType, Address)
			SELECT ClientId, addressType, address FROM @smendpt WHERE [@smendpt].dbId = 0
--Update the DbId for the new End Points inserted
UPDATE @smendpt
	SET dbId = SMEndPt.Id
	FROM SMEndPoint SMEndPt
	inner join @smendpt ON
	[@smendpt].address = SMEndPt.Address
	WHERE [@smendpt].dbId = 0
--Set the actual EndPoint Id from the Db
UPDATE @lunMapping
	SET dbId = SMEndPt.dbId,
        [@lunMapping].addressType = SMEndPt.addressType
	FROM @smendpt SMEndPt
	inner join @lunMapping ON
	[@lunMapping].epId = SMEndPt.endPtId
--Now you have the actual end point Id in the dbId field in the @smendpt table
--Set the actual Client Id
UPDATE @lunMapping
	SET clientId = SMEndPt.ClientId
	FROM SMEndPoint SMEndPt
	INNER JOIN @lunMapping ON
	[@lunMapping].dbId = SMEndPt.Id
INSERT INTO SProvEndPoint (EndPointId, ClientId, Enabled)
	SELECT dbId,
		   [@smendpt].ClientId,
		   1
		   FROM @smendpt
		   LEFT OUTER JOIN SProvEndPoint A ON A.EndPointId = [@smendpt].dbId
		   WHERE A.EndPointId IS NULL
INSERT INTO SProvStoragePool(StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled)
	SELECT distinct lnTbl.spoolId, lnTbl.arraynum, 90, 75, 1 FROM @lunTbl lnTbl
	LEFT OUTER JOIN SProvStoragePool A ON lnTbl.spoolId = A.StoragePoolId
	WHERE A.StoragePoolId is null AND lnTbl.status <> 110
INSERT INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, UserId)
	SELECT distinct lnTbl.volumeId, lnTbl.spoolId, lnTbl.arraynum, 1, @userId FROM @lunTbl lnTbl
	LEFT OUTER JOIN SProvArrayVolume A ON lnTbl.volumeId = A.VolumeId
	WHERE A.VolumeId is null AND lnTbl.status <> 110
INSERT INTO SProvLUN(LUNId, VolumeId, StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled, UserId, Criteria, ExpirationDate, OSType, Status, Description)
	SELECT lnTbl.lunId, lnTbl.volumeId, lnTbl.spoolId, lnTbl.arraynum, 90, 75, 1, @userId, 0, DATEADD(DAY, 90, GETUTCDATE()), lnTbl.osId, 1, 'Imported by User: ' + @userName FROM @lunTbl lnTbl
	LEFT OUTER JOIN SProvLun A ON lnTbl.lunId = A.LUNId
	WHERE A.LUNId is null AND lnTbl.status <> 110
INSERT INTO SProvMountLUN(LUNId, EndPointId, MountHostId, MountPath, ProtocolId, UserId, Enabled)
	SELECT lnMp.lunId, lnMp.dbId, lnMp.clientId, '', lnMp.addressType, @userId, 1 FROM @lunMapping lnMp
	LEFT OUTER JOIN SProvMountLUN A ON lnMp.lunId = A.LUNId and lnMp.dbId = A.EndPointId
	WHERE A.LUNId is null and A.EndPointId is null
SET @lunList = (
				SELECT lnTbl.lunId AS '@lunId',
				smLn.Name AS '@lunName',
				smLn.Path AS '@lunPath',
				lnTbl.volumeId AS '@volumeId',
				lnTbl.spoolId AS '@storagePoolId',
				lnTbl.arraynum AS '@arrayNum',
				lnTbl.status AS '@status'
				FROM @lunTbl lnTbl INNER JOIN SMLUN smLn ON lnTbl.lunId = smLn.Id
				FOR XML PATH('lunList')
				)
SET @errorCode = 0
SET @errorMsg = 'Import operation successful'
SET @xmlop = (SELECT @errorCode AS '@errorCode',
					 @errorMsg AS '@errorString',
					 @lunList
					 FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_UpdateImportParams')
	delete from GxQscripts where name = 'SProv_UpdateImportParams'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_UpdateImportParams')
	delete from GXDBVersions where aliasname = 'SProv_UpdateImportParams'
GO

insert into GXDBVersions values(2, 'SProv_UpdateImportParams',  '00000000000000000000', 'SProv_UpdateImportParams', '00000000000000000000')
GO

