

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_ShowStorageProvisioning.sp] ---------- 

/*
*	Author - Munish Tayal (mtayal)
*
* 	This stored procedure will hide/unhide the Storage provisioning feature from webconsole and GUI.
*	If Input is 1, storage provisioning feature will be unhidden.
*	If Input is 0, storage provisioning feature will be hidden.
*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SProv_ShowStorageProvisioning')
BEGIN
	print '>>> Drop Stored Procedure: SProv_ShowStorageProvisioning <<<'
	drop procedure SProv_ShowStorageProvisioning
END
IF EXISTS (select * from GxQscripts where name='SProv_ShowStorageProvisioning')
	delete from GxQscripts where name = 'SProv_ShowStorageProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ShowStorageProvisioning')
	delete from GXDBVersions where aliasname = 'SProv_ShowStorageProvisioning'
GO
print '... Creating Procedure: SProv_ShowStorageProvisioning'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SProv_ShowStorageProvisioning
--Inputs
  @showStorageProvisioning INT
AS
	SET NOCOUNT ON
	DECLARE @oldFlags INTEGER = 0
	DECLARE @newFlags INTEGER = 0
DECLARE @hiddenFlag INTEGER = 0x002 -- UM_PERMISSIONS_HIDDEN_PERMISSION is defined in hex. Bitwise NOT can not be used on hex
	IF (@showStorageProvisioning NOT IN (0, 1))
    BEGIN
        RAISERROR ('Invalid showStorageProvisioning value passed.',16,1)
        RETURN
    END
	IF @showStorageProvisioning = 0
	BEGIN
IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE entityId = 2 /* DEFAULT_COMMCELL_ID */ AND entityType = 3 /* CLIENT_ENTITY */ AND keyName = 'bShowStorageProvisioning')
		BEGIN
			-- Set the advanced setting to hide the Storage provisioning from WebConsole
UPDATE APP_AdvanceSettings SET value = '0' WHERE entityId = 2 /* DEFAULT_COMMCELL_ID */ AND entityType = 3 /* CLIENT_ENTITY */ AND keyName = 'bShowStorageProvisioning'
		END
		-- Hide the capabilities
SET @oldFlags = (SELECT flags FROM UMPermissions WITH(NOLOCK) WHERE id = 206)
		SET @newFlags = @oldFlags | @hiddenFlag
		IF(@oldFlags <> @newFlags)
		BEGIN
			UPDATE UMPermissions
			SET flags = @newFlags
WHERE id = 206
EXEC ReOrderPermissionScriptonFlagChange 206, @newFlags, @oldFlags
		END
SET @oldFlags = (SELECT flags FROM UMPermissions WITH(NOLOCK) WHERE id = 207)
		SET @newFlags = @oldFlags | @hiddenFlag
		IF(@oldFlags <> @newFlags)
		BEGIN
			UPDATE UMPermissions
			SET flags = @newFlags
WHERE id = 207
EXEC ReOrderPermissionScriptonFlagChange 207, @newFlags, @oldFlags
		END
	END
	IF @showStorageProvisioning = 1
	BEGIN
IF EXISTS (SELECT 1 FROM APP_AdvanceSettings WITH(NOLOCK) WHERE entityId = 2 /* DEFAULT_COMMCELL_ID */ AND entityType = 3 /* CLIENT_ENTITY */ AND keyName = 'bShowStorageProvisioning')
		BEGIN
UPDATE APP_AdvanceSettings SET value = '1', enabled = 1 WHERE entityId = 2 /* DEFAULT_COMMCELL_ID */ AND entityType = 3 /* CLIENT_ENTITY */ AND keyName = 'bShowStorageProvisioning'
		END
		ELSE
		BEGIN
			INSERT INTO APP_AdvanceSettings (entityId, KeyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
Values(2 /* DEFAULT_COMMCELL_ID */ , 'bShowStorageProvisioning', 'INTEGER', 'WebConsole', '1', 1, 0, 3 /* CLIENT_ENTITY */, 0, 0)
		END
		-- Unhide the capabilities
SET @oldFlags = (SELECT flags FROM UMPermissions WITH(NOLOCK) WHERE id = 206)
		SET @newFlags = @oldFlags & ~@hiddenFlag
		IF(@oldFlags <> @newFlags)
		BEGIN
			UPDATE UMPermissions
			SET flags = @newFlags
WHERE id = 206
EXEC ReOrderPermissionScriptonFlagChange 206, @newFlags, @oldFlags
		END
SET @oldFlags = (SELECT flags FROM UMPermissions WITH(NOLOCK) WHERE id = 207)
		SET @newFlags = @oldFlags & ~@hiddenFlag
		IF(@oldFlags <> @newFlags)
		BEGIN
			UPDATE UMPermissions
			SET flags = @newFlags
WHERE id = 207
EXEC ReOrderPermissionScriptonFlagChange 207, @newFlags, @oldFlags
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_ShowStorageProvisioning')
	delete from GxQscripts where name = 'SProv_ShowStorageProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ShowStorageProvisioning')
	delete from GXDBVersions where aliasname = 'SProv_ShowStorageProvisioning'
GO

insert into GXDBVersions values(2, 'SProv_ShowStorageProvisioning',  '00000000000000000000', 'SProv_ShowStorageProvisioning', '00000000000000000000')
GO

