

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_ResolveLunsToUsersForImport.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: SProv_ResolveLunsToUsersForImport()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_ResolveLunsToUsersForImport <<<'

IF EXISTS (select * from sysobjects where name='SProv_ResolveLunsToUsersForImport')
	drop procedure SProv_ResolveLunsToUsersForImport
IF EXISTS (select * from GxQscripts where name='SProv_ResolveLunsToUsersForImport')
	delete from GxQscripts where name = 'SProv_ResolveLunsToUsersForImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ResolveLunsToUsersForImport')
	delete from GXDBVersions where aliasname = 'SProv_ResolveLunsToUsersForImport'
GO
print '... Creating Procedure: SProv_ResolveLunsToUsersForImport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_ResolveLunsToUsersForImport
  @xmlText XML,
  @xmlop XML OUTPUT
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
DECLARE @lunTbl TABLE
(
                lunId INT,
                lunName NVARCHAR(1024),
                lunPath NVARCHAR(2048),
                volumeId INT,
                spoolId INT,
                arraynum INT,
				clientID INT,
				vendorName nvarchar(1024),
                osId INT,
                osName nvarchar(1024),
                status INT,
                errorCode INT,
                errorString nvarchar(1024)
)
DECLARE @smendpt TABLE
(
                tempId INT,
                endPtId INT,
                ClientId INT,
                address NVARCHAR(2048),
                addressType INT
)
DECLARE @lunMapping TABLE
(
                lunId INT,
                epId INT,
                clientId INT,
                addressType INT,
                hostId INT,
                address NVARCHAR(2048),
                tempEPId INT
)
INSERT INTO @lunTbl
                SELECT
                R.ref.value('@lunId', 'INT'),
                R.ref.value('@lunName', 'nvarchar(1024)'),
                R.ref.value('@lunPath', 'nvarchar(1024)'),
                R.ref.value('@volumeId', 'INT'),
                R.ref.value('@storagePoolId', 'INT'),
                R.ref.value('@arrayNum', 'INT'),
				1,
				'',
                0,
                R.ref.value('@osTypeName', 'nvarchar(1024)'),
                R.ref.value('@status', 'INT'),
                R.ref.value('@errorCode', 'INT'),
                R.ref.value('@errorString', 'nvarchar(1024)')
                FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
INSERT INTO @smendpt
                SELECT
                R.ref.value('@endPointId', 'INT'),
                0,
                1,
                R.ref.value('@address', 'nvarchar(2048)'),
                R.ref.value('@addressType', 'INT')
                FROM
                @xmlText.nodes('/StorageProvisioning_MMSProvInfo/endPointList') R(ref)
INSERT INTO @lunMapping
                SELECT
                R.ref.value('@lunId', 'INT'),
                R.ref.value('endPointList[1]/@endPointId', 'nvarchar(1024)'),
                1,
				R.ref.value('endPointList[1]/@addressType', 'nvarchar(1024)'),
				0,
				'',
                R.ref.value('endPointList[1]/@endPointId', 'INT')
                FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList/mountList') R(ref)
--SELECT * FROM @lunTbl
--SELECT * FROM @smendpt
--SELECT * FROM @lunMapping
--Update clientId
UPDATE @lunTbl
SET clientID = S_POOL.ClientId
FROM SMStoragePool S_POOL INNER JOIN @lunTbl T_LUN ON T_LUN.spoolId = S_POOL.Id
--Update vendor name
UPDATE @lunTbl
SET vendorName = S_HOST.SnapVendorName
FROM SMControlHost S_HOST INNER JOIN @lunTbl T_LUN ON T_LUN.clientID = S_HOST.ClientId
UPDATE @smendpt
SET ClientId = SMEndPt.ClientId
FROM SMEndPoint SMEndPt INNER JOIN @smendpt tempSMEP ON tempSMEP.address = SMEndPt.Address
UPDATE @lunMapping
SET clientId = tempSMEP.ClientId
FROM @smendpt tempSMEP INNER JOIN @lunMapping tempLnMp ON tempLnMp.epId = tempSMEP.endPtId
--you don't update the @smendpt's end point id in the first update query WHERE you update the @smendpt's client id is because
--initially the ep id's are negative and you need something to compare to update the @lunMapping table's client id.
UPDATE @smendpt
SET endPtId = SMEndPt.Id
FROM SMEndPoint SMEndPt INNER JOIN @smendpt tempSMEP ON SMEndPt.ClientId = tempSMEP.ClientId AND tempSMEP.address = SMEndPt.Address
UPDATE LUN
SET epId = TMP.endPtId,
    clientId = TMP.ClientId,
    address = TMP.address
FROM @smendpt TMP INNER JOIN @lunMapping LUN ON TMP.tempId = LUN.epId
UPDATE @lunMapping
SET hostId = SPrvHst.SProvHostId
FROM SProvHost SPrvHst INNER JOIN @lunMapping tempLnMp ON tempLnMp.ClientId = SPrvHst.ClientId
--SELECT * FROM @lunTbl
--SELECT * FROM @smendpt
--SELECT * FROM @lunMapping
SET @xmlop =
(SELECT
		--arrayFamilyList
		(SELECT S_VEN.Id AS '@vendorId',
				S_VEN.Name AS '@vendorName',
				S_VEN.IsProvisionCapable AS '@flags',
				(SELECT S_ARR.Id AS '@arrayNum',
						S_ARR.ArrayName AS '@arrayName',
						S_ARR.ClientId AS 'client/@clientId',
						(SELECT S_POOL.Id AS '@storagePoolId',
								S_POOL.Name AS '@storagePoolName',
								S_ARR.Id AS '@arrayNum'
						 FROM SMStoragePool S_POOL
						 WHERE S_POOL.ClientId = S_ARR.ClientId
						 FOR XML PATH('poolList'), TYPE)
				 FROM SMArray S_ARR INNER JOIN SMControlHost S_HOST ON S_HOST.ClientId = S_ARR.ClientId
				 WHERE S_HOST.SnapVendorName = S_VEN.Name AND
					   S_ARR.Id IN (SELECT arraynum FROM @lunTbl)
				 FOR XML PATH('arrayList'), TYPE)
		 FROM SMVendor S_VEN WHERE Name IN (SELECT DISTINCT vendorName FROM @lunTbl)
		 FOR XML PATH('arrayFamilyList'), TYPE),
		 --endPointList
		(SELECT T_EP.Address AS '@address',
				T_EP.AddressType AS '@addressType',
				T_EP.tempId AS '@endPointId',
				T_EP.ClientId AS 'client/@clientId'
		 FROM @smendpt T_EP
		 FOR XML PATH('endPointList'), TYPE),
		 --lunList
		(SELECT SMLN.Name AS '@lunName',
				SMLN.Id AS '@lunId',
				SMLN.Path AS '@lunPath',
				tempLnTbl.arraynum AS '@arrayNum',
				tempLnTbl.volumeId AS '@volumeId',
				tempLnTbl.spoolId AS '@storagePoolId',
				tempLnTbl.errorCode AS '@errorCode',
				tempLnTbl.errorString AS '@errorString',
				(SELECT SMLN.Id AS '@lunId',
						tempLnMap.clientId AS 'mountHost/@clientId',
						A_CLIENT.name AS 'mountHost/@clientName',
						(SELECT lnMap1.Address AS '@address',
								lnMap1.tempEPId AS '@endPointId',
								lnMap1.addressType AS '@addressType',
								lnMap1.ClientId AS 'client/@clientId',
								(SELECT DISTINCT SPrvEPt.userId AS '@userId'
								 FROM SProvEndPoint SPrvEPt
								 WHERE lnMap1.epId = SPrvEPt.EndPointId AND lnMap1.clientId= SPrvEPt.ClientId
								 FOR XML PATH('userList'), TYPE)
						 FROM @lunMapping lnMap1
						 WHERE lnMap1.ClientId = tempLnMap.clientId AND lnMap1.lunId = tempLnMap.lunId
						 FOR XML PATH('endPointList'), TYPE),
						 (SELECT DISTINCT SPrvHost.UserId AS '@userId', U_USERS.login '@userName' FROM SProvHost SPrvHost LEFT JOIN UMUsers U_USERS ON U_USERS.id = SPrvHost.UserId WHERE SPrvHost.ClientId = tempLnMap.clientId FOR XML PATH('regUsersList'), TYPE)
						 FROM (SELECT DISTINCT lunId, ClientId, hostId FROM @lunMapping) tempLnMap LEFT JOIN APP_Client A_CLIENT ON A_CLIENT.id = tempLnMap.clientId WHERE SMLN.Id = tempLnMap.lunId
						 FOR XML PATH('mountList'), TYPE)
			FROM SMLUN SMLN INNER JOIN @lunTbl tempLnTbl ON tempLnTbl.lunId = SMLN.Id
			FOR XML PATH('lunList'), TYPE)
FOR XML PATH('StorageProvisioning_MMSProvInfo'))
SET @o_outXML = @xmlop
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_ResolveLunsToUsersForImport')
	delete from GxQscripts where name = 'SProv_ResolveLunsToUsersForImport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ResolveLunsToUsersForImport')
	delete from GXDBVersions where aliasname = 'SProv_ResolveLunsToUsersForImport'
GO

insert into GXDBVersions values(2, 'SProv_ResolveLunsToUsersForImport',  '00000000000000000000', 'SProv_ResolveLunsToUsersForImport', '00000000000000000000')
GO

