

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_PreProcessSProvOperationHedvig.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_PreProcessSProvOperationHedvig.sp,v $ $Id: SProv_PreProcessSProvOperationHedvig.sp,v 1.1.4.3 2020/10/27 17:29:56 macharya Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "Sprov_PreProcessSProvOperationHedvig"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SProv_PreProcessSProvOperationHedvig')
BEGIN
	print '>>> Drop Stored Procedure: SProv_PreProcessSProvOperationHedvig <<<'
	drop procedure SProv_PreProcessSProvOperationHedvig
END
IF EXISTS (select * from GxQscripts where name='SProv_PreProcessSProvOperationHedvig')
	delete from GxQscripts where name = 'SProv_PreProcessSProvOperationHedvig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvOperationHedvig')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvOperationHedvig'
GO
print '... Creating Procedure: SProv_PreProcessSProvOperationHedvig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_PreProcessSProvOperationHedvig
  @i_xmlText XML,
  @i_reserveInt INT,
  @i_reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
-- *********** Local Variables *********** --
DECLARE @l_errorCode			INT					= 0
DECLARE @l_errorMsg				VARCHAR(255)		= ''
DECLARE @l_userId				INT					= 0
DECLARE @l_clientId				INT					= 0
DECLARE @l_subclientId			INT					= 0
DECLARE @l_arrayNum				INT					= 0				---- SMControlHost
DECLARE @l_vendorId				INT					= 0
DECLARE @l_arrayId				INT					= 0				---- SMArray
DECLARE @l_totalLunSize			INT					= 0
DECLARE @l_sizeInBytes			BIGINT				= 0
DECLARE @l_policyId				INT					= -3			---- There are default policy with -1/-2 IDs.
DECLARE @l_policyTypeId			INT					= 0
DECLARE @l_storagePoolName		VARCHAR(255)		= ''
DECLARE @l_storagePoolId		INT					= 0
DECLARE @l_criteria				INT					= 0
DECLARE @guid					UNIQUEIDENTIFIER	= NEWID()
DECLARE @guidStr				NVARCHAR(1024)		= CONVERT(NVARCHAR(1024), @guid)
DECLARE @l_insertQuery			NVARCHAR(MAX)		= N''
DECLARE @l_arrayConfigStr		NVARCHAR(MAX)		= N''
DECLARE @l_curCredAssocId		INT					= -1
DECLARE @POLICY_TYPE_BLOCK_STORAGE			VARCHAR(32) = 'Block Storage'
DECLARE @POLICY_NAME_HEDVIG_STORAGE			VARCHAR(32) = 'System: Hedvig'
DECLARE @POLICY_DESC_HEDVIG_STORAGE			VARCHAR(32) = 'For Hedvig Provisioning'
DECLARE @PROTOCOL_TYPE_ISCSI				VARCHAR(8)  = 'iSCSI'
DECLARE @PROTOCOL_TYPE_FC					VARCHAR(4)  = 'FC'
DECLARE @ARRAY_CLIENT_DUMMY_ID				INT			= 1
DECLARE @PROTOCOL_ID_ISCSI					INT			= 3
DECLARE @PROTOCOL_ID_FC						INT			= 4
-- *********** Local tables *********** --
DECLARE @l_tblLUNDetails					TABLE (TempLUNId INT IDENTITY, LunName VARCHAR(1024), LunSize BIGINT, LUNId INT, UserId INT, ExpDate INT, Description NVARCHAR(MAX), OSType INT, Flags INT)
DECLARE @l_tempVOLDetails					TABLE (VolumeId INT, VolumeName VARCHAR(1024))
DECLARE @l_tblVendorIdsLibraryNames			TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @l_tblCredentials					TABLE (UserName NVARCHAR(MAX), Password NVARCHAR(MAX), CredInfo XML, Flags INT, RecordType INT)
DECLARE @l_tblArrayInfo						TABLE (ControlHostId INT, UserName NVARCHAR(MAX), Password NVARCHAR(MAX))
-- *********** Input Gathering *********** --
----------------------------------------
---- Get UserId..
----------------------------------------
SET @l_userId	= (SELECT TOP 1 id FROM UMUsers WITH (READUNCOMMITTED) WHERE flags & 0x040 = 0x040 ORDER BY id ASC)
IF (@l_userId = 0)
BEGIN
	SET @l_errorMsg = 'No user configured in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get ClientId..
----------------------------------------
SET @l_clientId	= ISNULL((SELECT R.ref.value('@clientId', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/client') R(ref)), 0)
IF (@l_clientId = 0)
BEGIN
	SET @l_errorMsg = 'Client not provided in the input'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Client doesn't exist..
IF NOT EXISTS (SELECT 1 FROM APP_Client WITH (READUNCOMMITTED) WHERE id = @l_clientId)
BEGIN
	SET @l_errorMsg = 'Client ' + CONVERT(VARCHAR(1024), @l_clientId) + 'does not exist in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Client not ready to handle the request..
IF NOT EXISTS (SELECT 1 FROM MMHost WITH (READUNCOMMITTED) WHERE clientId = @l_clientId AND MmHostEnabled = 1 AND MmHostSoftState = 1 AND OfflineReason = 0)
BEGIN
	SET @l_errorMsg = 'Client ' + CONVERT(VARCHAR(1024), @l_clientId) + 'is not ready to process the request'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get Subclient Id..
----------------------------------------
SET @l_subclientId	= ISNULL((SELECT R.ref.value('@reserveInt2', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/reserve') R(ref)), 0)
IF (@l_subclientId = 0)
BEGIN
	SET @l_errorMsg = 'Subclient not provided in the input'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Subclient doesn't exist..
IF NOT EXISTS (SELECT 1 FROM APP_Application WITH (READUNCOMMITTED) WHERE id = @l_subclientId)
BEGIN
	SET @l_errorMsg = 'Subclient ' + CONVERT(VARCHAR(1024), @l_subclientId) + 'does not exist in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get Array number..
----------------------------------------
SET @l_arrayNum	= ISNULL((SELECT R.ref.value('@arrayNum', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
IF (@l_arrayNum = 0)
BEGIN
	SET @l_errorMsg = 'Array number not provided in the input'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Array doesn't exist..
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_arrayNum)
BEGIN
	SET @l_errorMsg = 'Array ' + CONVERT(VARCHAR(1024), @l_arrayNum) + 'not available in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Fetch array configs..
DECLARE @l_arrConfigReq		NVARCHAR(MAX) = N'<EVGui_MMSMGetArrayDetailsReq assocType="3" flags="1" copyId="0" appId="0"><array id="' + CONVERT(NVARCHAR(256), @l_arrayNum) + '"/></EVGui_MMSMGetArrayDetailsReq>'
DECLARE @l_tblArrConfigs	TABLE (id1 INT, id2 INT, id3 INT, id4 INT, id5 INT, id6 INT, configStr NVARCHAR(MAX), id8 INT, id9 INT)
INSERT	INTO @l_tblArrConfigs
EXEC	dbo.MM_SMXMLGetArrayDetails @l_arrConfigReq, 1
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
	SET @l_errorMsg = 'Failed to get array configs using ControlHost-' + CONVERT(VARCHAR(256), @l_arrayNum)
	GOTO ERR_EXIT
END
SET @l_arrayConfigStr = (SELECT configStr FROM @l_tblArrConfigs)
---- Check & Fetch App creds if present..
SET @l_curCredAssocId = ISNULL((SELECT CredentialId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_arrayNum), -1)
IF ( @l_curCredAssocId > 0 )
BEGIN
	INSERT	INTO @l_tblCredentials
	EXEC	dbo.AppGetAssocToCMCredentials @l_curCredAssocId, 0
	SET @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
	BEGIN
		SET @l_errorMsg = 'Failed to get array-[' + CONVERT(VARCHAR(512), @l_arrayNum) + '] credentials using association id-[' + CONVERT(VARCHAR(512), @l_curCredAssocId) + ']'
		GOTO ERR_EXIT
	END
	INSERT	INTO @l_tblArrayInfo (ControlHostId, UserName, Password)
	SELECT	@l_ArrayNum, T_CRED.UserName, T_CRED.Password
	FROM	@l_tblCredentials T_CRED
END
----------------------------------------
---- Get the input LUNs..
----------------------------------------
INSERT	INTO @l_tblLUNDetails (LunSize, LunName, Description, ExpDate, UserId, OSType, Flags)
SELECT	R.ref.value('@totalSpace', 'BIGINT'),
		ISNULL(R.ref.value('@lunName', 'VARCHAR(1024)'), ''),
		ISNULL(R.ref.value('@description', 'NVARCHAR(MAX)'), ''),
		R.ref.value('@expirationDate', 'INT'),
		 @l_userId,
		ISNULL(R.ref.value('@osTypeId', 'INT'), 0),
		ISNULL(R.ref.value('@flags', 'INT'), 0)
FROM	@i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
---- Get the total size ?
SET @l_sizeInBytes		= ISNULL(((SELECT SUM(LunSize) FROM @l_tblLUNDetails) * 1024 * 1024 * 1024), 0)
SET @l_totalLunSize		= ISNULL(((SELECT SUM(LunSize) FROM @l_tblLUNDetails) * 1024), 0)
----------------------------------------
---- Get the library name for the vendor
----------------------------------------
INSERT	INTO @l_tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT	DISTINCT Ven.Id, SMEngine.SnapEngineDLL
FROM	SMSnapShotEngine SMEngine WITH (READUNCOMMITTED)
			INNER JOIN SMVendor Ven WITH (READUNCOMMITTED)
				ON SMEngine.SnapVendorName = Ven.Name
			INNER JOIN SMControlHost Host WITH (READUNCOMMITTED)
				ON Ven.Name = Host.SnapVendorName
					AND Host.ControlHostId = @l_arrayNum
---- Get Vendor Id..
SET @l_vendorId = ISNULL((SELECT TOP 1 VendorId FROM @l_tblVendorIdsLibraryNames), 0)
IF (@l_vendorId = 0)
BEGIN
	SET @l_errorMsg = 'Unable to get vendor Id'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get PolicyTypeId
----------------------------------------
SET @l_policyTypeId = (SELECT TOP 1 policyTypeId FROM SprovAllocationPolicyType WITH (READUNCOMMITTED) WHERE policyTypeName = @POLICY_TYPE_BLOCK_STORAGE)
-- *********** Main logic *********** --
----------------------------------------
---- Check and insert SMArray & SMArrayCtrlHostMap...
----------------------------------------
IF NOT EXISTS (SELECT 1 FROM SMArray WITH (READUNCOMMITTED) WHERE ArrayName IN (SELECT TOP 1 SMArrayId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_arrayNum))
BEGIN
	INSERT	INTO SMArray (ClientId, ArrayName)
	SELECT	@ARRAY_CLIENT_DUMMY_ID, SMArrayId  FROM SMControlHost WITH (READUNCOMMITTED)  WHERE ControlHostId = @l_arrayNum
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed to add SMArray entry for array ' + CONVERT(VARCHAR(1024), @l_arrayNum)
		GOTO ERR_EXIT
	END
END
SET @l_arrayId = (SELECT TOP 1 Id FROM SMArray WITH (READUNCOMMITTED) WHERE ArrayName IN (SELECT TOP 1 SMArrayId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_arrayNum))
---- Add to SMArrayCtrlHostMap table..
IF NOT EXISTS (SELECT 1 FROM SMArrayCtrlHostMap WITH (READUNCOMMITTED) WHERE ArrayId = @l_arrayId AND ControlHostId = @l_arrayNum)
BEGIN
	INSERT	INTO SMArrayCtrlHostMap(ArrayId, ControlHostId)  VALUES (@l_arrayId, @l_arrayNum)
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed to add SMArrayCtrlHostMap entry for array ' + CONVERT(VARCHAR(1024), @l_arrayNum)
		GOTO ERR_EXIT
	END
END
----------------------------------------
---- Check and insert policy...
----------------------------------------
IF NOT EXISTS (SELECT 1 FROM SprovAllocationPolicy WITH (READUNCOMMITTED) WHERE policyId = @l_policyId AND policyName = @POLICY_NAME_HEDVIG_STORAGE)
BEGIN
	SET @l_insertQuery = 'INSERT INTO SprovAllocationPolicy (policyId, policyName, description, policyTypeId, userQuotaInBytes, expirationPeriod, createdby)'
							+ 'VALUES (' + CONVERT(VARCHAR(256), @l_policyId) + ', ''' + @POLICY_NAME_HEDVIG_STORAGE + ''', ''' + @POLICY_DESC_HEDVIG_STORAGE + ''', '
							+ CONVERT(VARCHAR(256), @l_policyTypeId) + ', 0, 0, ' + CONVERT(VARCHAR(256), @l_userId) + ')'
	EXEC SQLUtilIdentityInsert @l_insertQuery, 'SprovAllocationPolicy'
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed to add ' + @POLICY_NAME_HEDVIG_STORAGE
		GOTO ERR_EXIT
	END
END
----------------------------------------
---- Check and insert the protocols to be used..
----------------------------------------
SET @l_insertQuery = 'BEGIN
						IF NOT EXISTS(SELECT 1 FROM SProvProtocol WITH (READUNCOMMITTED) WHERE Name = ''' + @PROTOCOL_TYPE_ISCSI + ''')
						BEGIN
							INSERT INTO SProvProtocol(ProtocolId, Name, Enabled)  VALUES(' + CONVERT(VARCHAR(8), @PROTOCOL_ID_ISCSI) + ', ''' + @PROTOCOL_TYPE_ISCSI + ''', 1)
						END
						IF NOT EXISTS(SELECT 1 FROM SProvProtocol WITH (READUNCOMMITTED) WHERE Name = ''' + @PROTOCOL_TYPE_FC + ''')
						BEGIN
							INSERT INTO SProvProtocol(ProtocolId, Name, Enabled)  VALUES(' + CONVERT(VARCHAR(8), @PROTOCOL_ID_FC) + ', ''' + @PROTOCOL_TYPE_FC + ''', 1)
						END
					END'
EXEC SQLUtilIdentityInsert @l_insertQuery, 'SProvProtocol'
----------------------------------------
---- Check and Insert the Array..
----------------------------------------
IF NOT EXISTS(SELECT 1 FROM SProvArray WITH (READUNCOMMITTED) WHERE ArrayNum = @l_arrayId)
BEGIN
    INSERT INTO SProvArray(ArrayNum, HighWaterMark, WarningWaterMark, Enabled) VALUES(@l_arrayId, 90, 75, 1)
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed to add provisioning array ' + CONVERT(VARCHAR(1024), @l_arrayId)
		GOTO ERR_EXIT
	END
END
---- Check an insert array capabilities... Hedvig only supports iSCSI for now..
IF NOT EXISTS(SELECT 1 FROM SProvArrayCapabilities WITH (READUNCOMMITTED) WHERE ArrayNum = @l_arrayId AND ProtocolId = @PROTOCOL_ID_ISCSI)
BEGIN
    INSERT INTO SProvArrayCapabilities(ArrayNum, Critieria, ProtocolId, Priority, Enabled)  VALUES(@l_arrayId, 1, @PROTOCOL_ID_ISCSI, 3, 1)
END
----------------------------------------
---- Check and Insert into SMStoragePool - for ClientId & PoolName..
----------------------------------------
SET @l_storagePoolName = 'HEDVIG-DEFAULT-' + CONVERT(VARCHAR(1024), @ARRAY_CLIENT_DUMMY_ID)
---- Insert the entry
IF NOT EXISTS (SELECT 1 FROM SMStoragePool WITH (READUNCOMMITTED) WHERE ClientId = @ARRAY_CLIENT_DUMMY_ID AND Name = @l_storagePoolName)
BEGIN
	INSERT INTO SMStoragePool(ClientId, Name, UniqueID, IsEnabled)  VALUES (@ARRAY_CLIENT_DUMMY_ID, @l_storagePoolName, @l_storagePoolName, 1)
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed add SMStoragePool ' + @l_storagePoolName
		GOTO ERR_EXIT
	END
END
---- Get the pool Id..
SET @l_storagePoolId = (SELECT TOP 1 Id FROM SMStoragePool WITH (READUNCOMMITTED) WHERE ClientId = @ARRAY_CLIENT_DUMMY_ID AND Name = @l_storagePoolName)
----------------------------------------
---- Check and Insert default Prov Storage pool..
----------------------------------------
IF NOT EXISTS (SELECT 1 FROM SProvStoragePool WITH (READUNCOMMITTED) WHERE StoragePoolId = @l_storagePoolId)
BEGIN
	INSERT  INTO SProvStoragePool (StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled, Flags)
    SELECT  @l_storagePoolId, @l_arrayId, 0, 0, 1, 0
	SET @l_errorCode = @@ERROR
	IF (@l_errorCode <> 0)
	BEGIN
		SET @l_errorMsg = 'Failed add Provisioning pool ' + @l_storagePoolName
		GOTO ERR_EXIT
	END
END
----------------------------------------
---- Check and insert into array volume..
----------------------------------------
INSERT  INTO SMArrayVolume (ClientId, StoragePoolId, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Flags)
OUTPUT	inserted.Id, inserted.Name INTO @l_tempVOLDetails
SELECT	@l_clientId, @l_storagePoolId, LunSize * 1024, 0, LunSize * 1024, LunName, 8 /*Provision new volume*/ FROM @l_tblLUNDetails
----------------------------------------
---- Check and insert into prov volume..
----------------------------------------
INSERT  INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
SELECT  VolumeId, @l_storagePoolId, @l_arrayId, 1, 8 /*Provision new volume*/, @l_userId FROM @l_tempVOLDetails
IF NOT EXISTS (SELECT 1 FROM @l_tempVOLDetails)
BEGIN
	SET @l_errorMsg = 'Unable to add volumes'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Check and insert into LUN..
----------------------------------------
INSERT  INTO SMLUN (ArrayVolumeId, TotalSpaceBytes, UsedSpaceBytes, FreeSpaceBytes, Name, Path, ReserveField1, ReserveField4, ReserveFieldStr)
SELECT  T_VOL.VolumeId, T_LUN.LunSize * 1024 * 1024 * 1024, 0, T_LUN.LunSize * 1024 * 1024 * 1024, T_LUN.LunName, T_LUN.LunName, T_LUN.TempLUNId, @l_subclientId, @guidStr
FROM    @l_tblLUNDetails T_LUN
			INNER JOIN @l_tempVOLDetails T_VOL
				ON T_VOL.VolumeName = T_LUN.LunName
---- Get the newly added LUN Ids..
UPDATE  TMP
SET     LUNId = LUN.Id
FROM    SMLUN LUN WITH (READUNCOMMITTED)
            INNER JOIN @l_tblLUNDetails TMP
				ON TMP.TempLUNId = LUN.ReserveField1
					AND LUN.ReserveFieldStr = @guidStr
---- Reset the LUN fields..
UPDATE  LUN
SET     ReserveField1 = 0,
		ReserveFieldStr = ''
FROM	SMLUN LUN
			INNER JOIN @l_tblLUNDetails TMP
				ON LUN.Id = TMP.LUNId
---- Update the name & path in volume table..
UPDATE	SMArrayVolume
SET		Name = T_LUN.Name,
		Path = T_LUN.Name
FROM	SMLUN T_LUN
			INNER JOIN SMArrayVolume T_VOL
				ON T_LUN.ArrayVolumeId = T_VOL.Id
			INNER JOIN @l_tempVOLDetails T_TEMPVOL
				ON T_TEMPVOL.VolumeId = T_VOL.Id
----------------------------------------
---- Add to Prov LUN..
----------------------------------------
INSERT  INTO SProvLUN (LUNId, VolumeId, StoragePoolId, ArrayNum, UserId, Criteria, ExpirationDate, HighWaterMark, WarningWaterMark, Enabled, Description, OSType, Status, PolicyId)
SELECT  T_LUN.LUNId, T_VOL.VolumeId, @l_storagePoolId, @l_arrayId, T_LUN.UserId, @l_criteria, dbo.getDateTime(ExpDate), 0, 0, 0, T_LUN.Description, T_LUN.OSType, 0, @l_policyId
FROM    @l_tblLUNDetails T_LUN
			INNER JOIN @l_tempVOLDetails T_VOL
				ON T_LUN.LunName = T_VOL.VolumeName
SET @l_errorCode = @@ERROR
IF (@l_errorCode <> 0)
BEGIN
	SET @l_errorMsg = 'Failed add Provisioning LUNs'
	GOTO ERR_EXIT
END
---- Format the output XML...
SET @o_outXML = (
					SELECT
							(
								SELECT	TOP 1
										CLNT.id				AS 'client/@clientId',
										CLNT.net_hostname	AS 'client/@clientName'
								FROM APP_Client CLNT WITH (READUNCOMMITTED) WHERE Id = @l_clientId
								FOR XML PATH ('sprovParam'), TYPE
							),
							(
								SELECT	VEN.Id					AS '@vendorId',
										VEN.Name				AS '@vendorName',
										VEN.Name				AS '@familyName',
										VEN.ShowInGUI			AS '@showInGUI',
										VEN.IsEnabled			AS '@enabled',
										0						AS '@flags',
										0						AS '@status',
										0						AS '@errorCode',
										''						AS '@errorString',
										T_IDSLIBS.LibraryName	AS '@libraryName',
										(
											SELECT	ARR.Id				AS '@arrayNum',
													HOST.SMArrayId		AS '@arrayName',
													HOST.SMHostName		AS '@controlHost',
													ISNULL(T_ARRINFO.UserName, HOST.SMHostUserName)		AS '@userName',
													ISNULL(T_ARRINFO.Password, HOST.SMHostPassword)		AS '@password',
													0					AS '@useTunneling',
													''					AS '@vServerName',
													0					AS '@phyArrayNum',
													1					AS '@enabled',
													0					AS '@status',
													0					AS '@errorCode',
													''					AS '@errorString',
													HOST.ClientId		AS 'client/@clientId',
													@l_arrayConfigStr	AS 'reserve/@reserveString2',
													(
														SELECT	S_POOL.StoragePoolId	AS '@storagePoolId',
																POOL.Name				AS '@storagePoolName',
																@l_arrayId				AS '@arrayNum',
																POOL.UsedSpaceMB		AS '@usedSpace',
																POOL.TotalSpaceMB		AS '@totalSpace',
																S_POOL.Enabled			AS '@enabled',
																S_POOL.Flags			AS '@flags',
																0						AS '@status',
																0						AS '@errorCode',
																''						AS '@errorString',
																(
																	SELECT	S_VOL.VolumeId					AS '@volumeId',
																			VOL.Name						AS '@volumeName',
																			@l_storagePoolId				AS '@storagePoolId',
																			@l_arrayId						AS '@arrayNum',
																			VOL.UsedSpaceMB * 1024 * 1024	AS '@usedSpace',
																			VOL.TotalSpaceMB * 1024 * 1024	AS '@totalSpace',
																			S_VOL.Enabled					AS '@enabled',
																			S_VOL.Flags						AS '@flags',
																			VOL.Path						AS '@volumePath',
																			0								AS '@status',
																			0								AS '@errorCode',
																			''								AS '@errorString'
																	FROM	SProvArrayVolume S_VOL WITH (READUNCOMMITTED)
																				INNER JOIN SMArrayVolume VOL WITH (READUNCOMMITTED)
																					ON	S_VOL.VolumeId = VOL.Id
																						AND S_VOL.VolumeId IN (SELECT VolumeId FROM @l_tempVOLDetails)
																						AND S_VOL.ArrayNum = ARR.Id
																	FOR XML PATH ('volumeList'), TYPE
																)
														FROM	SProvStoragePool S_POOL WITH (READUNCOMMITTED)
																	INNER JOIN SMStoragePool POOL WITH (READUNCOMMITTED)
																		ON S_POOL.StoragePoolId = POOL.Id
																			AND S_POOL.StoragePoolId = @l_storagePoolId
																			AND S_POOL.ArrayNum = ARR.Id
														FOR XML PATH('poolList'), TYPE
													)
											FROM	SMArray ARR WITH (READUNCOMMITTED)
														INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
															ON MAP.ArrayId = ARR.Id
														INNER JOIN SMControlHost HOST WITH (READUNCOMMITTED)
															ON HOST.ControlHostId = MAP.ControlHostId
																AND HOST.ControlHostId = @l_arrayNum
														LEFT OUTER JOIN @l_tblArrayInfo T_ARRINFO
															ON HOST.ControlHostId = T_ARRINFO.ControlHostId
											FOR XML PATH ('arrayList'), TYPE
										)
								FROM	SMVendor VEN WITH (READUNCOMMITTED)
											INNER JOIN @l_tblVendorIdsLibraryNames T_IDSLIBS
												ON T_IDSLIBS.VendorId = VEN.Id
								FOR XML PATH ('arrayFamilyList'), TYPE
							),
							(
								SELECT	P_LUN.LUNId				AS '@lunId',
										LUN.Name				AS '@lunName',
										P_LUN.VolumeId			AS '@volumeId',
										P_LUN.StoragePoolId		AS '@storagePoolId',
										P_LUN.ArrayNum			AS '@arrayNum',
										LUN.UsedSpaceBytes		AS '@usedSpace',
										LUN.TotalSpaceBytes		AS '@totalSpace',
										@l_criteria				AS '@criteria',
										P_LUN.ExpirationDate	AS '@expirationDate',
										P_LUN.Enabled			AS '@enabled',
										( CASE
												WHEN TMP.Flags > 0 THEN TMP.Flags
												ELSE P_LUN.Flags
										  END
										)						AS '@flags',
										P_LUN.OSType			AS '@osTypeId',
										P_LUN.Status			AS '@status',
										P_LUN.Description		AS '@description',
										LUN.Path				AS '@lunPath',
										0						AS '@errorCode',
										''						AS '@errorString',
										P_LUN.userId			AS 'user/@userId',
										CONVERT(NVARCHAR(MAX), LUN.Properties)			AS 'reserve/@reserveString'
								FROM	@l_tblLUNDetails TMP
											INNER JOIN SProvLUN P_LUN WITH (READUNCOMMITTED)
												ON TMP.LUNId = P_LUN.LUNId
											INNER JOIN SMLUN LUN WITH (READUNCOMMITTED)
												ON P_LUN.LUNId = LUN.Id
								FOR XML PATH ('lunList'), TYPE
							)
					FOR XML PATH ('StorageProvisioning_MMSProvInfo')
				)
SELECT @o_outXML
RETURN
ERR_EXIT:
	SET @o_outXML = (SELECT @l_errorCode AS '@errorCode',
							@l_errorMsg AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_PreProcessSProvOperationHedvig')
	delete from GxQscripts where name = 'SProv_PreProcessSProvOperationHedvig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvOperationHedvig')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvOperationHedvig'
GO

insert into GXDBVersions values(2, 'SProv_PreProcessSProvOperationHedvig',  '00010001000400030000', 'SProv_PreProcessSProvOperationHedvig', '00010001000400030000')
GO

