

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_PreProcessSProvOperation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_PreProcessSProvOperation.sp,v $ $Id: SProv_PreProcessSProvOperation.sp,v 1.5.12.6 2018/03/20 00:06:21 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "Sprov_PreProcessSProvOperation"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_PreProcessSProvOperation <<<'

IF EXISTS (select * from sysobjects where name='SProv_PreProcessSProvOperation')
	drop procedure SProv_PreProcessSProvOperation
IF EXISTS (select * from GxQscripts where name='SProv_PreProcessSProvOperation')
	delete from GxQscripts where name = 'SProv_PreProcessSProvOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvOperation')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvOperation'
GO
print '... Creating Procedure: SProv_PreProcessSProvOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_PreProcessSProvOperation
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
DECLARE @tblLUNDetails TABLE (TempLUNId INT IDENTITY, LunName VARCHAR(1024), LunSize BIGINT, LUNId INT, UserId INT, ExpDate INT, Description NVARCHAR(MAX), OSType INT)
--Temp table variable to save the list of identity rows inserted into SMArrayVolume so that the
--array volume id can be inserted into SProvArrayVolume. For Non NetApp LUNs this table has as many entries as the number of LUNs
--but for NetApp LUNs it has just 1 entry
DECLARE @tempVOLDetails TABLE (VolumeId INT, VolumeName VARCHAR(1024))
DECLARE @tblVendorIdsLibraryNames TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @arrayNum		INT = 0
DECLARE @criteria		INT = 0
DECLARE @arrayVolumeId	INT = 0
DECLARE @arrayStgPoolId INT = 0
DECLARE @arrayClientId	INT = 0
DECLARE @isNewVol		INT = 0
DECLARE @userId			INT = 0
DECLARE @reqFlags		INT = 0
DECLARE @policyId		INT = 0
DECLARE @errorCode		INT = 0
DECLARE @errorMsg		VARCHAR(255) = ''
DECLARE @totalLunSize	INT = 0
DECLARE @sizeInBytes	BIGINT = 0
DECLARE @userName		VARCHAR(512) = ''
DECLARE @vendorId		INT = 0
 --Volume name incase we have to provision a new volume
DECLARE @volumeName	VARCHAR(1024) = 'SProvVolUsr' + CONVERT(VARCHAR(255), @userId) + 'TS' + CONVERT(VARCHAR(255), dbo.GetUnixTime(GETUTCDATE()))
SET @policyId = ISNULL((SELECT R.ref.value('@policyId', 'INT')
						FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
SET @userId = ISNULL((SELECT R.ref.value('@userId', 'INT')
					FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref)), 0)
IF @userId = 0 OR @policyId = 0
BEGIN
	SET @errorMsg = 'Invalid policy/user Id'
	SET @errorCode = -1
	GOTO ERR_EXIT
END
SET @userName = (SELECT name FROM UMUsers WHERE id = @userId)
IF OBJECT_ID('tempdb.dbo.#policyInfoArrays') IS NOT NULL
	DROP TABLE #policyInfoArrays
IF OBJECT_ID('tempdb.dbo.#policyInfoStoragePools') IS NOT NULL
	DROP TABLE #policyInfoStoragePools
CREATE TABLE #policyInfoArrays ( [arrayNum]		INT NOT NULL DEFAULT 0,
								 [arrayName]	NVARCHAR(1024) NOT NULL DEFAULT '',
								 [vendorName]	NVARCHAR(1024)	NOT NULL DEFAULT '',
								 [vendorId]		INT NOT NULL DEFAULT 0,
								 [policyId]		INT	NOT NULL DEFAULT 0,
								 [clientId]     INT	NOT NULL DEFAULT 0,
								 [flags]		INT NOT NULL DEFAULT 0,
								 [totalSpace]	BIGINT NOT NULL DEFAULT 0,
								 [freeSpace]		BIGINT NOT NULL DEFAULT 0
							    )
CREATE TABLE #policyInfoStoragePools ( [storagePoolId]		INT NOT NULL DEFAULT 0,
									   [clientId]			INT NOT NULL DEFAULT 0,
									   [arrayNum]			INT NOT NULL DEFAULT 0,
									   [storagePoolName]	NVARCHAR(1024) NOT NULL DEFAULT '',
									   [policyId]			INT	NOT NULL DEFAULT 0,
									   [flags]				INT NOT NULL DEFAULT 0,
    								   [totalSpace]			BIGINT NOT NULL DEFAULT 0,
									   [freeSpace]			BIGINT NOT NULL DEFAULT 0
									  )
-- Lun totalspace is in GB
INSERT	INTO @tblLUNDetails (LunSize, LunName, Description, ExpDate, UserId, OSType)
SELECT	R.ref.value('@totalSpace', 'BIGINT'),
		ISNULL(R.ref.value('@lunName', 'VARCHAR(1024)'), ''),
		ISNULL(R.ref.value('@description', 'NVARCHAR(MAX)'), ''),
		R.ref.value('@expirationDate', 'INT'),
		@userId,
		ISNULL(R.ref.value('@osTypeId', 'INT'), 0)
FROM	@xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
SET @sizeInBytes = ISNULL(((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024 * 1024 * 1024), 0)
--TODO
--Check if the user is associated with the given policy
--Check if the user is within quota
EXEC SProv_IsUserWithinQuota @policyId, @userId, @sizeInBytes, @errorCode OUT, @errorMsg OUT
IF @errorCode <> 0
BEGIN
	GOTO ERR_EXIT
END
--Given policy id and user id get the list of all arrays, storage pools, volumes for that user
EXEC SProv_GetPolicyInfo @policyId, '#policyInfoArrays', '#policyInfoStoragePools', '', ''
IF NOT EXISTS (SELECT 1 FROM #policyInfoArrays)
BEGIN
	SET @errorMsg = 'Arrays not found for policy Id: ' + CONVERT(VARCHAR(1024), @policyId)
	SET @errorCode = -1
	GOTO ERR_EXIT
END
IF NOT EXISTS (SELECT 1 FROM #policyInfoStoragePools)
BEGIN
	SET @errorMsg = 'Storage Pools not found for policy Id: ' + CONVERT(VARCHAR(1024), @policyId)
	SET @errorCode = -1
	GOTO ERR_EXIT
END
--All checks completed
SET @arrayNum			= ISNULL((SELECT R.ref.value('@arrayNum', 'INT')
						  FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
SET @arrayStgPoolId		= ISNULL((SELECT R.ref.value('@storagePoolId', 'INT')
						  FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
SET @arrayVolumeId		= ISNULL((SELECT R.ref.value('@volumeId', 'INT')
						  FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
SET @criteria			= ISNULL((SELECT R.ref.value('@criteria', 'INT')
						  FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
SET @reqFlags			= ISNULL((SELECT R.ref.value('@reqFlags', 'INT')
						  FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon') R(ref)), 0)
SET @totalLunSize		= ISNULL(((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024), 0)
--select @arrayNum, @arrayStgPoolId
--select * from @tblLUNDetails
--This will get you only those arrays and storage pools which are associated with @policyId
BEGIN
	SELECT @arrayNum = ArrayNum, @arrayStgPoolId = StgPoolId, @arrayClientId = ClientId
	FROM
	(
		SELECT TOP 1 MAP.ArrayId AS ArrayNum, SMPOOL.Id AS StgPoolId, HOST.ClientId AS ClientId
		FROM SMControlHost HOST (NOLOCK) INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
										 --INNER JOIN SProvArrayCapabilities CPBLTY (NOLOCK) ON MAP.ArrayId = CPBLTY.ArrayNum
										 INNER JOIN SMStoragePool SMPOOL (NOLOCK) ON SMPOOL.ClientId = HOST.ClientId
										 --Make sure the selected array and storage pool is associated to the given policy
										 INNER JOIN #policyInfoStoragePools T_POOL ON T_POOL.storagePoolId = SMPOOL.Id
										 INNER JOIN #policyInfoArrays T_ARR ON T_ARR.arrayNum = MAP.ArrayId
		WHERE SMPOOL.FreeSpaceMB > ((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024) AND
			  (MAP.ArrayId = @arrayNum OR @arrayNum = 0) AND
			  (SMPOOL.Id = @arrayStgPoolId OR @arrayStgPoolId = 0) AND
			  --Select those arrays in the include and not in the exclude list of the given policy
			  MAP.ArrayId IN (
				SELECT arrayNum
				FROM #policyInfoArrays WHERE flags = 1
			  ) AND
			  MAP.ArrayId NOT IN (
				SELECT arrayNum
				FROM #policyInfoArrays WHERE flags = 2
			  ) AND
			  --Select those storage pools in the include and not in the exclude list of the given policy
			  SMPOOL.Id IN (
				SELECT storagePoolId
				FROM #policyInfoStoragePools WHERE flags = 1
			  ) AND
			  SMPOOL.Id NOT IN (
				SELECT storagePoolId
				FROM #policyInfoStoragePools WHERE flags = 2
			  )
		ORDER BY SMPOOL.FreeSpaceMB DESC
	) TMP
END
IF (@arrayNum = 0 OR @arrayStgPoolId = 0  OR @arrayClientId = 0)
BEGIN
	SET @errorCode = 1
	SET @errorMsg = 'Failed to find array and storage pool details to provision new lun(s).'
	GOTO ERR_EXIT
END
--Get the library name for the vendor
INSERT INTO @tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT DISTINCT Ven.Id, SMEngine.SnapEngineDLL
FROM SMSnapShotEngine SMEngine
INNER JOIN SMVendor Ven ON SMEngine.SnapVendorName = Ven.Name
INNER JOIN SMControlHost Host ON Ven.Name = Host.SnapVendorName
INNER JOIN SMArrayCtrlHostMap Map ON Map.ControlHostId = Host.ControlHostId AND Map.ArrayId = @arrayNum
SET @vendorId = ISNULL((SELECT TOP 1 VendorId FROM @tblVendorIdsLibraryNames), 0)
--Update the size info for both Storage Pool and its Array
UPDATE SMStoragePool SET UsedSpaceMB = UsedSpaceMB + @totalLunSize WHERE Id = @arrayStgPoolId
UPDATE SMStoragePool SET FreeSpaceMB = TotalSpaceMB - UsedSpaceMB WHERE Id = @arrayStgPoolId
--SMArray does not have UsedSpace field
UPDATE SMArray SET FreeSpaceMB = FreeSpaceMB - @totalLunSize WHERE ClientId = @arrayClientId
IF NOT EXISTS (SELECT * FROM SProvStoragePool (NOLOCK) WHERE StoragePoolId = @arrayStgPoolId)
BEGIN
	-- Insert new row into SProvStoragePool for this aggregate
	INSERT	INTO SProvStoragePool (StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled, Flags)
	SELECT	@arrayStgPoolId, @arrayNum, 0, 0, 1, 0
END
--Process SProvArrayVolume entries and update the size information for SMArrayVolume entries (SMArrayVolume size entries are processed only for NetApp)
IF(@vendorId <> 3)
BEGIN
	--Create a New Volume for every LUN
	INSERT	INTO SMArrayVolume (ClientId, StoragePoolId, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Flags)
	OUTPUT inserted.Id, inserted.Name INTO @tempVOLDetails
SELECT @arrayClientId, @arrayStgPoolId, LunSize * 1024, 0, LunSize * 1024, LunName, 8 /*Provision new volume*/ FROM @tblLUNDetails
	INSERT	INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
SELECT	VolumeId, @arrayStgPoolId, @arrayNum, 1, 8 /*Provision new volume*/, @userId FROM @tempVOLDetails
END
ELSE
BEGIN
IF @arrayVolumeId > 0
BEGIN
	INSERT	INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
	SELECT	@arrayVolumeId, @arrayStgPoolId, @arrayNum, 1, 0, @userId
	WHERE	@arrayVolumeId NOT IN (SELECT VolumeId FROM SProvArrayVolume)
	UPDATE SMArrayVolume SET UsedSpaceMB = UsedSpaceMB + @totalLunSize WHERE Id = @arrayVolumeId
	UPDATE SMArrayVolume SET FreeSpaceMB = TotalSpaceMB - UsedSpaceMB WHERE Id = @arrayVolumeId
END
ELSE IF @reqFlags & 1 = 1 -- User selected the 'Create New Volume' option
BEGIN
	-- Insert a new volume and provision it.
	INSERT	INTO SMArrayVolume (ClientId, StoragePoolId, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Flags)
	SELECT	@arrayClientId, @arrayStgPoolId, ((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024), 0,
			((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024),
'SProv_Vol_' + CONVERT(VARCHAR(255), @userId) + '_' + CONVERT(VARCHAR(255), dbo.GetUnixTime(GETUTCDATE())), 8 /*Provision new volume*/
	SET @arrayVolumeId = @@IDENTITY
	INSERT	INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
SELECT	@arrayVolumeId, @arrayStgPoolId, @arrayNum, 1, 8 /*Provision new volume*/, @userId
	SET @isNewVol = 1
END
ELSE -- User has no preference for volume
BEGIN
IF EXISTS (SELECT * FROM SProvArrayVolume (NOLOCK) WHERE StoragePoolId = @arrayStgPoolId AND UserId = @userId AND ((Flags = 8) OR (Flags = 16)))
	BEGIN
		-- If a volume exists for a storage pool and for that user, use it
		SET @arrayVolumeId = (	SELECT	TOP 1 VOL.VolumeId
								FROM	SProvArrayVolume VOL (NOLOCK)
								WHERE	VOL.StoragePoolId = @arrayStgPoolId AND
										VOL.UserId = @userId AND
((VOL.Flags = 8) OR (VOL.Flags = 16)))
		UPDATE SMArrayVolume SET UsedSpaceMB = UsedSpaceMB + @totalLunSize WHERE Id = @arrayVolumeId
		UPDATE SMArrayVolume SET FreeSpaceMB = TotalSpaceMB - UsedSpaceMB WHERE Id = @arrayVolumeId
	END
	ELSE -- No volume has been provisioned on the aggregate for that user
	BEGIN
		-- Insert a new volume and provision it.
		INSERT	INTO SMArrayVolume (ClientId, StoragePoolId, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Flags)
		SELECT	@arrayClientId, @arrayStgPoolId, ((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024), 0,
				((SELECT SUM(LunSize) FROM @tblLUNDetails) * 1024),
'SProv_Vol_' + CONVERT(VARCHAR(255), @userId) + '_' + CONVERT(VARCHAR(255), dbo.GetUnixTime(GETUTCDATE())), 8 /*Provision new volume*/
		SET @arrayVolumeId = @@IDENTITY
		INSERT	INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
SELECT	@arrayVolumeId, @arrayStgPoolId, @arrayNum, 1, 8 /*Provision new volume*/, @userId
		SET @isNewVol = 1
	END
END
	INSERT INTO @tempVOLDetails (VolumeId)
	SELECT @arrayVolumeId
END
IF NOT EXISTS (SELECT 1 FROM @tempVOLDetails)
BEGIN
	SET @errorCode = 2
	SET @errorMsg = 'Failed to find volume details to provision new lun(s).'
	GOTO ERR_EXIT
END
-- INSERT INTO SMLUN and SProvLUN
DECLARE @guid UNIQUEIDENTIFIER = NEWID()
DECLARE @guidStr NVARCHAR(1024) = CONVERT(NVARCHAR(1024), @guid)
IF(@vendorId = 3)
BEGIN
INSERT	INTO SMLUN (ArrayVolumeId, TotalSpaceBytes, UsedSpaceBytes, FreeSpaceBytes, Name, Path, ReserveField1, ReserveFieldStr)
SELECT	@arrayVolumeId, LunSize * 1024 * 1024 * 1024, 0, LunSize * 1024 * 1024 * 1024, LunName, LunName, TempLUNId, @guidStr
FROM	@tblLUNDetails
END
ELSE
BEGIN
	INSERT	INTO SMLUN (ArrayVolumeId, TotalSpaceBytes, UsedSpaceBytes, FreeSpaceBytes, Name, Path, ReserveField1, ReserveFieldStr)
	SELECT	T_VOL.VolumeId, T_LUN.LunSize * 1024 * 1024 * 1024, 0, T_LUN.LunSize * 1024 * 1024 * 1024, T_LUN.LunName, T_LUN.LunName, T_LUN.TempLUNId, @guidStr
	FROM	@tblLUNDetails T_LUN INNER JOIN @tempVOLDetails T_VOL ON T_VOL.VolumeName = T_LUN.LunName
END
SET @errorCode = @@ERROR
IF (@errorCode <> 0)
BEGIN
	SET @errorMsg = 'Failed to find add new lun details to SMLUN.'
	GOTO ERR_EXIT
END
UPDATE	TMP
SET		LUNId = LUN.Id
FROM	SMLUN LUN (NOLOCK)
			INNER JOIN @tblLUNDetails TMP ON TMP.TempLUNId = LUN.ReserveField1
			AND LUN.ReserveFieldStr = @guidStr
UPDATE	LUN
SET		Name = Name + 'L' + CONVERT(VARCHAR(10), Id),
		Path = Path + 'L' + CONVERT(VARCHAR(10), Id),
		ReserveField1 = 0, ReserveFieldStr = ''
		FROM SMLUN LUN INNER JOIN @tblLUNDetails TMP ON LUN.Id = TMP.LUNId
-- Set enabled = 1 when inserting. Update to 1 if created successfully.
--Now, that you have changed the LUN name and path update the same values in SMArrayVolume table for Non NetApp engines
IF(@vendorId <> 3)
BEGIN
	UPDATE SMArrayVolume SET Name = T_LUN.Name,
							 Path = T_LUN.Name
	FROM SMLUN T_LUN INNER JOIN SMArrayVolume T_VOL ON T_LUN.ArrayVolumeId = T_VOL.Id
					 INNER JOIN @tempVOLDetails T_TEMPVOL ON T_TEMPVOL.VolumeId = T_VOL.Id
END
IF(@vendorId = 3)
BEGIN
INSERT	INTO SProvLUN (LUNId, VolumeId, StoragePoolId, ArrayNum, UserId, Criteria, ExpirationDate, HighWaterMark,
						WarningWaterMark, Enabled, Description, OSType, Status, PolicyId)
SELECT	LUNId, @arrayVolumeId, @arrayStgPoolId, @arrayNum, UserId, @criteria, dbo.getDateTime(ExpDate), 0, 0, 0, Description, OSType, 0, @policyId
FROM	@tblLUNDetails
END
ELSE
BEGIN
	INSERT	INTO SProvLUN (LUNId, VolumeId, StoragePoolId, ArrayNum, UserId, Criteria, ExpirationDate, HighWaterMark,
							WarningWaterMark, Enabled, Description, OSType, Status, PolicyId)
	SELECT	T_LUN.LUNId, T_VOL.VolumeId, @arrayStgPoolId, @arrayNum, T_LUN.UserId, @criteria, dbo.getDateTime(ExpDate), 0, 0, 0, T_LUN.Description, T_LUN.OSType, 0, @policyId
	FROM	@tblLUNDetails T_LUN INNER JOIN @tempVOLDetails T_VOL ON T_LUN.LunName = T_VOL.VolumeName
END
SET @errorCode = @@ERROR
IF (@errorCode <> 0)
BEGIN
	SET @errorMsg = 'Failed to find add new lun details to SProvLUN.'
	GOTO ERR_EXIT
END
-- Check if tunneling is enabled for the array.
DECLARE @useTunneling INT = 0
SET @useTunneling = (SELECT CONF.ValueInt FROM SMArrayCtrlHostMap MAP (NOLOCK)
					INNER JOIN SMControlHost HOST (NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId AND MAP.ArrayId = @arrayNum
					INNER JOIN SMConfigs CONF (NOLOCK) ON CONF.ArrayId = HOST.ControlHostId AND CONF.AssocId = HOST.ControlHostId
					INNER JOIN SMMasterConfigs MC(NOLOCK) ON MC.Id = CONF.MasterConfigId
						AND MC.KeyName = 'SMCONFIG_NAME_USE_TUNNELING')
DECLARE @phyArrayNum INT = 0
DECLARE @vServerName VARCHAR(1024) = ''
IF (@useTunneling = 1)
BEGIN
	SET @phyArrayNum = (SELECT MAP.ArrayId FROM APP_VMToPMMap VMMAP (NOLOCK)
						INNER JOIN SMControlHost HOST(NOLOCK)
							ON VMMAP.PMClientId = HOST.ClientId AND VMMAP.VMClientId = @arrayClientId
						INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId)
	SET @vServerName = (SELECT PROP.attrVal FROM APP_ClientProp PROP
						WHERE PROP.componentNameId = @arrayClientId
						AND PROP.attrName = 'NAS vServer Name')
END
DECLARE @MAClientId INT = 0
SET @MAClientId = 	( SELECT TOP 1 HOST.ClientId
						FROM SMArrayCtrlHostMap MAP (NOLOCK)
							INNER JOIN SMArrayController CTRL (NOLOCK) ON MAP.ArrayId = @arrayNum AND MAP.ControlHostId = CTRL.ArrayNum
							INNER JOIN MMHost HOST (NOLOCK) ON HOST.ClientId = CTRL.MMHostId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
							INNER JOIN APP_Client CLNT (NOLOCK) ON CLNT.Id = CTRL.MMHostId AND CLNT.releaseId = 16)
SET @o_outXML =
(SELECT
		(SELECT TOP 1
		CLNT.id AS 'client/@clientId',
		CLNT.net_hostname AS 'client/@clientName'
		FROM APP_Client CLNT (NOLOCK) WHERE Id = @MAClientId
		FOR XML PATH ('sprovParam'), TYPE),
		(SELECT
		VEN.Id AS '@vendorId',
		VEN.Name AS '@vendorName',
		VEN.Name AS '@familyName',
		VEN.ShowInGUI AS '@showInGUI',
		VEN.IsEnabled AS '@enabled',
		0 AS '@flags',
		0 AS '@status',
		0 AS '@errorCode',
		'' AS '@errorString',
		T_IDSLIBS.LibraryName AS '@libraryName',
			(SELECT
			ARR.Id AS '@arrayNum',
			ARR.ArrayName AS '@arrayName',
			HOST.SMHostName AS '@controlHost',
			HOST.SMHostUserName AS '@userName',
			HOST.SMHostPassword AS '@password',
			@useTunneling AS '@useTunneling',
			@vServerName AS '@vServerName',
			@phyArrayNum AS '@phyArrayNum',
			1 AS '@enabled',
			0 AS '@status',
			0 AS '@errorCode',
			'' AS '@errorString',
			HOST.ClientId AS 'client/@clientId',
				(SELECT
				S_POOL.StoragePoolId AS '@storagePoolId',
				POOL.Name AS '@storagePoolName',
				@arrayNum AS '@arrayNum',
				POOL.UsedSpaceMB AS '@usedSpace',
				POOL.TotalSpaceMB AS '@totalSpace',
				S_POOL.Enabled AS '@enabled',
				S_POOL.Flags AS '@flags',
				0 AS '@status',
				0 AS '@errorCode',
				'' AS '@errorString',
					(SELECT
					S_VOL.VolumeId AS '@volumeId',
					VOL.Name AS '@volumeName',
					@arrayStgPoolId AS '@storagePoolId',
					@arrayNum AS '@arrayNum',
					VOL.UsedSpaceMB * 1024 * 1024 AS '@usedSpace',
					VOL.TotalSpaceMB * 1024 * 1024 AS '@totalSpace',
					S_VOL.Enabled AS '@enabled',
(CASE WHEN @isNewVol > 0 THEN 8
					ELSE S_VOL.Flags END ) AS '@flags',
					VOL.Path AS '@volumePath',
					0 AS '@status',
					0 AS '@errorCode',
					'' AS '@errorString'
					FROM SProvArrayVolume S_VOL (NOLOCK)
						INNER JOIN SMArrayVolume VOL (NOLOCK) ON S_VOL.VolumeId = VOL.Id
						AND S_VOL.VolumeId IN (SELECT VolumeId FROM @tempVOLDetails) AND S_VOL.ArrayNum = ARR.Id
					FOR XML PATH ('volumeList'), TYPE)
				FROM SProvStoragePool S_POOL (NOLOCK)
					INNER JOIN SMStoragePool POOL (NOLOCK) ON S_POOL.StoragePoolId = POOL.Id
						AND S_POOL.StoragePoolId = @arrayStgPoolId AND S_POOL.ArrayNum = ARR.Id
				FOR XML PATH('poolList'), TYPE)
			FROM SMArray ARR (NOLOCK)
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK)
				ON MAP.ArrayId = ARR.Id AND ARR.Id IN (@arrayNum, @phyArrayNum)
			INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
			FOR XML PATH ('arrayList'), TYPE )
		FROM SMVendor VEN (NOLOCK) INNER JOIN @tblVendorIdsLibraryNames T_IDSLIBS ON T_IDSLIBS.VendorId = VEN.Id
		FOR XML PATH ('arrayFamilyList'), TYPE),
		(SELECT
		P_LUN.LUNId AS '@lunId',
		LUN.Name AS '@lunName',
		P_LUN.VolumeId AS '@volumeId',
		P_LUN.StoragePoolId AS '@storagePoolId',
		P_LUN.ArrayNum AS '@arrayNum',
		LUN.UsedSpaceBytes AS '@usedSpace',
		LUN.TotalSpaceBytes AS '@totalSpace',
		@criteria AS '@criteria',
		P_LUN.ExpirationDate AS '@expirationDate',
		P_LUN.Enabled AS '@enabled',
		P_LUN.Flags AS '@flags',
		P_LUN.OSType AS '@osTypeId',
		--SIM.Name AS '@osTypeName',
		P_LUN.Status AS '@status',
		P_LUN.Description AS '@description',
		LUN.Path AS '@lunPath',
		0 AS '@errorCode',
		'' AS '@errorString',
		P_LUN.userId AS 'user/@userId'
		FROM @tblLUNDetails TMP
			INNER JOIN SProvLUN P_LUN (NOLOCK) ON TMP.LUNId = P_LUN.LUNId
			INNER JOIN SMLUN LUN (NOLOCK) ON P_LUN.LUNId = LUN.Id
			--INNER JOIN simOperatingSystem SIM (NOLOCK) ON P_LUN.OSType = SIM.id
		FOR XML PATH ('lunList'), TYPE)
FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
ERR_EXIT:
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_PreProcessSProvOperation')
	delete from GxQscripts where name = 'SProv_PreProcessSProvOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvOperation')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvOperation'
GO

insert into GXDBVersions values(2, 'SProv_PreProcessSProvOperation',  '00010005001200060000', 'SProv_PreProcessSProvOperation', '00010005001200060000')
GO

