

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_PreProcessSProvMapOperation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_PreProcessSProvMapOperation.sp,v $ $Id: SProv_PreProcessSProvMapOperation.sp,v 1.3.12.2 2018/03/20 00:15:40 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "SProv_PreProcessSProvMapOperation"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_PreProcessSProvMapOperation <<<'

IF EXISTS (select * from sysobjects where name='SProv_PreProcessSProvMapOperation')
	drop procedure SProv_PreProcessSProvMapOperation
IF EXISTS (select * from GxQscripts where name='SProv_PreProcessSProvMapOperation')
	delete from GxQscripts where name = 'SProv_PreProcessSProvMapOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvMapOperation')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvMapOperation'
GO
print '... Creating Procedure: SProv_PreProcessSProvMapOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_PreProcessSProvMapOperation
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
DECLARE @tblLUNMountDetails TABLE (	LUNId INT,
									EndPointId INT,
									MountHostId INT,
									MountPath NVARCHAR(1024),
									ProtocolId INT,
									UserId INT,
									MountLUNId INT)
DECLARE @tblVolIds TABLE (VolumeId INT)
DECLARE @tblPoolIds TABLE (PoolId INT)
DECLARE @tblArrayNums TABLE (ArrayNum INT, PhyArrayNum INT, useTunneling INT, ClientId INT, vServerName NVARCHAR(1024))
DECLARE @tblVendorIdsLibraryNames TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @errorCode INT = 0
DECLARE @errorMsg VARCHAR(256) = ''
DECLARE @userId INT
SET @userId = ISNULL((SELECT R.ref.value('@userId', 'INT')
					FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref)), 0)
INSERT	INTO @tblLUNMountDetails (LunId, EndPointId, MountHostId, MountPath, ProtocolId, UserId)
SELECT	R.ref.value('@lunId', 'INT'),
		R.ref.value('@endPointId', 'INT'),
		R3.ref3.value('@clientId', 'INT'),
		ISNULL(R.ref.value('@mountPath', 'NVARCHAR(1024)'), ''),
		ISNULL(R.ref.value('@protocolId', 'INT'), 0),
		@userId
FROM	@xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList/mountList') R(ref)
		CROSS APPLY ref.nodes('./mountHost') R3 (ref3)
INSERT	INTO @tblVolIds
SELECT	DISTINCT VolumeId
FROM	@tblLUNMountDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
INSERT	INTO @tblPoolIds
SELECT	DISTINCT StoragePoolId
FROM	@tblLUNMountDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
INSERT	INTO @tblArrayNums (ArrayNum)
SELECT	DISTINCT ArrayNum
FROM	@tblLUNMountDetails TMP
		INNER JOIN SProvLUN LUN (NOLOCK) ON TMP.LUNId = LUN.LUNId
UPDATE	TMP
SET		TMP.ProtocolId = EP.AddressType
FROM	@tblLUNMountDetails TMP
		INNER JOIN SMEndPoint EP (NOLOCK) ON TMP.EndPointId = EP.Id
WHERE	TMP.ProtocolId = 0
INSERT	INTO SProvEndPoint(EndPointId, ClientId, Enabled, UserId)
SELECT	DISTINCT EndPointId, MountHostId, 1, @userId
FROM	@tblLUNMountDetails
WHERE	EndpointId NOT IN (SELECT EndPointId FROM SProvEndPoint)
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorMsg = 'Failed to set SProvEndPoint details.'
	GOTO ERR_EXIT
END
DECLARE @openCurFlag INT = 0
DECLARE @curLUNId INT
DECLARE @curEndPointId INT
DECLARE @curMountHostId INT
DECLARE @curProtocolId INT
DECLARE @curMntLunId INT
DECLARE db_cursor CURSOR FOR
SELECT DISTINCT LUNId, EndPointId, MountHostId, ProtocolId
FROM @tblLUNMountDetails
ORDER BY LunId, MountHostId
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorMsg = 'Failed to declare cursor to set SProvMountLUN details.'
	GOTO ERR_EXIT
END
SET @openCurFlag = 1
OPEN db_cursor
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorMsg = 'Failed to open cursor to set SProvMountLUN details.'
	GOTO ERR_EXIT
END
FETCH NEXT FROM db_cursor INTO @curLUNId, @curEndPointId, @curMountHostId, @curProtocolId
SET @errorCode = @@ERROR
IF @errorCode <> 0
BEGIN
	SET @errorMsg = 'Failed to read cursor to SProvMountLUN details.'
	GOTO ERR_EXIT
END
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT	INTO SProvMountLUN ( LunId, EndPointId, MountHostId, MountPath, ProtocolId, UserId, Enabled)
	SELECT	@curLUNId, @curEndPointId, @curMountHostId, N'', @curProtocolId, @userId, 1
	SET @curMntLunId = SCOPE_IDENTITY()
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorMsg = 'Failed to add SProvMountLUN details.'
		GOTO ERR_EXIT
	END
	UPDATE	@tblLUNMountDetails
	SET		MountLUNId = @curMntLunId
	WHERE	LUNId = @curLUNId
			AND MountHostId = @curMountHostId
			AND EndPointId = @curEndPointId
			AND ProtocolId = @curProtocolId
	FETCH NEXT FROM db_cursor INTO @curLUNId, @curEndPointId, @curMountHostId, @curProtocolId
	SET @errorCode = @@ERROR
	IF @errorCode <> 0
	BEGIN
		SET @errorMsg = 'Failed to set SProvMountLUN details.'
		GOTO ERR_EXIT
	END
END
CLOSE db_cursor
DEALLOCATE db_cursor
SET @openCurFlag = 0
UPDATE	TMP
SET		TMP.ClientId = HOST.ClientId
		FROM @tblArrayNums TMP
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
			INNER JOIN SMControlHost HOST(NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
UPDATE	TMP
SET		TMP.useTunneling = CONF.ValueInt
		FROM @tblArrayNums TMP
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
			INNER JOIN SMControlHost HOST (NOLOCK) ON MAP.ControlHostId = HOST.ControlHostId
			INNER JOIN SMConfigs CONF (NOLOCK) ON CONF.ArrayId = HOST.ControlHostId AND CONF.AssocId = HOST.ControlHostId
			INNER JOIN SMMasterConfigs MC(NOLOCK) ON MC.Id = CONF.MasterConfigId
			AND MC.KeyName = 'SMCONFIG_NAME_USE_TUNNELING'
UPDATE	TMP
SET		TMP.PhyArrayNum = MAP.ArrayId
		FROM APP_VMToPMMap VMMAP (NOLOCK)
			INNER JOIN SMControlHost HOST(NOLOCK)
				ON VMMAP.PMClientId = HOST.ClientId
			INNER JOIN @tblArrayNums TMP ON VMMAP.VMClientId = TMP.ClientId AND TMP.useTunneling = 1
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
WHERE	TMP.useTunneling = 1
UPDATE	TMP
SET		TMP.vServerName = PROP.attrVal
		FROM @tblArrayNums TMP
			INNER JOIN APP_ClientProp PROP ON PROP.componentNameId = TMP.ClientId
				AND PROP.attrName = 'NAS vServer Name'
WHERE	TMP.useTunneling = 1
INSERT INTO @tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT DISTINCT Ven.Id, SMEngine.SnapEngineDLL
FROM SMSnapShotEngine SMEngine
INNER JOIN SMVendor Ven ON SMEngine.SnapVendorName = Ven.Name
INNER JOIN SMControlHost Host ON Ven.Name = Host.SnapVendorName
INNER JOIN SMArrayCtrlHostMap Map ON Map.ControlHostId = Host.ControlHostId
INNER JOIN @tblArrayNums T_ARR ON Map.ArrayId = T_ARR.ArrayNum
DECLARE @MAClientId INT = 0
;with cte as
(SELECT CTRL.*,
        COUNT(TMP.ArrayNum) OVER (PARTITION BY CTRL.MMHostId) t1c
 FROM @tblArrayNums TMP
		INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = TMP.ArrayNum
		INNER JOIN SMArrayController CTRL (NOLOCK) ON MAP.ControlHostId = CTRL.ArrayNum
		INNER JOIN MMHost HOST (NOLOCK) ON HOST.ClientId = CTRL.MMHostId AND HOST.MmHostEnabled = 1 AND HOST.MmHostSoftState = 1 AND HOST.OfflineReason = 0
		INNER JOIN APP_Client CLNT (NOLOCK) ON CLNT.Id = CTRL.MMHostId AND CLNT.releaseId = 16)
SELECT @MAClientId =  MIN(MMHostId) FROM cte WHERE t1c = (SELECT COUNT(DISTINCT arrayNum) FROM @tblArrayNums)
SET @o_outXML =
(SELECT
		(SELECT TOP 1
		CLNT.id AS 'client/@clientId',
		CLNT.net_hostname AS 'client/@clientName'
		FROM APP_Client CLNT (NOLOCK) WHERE Id = @MAClientId
		FOR XML PATH ('sprovParam'), TYPE),
		(SELECT
		EPNT.Id AS '@endPointId',
		EPNT.AddressType AS '@addressType',
		EPNT.Address AS '@address',
		EPNT.IsActive AS '@isActive'
		FROM SMEndPoint EPNT (NOLOCK)
			INNER JOIN (SELECT DISTINCT EndPointID FROM @tblLUNMountDetails ) TMP
				ON EPNT.Id = TMP.EndPointId
		FOR XML PATH ('endPointList'), TYPE),
		(SELECT
		VEN.Id AS '@vendorId',
		VEN.Name AS '@vendorName',
		VEN.Name AS '@familyName',
		VEN.ShowInGUI AS '@showInGUI',
		VEN.IsEnabled AS '@enabled',
		0 AS '@flags',
		0 AS '@status',
		0 AS '@errorCode',
		'' AS '@errorString',
		T_IDSLIBS.LibraryName AS '@libraryName',
			(SELECT
			ARR.Id AS '@arrayNum',
			T_ARR.PhyArrayNum AS '@phyArrayNum',
			T_ARR.useTunneling AS '@useTunneling',
			T_ARR.vServerName AS '@vServerName',
			ARR.ArrayName AS '@arrayName',
			HOST.SMHostName AS '@controlHost',
			HOST.SMHostUserName AS '@userName',
			HOST.SMHostPassword AS '@password',
			1 AS '@enabled',
			0 AS '@status',
			0 AS '@errorCode',
			'' AS '@errorString',
			HOST.ClientId AS 'client/@clientId',
				(SELECT
				S_POOL.StoragePoolId AS '@storagePoolId',
				POOL.Name AS '@storagePoolName',
				S_POOL.ArrayNum AS '@arrayNum',
				POOL.UsedSpaceMB AS '@usedSpace',
				POOL.TotalSpaceMB AS '@totalSpace',
				S_POOL.Enabled AS '@enabled',
				S_POOL.Flags AS '@flags',
				0 AS '@status',
				0 AS '@errorCode',
				'' AS '@errorString',
					(SELECT
					S_VOL.VolumeId AS '@volumeId',
					VOL.Name AS '@volumeName',
					S_POOL.StoragePoolId AS '@storagePoolId',
					S_VOL.ArrayNum AS '@arrayNum',
					VOL.UsedSpaceMB * 1024 * 1024 AS '@usedSpace',
					VOL.TotalSpaceMB * 1024 * 1024 AS '@totalSpace',
					S_VOL.Enabled AS '@enabled',
					S_VOL.Flags AS '@flags',
					VOL.Path AS '@volumePath',
					0 AS '@status',
					0 AS '@errorCode',
					'' AS '@errorString'
					FROM SProvArrayVolume S_VOL (NOLOCK)
						INNER JOIN @tblVolIds T_VOL ON S_VOL.VolumeId = T_VOL.VolumeId
						INNER JOIN SMArrayVolume VOL (NOLOCK) ON S_VOL.VolumeId = VOL.Id
						AND S_VOL.ArrayNum = ARR.Id
					FOR XML PATH ('volumeList'), TYPE)
				FROM SProvStoragePool S_POOL (NOLOCK)
					INNER JOIN @tblPoolIds T_POOL ON T_POOL.PoolId = S_POOL.StoragePoolId
					INNER JOIN SMStoragePool POOL (NOLOCK) ON S_POOL.StoragePoolId = POOL.Id
						AND S_POOL.ArrayNum = ARR.Id
				FOR XML PATH('poolList'), TYPE)
			FROM  @tblArrayNums T_ARR --, @tblPoolIds T_POOL, @tblVolIds T_VOL
			INNER JOIN SMArray ARR (NOLOCK) ON (T_ARR.ArrayNum = ARR.Id OR T_ARR.PhyArrayNum = ARR.Id)
			INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK)
				ON MAP.ArrayId = ARR.Id
				--AND ARR.Id = P_LUN.ArrayNum
				--	AND ARR.Id IN (@arrayNum, @phyArrayNum)
			INNER JOIN SMControlHost HOST (NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
			FOR XML PATH ('arrayList'), TYPE )
		FROM SMVendor VEN (NOLOCK) INNER JOIN @tblVendorIdsLibraryNames T_IDSLIBS ON T_IDSLIBS.VendorId = VEN.Id
		FOR XML PATH ('arrayFamilyList'), TYPE),
		(SELECT
		P_LUN.LUNId AS '@lunId',
		LUN.Name AS '@lunName',
		P_LUN.VolumeId AS '@volumeId',
		P_LUN.StoragePoolId AS '@storagePoolId',
		P_LUN.ArrayNum AS '@arrayNum',
		LUN.UsedSpaceBytes AS '@usedSpace',
		LUN.TotalSpaceBytes AS '@totalSpace',
		P_LUN.Criteria AS '@criteria',
		--@criteria AS '@criteria',
		P_LUN.ExpirationDate AS '@expirationDate',
		P_LUN.Enabled AS '@enabled',
		P_LUN.Flags AS '@flags',
		P_LUN.OSType AS '@osTypeId',
		--SIM.Name AS '@osTypeName',
		P_LUN.Status AS '@status',
		P_LUN.Description AS '@description',
		LUN.Path AS '@lunPath',
		0 AS '@errorCode',
		'' AS '@errorString',
		P_LUN.userId AS 'user/@userId',
			(SELECT
			M_LUN.MountLunId AS '@mountLunId',
			M_LUN.LunId AS '@lunId',
			M_LUN.ProtocolId AS '@protocolId',
			M_LUN.EndPointId AS '@endPointId',
			CLNT.simOperatingSystemId AS '@mountHostOSTypeId',
			SIM.Name AS '@mountHostOSType',
			M_LUN.UserId AS 'user/@userId',
			M_LUN.MountHostId AS 'mountHost/@clientId',
			CLNT.net_hostname AS 'mountHost/@clientName'
			FROM SProvMountLUN M_LUN (NOLOCK) INNER JOIN APP_CLIENT CLNT (NOLOCK) ON CLNT.id = M_LUN.MountHostId
			INNER JOIN simOperatingSystem SIM (NOLOCK) ON CLNT.simOperatingSystemId = SIM.id
			WHERE M_LUN.LUNId = TMP.LUNId
			AND M_LUN.MountLunId IN (SELECT MountLunId FROM @tblLUNMountDetails)
			FOR XML PATH('mountList'), TYPE)
		FROM (SELECT DISTINCT LUNId FROM @tblLUNMountDetails) TMP
			INNER JOIN SProvLUN P_LUN (NOLOCK) ON TMP.LUNId = P_LUN.LUNId
			INNER JOIN SMLUN LUN (NOLOCK) ON P_LUN.LUNId = LUN.Id
			--INNER JOIN simOperatingSystem SIM (NOLOCK) ON P_LUN.OSType = SIM.id
		FOR XML PATH ('lunList'), TYPE)
FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
ERR_EXIT:
IF @openCurFlag = 1
BEGIN
    CLOSE db_cursor
    DEALLOCATE db_cursor
END
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_PreProcessSProvMapOperation')
	delete from GxQscripts where name = 'SProv_PreProcessSProvMapOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_PreProcessSProvMapOperation')
	delete from GXDBVersions where aliasname = 'SProv_PreProcessSProvMapOperation'
GO

insert into GXDBVersions values(2, 'SProv_PreProcessSProvMapOperation',  '00010003001200020000', 'SProv_PreProcessSProvMapOperation', '00010003001200020000')
GO

