

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_IsUserWithinQuota.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: SProv_IsUserWithinQuota()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_IsUserWithinQuota <<<'

IF EXISTS (select * from sysobjects where name='SProv_IsUserWithinQuota')
	drop procedure SProv_IsUserWithinQuota
IF EXISTS (select * from GxQscripts where name='SProv_IsUserWithinQuota')
	delete from GxQscripts where name = 'SProv_IsUserWithinQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_IsUserWithinQuota')
	delete from GXDBVersions where aliasname = 'SProv_IsUserWithinQuota'
GO
print '... Creating Procedure: SProv_IsUserWithinQuota'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_IsUserWithinQuota
  @policyId INT,
  @userId INT, 
  @totalSizeRequested BIGINT,
  @errorCode INT = 0 OUTPUT, 
  @errorString VARCHAR(256) = '' OUTPUT
AS
SET NOCOUNT ON
DECLARE @totalSpaceUsedByUser BIGINT
DECLARE @totalSpaceAllowedByPolicy BIGINT
DECLARE @currentDate DATETIME
SET @currentDate = GETUTCDATE()
IF @policyId <= 0 OR @policyId IS NULL OR
   @userId <= 0 OR @userId IS NULL OR
   @totalSizeRequested IS NULL OR @totalSizeRequested = 0
BEGIN
	SET @errorCode = 0
	SET @errorString = 'Invalid input'
	RETURN 0
END
DECLARE @lunTbl TABLE(lunId INT, policyId INT, userid INT, totalSpace BIGINT)
INSERT INTO @lunTbl(lunId, policyId, userid)
SELECT LUNId, PolicyId, UserId FROM SProvLUN WHERE UserId = @userId AND
												   PolicyId = @policyId AND
												   ExpirationDate > @currentDate
UPDATE @lunTbl SET totalSpace = S_LUN.TotalSpaceBytes
FROM SMLUN S_LUN INNER JOIN @lunTbl T_LUN ON T_LUN.lunId = S_LUN.Id
SET @totalSpaceUsedByUser = ISNULL((SELECT SUM(totalSpace) FROM @lunTbl), 0)
SET @totalSpaceAllowedByPolicy = (SELECT userQuotaInBytes FROM SprovAllocationPolicy WHERE policyId = @policyId)
IF (@totalSizeRequested + @totalSpaceUsedByUser) > @totalSpaceAllowedByPolicy
	BEGIN
		SET @errorCode = -1
		SET @errorString = 'User has exceeded the quota'
		RETURN 1
	END
ELSE
	BEGIN
		SET @errorCode = 0
		SET @errorString = 'User within quota'
		RETURN 0
	END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_IsUserWithinQuota')
	delete from GxQscripts where name = 'SProv_IsUserWithinQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_IsUserWithinQuota')
	delete from GXDBVersions where aliasname = 'SProv_IsUserWithinQuota'
GO

insert into GXDBVersions values(2, 'SProv_IsUserWithinQuota',  '00000000000000000000', 'SProv_IsUserWithinQuota', '00000000000000000000')
GO

