

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_ImportStorage.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: SProv_ImportStorage()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_ImportStorage <<<'

IF EXISTS (select * from sysobjects where name='SProv_ImportStorage')
	drop procedure SProv_ImportStorage
IF EXISTS (select * from GxQscripts where name='SProv_ImportStorage')
	delete from GxQscripts where name = 'SProv_ImportStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ImportStorage')
	delete from GXDBVersions where aliasname = 'SProv_ImportStorage'
GO
print '... Creating Procedure: SProv_ImportStorage'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_ImportStorage
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(1024),
  @xmlop XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @userId INT = 0
DECLARE @errorMsg NVARCHAR(1024) = ''
DECLARE @errorCode INT = 0
DECLARE @description NVARCHAR(1024) = ''
SET @userId = (SELECT R.ref.value('@userId', 'INT') FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/sprovCommon/logonUser') R(ref))
SET @description = 'This LUN was imported on ' + CONVERT(VARCHAR(128), GETUTCDATE()) + ' by user: ' + (SELECT TOP 1 name FROM UMUsers WHERE id = @userId)
DECLARE @lunTbl TABLE
(
	lunId INT,
	lunName VARCHAR(1024),
	volumeId INT,
	storagePoolId INT,
	arrayNum INT,
	lunUserId INT,
	volUser INT,
	volUserName VARCHAR(1024),
	volCanBeImported INT DEFAULT 0,
	distinctVolUsersCount INT
)
DECLARE @smendpt TABLE
(
    tempId INT,
    endPtId INT,
    ClientId INT,
    address NVARCHAR(2048),
    addressType INT
)
DECLARE @lunMapping TABLE
(
    lunId INT,
    epId INT,
    clientId INT,
    addressType INT,
    hostId INT,
    address NVARCHAR(2048),
    tempEPId INT,
	userId INT
)
INSERT INTO @lunTbl
                SELECT
                R.ref.value('@lunId', 'INT'),
				'',
                R.ref.value('@volumeId', 'nvarchar(1024)'),
                R.ref.value('@storagePoolId', 'INT'),
                R.ref.value('@arrayNum', 'INT'),
				R.ref.value('user[1]/@userId', 'INT'),
				0,
				'',
				0,
				0
                FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
INSERT INTO @smendpt
				SELECT
				R.ref.value('@endPointId', 'INT'),
				0,									--Actual EP Id. Setting it to 0 now.
				1,									--Client Id
				R.ref.value('@address', 'nvarchar(2048)'),
				R.ref.value('@addressType', 'INT')
				FROM
				@xmlText.nodes('/StorageProvisioning_MMSProvInfo/endPointList') R(ref)
INSERT INTO @lunMapping
                SELECT
                R.ref.value('@lunId', 'INT'),
                0,
                1,
				R1.ref1.value('@addressType', 'nvarchar(1024)'),
				0,
				R1.ref1.value('@address', 'nvarchar(1024)'),
                R1.ref1.value('@endPointId', 'INT'),
				R.ref.value('user[1]/@userId', 'INT')
                FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
				CROSS APPLY ref.nodes('./mountList/endPointList') R1(ref1)
--Update the actual End Point Id's from SMEndPoint table
UPDATE @smendpt SET endPtId = SM_EP.Id,
					ClientId = SM_EP.ClientId
FROM SMEndPoint SM_EP INNER JOIN @smendpt T_EP ON T_EP.address = SM_EP.Address AND T_EP.addressType = SM_EP.AddressType
--Update the actual end point id and the host id/client id in @lunMapping table
UPDATE @lunMapping SET epId = T_EP.endPtId,
					   clientId = T_EP.ClientId
FROM @smendpt T_EP INNER JOIN @lunMapping T_LUNMP ON /*T_LUNMP.tempEPId = T_EP.tempId AND*/ T_EP.address = T_LUNMP.address
AND T_EP.addressType = T_LUNMP.addressType
--Update the SProvHost Id in @lunMapping table
UPDATE @lunMapping SET hostId = SP_HST.SProvHostId
FROM SProvHost SP_HST INNER JOIN @lunMapping T_LUNMAP ON T_LUNMAP.clientId = SP_HST.ClientId
/***********
Check if the Volume has already been imported. If imported already check if the volume
was imported to the current user (@userId) or if it is getting imported to a different
user. If it is getting imported to a different user set the volCanBeImported flag to 0
which means the volume cannot be imported. If there is any such volume which cannot be
imported report the volume that cannot be imported.
***********/
--Update the volume User ID i.e., the user to which the volume belongs to
UPDATE @lunTbl SET volUser = SP_VOL.UserId
FROM SProvArrayVolume SP_VOL INNER JOIN @lunTbl T_LN ON T_LN.volumeId = SP_VOL.VolumeId
--Check if the volume can be imported. This basically checks if the volume user in SProvArrayvolume (if any)
--is same as the user to which the lun is supposed to get imported
UPDATE @lunTbl SET volCanBeImported = (CASE
											WHEN volUser = lunUserId
												THEN 1
												ELSE
												0
											END)
--If the volumes have not been imported before then they are not present in SProvArrayVolume, so mark them as volCanBeImported = 1
--Now, there is another case here. Let's say the admin is trying to import 2 luns belonging to the same volume to different users and
--the volume is not present in SProvArrayVolume i.e., the volume is getting newly imported.
--Initially lets just check if the volume is present in SProvArrayVolume table and set the volCanBeImported flag to 1 if not present
UPDATE @lunTbl SET volCanBeImported = 1 WHERE volumeId NOT IN (SELECT VolumeId FROM SProvArrayVolume)
--Lets handle the case where the admin is trying to import 2 luns belonging to the same volume to different users and
--the volume is not present in SProvArrayVolume i.e., the volume is getting newly imported. At this point the new volumes
--will have the volCanBeImported set. The below is a sample structure of how this case would look like. The first 2 luns
--are getting imported to lunUserId 1 and the last one is to lunUserId 3. The Volume Id for all luns is 663 which. In this
--case though the luns share the volume, the volume should be assigned to 1 user only.
/*
+================================================================================================================================+
+	lunId   lunName		volumeId 	storagePoolId	arrayNum	lunUserId	volUser		volCanBeImported	distinctVolUsersCount+
+================================================================================================================================+
+	552		luntest1_2	663			4				1			1			0			1							0  			 +
+	1003	asd			663			4				1			1			0			1							0			 +
+	5341	rahul_lun	663			4				1			3			0			1							0			 +
+================================================================================================================================+
*/
/*As the volume is not yet assigned to anyone volUser is set to 0. Therfore from the above table we should get the distinct lunUserId by
 grouping by volumeId. This gives us if info about the number of users getting assigned to the same volume. If the count is 1, no issues.
 if the count is more than, it means the admin is trying to share volumes. Therfore set volCanBeImported to 0 for such volumes.
*/
UPDATE @lunTbl SET distinctVolUsersCount = (SELECT COUNT(DISTINCT lunUserId) FROM @lunTbl WHERE volumeId = A.volumeId GROUP BY volumeId)
FROM @lunTbl A
/*
+================================================================================================================================+
+	lunId   lunName		volumeId 	storagePoolId	arrayNum	lunUserId	volUser		volCanBeImported	distinctVolUsersCount+
+================================================================================================================================+
+	552		luntest1_2		663				4			1				1		0				1					2			 +
+	1003	asd				663				4			1				1		0				1					2			 +
+	5341	rahul_lun		663				4			1				3		0				1					2			 +
+================================================================================================================================+
*/
--Update the volCanBeImported flag again where distinctVolUsersCount is > 1
UPDATE @lunTbl SET volCanBeImported = 0 WHERE distinctVolUsersCount > 1
--Update the lun name
UPDATE @lunTbl SET lunName = S_LN.Name
FROM SMLUN S_LN INNER JOIN @lunTbl T_LN ON T_LN.lunId = S_LN.Id
--Update the volume user name
UPDATE @lunTbl SET volUserName = U_USR.name
FROM UMUsers U_USR INNER JOIN @lunTbl T_LN ON T_LN.volUser = U_USR.id
--SELECT * FROM @lunTbl
--SELECT * FROM @smendpt
--SELECT * FROM @lunMapping
IF EXISTS(SELECT 1 FROM @lunTbl WHERE volCanBeImported = 0)
BEGIN
	SET @errorMsg = 'Volumes cannot be shared. The volumes for LUNs ' +
					CONVERT(NVARCHAR(2048), (SELECT STUFF((SELECT ', ' + lunName FROM @lunTbl WHERE volCanBeImported = 0 FOR XML PATH('')), 1, 1, ''))) +
					' are assigned to different users.'
	SET @errorCode = -1
	GOTO ERR_EXIT
END
IF EXISTS(SELECT 1 FROM SProvLUN WHERE LUNId IN (SELECT lunId FROM @lunTbl))
BEGIN
	SET @errorMsg = 'LUNs cannot be shared. One or more of the selected LUNs are already assigned to another user.'
	SET @errorCode = -1
	GOTO ERR_EXIT
END
--Update the SPROV tables
--Insert into SProvEndPoint
INSERT INTO SProvEndPoint(EndPointId, ClientId, Enabled, UserId)
SELECT DISTINCT T_LMAP.epId, T_LMAP.ClientId, 1, T_LMAP.userId
FROM @lunMapping T_LMAP WHERE NOT EXISTS (SELECT 1 FROM SProvEndPoint SP_EP WHERE SP_EP.EndPointId = T_LMAP.epId AND SP_EP.UserId = T_LMAP.userId)
--Insert into SProvArray if the array does not exist
INSERT INTO SProvArray(ArrayNum, HighWaterMark, WarningWaterMark, Enabled, ReserveFieldStr)
SELECT DISTINCT T_LUN.arrayNum, 90, 75, 1, 'Inserted during import operation by user id: ' + CONVERT(NVARCHAR(64), 1)
FROM @lunTbl T_LUN WHERE NOT EXISTS (SELECT 1 FROM SProvArray SP_ARR WHERE SP_ARR.ArrayNum = T_LUN.arrayNum)
--Insert into SProvStoragePool
INSERT INTO SProvStoragePool(StoragePoolId, ArrayNum, HighWaterMark, WarningWaterMark, Enabled)
SELECT DISTINCT T_LUN.storagePoolId, T_LUN.arrayNum, 0, 0, 1
FROM @lunTbl T_LUN WHERE NOT EXISTS(SELECT 1 FROM SProvStoragePool SP_POOL WHERE SP_POOL.StoragePoolId = T_LUN.storagePoolId)
--Insert into SProvArrayVolume
INSERT INTO SProvArrayVolume(VolumeId, StoragePoolId, ArrayNum, Enabled, Flags, UserId)
SELECT DISTINCT T_LUN.volumeId, T_LUN.storagePoolId, T_LUN.arrayNum, 1, 0, lunUserId
FROM @lunTbl T_LUN WHERE NOT EXISTS(SELECT 1 FROM SProvArrayVolume SP_VOL WHERE SP_VOL.VolumeId = T_LUN.volumeId)
--Check if import policy exists. If it doesn't exist, create one.
IF NOT EXISTS (SELECT policyName FROM SprovAllocationPolicy WHERE policyName = 'System: Import Policy')
BEGIN
		SET IDENTITY_INSERT SprovAllocationPolicy ON;;
	INSERT INTO SprovAllocationPolicy
										(policyId,
										 policyName,
										 description,
										 policyTypeId,
										 userQuotaInBytes,
										 expirationPeriod,
										 createdby)
										VALUES
										(-2,
										 'System: Import Policy',
										 'System: Import Policy',
										 (SELECT TOP 1 policyTypeId FROM SprovAllocationPolicyType WHERE policyTypeId = -1),
										 0,
										 90,
										 (SELECT TOP 1 UMUsers.id FROM UMUsers WHERE ((UMUsers.flags & 0x040) <> 0)))
		SET IDENTITY_INSERT SprovAllocationPolicy OFF;;
END
--Insert into SprovLUN
INSERT INTO SProvLUN(LUNId, VolumeId, StoragePoolId, ArrayNum, UserId, Criteria, ExpirationDate, HighWaterMark, WarningWaterMark, Enabled, Flags, OSType, Status, PolicyId, Description)
SELECT lunId, volumeId, storagePoolId, arrayNum, lunUserId, 0, DATEADD(DD, (SELECT TOP 1 expirationPeriod FROM SprovAllocationPolicy WHERE policyId = -2), GETUTCDATE()), 0, 0, 1, 0, 0, 39/*SPROV_LS_CRT_CREATED*/, -2 /*System: Import Policy*/, @description
FROM @lunTbl T_LUN WHERE NOT EXISTS(SELECT 1 FROM SProvLUN SP_LUN WHERE SP_LUN.LUNId = T_LUN.lunId)
--Insert into SProvMounLUN
INSERT INTO SProvMountLUN (LUNId, EndPointId, MountHostId, MountPath, ProtocolId, UserId, Enabled)
SELECT lunId, epId, clientId, '', addressType, userId, 1
FROM @lunMapping T_LMAP WHERE NOT EXISTS(SELECT 1 FROM SProvMountLun SP_MNT WHERE
													   SP_MNT.LUNId = T_LMAP.lunId AND
													   SP_MNT.UserId = T_LMAP.userId AND
													   SP_MNT.EndPointId = T_LMAP.epId)
SET @errorCode = 0
SET @errorMsg = 'Successfully Imported LUNs to the selected user'
SET @xmlop = (SELECT @errorCode AS '@errorCode',
				 	 @errorMsg AS '@errorString'
			  FOR XML PATH('StorageProvisioning_MMSProvInfo'))
RETURN
ERR_EXIT:
SET @xmlop = (SELECT @errorCode AS '@errorCode',
				 	 @errorMsg AS '@errorString'
			  FOR XML PATH('StorageProvisioning_MMSProvInfo'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_ImportStorage')
	delete from GxQscripts where name = 'SProv_ImportStorage'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_ImportStorage')
	delete from GXDBVersions where aliasname = 'SProv_ImportStorage'
GO

insert into GXDBVersions values(2, 'SProv_ImportStorage',  '00000000000000000000', 'SProv_ImportStorage', '00000000000000000000')
GO

