

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_GetPolicyInfo.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: SProv_GetPolicyInfo()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_GetPolicyInfo <<<'

IF EXISTS (select * from sysobjects where name='SProv_GetPolicyInfo')
	drop procedure SProv_GetPolicyInfo
IF EXISTS (select * from GxQscripts where name='SProv_GetPolicyInfo')
	delete from GxQscripts where name = 'SProv_GetPolicyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetPolicyInfo')
	delete from GXDBVersions where aliasname = 'SProv_GetPolicyInfo'
GO
print '... Creating Procedure: SProv_GetPolicyInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_GetPolicyInfo
  @policyId INT,
  @outputArrayTableArg NVARCHAR(1024) = '',
  @outputStPoolArg NVARCHAR(1024) = '',
  @opxmlgetInfo XML OUTPUT,
  @opxmlForEdit XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @errorCode INT = 0
DECLARE @errorString nvarchar(1024) = ''
DECLARE @selectionType INT  = 0
IF @policyId <= 0 OR @policyId IS NULL
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Invalid policy ID!'
	GOTO ERR_EXIT
END
IF NOT EXISTS (SELECT 1 FROM SprovAllocationPolicy WHERE policyId = @policyId)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Policy ID does not exist!'
	GOTO ERR_EXIT
END
--A policy can have only one selection type in any case.
--Adding 'TOP 1' just to make sure we assign only 1 entry to @selectionType variable.
--Or should we return an error here if a policy has multiple selection types ??
SET @selectionType = (SELECT TOP 1 selectionType FROM SprovAllocationPolicyFilerProp WHERE policyId = @policyId)
IF @selectionType = 0
RETURN
IF OBJECT_ID('tempdb.dbo.#policyInfoArraysTbl') IS NOT NULL
	DROP TABLE #policyInfoArraysTbl
IF OBJECT_ID('tempdb.dbo.#policyInfoStoragePoolsTbl') IS NOT NULL
	DROP TABLE #policyInfoStoragePoolsTbl
CREATE TABLE #policyInfoArraysTbl ( [arrayNum]		INT NOT NULL DEFAULT 0,
									[arrayName]		NVARCHAR(1024) NOT NULL DEFAULT '',
									[vendorName]	NVARCHAR(1024)	NOT NULL DEFAULT '',
									[vendorId]		INT NOT NULL DEFAULT 0,
									[policyId]		INT	NOT NULL DEFAULT 0,
									[clientId]		INT	NOT NULL DEFAULT 0,
									[flags]			INT NOT NULL DEFAULT 0,
									[totalSpace]	BIGINT NOT NULL DEFAULT 0,
									[freeSpace]		BIGINT NOT NULL DEFAULT 0
							      )
CREATE TABLE #policyInfoStoragePoolsTbl ( [storagePoolId]		INT NOT NULL DEFAULT 0,
										  [clientId]			INT NOT NULL DEFAULT 0,
										  [arrayNum]			INT NOT NULL DEFAULT 0,
										  [storagePoolName]		NVARCHAR(1024) NOT NULL DEFAULT '',
										  [policyId]			INT	NOT NULL DEFAULT 0,
										  [flags]				INT NOT NULL DEFAULT 0,
    									  [totalSpace]			BIGINT NOT NULL DEFAULT 0,
										  [freeSpace]			BIGINT NOT NULL DEFAULT 0
									    )
DECLARE @arrayTbl TABLE
(
	arrayId INT,
	controlHostId INT,
	arrayName NVARCHAR(1024),
	vendorName NVARCHAR(1024),
	clientId INT,
	selectionType INT,
	totalSpace BIGINT,
	freeSpace BIGINT
)
DECLARE @storagePoolTbl TABLE
(
	arrayId INT,
	storagePoolId INT,
	storagePoolName NVARCHAR(1024),
	clientId INT,
	totalSpace BIGINT,
	freeSpace BIGINT,
	flags INT
)
--INSERT include filters for arrays
------------------------------------------------------------
--Option a (file server)
--Insert only file servers whose name is not empty and the name does not have wildcard characters.
--The name field can be empty in SprovAllocationPolicyFilerProp table when the user chooses
--the vendors option (option b).
IF @selectionType = 1
BEGIN
	INSERT INTO #policyInfoArraysTbl (arrayNum, clientId, arrayName, policyId, flags, totalSpace, freeSpace)
	SELECT S_ARR.Id, S_ARR.ClientId, S_ARR.ArrayName, @policyId, 1, S_ARR.TotalSpaceMB, S_ARR.FreeSpaceMB
	FROM SMArray S_ARR INNER JOIN SProvArray SP_ARR ON SP_ARR.ArrayNum = S_ARR.Id
	WHERE S_ARR.Id IN
	(SELECT arrayNum
	 FROM SprovAllocationPolicyFilerProp
	 WHERE policyId = @policyId AND filerId <> '' AND selectionType = 1) AND
	SP_ARR.Enabled = 1
 END
--Option b (vendors option in the GUI)
--Insert only file servers whose name is empty. The name field can be empty in SprovAllocationPolicyFilerProp table when the user chooses
--the vendor option.
ELSE IF @selectionType = 2
BEGIN
	INSERT INTO @arrayTbl(controlHostId, clientId, vendorName, selectionType)
	SELECT S_HOST.ControlHostId, S_HOST.ClientId, S_HOST.SnapVendorName, 2
	FROM SMControlHost S_HOST INNER JOIN SMArray S_ARR ON S_ARR.ClientId = S_HOST.ClientId
							  INNER JOIN SProvArray SP_ARR ON SP_ARR.ArrayNum = S_ARR.Id
	WHERE S_HOST.SnapVendorName IN
	(SELECT filerType FROM SprovAllocationPolicyFilerProp WHERE filerId = '' AND policyId = @policyId AND filerType <> '' AND selectionType = 2) AND
	SP_ARR.Enabled = 1
	UPDATE @arrayTbl SET arrayId = S_ARR.Id,
						 arrayName = S_ARR.ArrayName,
						 totalSpace = S_ARR.TotalSpaceMB,
						 freeSpace = S_ARR.FreeSpaceMB
	FROM SMArray S_ARR INNER JOIN @arrayTbl T_ARR ON T_ARR.clientId = S_ARR.ClientId
	INSERT INTO #policyInfoArraysTbl (arrayNum, clientId, arrayName, policyId, flags, totalSpace, freeSpace)
	SELECT arrayId, clientId, arrayName, @policyId, 1, totalSpace, freeSpace FROM @arrayTbl
END
--Option c
--Insert only when the user chooses option c. i.e., when the user has wildcards in both include and exclude filters
ELSE IF @selectionType = 3
BEGIN
	INSERT INTO #policyInfoArraysTbl (arrayNum, clientId, arrayName, policyId, flags, totalSpace, freeSpace)
	SELECT S_ARR.Id, S_ARR.ClientId, S_ARR.ArrayName, @policyId, 1, S_ARR.TotalSpaceMB, S_ARR.FreeSpaceMB
	FROM SMArray S_ARR INNER JOIN SProvArray SP_ARR ON SP_ARR.ArrayNum = S_ARR.Id
	WHERE S_ARR.ArrayName IN
	(SELECT DISTINCT S_ARR.ArrayName
	 FROM SprovAllocationPolicyFilerProp S_POL INNER JOIN SMArray S_ARR ON S_ARR.ArrayName LIKE S_POL.filerId
	 WHERE S_POL.policyId = @policyId AND S_POL.filerId <> '' AND S_POL.selectionType = 3) AND
	SP_ARR.Enabled = 1
 END
 --END: INSERT include filters for arrays
------------------------------------------------------------
--INSERT exclude filters for arrays
------------------------------------------------------------
INSERT INTO #policyInfoArraysTbl (arrayNum, clientId, arrayName, policyId, flags, totalSpace, freeSpace)
SELECT S_ARR.Id, S_ARR.ClientId, S_ARR.ArrayName, @policyId, 2, S_ARR.TotalSpaceMB, S_ARR.FreeSpaceMB FROM SMArray S_ARR WHERE S_ARR.ArrayName IN
(SELECT DISTINCT SM_ARR.ArrayName
 FROM SprovAllocationPolicyFilerFilter S_POL INNER JOIN SMArray SM_ARR ON SM_ARR.ArrayName LIKE S_POL.filerId
 WHERE S_POL.policyId = @policyId AND S_POL.filerId <> '')
--END: INSERT exclude filters for arrays
------------------------------------------------------------
--Update the vendor name and vendor id field in #policyInfoArraysTbl table
UPDATE #policyInfoArraysTbl
SET vendorName = S_HOST.SnapVendorName
FROM SMControlHost S_HOST INNER JOIN #policyInfoArraysTbl T_ARR ON T_ARR.clientId = S_HOST.ClientId
UPDATE #policyInfoArraysTbl
SET vendorId = S_VEN.Id
FROM SMVendor S_VEN INNER JOIN #policyInfoArraysTbl T_ARR ON T_ARR.vendorName = S_VEN.Name
--Pre Process Storage Pools entities------------------------
--Include Storage Pools
INSERT INTO @storagePoolTbl(arrayId, storagePoolId, storagePoolName, clientId, totalSpace, freeSpace, flags)
SELECT SPOL_POOL.arrayNum, SM_POOL.Id, SM_POOL.Name, SM_POOL.ClientId, SM_POOL.TotalSpaceMB, SM_POOL.FreeSpaceMB, 1
FROM SprovAllocationPolicyResourcePool SPOL_POOL INNER JOIN SMStoragePool SM_POOL ON SM_POOL.Id = SPOL_POOL.aggregateId
WHERE SPOL_POOL.policyId = @policyId AND SPOL_POOL.aggregateName <> ''
--Update the arrayId field
--UPDATE @storagePoolTbl SET arrayId = S_ARR.Id
--FROM SMArray S_ARR INNER JOIN @storagePoolTbl T_SPOOL ON T_SPOOL.clientId = S_ARR.ClientId
--Exclude Storage Pools
INSERT INTO @storagePoolTbl(arrayId, storagePoolId, storagePoolName, clientId, totalSpace, freeSpace, flags)
SELECT T_ARR.arrayNum, SM_POOL.Id, SM_POOL.Name, SM_POOL.ClientId, SM_POOL.TotalSpaceMB, SM_POOL.FreeSpaceMB, 2 FROM SMStoragePool SM_POOL INNER JOIN #policyInfoArraysTbl T_ARR
ON T_ARR.clientId = SM_POOL.ClientId
WHERE SM_POOL.Name IN
(SELECT DISTINCT SM_POOL.Name
 FROM SprovAllocationPolicyResourcePoolFilter S_POOLFILTER INNER JOIN SMStoragePool SM_POOL ON SM_POOL.Name LIKE S_POOLFILTER.aggregateName
 WHERE S_POOLFILTER.policyId = @policyId AND S_POOLFILTER.aggregateName <> '')
--End: Pre Process Storage Pools entities-------------------
--INSERT include filters for storage pools
------------------------------------------------------------
INSERT INTO #policyInfoStoragePoolsTbl(storagePoolId, clientId, arrayNum, storagePoolName, policyId, flags, totalSpace, freeSpace)
SELECT storagePoolId, clientId, arrayId, storagePoolName, @policyId, flags, totalSpace, freeSpace FROM @storagePoolTbl T_POOL
WHERE T_POOL.flags = 1
--END: INSERT include filters for storage pools
------------------------------------------------------------
INSERT INTO #policyInfoStoragePoolsTbl(storagePoolId, clientId, arrayNum, storagePoolName, policyId, flags, totalSpace, freeSpace)
SELECT storagePoolId, clientId, arrayId, storagePoolName, @policyId, flags, totalSpace, freeSpace FROM @storagePoolTbl T_POOL
WHERE T_POOL.flags = 2
--DEBUG
--SELECT * FROM @arrayTbl
--SELECT * FROM @storagePoolTbl
--SELECT * FROM #policyInfoArraysTbl
--SELECT * FROM #policyInfoStoragePoolsTbl
--END: INSERT exclude filters for storage pools
------------------------------------------------------------
IF ((@outputArrayTableArg IS NOT NULL AND @outputArrayTableArg <> '') AND (@outputStPoolArg IS NOT NULL AND @outputStPoolArg <> ''))
BEGIN
	DECLARE @insertIntoArraysTbl NVARCHAR(MAX)
	DECLARE @insertIntoSPoolsTbl NVARCHAR(MAX)
	SET @insertIntoArraysTbl = 'INSERT INTO '+ @outputArrayTableArg
							  +' SELECT * FROM #policyInfoArraysTbl'
	EXEC (@insertIntoArraysTbl)
	SET @insertIntoSPoolsTbl = 'INSERT INTO '+ @outputStPoolArg
							  +' SELECT * FROM #policyInfoStoragePoolsTbl'
	EXEC (@insertIntoSPoolsTbl)
END
SET @opxmlgetInfo = (	SELECT
							(SELECT S_VEN.Id AS '@vendorId',
									S_VEN.Name AS '@vendorName',
									(
										SELECT T_ARR.arrayNum AS '@arrayNum',
											   T_ARR.arrayName AS '@arrayName',
											   T_ARR.clientId AS 'client/@clientId',
											   (
													SELECT T_POOL.arrayNum AS '@arrayNum',
														   T_POOL.storagePoolId AS '@storagePoolId',
														   T_POOL.storagePoolName AS '@storagePoolName'
													FROM #policyInfoStoragePoolsTbl T_POOL
													WHERE T_POOL.arrayNum = T_ARR.arrayNum AND
														  T_POOL.storagePoolId IN (SELECT storagePoolId FROM #policyInfoStoragePoolsTbl WHERE flags = 1) AND
														  T_POOL.storagePoolId NOT IN (SELECT storagePoolId FROM #policyInfoStoragePoolsTbl WHERE flags = 2)
													FOR XML PATH('poolList'), TYPE
											   )
										FROM #policyInfoArraysTbl T_ARR
										WHERE T_ARR.vendorName = S_VEN.Name AND
											  T_ARR.arrayNum IN (SELECT arrayNum FROM #policyInfoArraysTbl WHERE flags = 1) AND
											  T_ARR.arrayNum NOT IN (SELECT arrayNum FROM #policyInfoArraysTbl WHERE flags = 2)
										FOR XML PATH('arrayList'), TYPE
									 )
							FROM SMVendor S_VEN INNER JOIN #policyInfoArraysTbl T_ARRAY ON T_ARRAY.vendorId = S_VEN.Id GROUP BY S_VEN.Id, S_VEN.Name
							FOR XML PATH('arrayFamilyList'), TYPE)
							FOR XML PATH('StorageProvisioning_MMSProvInfo')
				    )
SET @opxmlForEdit =	(SELECT
						(SELECT S_POL.policyId AS '@policyId',
					 			S_POL.policyName AS '@policyName',
					 			S_POL.description AS '@description',
					 			S_POL.userQuotaInBytes/(1024*1024*1024) AS '@userQuotaInGB',
					 			/*dbo.GetUnixTime(S_POL.expirationPeriod)*/ S_POL.expirationPeriod AS '@expirationPeriod',
					 			S_POL.policyTypeId AS '@policyTypeId',
					 			(SELECT
					 				(SELECT filerId AS '@arrayName',
											arrayNum AS '@arrayNum',
					 						1 AS '@flags',
					 						selectionType AS '@selectionType',
					 						filerType AS 'reserve/@reserveString'
					 				FROM SprovAllocationPolicyFilerProp S_POLARRAY WHERE S_POLARRAY.policyId = S_POL.policyId
					 				FOR XML PATH('includeExcludeArrayList'), TYPE),
					 				(SELECT filerId AS '@arrayName',
											arrayNum AS '@arrayNum',
					 						2 AS '@flags',
					 						filerType AS 'reserve/@reserveString'
					 				FROM SprovAllocationPolicyFilerFilter S_POLARRAYFILTER WHERE S_POLARRAYFILTER.policyId = S_POL.policyId
					 				FOR XML PATH('includeExcludeArrayList'), TYPE),
					 				(SELECT aggregateName AS '@storagePoolName',
											arrayNum AS '@arrayNum',
					 						1 AS '@flags'
					 				FROM SprovAllocationPolicyResourcePool S_POOL WHERE S_POOL.policyId = S_POL.policyId
					 				FOR XML PATH('includeExcludeStoragePoolList'), TYPE),
					 				(SELECT aggregateName AS '@storagePoolName',
											arrayNum AS '@arrayNum',
					 						2 AS '@flags'
					 				FROM SprovAllocationPolicyResourcePoolFilter S_POOLFILTER WHERE S_POOLFILTER.policyId = S_POL.policyId
					 				FOR XML PATH('includeExcludeStoragePoolList'), TYPE)
					 				FOR XML PATH('includeExcludeList'), TYPE),
					 			(SELECT userOrGroupId AS '@userOrGroupId',
					 					isGroup AS '@isGroup'
					 			FROM SprovPolicyToUserMap S_POL2USERMAP WHERE S_POL2USERMAP.policyId = S_POL.policyId
					 			FOR XML PATH('userOrGroupList'), TYPE),
					 			(SELECT SM_LUN.Id AS '@lunId',
					 					SM_LUN.Name AS '@lunName'
					 			FROM SProvLUN SP_LUN INNER JOIN SMLUN SM_LUN ON SP_LUN.LUNId = SM_LUN.Id WHERE SP_LUN.PolicyId = S_POL.policyId
					 			FOR XML PATH('lunList'), TYPE)
						FROM SprovAllocationPolicy S_POL WHERE S_POL.policyId = @policyId
			     		FOR XML PATH('policyList'), TYPE)
				FOR XML PATH('StorageProvisioning_MMSProvPolicyInfo'))
RETURN
ERR_EXIT:
SET @opxmlForEdit = (SELECT @errorCode AS '@errorCode',
							@errorString AS '@errorString'
					 FOR XML PATH('StorageProvisioning_MMSProvPolicyInfo'))
SET @opxmlgetInfo = (SELECT @errorCode AS '@errorCode',
						    @errorString AS '@errorString'
			         FOR XML PATH('StorageProvisioning_MMSProvInfo'))
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_GetPolicyInfo')
	delete from GxQscripts where name = 'SProv_GetPolicyInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetPolicyInfo')
	delete from GXDBVersions where aliasname = 'SProv_GetPolicyInfo'
GO

insert into GXDBVersions values(2, 'SProv_GetPolicyInfo',  '00000000000000000000', 'SProv_GetPolicyInfo', '00000000000000000000')
GO

