

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_GetLUNsForExpiryAlerts.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_GetLUNsForExpiryAlerts.sp,v $ $Id: SProv_GetLUNsForExpiryAlerts.sp,v 1.2.14.2 2018/03/20 00:07:31 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "SProv_GetLUNsForExpiryAlerts"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_GetLUNsForExpiryAlerts <<<'

IF EXISTS (select * from sysobjects where name='SProv_GetLUNsForExpiryAlerts')
	drop procedure SProv_GetLUNsForExpiryAlerts
IF EXISTS (select * from GxQscripts where name='SProv_GetLUNsForExpiryAlerts')
	delete from GxQscripts where name = 'SProv_GetLUNsForExpiryAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetLUNsForExpiryAlerts')
	delete from GXDBVersions where aliasname = 'SProv_GetLUNsForExpiryAlerts'
GO
print '... Creating Procedure: SProv_GetLUNsForExpiryAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_GetLUNsForExpiryAlerts
  @xmlText XML,
  @reserveInt INT,
  @reserveStr VARCHAR(256)
AS
  DECLARE @o_LunId INT
  DECLARE @o_LunName VARCHAR(1024)
  DECLARE @o_VolumeId INT
  DECLARE @o_VolumeName VARCHAR(1024)
  DECLARE @o_ArrayName VARCHAR(1024)
  DECLARE @o_userId INT
  DECLARE @o_userName VARCHAR(1024)
  DECLARE @o_userEmail VARCHAR(1024)
  DECLARE @o_DaysToExpire INT
  DECLARE @o_ExpDate DATETIME
  DECLARE @o_Description VARCHAR(1024)
SET NOCOUNT ON
DECLARE @currTime INT = dbo.getUnixTime(GETUTCDATE())
DECLARE @lunCleanupWaitTime INTEGER
SET @lunCleanupWaitTime = ISNULL((select Value from MMConfigs(NOLOCK) where name = 'MMS2_SPROV_LUN_CLEANUP_ALERT_TIME_DAYS'), 5) * 24 * 60 * 60
DECLARE @cleanupCutOffTime DATETIME = dbo.getDateTime (@currTime + @lunCleanupWaitTime)
--select @cleanupCutOffTime
DECLARE @tblLUNDetails TABLE (LUNId INT, UserId INT, Description VARCHAR(1024))
INSERT	INTO @tblLUNDetails (LunId, UserId, Description)
SELECT	LunId, UserId, Description
FROM	SProvLUN (NOLOCK)
WHERE	ExpirationDate > GETUTCDATE()
		AND ExpirationDate < @cleanupCutOffTime
SELECT	P_LUN.LUNId, LUN.Name AS LunName, VOL.Id AS VolumeId, VOL.Name AS VolumeName,
		HOST.SMArrayId AS ArrayName, USR.id AS UserId, USR.name AS UserName, USR.email AS UserEmail,
		DATEDIFF(day, GETUTCDATE(), P_LUN.ExpirationDate) AS DaysToExpire,
		P_LUN.ExpirationDate AS ExpirationDate, P_LUN.Description AS Description
FROM	@tblLUNDetails TMP
		INNER JOIN SProvLUN P_LUN (NOLOCK) ON TMP.LUNId = P_LUN.LunId
		INNER JOIN SMLUN LUN (NOLOCK) ON P_LUN.LUNId = LUN.Id
		INNER JOIN SMArrayVolume VOL (NOLOCK) ON VOL.Id = LUN.ArrayVolumeId
		INNER JOIN SMArray ARR (NOLOCK) ON P_LUN.ArrayNum = ARR.Id
		INNER JOIN SMArrayCtrlHostMap MAP (NOLOCK) ON MAP.ArrayId = ARR.Id
		INNER JOIN SMControlHost HOST(NOLOCK) ON HOST.ControlHostId = MAP.ControlHostId
		INNER JOIN UMUsers USR (NOLOCK) ON USR.id = TMP.UserId
		ORDER BY ArrayName
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_GetLUNsForExpiryAlerts')
	delete from GxQscripts where name = 'SProv_GetLUNsForExpiryAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetLUNsForExpiryAlerts')
	delete from GXDBVersions where aliasname = 'SProv_GetLUNsForExpiryAlerts'
GO

insert into GXDBVersions values(2, 'SProv_GetLUNsForExpiryAlerts',  '00010002001400020000', 'SProv_GetLUNsForExpiryAlerts', '00010002001400020000')
GO

