

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_GetHedvigSProvInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_GetHedvigSProvInfo.sp,v $ $Id: SProv_GetHedvigSProvInfo.sp,v 1.1.4.3 2020/10/27 17:29:33 macharya Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "Sprov_GetSProvInfo"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SProv_GetHedvigSProvInfo')
BEGIN
	print '>>> Drop Stored Procedure: SProv_GetHedvigSProvInfo <<<'
	drop procedure SProv_GetHedvigSProvInfo
END
IF EXISTS (select * from GxQscripts where name='SProv_GetHedvigSProvInfo')
	delete from GxQscripts where name = 'SProv_GetHedvigSProvInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetHedvigSProvInfo')
	delete from GXDBVersions where aliasname = 'SProv_GetHedvigSProvInfo'
GO
print '... Creating Procedure: SProv_GetHedvigSProvInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_GetHedvigSProvInfo
  @i_xmlText XML,
  @i_reserveInt INT,
  @i_reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
-- #################### Local Variables #################### --
DECLARE @l_errorCode			INT = 0
DECLARE @l_errorMsg				VARCHAR(256) = ''
DECLARE @l_subclientId			INT = 0
DECLARE @l_clientId				INT = 0
DECLARE @l_arrayNum				INT = 0
DECLARE @l_opType				INT = 0
DECLARE @l_userId				INT = 0
DECLARE @l_openArrCurFlag		INT	= 0
DECLARE @l_curArrayNum			INT	= 0
DECLARE @l_curControlHostId		INT	= 0
-- #################### Local Tables #################### --
DECLARE @l_tblLUNDetails				TABLE (LUNId INT, UserId INT)
DECLARE @l_tblMountLUNDetails			TABLE (MountLUNId INT, UserId INT)
DECLARE @l_tblVolIds					TABLE (VolumeId INT, TotalLUNsUnderVolume INT, TotalLUNsSelectedForSProvOperation INT, DeleteVolume INT)
DECLARE @l_tblPoolIds					TABLE (PoolId INT)
DECLARE @l_tblVendorIdsLibraryNames		TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @l_tblArrayNums					TABLE (ArrayNum INT, ArrayConfigs NVARCHAR(MAX), UserName NVARCHAR(MAX), Password NVARCHAR(MAX))
-- #################### Input Gathering #################### --
----------------------------------------
---- Get Subclient Id..
----------------------------------------
SET @l_subclientId	= ISNULL((SELECT R.ref.value('@reserveInt2', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam/reserve') R(ref)), 0)
IF (@l_subclientId = 0)
BEGIN
	SET @l_errorMsg = 'Subclient not provided in the input'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Subclient doesn't exist..
IF NOT EXISTS (SELECT 1 FROM APP_Application WITH (READUNCOMMITTED) WHERE id = @l_subclientId)
BEGIN
	SET @l_errorMsg = 'Subclient ' + CONVERT(VARCHAR(1024), @l_subclientId) + 'does not exist in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get Array number..
----------------------------------------
SET @l_arrayNum	= ISNULL((SELECT R.ref.value('@arrayNum', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
IF (@l_arrayNum = 0)
BEGIN
	SET @l_errorMsg = 'Array number not provided in the input'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
---- Array doesn't exist..
IF NOT EXISTS (SELECT 1 FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_arrayNum)
BEGIN
	SET @l_errorMsg = 'Array ' + CONVERT(VARCHAR(1024), @l_arrayNum) + 'not available in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get Array info..
----------------------------------------
INSERT  INTO @l_tblArrayNums (ArrayNum)
SELECT  DISTINCT MAP.ArrayId
FROM    SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
WHERE	MAP.ControlHostId = @l_arrayNum
----------------------------------------
---- Get operation type..
----------------------------------------
SET @l_opType = ISNULL((SELECT R.ref.value('@operation', 'INT') FROM @i_xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
----------------------------------------
---- Get User Id..
----------------------------------------
SET @l_userId = (SELECT TOP 1 id FROM UMUsers WITH (READUNCOMMITTED) WHERE flags & 0x040 = 0x040 ORDER BY id ASC)
IF (@l_userId = 0)
BEGIN
	SET @l_errorMsg = 'No user configured in the DB'
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Get LUNs for the subclient..
----------------------------------------
INSERT  INTO @l_tblLUNDetails (LunId, UserId)
SELECT  Id, @l_userId
FROM	SMLUN LUN WITH (READUNCOMMITTED)
			INNER JOIN SProvLUN P_LUN WITH (READUNCOMMITTED)
				ON LUN.Id = P_LUN.LUNId
WHERE	LUN.ReserveField4 = @l_subclientId
			AND P_LUN.ArrayNum IN (SELECT ArrayNum FROM @l_tblArrayNums)
----------------------------------------
---- Get Mount LUNs..
----------------------------------------
INSERT	INTO @l_tblMountLUNDetails (MountLUNId, UserId)
SELECT	DISTINCT MountLUNId, @l_userId
FROM	@l_tblLUNDetails T_LUN
			INNER JOIN SProvMountLUN M_LUN WITH (READUNCOMMITTED)
				ON M_LUN.LUNId = T_LUN.LunId
----------------------------------------
---- Get Volume info..
----------------------------------------
INSERT  INTO @l_tblVolIds
SELECT  DISTINCT VolumeId, 0, 0, 0
FROM    @l_tblLUNDetails TMP
			INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
				ON TMP.LUNId = LUN.LUNId
----------------------------------------
---- Get Pool info..
----------------------------------------
INSERT  INTO @l_tblPoolIds
SELECT  DISTINCT StoragePoolId
FROM    @l_tblLUNDetails TMP
        INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
			ON TMP.LUNId = LUN.LUNId
----------------------------------------
---- Get Vendor info..
----------------------------------------
INSERT	INTO @l_tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT	DISTINCT VEN.Id, ENG.SnapEngineDLL
FROM	SMSnapShotEngine ENG WITH (READUNCOMMITTED)
			INNER JOIN SMVendor VEN WITH (READUNCOMMITTED)
				ON ENG.SnapVendorName = VEN.Name
			INNER JOIN SMControlHost HOST WITH (READUNCOMMITTED)
				ON VEN.Name = HOST.SnapVendorName
			INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
				ON MAP.ControlHostId = HOST.ControlHostId
			INNER JOIN @l_tblArrayNums T_ARR
				ON MAP.ArrayId = T_ARR.ArrayNum
----------------------------------------
---- Fetch Array Config details..
----------------------------------------
---- create cursor
DECLARE arr_cursor CURSOR FOR
SELECT	T_ARR.ArrayNum, MAP.ControlHostId
FROM	@l_tblArrayNums T_ARR
			INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
				ON MAP.ArrayId = T_ARR.ArrayNum
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to declare cursor to get snap configs'
    GOTO ERR_EXIT
END
---- Open cursor...
SET @l_openArrCurFlag = 1
OPEN arr_cursor
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to open cursor to get array configs'
    GOTO ERR_EXIT
END
---- Read first entry...
FETCH NEXT FROM arr_cursor INTO @l_curArrayNum, @l_curControlHostId
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to read cursor to get array configs'
    GOTO ERR_EXIT
END
---- Fetch configs
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @l_arrConfigReq		NVARCHAR(MAX) = N'<EVGui_MMSMGetArrayDetailsReq assocType="3" flags="1" copyId="0" appId="0"><array id="' + CONVERT(NVARCHAR(256), @l_curControlHostId) + '"/></EVGui_MMSMGetArrayDetailsReq>'
	DECLARE @l_tblArrConfigs	TABLE (id1 INT, id2 INT, id3 INT, id4 INT, id5 INT, id6 INT, configStr NVARCHAR(MAX), id8 INT, id9 INT)
	DECLARE @l_tblCredentials	TABLE (UserName NVARCHAR(MAX), Password NVARCHAR(MAX), CredInfo XML, Flags INT, RecordType INT)
	DECLARE @l_curCredAssocId	INT = -1
	INSERT	INTO @l_tblArrConfigs
	EXEC	dbo.MM_SMXMLGetArrayDetails @l_arrConfigReq, 1
	SET @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
	BEGIN
		SET @l_errorMsg = 'Failed to get array configs using ControlHost-' + CONVERT(VARCHAR(256), @l_curControlHostId)
		GOTO ERR_EXIT
	END
	---- Update array table with configs..
	UPDATE	T_ARR
	SET		T_ARR.ArrayConfigs = T_AC.configStr
	FROM	@l_tblArrayNums T_ARR, @l_tblArrConfigs T_AC
	WHERE	T_ARR.ArrayNum = @l_curArrayNum
	---- Get the App credential association.
	SET @l_curCredAssocId = ISNULL((SELECT CredentialId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_curControlHostId), -1)
	---- Fetch the credentials if association exists..
	IF ( @l_curCredAssocId > 0 )
	BEGIN
		INSERT	INTO @l_tblCredentials
		EXEC	dbo.AppGetAssocToCMCredentials @l_curCredAssocId, 0
		SET @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
		BEGIN
			SET @l_errorMsg = 'Failed to get array-[' + CONVERT(VARCHAR(512), @l_curControlHostId) + '] credentials using association id-[' + CONVERT(VARCHAR(512), @l_curCredAssocId) + ']'
			GOTO ERR_EXIT
		END
		---- Update the table with the creds..
		UPDATE	T_ARR
		SET		T_ARR.UserName = T_CRED.UserName,
				T_ARR.Password = T_CRED.Password
		FROM	@l_tblArrayNums T_ARR, @l_tblCredentials T_CRED
		WHERE	T_ARR.ArrayNum = @l_curArrayNum
	END
	---- Read next entry..
	FETCH NEXT FROM arr_cursor INTO @l_curArrayNum, @l_curControlHostId
	SET @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
	BEGIN
		SET @l_errorMsg = 'Failed to read cursor to get array configs'
		GOTO ERR_EXIT
	END
END
---- Close the cursor..
CLOSE arr_cursor
DEALLOCATE arr_cursor
SET @l_openArrCurFlag = 0
----------------------------------------
---- Get Client info..
----------------------------------------
SET @l_clientId = (SELECT TOP 1 clientId FROM APP_Application WITH (READUNCOMMITTED) WHERE id = @l_subclientId)
IF (@l_clientId = 0)
BEGIN
	SET @l_errorMsg = 'Client not found in DB for subclient-' + CONVERT(VARCHAR(256), @l_subclientId)
    SET @l_errorCode = -1
    GOTO ERR_EXIT
END
----------------------------------------
---- Format the output...
----------------------------------------
SET @o_outXML = (
					SELECT
							(
								SELECT	TOP 1
										CLNT.id				AS 'client/@clientId',
										CLNT.net_hostname	AS 'client/@clientName'
								FROM	APP_Client CLNT WITH (READUNCOMMITTED)
								WHERE	Id = @l_clientId
								FOR XML PATH ('sprovParam'), TYPE
							),
							(
								SELECT	EPNT.Id				AS '@endPointId',
										EPNT.AddressType	AS '@addressType',
										EPNT.Address		AS '@address',
										EPNT.IsActive		AS '@isActive'
								FROM	SMEndPoint EPNT WITH (READUNCOMMITTED)
											INNER JOIN (	SELECT	DISTINCT M.EndPointID
															FROM	@l_tblLUNDetails T
																		INNER JOIN SProvMountLUN M WITH (READUNCOMMITTED)
																			ON M.LUNId = T.LUNId
														) TMP
												ON EPNT.Id = TMP.EndPointId
								FOR XML PATH ('endPointList'), TYPE
							),
							(
								SELECT	VEN.Id					AS '@vendorId',
										VEN.Name				AS '@vendorName',
										VEN.Name				AS '@familyName',
										VEN.ShowInGUI			AS '@showInGUI',
										VEN.IsEnabled			AS '@enabled',
										0						AS '@flags',
										0						AS '@status',
										0						AS '@errorCode',
										''						AS '@errorString',
										T_IDSLIBS.LibraryName	AS '@libraryName',
										(
											SELECT	ARR.Id				AS '@arrayNum',
													HOST.SMArrayId		AS '@arrayName',
													HOST.SMHostName		AS '@controlHost',
													ISNULL(T_ARR.UserName, HOST.SMHostUserName)		AS '@userName',
													ISNULL(T_ARR.Password, HOST.SMHostPassword)		AS '@password',
													0					AS '@phyArrayNum',
													0					AS '@useTunneling',
													''					AS '@vServerName',
													1					AS '@enabled',
													0					AS '@status',
													0					AS '@errorCode',
													''					AS '@errorString',
													HOST.ClientId		AS 'client/@clientId',
													T_ARR.ArrayConfigs	AS 'reserve/@reserveString2',
													(
														SELECT	S_POOL.StoragePoolId	AS '@storagePoolId',
																POOL.Name				AS '@storagePoolName',
																S_POOL.ArrayNum			AS '@arrayNum',
																POOL.UsedSpaceMB		AS '@usedSpace',
																POOL.TotalSpaceMB		AS '@totalSpace',
																S_POOL.Enabled			AS '@enabled',
																S_POOL.Flags			AS '@flags',
																0						AS '@status',
																0						AS '@errorCode',
																''						AS '@errorString',
																(
																	SELECT	S_VOL.VolumeId					AS '@volumeId',
																			VOL.Name						AS '@volumeName',
																			S_POOL.StoragePoolId			AS '@storagePoolId',
																			S_VOL.ArrayNum					AS '@arrayNum',
																			VOL.UsedSpaceMB * 1024 * 1024	AS '@usedSpace',
																			VOL.TotalSpaceMB * 1024 * 1024	AS '@totalSpace',
																			S_VOL.Enabled					AS '@enabled',
																			S_VOL.Flags						AS '@flags',
																			VOL.Path						AS '@volumePath',
																			0								AS '@status',
																			0								AS '@errorCode',
																			''								AS '@errorString'
																	FROM	SProvArrayVolume S_VOL WITH (READUNCOMMITTED)
																				INNER JOIN @l_tblVolIds T_VOL
																					ON S_VOL.VolumeId = T_VOL.VolumeId
																				INNER JOIN SMArrayVolume VOL WITH (READUNCOMMITTED)
																					ON S_VOL.VolumeId = VOL.Id
																						AND S_VOL.ArrayNum = ARR.Id
																	FOR XML PATH ('volumeList'), TYPE
																)
														FROM	SProvStoragePool S_POOL WITH (READUNCOMMITTED)
																	INNER JOIN @l_tblPoolIds T_POOL
																		ON T_POOL.PoolId = S_POOL.StoragePoolId
																	INNER JOIN SMStoragePool POOL WITH (READUNCOMMITTED)
																		ON S_POOL.StoragePoolId = POOL.Id
																		AND S_POOL.ArrayNum = ARR.Id
														FOR XML PATH('poolList'), TYPE
													)
											FROM	@l_tblArrayNums T_ARR
														INNER JOIN SMArray ARR WITH (READUNCOMMITTED)
															ON T_ARR.ArrayNum = ARR.Id
														INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
															ON MAP.ArrayId = ARR.Id
														INNER JOIN SMControlHost HOST WITH (READUNCOMMITTED)
															ON HOST.ControlHostId = MAP.ControlHostId
											FOR XML PATH ('arrayList'), TYPE
										)
								FROM	SMVendor VEN WITH (READUNCOMMITTED)
											INNER JOIN @l_tblVendorIdsLibraryNames T_IDSLIBS
												ON T_IDSLIBS.VendorId = VEN.Id
								FOR XML PATH ('arrayFamilyList'), TYPE
							),
							(
								SELECT	P_LUN.LUNId				AS '@lunId',
										LUN.Name				AS '@lunName',
										P_LUN.VolumeId			AS '@volumeId',
										P_LUN.StoragePoolId		AS '@storagePoolId',
										P_LUN.ArrayNum			AS '@arrayNum',
										LUN.UsedSpaceBytes		AS '@usedSpace',
										LUN.TotalSpaceBytes		AS '@totalSpace',
										P_LUN.Criteria			AS '@criteria',
										P_LUN.ExpirationDate	AS '@expirationDate',
										P_LUN.Enabled			AS '@enabled',
										P_LUN.Flags				AS '@flags',
										P_LUN.OSType			AS '@osTypeId',
										P_LUN.Status			AS '@status',
										P_LUN.Description		AS '@description',
										LUN.Path				AS '@lunPath',
										0						AS '@errorCode',
										''						AS '@errorString',
										P_LUN.userId			AS 'user/@userId',
										CONVERT(NVARCHAR(MAX), LUN.Properties)			AS 'reserve/@reserveString',
										(
											SELECT	M_LUN.MountLunId				AS '@mountLunId',
													M_LUN.LunId						AS '@lunId',
													M_LUN.ProtocolId				AS '@protocolId',
													M_LUN.EndPointId				AS '@endPointId',
													CLNT2.simOperatingSystemId		AS '@mountHostOSTypeId',
													SIM.Name						AS '@mountHostOSType',
													M_LUN.UserId					AS 'user/@userId',
													M_LUN.MountHostId				AS 'mountHost/@clientId',
													CLNT2.net_hostname				AS 'mountHost/@clientName'
											FROM	SProvMountLUN M_LUN WITH (READUNCOMMITTED)
														INNER JOIN APP_CLIENT CLNT2 WITH (READUNCOMMITTED)
															ON CLNT2.id = M_LUN.MountHostId
														INNER JOIN simOperatingSystem SIM WITH (READUNCOMMITTED)
															ON CLNT2.simOperatingSystemId = SIM.id
											WHERE	M_LUN.LUNId = TMP.LUNId
														AND M_LUN.MountLunId IN (SELECT MountLunId FROM @l_tblMountLUNDetails)
											FOR XML PATH('mountList'), TYPE
										)
								FROM	@l_tblLUNDetails TMP
											INNER JOIN SProvLUN P_LUN WITH (READUNCOMMITTED)
												ON TMP.LUNId = P_LUN.LUNId
											INNER JOIN SMLUN LUN WITH (READUNCOMMITTED)
												ON P_LUN.LUNId = LUN.Id
								FOR XML PATH ('lunList'), TYPE
							)
					FOR XML PATH ('StorageProvisioning_MMSProvInfo')
				)
SELECT @o_outXML
RETURN
ERR_EXIT:
---- Close the cursor..
IF @l_openArrCurFlag = 1
BEGIN
    CLOSE arr_cursor
    DEALLOCATE arr_cursor
END
SET @o_outXML = (	SELECT	@l_errorCode	AS '@errorCode',
							@l_errorMsg		AS '@errorString'
				FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_GetHedvigSProvInfo')
	delete from GxQscripts where name = 'SProv_GetHedvigSProvInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetHedvigSProvInfo')
	delete from GXDBVersions where aliasname = 'SProv_GetHedvigSProvInfo'
GO

insert into GXDBVersions values(2, 'SProv_GetHedvigSProvInfo',  '00010001000400030000', 'SProv_GetHedvigSProvInfo', '00010001000400030000')
GO

