

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_GetDisksToDelete.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SProv_GetDisksToDelete.sp,v $ $Id: SProv_GetDisksToDelete.sp,v 1.1.2.1.4.1 2021/01/25 21:15:25 macharya Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "SProv_GetDisksToDelete"
--	|
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SProv_GetDisksToDelete')
BEGIN
	print '>>> Drop Stored Procedure: SProv_GetDisksToDelete <<<'
	drop procedure SProv_GetDisksToDelete
END
IF EXISTS (select * from GxQscripts where name='SProv_GetDisksToDelete')
	delete from GxQscripts where name = 'SProv_GetDisksToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetDisksToDelete')
	delete from GXDBVersions where aliasname = 'SProv_GetDisksToDelete'
GO
print '... Creating Procedure: SProv_GetDisksToDelete'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SProv_GetDisksToDelete
  @i_xmlText XML
AS
  DECLARE @o_ArrayNum INT
  DECLARE @o_AppId INT
  DECLARE @o_outXML XML
SET NOCOUNT ON
-- #################### Local Variables #################### --
DECLARE @l_errorCode			INT				= 0
DECLARE @l_errorMsg				VARCHAR(256)	= ''
DECLARE @l_openArrCurFlag		INT				= 0
DECLARE @l_curArrayNum			INT				= 0
DECLARE @l_curControlHostId		INT				= 0
DECLARE @l_currTime				INT				= dbo.getUnixTime(GETUTCDATE())
DECLARE @l_cleanupWaitTime		INT				= 0
-- #################### Local Tables #################### --
DECLARE @l_tblLUNDetails			TABLE (LUNId INT, UserId INT, AppId INT)
DECLARE @l_tblVolIds				TABLE (VolumeId INT, AppId INT)
DECLARE @l_tblPoolIds				TABLE (PoolId INT, AppId INT)
DECLARE @l_tblArrayNums				TABLE (ArrayNum INT, ArrayConfigs NVARCHAR(MAX), UserName NVARCHAR(MAX), Password NVARCHAR(MAX))
DECLARE @l_tblVendorIdsLibraryNames TABLE (VendorId INT, LibraryName VARCHAR(128))
DECLARE @l_tblArraySubclientMap		TABLE (ArrayNum INT, AppId INT, ClientId INT)
DECLARE @l_tblArrConfigs			TABLE (id1 INT, id2 INT, id3 INT, id4 INT, id5 INT, id6 INT, configStr NVARCHAR(MAX), id8 INT, id9 INT)
DECLARE @l_tblCredentials			TABLE (UserName NVARCHAR(MAX), Password NVARCHAR(MAX), CredInfo XML, Flags INT, RecordType INT)
-- #################### Input Gathering #################### --
----------------------------------------
---- Cleanup days..
----------------------------------------
SET @l_cleanupWaitTime = ISNULL((select Value from MMConfigs WITH (READUNCOMMITTED) where name = 'MMS2_SPROV_LUN_CLEANUP_WAIT_TIME_DAYS'), 60) * 24 * 60 * 60
----------------------------------------
---- LUNs with deleted subclient..
----------------------------------------
INSERT	INTO @l_tblLUNDetails (LunId, UserId, AppId)
SELECT	LUN.Id, P_LUN.UserId, LUN.ReserveField4
FROM	SMLUN LUN WITH (READUNCOMMITTED)
			INNER JOIN SProvLUN P_LUN WITH (READUNCOMMITTED)
				ON LUN.Id = P_LUN.LUNId
WHERE	( LUN.ReserveField4 > 0 )				---- Hedvig provisionined Disks as of now..
		AND
( P_LUN.Status >= 79 OR P_LUN.Status <= 39 )	---- Not mapped disks..
		AND
		(  ( @l_currTime - dbo.getUnixTime(LUN.CreationTime) ) >  @l_cleanupWaitTime )				---- 60 days of wait interval..
		AND
		(
			LUN.ReserveField4 NOT IN ( SELECT Id FROM APP_Application WITH (READUNCOMMITTED) )														---- Subclient Deleted & cleaned in db
			OR
LUN.ReserveField4 IN ( SELECT Id FROM APP_Application WITH (READUNCOMMITTED) WHERE (subclientstatus & 0x00004) > 0 )		---- Subclient marked for deletion..
		)
----------------------------------------
---- Get Volume info..
----------------------------------------
INSERT	INTO @l_tblVolIds (VolumeId, AppId)
SELECT	DISTINCT VolumeId, TMP.AppId
FROM	@l_tblLUNDetails TMP
			INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
				ON TMP.LUNId = LUN.LUNId
----------------------------------------
---- Get Pool info..
----------------------------------------
INSERT	INTO @l_tblPoolIds (PoolId, AppId)
SELECT	DISTINCT StoragePoolId, TMP.AppId
FROM	@l_tblLUNDetails TMP
			INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
				ON TMP.LUNId = LUN.LUNId
----------------------------------------
---- Get Array info..
----------------------------------------
INSERT	INTO @l_tblArrayNums (ArrayNum)
SELECT	DISTINCT ArrayNum
FROM	@l_tblLUNDetails TMP
			INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
				ON TMP.LUNId = LUN.LUNId
----------------------------------------
---- Get Vendor info..
----------------------------------------
INSERT	INTO @l_tblVendorIdsLibraryNames (VendorId, LibraryName)
SELECT	DISTINCT Ven.Id, ENG.SnapEngineDLL
FROM	SMSnapShotEngine ENG
			INNER JOIN SMVendor VEN WITH (READUNCOMMITTED)
				ON ENG.SnapVendorName = VEN.Name
			INNER JOIN SMControlHost HOST WITH (READUNCOMMITTED)
				ON VEN.Name = HOST.SnapVendorName
			INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
				ON MAP.ControlHostId = HOST.ControlHostId
			INNER JOIN @l_tblArrayNums T_ARR
				ON MAP.ArrayId = T_ARR.ArrayNum
----------------------------------------
---- Fetch Array Config details..
----------------------------------------
---- create cursor
DECLARE arr_cursor CURSOR FOR
SELECT	T_ARR.ArrayNum, MAP.ControlHostId
FROM	@l_tblArrayNums T_ARR
			INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
				ON MAP.ArrayId = T_ARR.ArrayNum
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to declare cursor to get snap configs'
    GOTO ERR_EXIT
END
---- Open cursor...
SET @l_openArrCurFlag = 1
OPEN arr_cursor
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to open cursor to get array configs'
    GOTO ERR_EXIT
END
---- Read first entry...
FETCH NEXT FROM arr_cursor INTO @l_curArrayNum, @l_curControlHostId
SET @l_errorCode = @@ERROR
IF @l_errorCode <> 0
BEGIN
    SET @l_errorMsg = 'Failed to read cursor to get array configs'
    GOTO ERR_EXIT
END
---- Fetch configs
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @l_arrConfigReq		NVARCHAR(MAX) = N'<EVGui_MMSMGetArrayDetailsReq assocType="3" flags="1" copyId="0" appId="0"><array id="' + CONVERT(NVARCHAR(256), @l_curControlHostId) + '"/></EVGui_MMSMGetArrayDetailsReq>'
	DECLARE @l_curCredAssocId	INT = -1
	---- Clear the local tables..
	DELETE FROM @l_tblArrConfigs
	DELETE FROM @l_tblCredentials
	---- Run the SP to fetrch array configs..
	INSERT	INTO @l_tblArrConfigs
	EXEC	dbo.MM_SMXMLGetArrayDetails @l_arrConfigReq, 1
	SET @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
	BEGIN
		SET @l_errorMsg = 'Failed to get array configs using ControlHost-' + CONVERT(VARCHAR(256), @l_curControlHostId)
		GOTO ERR_EXIT
	END
	---- Update array table with configs..
	UPDATE	T_ARR
	SET		T_ARR.ArrayConfigs = T_AC.configStr
	FROM	@l_tblArrayNums T_ARR, @l_tblArrConfigs T_AC
	WHERE	T_ARR.ArrayNum = @l_curArrayNum
	---- Get the App credential association.
	SET @l_curCredAssocId = ISNULL((SELECT CredentialId FROM SMControlHost WITH (READUNCOMMITTED) WHERE ControlHostId = @l_curControlHostId), -1)
	---- Fetch the credentials if association exists..
	IF ( @l_curCredAssocId > 0 )
	BEGIN
		INSERT	INTO @l_tblCredentials
		EXEC	dbo.AppGetAssocToCMCredentials @l_curCredAssocId, 0
		SET @l_errorCode = @@ERROR
		IF @l_errorCode <> 0
		BEGIN
			SET @l_errorMsg = 'Failed to get array-[' + CONVERT(VARCHAR(512), @l_curControlHostId) + '] credentials using association id-[' + CONVERT(VARCHAR(512), @l_curCredAssocId) + ']'
			GOTO ERR_EXIT
		END
		---- Update the table with the creds..
		UPDATE	T_ARR
		SET		T_ARR.UserName = T_CRED.UserName,
				T_ARR.Password = T_CRED.Password
		FROM	@l_tblArrayNums T_ARR, @l_tblCredentials T_CRED
		WHERE	T_ARR.ArrayNum = @l_curArrayNum
	END
	---- Read next entry..
	FETCH NEXT FROM arr_cursor INTO @l_curArrayNum, @l_curControlHostId
	SET @l_errorCode = @@ERROR
	IF @l_errorCode <> 0
	BEGIN
		SET @l_errorMsg = 'Failed to read cursor to get array configs'
		GOTO ERR_EXIT
	END
END
---- Close the cursor..
CLOSE arr_cursor
DEALLOCATE arr_cursor
SET @l_openArrCurFlag = 0
----------------------------------------
---- Get Array, Subclient, Client details..
----------------------------------------
INSERT	INTO @l_tblArraySubclientMap (ArrayNum, AppId, ClientId)
SELECT	DISTINCT LUN.ArrayNum, TMP.AppId, 0
FROM	@l_tblLUNDetails TMP
			INNER JOIN SProvLUN LUN WITH (READUNCOMMITTED)
				ON TMP.LUNId = LUN.LUNId
---- Update client for existing subclients..
UPDATE	TMP
SET		ClientId = APP.clientId
FROM	@l_tblArraySubclientMap TMP
			INNER JOIN APP_Application APP WITH (READUNCOMMITTED)
				ON TMP.AppId = APP.id
---- Set Array accessNodes for remaining ones..
UPDATE	TMP
SET		ClientId = MA.ClientId
FROM	@l_tblArraySubclientMap TMP
			INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
				ON MAP.ArrayId = TMP.ArrayNum
			INNER JOIN SMArrayController CTRL WITH (READUNCOMMITTED)
				ON CTRL.ArrayNum = MAP.ControlHostId
			INNER JOIN MMHost MA WITH (READUNCOMMITTED)
				ON MA.ClientId = CTRL.MMHostId
WHERE	TMP.ClientId = 0
			AND MA.MmHostSoftState = 1
			AND MA.MmHostEnabled = 1
			AND	MA.OfflineReason = 0
---- For any remaining, set any MA by default.
UPDATE	TMP
SET		ClientId = MA.ClientId
FROM	@l_tblArraySubclientMap TMP, MMHost MA WITH (READUNCOMMITTED)
WHERE	TMP.ClientId = 0
			AND MA.MmHostSoftState = 1
			AND MA.MmHostEnabled = 1
			AND	MA.OfflineReason = 0
----------------------------------------
---- Format the output...
----------------------------------------
(
	SELECT	A.ArrayNum,
			A.AppId,
	(
		SELECT
				(	SELECT	TOP 1	CLNT.id				AS 'client/@clientId',
									CLNT.net_hostname	AS 'client/@clientName'
					FROM	APP_Client CLNT WITH (READUNCOMMITTED)
					WHERE	CLNT.Id = A.ClientId
					FOR XML PATH ('sprovParam'), TYPE
				),
				(	SELECT	EPNT.Id				AS '@endPointId',
							EPNT.AddressType	AS '@addressType',
							EPNT.Address		AS '@address',
							EPNT.IsActive		AS '@isActive'
					FROM	SMEndPoint EPNT WITH (READUNCOMMITTED)
								INNER JOIN (	SELECT	DISTINCT M.EndPointID
												FROM	@l_tblLUNDetails T
															INNER JOIN SProvMountLUN M WITH (READUNCOMMITTED)
																ON M.LUNId = T.LUNId
												WHERE	T.AppId = A.AppId
											) TMP
									ON EPNT.Id = TMP.EndPointId
					FOR XML PATH ('endPointList'), TYPE
				),
				(	SELECT	VEN.Id					AS '@vendorId',
							VEN.Name				AS '@vendorName',
							VEN.Name				AS '@familyName',
							VEN.ShowInGUI			AS '@showInGUI',
							VEN.IsEnabled			AS '@enabled',
							0						AS '@flags',
							0						AS '@status',
							0						AS '@errorCode',
							''						AS '@errorString',
							T_IDSLIBS.LibraryName	AS '@libraryName',
							(	SELECT	ARR.Id				AS '@arrayNum',
										0					AS '@phyArrayNum',
										0					AS '@useTunneling',
										''					AS '@vServerName',
										HOST.SMArrayId		AS '@arrayName',
										HOST.SMHostName		AS '@controlHost',
										ISNULL(T_ARR.UserName, HOST.SMHostUserName)		AS '@userName',
										ISNULL(T_ARR.Password, HOST.SMHostPassword)		AS '@password',
										1					AS '@enabled',
										0					AS '@status',
										0					AS '@errorCode',
										''					AS '@errorString',
										HOST.ClientId		AS 'client/@clientId',
										T_ARR.ArrayConfigs	AS 'reserve/@reserveString2',
										(	SELECT	S_POOL.StoragePoolId	AS '@storagePoolId',
													POOL.Name				AS '@storagePoolName',
													S_POOL.ArrayNum			AS '@arrayNum',
													POOL.UsedSpaceMB		AS '@usedSpace',
													POOL.TotalSpaceMB		AS '@totalSpace',
													S_POOL.Enabled			AS '@enabled',
													S_POOL.Flags			AS '@flags',
													0						AS '@status',
													0						AS '@errorCode',
													''						AS '@errorString',
													(	SELECT	S_VOL.VolumeId					AS '@volumeId',
																VOL.Name						AS '@volumeName',
																S_POOL.StoragePoolId			AS '@storagePoolId',
																S_VOL.ArrayNum					AS '@arrayNum',
																VOL.UsedSpaceMB * 1024 * 1024	AS '@usedSpace',
																VOL.TotalSpaceMB * 1024 * 1024	AS '@totalSpace',
																S_VOL.Enabled					AS '@enabled',
																S_VOL.Flags						AS '@flags',
																0								AS '@status',
																0								AS '@errorCode',
																''								AS '@errorString'
														FROM	SProvArrayVolume S_VOL WITH (READUNCOMMITTED)
																	INNER JOIN @l_tblVolIds T_VOL
																		ON S_VOL.VolumeId = T_VOL.VolumeId
																	INNER JOIN SMArrayVolume VOL WITH (READUNCOMMITTED)
																		ON S_VOL.VolumeId = VOL.Id
																	AND S_VOL.ArrayNum = ARR.Id
														WHERE	T_VOL.AppId = A.AppId
														FOR XML PATH ('volumeList'), TYPE
													)
											FROM	SProvStoragePool S_POOL WITH (READUNCOMMITTED)
														INNER JOIN @l_tblPoolIds T_POOL
															ON T_POOL.PoolId = S_POOL.StoragePoolId
														INNER JOIN SMStoragePool POOL WITH (READUNCOMMITTED)
															ON S_POOL.StoragePoolId = POOL.Id
																AND S_POOL.ArrayNum = ARR.Id
											WHERE	T_POOL.AppId = A.AppId
											FOR XML PATH('poolList'), TYPE
										)
								FROM	@l_tblArrayNums T_ARR
											INNER JOIN SMArray ARR WITH (READUNCOMMITTED)
												ON T_ARR.ArrayNum = ARR.Id
											INNER JOIN SMArrayCtrlHostMap MAP WITH (READUNCOMMITTED)
												ON MAP.ArrayId = ARR.Id
											INNER JOIN SMControlHost HOST WITH (READUNCOMMITTED)
												ON HOST.ControlHostId = MAP.ControlHostId
								WHERE	T_ARR.ArrayNum = A.ArrayNum
								FOR XML PATH ('arrayList'), TYPE
							)
					FROM	SMVendor VEN WITH (READUNCOMMITTED)
								INNER JOIN @l_tblVendorIdsLibraryNames T_IDSLIBS
									ON T_IDSLIBS.VendorId = VEN.Id
					FOR XML PATH ('arrayFamilyList'), TYPE
				),
				(	SELECT	P_LUN.LUNId				AS '@lunId',
							LUN.Name				AS '@lunName',
							P_LUN.VolumeId			AS '@volumeId',
							P_LUN.StoragePoolId		AS '@storagePoolId',
							P_LUN.ArrayNum			AS '@arrayNum',
							LUN.UsedSpaceBytes		AS '@usedSpace',
							LUN.TotalSpaceBytes		AS '@totalSpace',
							P_LUN.Criteria			AS '@criteria',
							P_LUN.ExpirationDate	AS '@expirationDate',
							P_LUN.Enabled			AS '@enabled',
							P_LUN.Flags				AS '@flags',
							P_LUN.OSType			AS '@osTypeId',
							P_LUN.Status			AS '@status',
							LUN.Path				AS '@lunPath',
							0						AS '@errorCode',
							''						AS '@errorString',
							P_LUN.userId			AS 'user/@userId',
							CONVERT(NVARCHAR(MAX), LUN.Properties)			AS 'reserve/@reserveString',
							(	SELECT	M_LUN.MountLunId            AS '@mountLunId',
										M_LUN.LunId					AS '@lunId',
										M_LUN.ProtocolId			AS '@protocolId',
										CLNT2.simOperatingSystemId	AS '@mountHostOSTypeId',
										SIM.Type					AS '@mountHostOSType',
										M_LUN.MountHostId			AS 'mountHost/@clientId',
										CLNT2.net_hostname			AS 'mountHost/@clientName',
										(	SELECT	SM_EP.Id			AS '@endPointId',
													SM_EP.AddressType	AS '@addressType',
													SM_EP.Address		AS '@address',
													SM_EP.ClientId		AS 'client/@clientId'
											 FROM	SMEndPoint SM_EP WITH (READUNCOMMITTED)
														INNER JOIN SProvEndPoint SP_EP WITH (READUNCOMMITTED)
															ON SP_EP.EndPointId = SM_EP.Id
											 WHERE	SM_EP.Id = M_LUN.EndPointId
											 FOR XML PATH('endPointList'), TYPE
										),
										(	SELECT	UM_USR.id		AS '@userId',
													UM_USR.login	AS '@userName'
											FROM	UMUsers UM_USR WITH (READUNCOMMITTED)
														INNER JOIN SProvHost SP_HST WITH (READUNCOMMITTED)
															ON SP_HST.UserId = UM_USR.id
											 WHERE	SP_HST.ClientId = M_LUN.MountHostId
											 FOR XML PATH('regUsersList'), TYPE
										)
								FROM	SProvMountLUN M_LUN WITH (READUNCOMMITTED)
											INNER JOIN APP_CLIENT CLNT2 WITH (READUNCOMMITTED)
												ON CLNT2.id = M_LUN.MountHostId
											INNER JOIN simOperatingSystem SIM WITH (READUNCOMMITTED)
												ON CLNT2.simOperatingSystemId = SIM.id
								WHERE	M_LUN.LUNId = TMP.LUNId
								FOR XML PATH('mountList'), TYPE
							)
					FROM	@l_tblLUNDetails TMP
								INNER JOIN SProvLUN P_LUN WITH (READUNCOMMITTED)
									ON TMP.LUNId = P_LUN.LUNId
								INNER JOIN SMLUN LUN WITH (READUNCOMMITTED)
									ON P_LUN.LUNId = LUN.Id
								INNER JOIN @l_tblArrayNums B
									ON P_LUN.ArrayNum = B.ArrayNum
					WHERE	A.ArrayNum = B.ArrayNum
							AND A.AppId = TMP.AppId
					FOR XML PATH ('lunList'), TYPE
				)
		FOR XML PATH ('StorageProvisioning_MMSProvInfo'), TYPE
	) AS rowXML
	FROM	@l_tblArraySubclientMap A
)
RETURN
ERR_EXIT:
---- Close the cursor..
IF @l_openArrCurFlag = 1
BEGIN
    CLOSE arr_cursor
    DEALLOCATE arr_cursor
END
SET @o_outXML = (	SELECT	@l_errorCode	AS '@errorCode',
							@l_errorMsg		AS '@errorString'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo')
				)
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_GetDisksToDelete')
	delete from GxQscripts where name = 'SProv_GetDisksToDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_GetDisksToDelete')
	delete from GXDBVersions where aliasname = 'SProv_GetDisksToDelete'
GO

insert into GXDBVersions values(2, 'SProv_GetDisksToDelete',  'v1.1.2.1.4.1', 'SProv_GetDisksToDelete', 'v1.1.2.1.4.1')
GO

