

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SProv_CleanupOperation.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: SProv_CleanupOperation()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SProv_CleanupOperation <<<'

IF EXISTS (select * from sysobjects where name='SProv_CleanupOperation')
	drop procedure SProv_CleanupOperation
IF EXISTS (select * from GxQscripts where name='SProv_CleanupOperation')
	delete from GxQscripts where name = 'SProv_CleanupOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_CleanupOperation')
	delete from GXDBVersions where aliasname = 'SProv_CleanupOperation'
GO
print '... Creating Procedure: SProv_CleanupOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SProv_CleanupOperation
  @xmlText XML,
  @reserveInt INT, 
  @reserveStr VARCHAR(256)
AS
  DECLARE @o_outXML XML
SET NOCOUNT ON
DECLARE @lunId INT					= 0
DECLARE @lunSize INT				= 0
DECLARE @clientId INT				= 0
DECLARE @arrayNum INT				= 0
DECLARE @storagePoolId INT			= 0
DECLARE @errorCode INT				= 0
DECLARE @errorMsg VARCHAR(1024)		= ''
DECLARE @operationType INT			= 0
SET @operationType = ISNULL((SELECT R.ref.value('@operation', 'INT')
							 FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/sprovParam') R(ref)), 0)
IF @operationType = 0
BEGIN
	SET @errorCode = -1
	SET @errorMsg = 'Invalid operation type'
	GOTO ERR_EXIT
END
IF ((@operationType = 1) OR (@operationType = 2))		--DELETE AND CREATE
BEGIN
	DECLARE @lunTbl TABLE(lunIds INT, totalSpace BIGINT, volumeId INT, storagePoolId INT, arrayId INT)
	INSERT INTO @lunTbl(lunIds, totalSpace, volumeId, storagePoolId, arrayId)
		SELECT R.ref.value('@lunId', 'INT'),
			   R.ref.value('@totalSpace', 'BIGINT'),
			   R.ref.value('@volumeId', 'BIGINT'),
			   R.ref.value('@storagePoolId', 'BIGINT'),
			   R.ref.value('@arrayNum', 'BIGINT')
		FROM @xmlText.nodes('/StorageProvisioning_MMSProvInfo/lunList') R(ref)
	--Should we update the volume size ?? In some cases the volume may be thin provisioned. In such cases we may have the totalspace of the volume
	--lesser than the usedspace. If we add the totallun size to the volume size we may be updating incorrect information.
	--Updating the storage pool and array space fields
	UPDATE SMStoragePool SET FreeSpaceMB = FreeSpaceMB + T_LUN.totalLunSpaceUnderPool/(1024 * 1024),
							 UsedSpaceMB = UsedSpaceMB - T_LUN.totalLunSpaceUnderPool/(1024 * 1024)
	FROM (SELECT storagePoolId AS SPoolId, SUM(totalSpace) AS totalLunSpaceUnderPool FROM @lunTbl GROUP BY storagePoolId) AS T_LUN
	WHERE T_LUN.SPoolId = SMStoragePool.Id
	UPDATE SMArray SET FreeSpaceMB = FreeSpaceMB + T_LUN.totalLunSpaceUnderPool/(1024 * 1024)
	FROM (SELECT arrayId AS arrayId, SUM(totalSpace) AS totalLunSpaceUnderPool FROM @lunTbl GROUP BY arrayId) AS T_LUN
	WHERE T_LUN.arrayId = SMArray.Id
END
SET @errorMsg = 'Updated the size information successfully'
SET @errorCode = 0
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorString'
				 FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
ERR_EXIT:
SET @o_outXML = (SELECT @errorCode AS '@errorCode',
						@errorMsg AS '@errorMsg'
					FOR XML PATH ('StorageProvisioning_MMSProvInfo'))
SELECT @o_outXML
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'SProv_CleanupOperation')
	delete from GxQscripts where name = 'SProv_CleanupOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SProv_CleanupOperation')
	delete from GXDBVersions where aliasname = 'SProv_CleanupOperation'
GO

insert into GXDBVersions values(2, 'SProv_CleanupOperation',  '00000000000000000000', 'SProv_CleanupOperation', '00000000000000000000')
GO

