

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMUpdateControlHostUniqueId.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "SMUpdateControlHostUniqueId"
--	|	This Procedure is used to update the UniqueIdentifier column in the SMControlHost table
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SMUpdateControlHostUniqueId')
BEGIN
	print '>>> Drop Stored Procedure: SMUpdateControlHostUniqueId <<<'
	drop procedure SMUpdateControlHostUniqueId
END
IF EXISTS (select * from GxQscripts where name='SMUpdateControlHostUniqueId')
	delete from GxQscripts where name = 'SMUpdateControlHostUniqueId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMUpdateControlHostUniqueId')
	delete from GXDBVersions where aliasname = 'SMUpdateControlHostUniqueId'
GO
print '... Creating Procedure: SMUpdateControlHostUniqueId'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SMUpdateControlHostUniqueId
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorStr NVARCHAR(1024)
SET NOCOUNT ON
SET XACT_ABORT ON
/*<SMUpdateControlHostUniqueId>
<ControlHostDetails>
	<Id>1</Id>
	<ControlHostId>102</ControlHostId>
	<UniqueIdentifier>af14fd50-8f6d-11e8-873e-00a0b8cbb2ea</UniqueIdentifier>
	<AliasList>
		<Alias Name = "OntapSelect4VS2" Type = "3" />
		<Alias Name = "172.24.31.90" Type = "3" />
		<Alias Name = "172.24.31.90" Type = "1" />
	</AliasList>
</ControlHostDetails>
</SMUpdateControlHostUniqueId>*/
 DECLARE @tblInput TABLE (Id INTEGER, ControlHostId INTEGER, UniqueId NVARCHAR(1024), ArrayName NVARCHAR(1024) DEFAULT N'')
 DECLARE @tblAlias TABLE (Id INTEGER, InterfaceType INTEGER, AliasName NVARCHAR(1024), RefId INTEGER,  ClientId INTEGER, ElementOrder INTEGER)
 SET @o_ErrorCode = 0
 SET @o_ErrorStr = ''
 INSERT	INTO @tblInput
 SELECT
		R.ref.value('Id[1]', 'integer') AS Id,
		R.ref.value('ControlHostId[1]', 'INTEGER') AS ControlHostId,
		R.ref.value('UniqueIdentifier[1]', 'NVARCHAR(1024)') AS UniqueId,
		N''
 FROM	@xmlText.nodes('/SMUpdateControlHostUniqueId/ControlHostDetails') R(ref)
 INSERT	INTO @tblAlias
 SELECT
		R.ref.value('../../Id[1]', 'integer') AS Id,
		R.ref.value('@Type', 'INTEGER') AS InterfaceType,
		R.ref.value('@Name', 'NVARCHAR(1024)') AS AliasName,
		0,
		0,
		DENSE_RANK() OVER (PARTITION BY R.ref.value('../../Id[1]', 'integer') ORDER BY R.ref.value('../../Id[1]', 'integer'), R.ref.value('@Name', 'NVARCHAR(1024)'))*10
 FROM	@xmlText.nodes('/SMUpdateControlHostUniqueId/ControlHostDetails/AliasList/Alias') R(ref)
 IF NOT EXISTS (SELECT 1 FROM SMControlHost WHERE ControlHostId IN (SELECT ControlHostId FROM @tblInput))
 BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorStr = 'Cannot find the controlhost ID'
	GOTO PROC_END
 END
 IF EXISTS (SELECT 1 FROM SMControlHost host INNER JOIN @tblInput tmp ON host.UniqueIdentifier = tmp.UniqueId WHERE host.ControlHostId <> tmp.ControlHostId)
 BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorStr = 'The uniqueIdentifier already exists for a different controlhost'
	GOTO PROC_END
 END
 BEGIN TRY
	BEGIN TRANSACTION UpdateArrayUUIDAndAlias
		DECLARE @MasterConfigId INTEGER
		DECLARE @MMSM_AT_ARRAY  INTEGER = 3
SELECT @MasterConfigId = Id FROM SMMasterConfigs where name = 'Array Host Aliases' /*SMCONFIG_NAME_ARRAY_HOST_ALIASES_NAME*/ AND VendorId = 3 /*3*/
		--Update the uniqueIdentifer in the SMControlHost table
		UPDATE	cHost
		SET		cHost.UniqueIdentifier = tmp.UniqueId
		FROM	SMControlHost cHost INNER JOIN @tblInput tmp ON cHost.ControlHostId = tmp.ControlHostId
		--Remove the controlhosts that does not have auto-update alias set.
		DELETE FROM @tblInput
		WHERE ControlHostId NOT IN (SELECT ArrayId FROM SMConfigs WHERE MasterConfigId = 131 AND ValueInt = 1)
		--For arrays that have auto-update alias set, update the SMHostAlias and SMEndpoint tables
		--The input aliasList has the most recent interfaces on the array - so refresh the SMHostAlias, SMEndPpint and SMConfigsList tables accordingly
		IF EXISTS (SELECT 1 FROM @tblInput)
		BEGIN
			--Remove the aliases from the SMHostAlias table
			DELETE	ALIAS
			FROM	SMHostAlias ALIAS
			INNER JOIN @tblInput I_INPUT ON I_INPUT.ControlHostId = ALIAS.RefId
			INNER JOIN @tblAlias I_ALIAS ON I_ALIAS.Id = I_INPUT.Id
			--Remove the corresponding entries from the SMCOnfigsList
			DELETE	CONFIGS
			FROM	SMConfigsList CONFIGS
			INNER JOIN @tblInput I_INPUT ON I_INPUT.ControlHostId = CONFIGS.ArrayId
			INNER JOIN @tblAlias I_ALIAS ON I_ALIAS.Id = I_INPUT.Id
			--Insert the newly fetched aliases from the array
			INSERT INTO SMHostAlias
SELECT 5 /*5*/,I_INPUT.ControlHostId, 0, 0, T1.AliasName, GETUTCDate(), 0, NEWID(), 0, 0, 0, 0, N''
			FROM @tblInput I_INPUT INNER JOIN (SELECT DISTINCT Id, AliasName FROM @tblAlias) T1 ON I_INPUT.Id = T1.Id
			--Update the input tables with more information rewuired to update the remaining tables - SMConfigsList and SMEndPoint
			UPDATE I_ALIAS
			SET RefId = ALIAS.Id, ClientId = CHOST.ClientId
			FROM @tblAlias I_ALIAS INNER JOIN @tblInput I_INPUT ON I_INPUT.Id = I_ALIAS.Id
			INNER JOIN SMHostAlias ALIAS ON I_INPUT.ControlHostId = ALIAS.RefId AND I_ALIAS.AliasName=ALIAS.AliasName
			INNER JOIN SMControlHost CHOST ON I_INPUT.ControlHostId = CHOST.ControlHostId
			--The arrayName cannot be one of the hosts in the SMConfigsList. Hence, getting the arrayName for each array
			UPDATE I_INPUT
			SET ArrayName = CHOST.SMArrayId
			FROM @tblInput I_INPUT INNER JOIN SMControlHost CHOST ON I_INPUT.ControlHostId = CHOST.ControlHostId
			INSERT INTO SMConfigsList
			SELECT @MasterConfigId, I_INPUT.ControlHostId, I_INPUT.ControlHostId, @MMSM_AT_ARRAY, T1.ElementOrder,1,1,0,0,0,T1.AliasName,dbo.GetUnixTime(GetUTCDate()),dbo.GetUnixTime(GetUTCDate()),2, newid(), 1, T1.RefId
			FROM @tblInput I_INPUT INNER JOIN (SELECT DISTINCT Id, AliasName, ElementOrder, RefId FROM @tblAlias) T1 ON I_INPUT.Id = T1.Id AND T1.AliasName <> I_INPUT.ArrayName
			--Refresh Endpoint tables
			DELETE	EPOINT
			FROM	SMEndPoint EPOINT
			INNER JOIN @tblAlias I_ALIAS ON I_ALIAS.ClientId = EPOINT.ClientId
			INNER JOIN @tblInput I_INPUT ON I_INPUT.Id = I_ALIAS.Id
			INSERT INTO SMEndPoint
			SELECT I_ALIAS.ClientId,0,0,0,0,0,0,I_ALIAS.InterfaceType,I_ALIAS.AliasName,GETUTCDATE(), GETUTCDATE(), 0, N'', 0, NEWID(), 0, 0, 0, 0, N''
			FROM @tblAlias I_ALIAS
		END
	COMMIT TRANSACTION UpdateArrayUUIDAndAlias
 END TRY
 BEGIN CATCH
	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    ROLLBACK TRANSACTION UpdateArrayUUIDAndAlias
	SET @o_ErrorCode = 1
	SET @o_ErrorStr ='ERROR: PROC(' + ERROR_PROCEDURE() +
					'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
					'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
					'), INFO: ' + ERROR_MESSAGE() + '.'
END CATCH
PROC_END:
SELECT @o_ErrorCode, @o_ErrorStr
GO

IF EXISTS (select * from GxQscripts where name = 'SMUpdateControlHostUniqueId')
	delete from GxQscripts where name = 'SMUpdateControlHostUniqueId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMUpdateControlHostUniqueId')
	delete from GXDBVersions where aliasname = 'SMUpdateControlHostUniqueId'
GO

insert into GXDBVersions values(2, 'SMUpdateControlHostUniqueId',  '00000000000000000000', 'SMUpdateControlHostUniqueId', '00000000000000000000')
GO

