

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMProcessDFMReportEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMProcessDFMReportEntries.sp,v $ $Id: SMProcessDFMReportEntries.sp,v 1.6.2.5 2018/03/20 00:13:35 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMProcessDFMReportEntries <<<'

IF EXISTS (select * from sysobjects where name='SMProcessDFMReportEntries')
	drop procedure SMProcessDFMReportEntries
IF EXISTS (select * from GxQscripts where name='SMProcessDFMReportEntries')
	delete from GxQscripts where name = 'SMProcessDFMReportEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMProcessDFMReportEntries')
	delete from GXDBVersions where aliasname = 'SMProcessDFMReportEntries'
GO
print '... Creating Procedure: SMProcessDFMReportEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMProcessDFMReportEntries
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
-- Do not use SM related tables in this SP as the lock is acquired only for DFM related tables.
/* Input XML Format
<SMDFMReportInfo>
	<StoragePolicyId>4</StoragePolicyId>
	<DFMHostName>172.19.109.100</DFMHostName>
	<ReserveField1>0</ReserveField1>
	<ReserveField2>0</ReserveField2>
	<ReserveFieldStr/>
	<SMDataSetDetailsInfo>
		<StoragePolicyId>4</StoragePolicyId>
		<DataSetId>143324</DataSetId>
		<DataSetName>CC-STORAGEPROVWEB_SS-1_SC-181413909170</DataSetName>
		<DataSetDescription/>
		<ConformanceStatus>conformant</ConformanceStatus>
		<StorageServiceId>143320</StorageServiceId>
		<StorageServiceName>CC-STORAGEPROVWEB_SP-4_Copy-6</StorageServiceName>
		<StorageServiceDescription/>
		<ProtectionPolicy>SnapProtect Back up, then mirror</ProtectionPolicy>
		<DataConformanceStatus>conformant</DataConformanceStatus>
		<ReserveField1>0</ReserveField1>
		<ReserveField2>0</ReserveField2>
		<ReserveFieldStr/>
		<SMDataSetNodeInfo>
			<Relation>Primary data</Relation>
			<FileServerName>hfiler3.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy/>
			<ResourcePool>SnapProtectDummyResourcePoolForPrimary</ResourcePool>
			<vFilerUnit/>
			<VolumeName>TestvolMay9</VolumeName>
			<NodeId>1</NodeId>
			<DataSetMemberId>4635</DataSetMemberId>
			<DataSetMemberName>hfiler3:/TestvolMay9/-</DataSetMemberName>
			<VolumeTotalSpace>83886080</VolumeTotalSpace>
			<VolumeUsedSpace>12369920</VolumeUsedSpace>
			<VolumeFreeSpace>71516160</VolumeFreeSpace>
			<LagTime>0</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
		<SMDataSetNodeInfo>
			<Relation>Backup</Relation>
			<FileServerName>mold.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy>SnapProtect_test</ProvisioningPolicy>
			<ResourcePool>mold_1</ResourcePool>
			<vFilerUnit/>
			<VolumeName>SP_TestvolMay9_3</VolumeName>
			<NodeId>2</NodeId>
			<DataSetMemberId>143327</DataSetMemberId>
			<DataSetMemberName>mold:/SP_TestvolMay9_3/-</DataSetMemberName>
			<VolumeTotalSpace>2926061477888</VolumeTotalSpace>
			<VolumeUsedSpace>12849152</VolumeUsedSpace>
			<VolumeFreeSpace>1243951960064</VolumeFreeSpace>
			<LagTime>492779</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
		<SMDataSetNodeInfo>
			<Relation>Mirror</Relation>
			<FileServerName>mold.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy>SnapProtect_test</ProvisioningPolicy>
			<ResourcePool>mold_2</ResourcePool>
			<vFilerUnit/>
			<VolumeName>SP_TestvolMay9_4</VolumeName>
			<NodeId>3</NodeId>
			<DataSetMemberId>143330</DataSetMemberId>
			<DataSetMemberName>mold:/SP_TestvolMay9_4/-</DataSetMemberName>
			<VolumeTotalSpace>2926061477888</VolumeTotalSpace>
			<VolumeUsedSpace>12849152</VolumeUsedSpace>
			<VolumeFreeSpace>776814968832</VolumeFreeSpace>
			<LagTime>359448</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
	</SMDataSetDetailsInfo>
	<SMDataSetDetailsInfo>
		<StoragePolicyId>4</StoragePolicyId>
		<DataSetId>146185</DataSetId>
		<DataSetName>CC-STORAGEPROVWEB_SS-1_SC-241414211072</DataSetName>
		<DataSetDescription/>
		<ConformanceStatus>conformant</ConformanceStatus>
		<StorageServiceId>143320</StorageServiceId>
		<StorageServiceName>CC-STORAGEPROVWEB_SP-4_Copy-6</StorageServiceName>
		<StorageServiceDescription/>
		<ProtectionPolicy>SnapProtect Back up, then mirror</ProtectionPolicy>
		<DataConformanceStatus>conformant</DataConformanceStatus>
		<ReserveField1>0</ReserveField1>
		<ReserveField2>0</ReserveField2>
		<ReserveFieldStr/>
		<SMDataSetNodeInfo>
			<Relation>Primary data</Relation>
			<FileServerName>hfiler1.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy/>
			<ResourcePool>SnapProtectDummyResourcePoolForPrimary</ResourcePool>
			<vFilerUnit/>
			<VolumeName>Vol_Chiru_13Aug</VolumeName>
			<NodeId>1</NodeId>
			<DataSetMemberId>1323</DataSetMemberId>
			<DataSetMemberName>hfiler1:/Vol_Chiru_13Aug/-</DataSetMemberName>
			<VolumeTotalSpace>167772160</VolumeTotalSpace>
			<VolumeUsedSpace>21876736</VolumeUsedSpace>
			<VolumeFreeSpace>145895424</VolumeFreeSpace>
			<LagTime>0</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
		<SMDataSetNodeInfo>
			<Relation>Backup</Relation>
			<FileServerName>mold.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy>SnapProtect_test</ProvisioningPolicy>
			<ResourcePool>mold_1</ResourcePool>
			<vFilerUnit/>
			<VolumeName>SP_Vol_Chiru_13Aug</VolumeName>
			<NodeId>2</NodeId>
			<DataSetMemberId>146188</DataSetMemberId>
			<DataSetMemberName>mold:/SP_Vol_Chiru_13Aug/-</DataSetMemberName>
			<VolumeTotalSpace>2926061477888</VolumeTotalSpace>
			<VolumeUsedSpace>22253568</VolumeUsedSpace>
			<VolumeFreeSpace>1243951960064</VolumeFreeSpace>
			<LagTime>190908</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
		<SMDataSetNodeInfo>
			<Relation>Mirror</Relation>
			<FileServerName>mold.testlab.commvault.com</FileServerName>
			<ProvisioningPolicy>SnapProtect_test</ProvisioningPolicy>
			<ResourcePool>mold_2</ResourcePool>
			<vFilerUnit/>
			<VolumeName>SP_Vol_Chiru_13Aug_1</VolumeName>
			<NodeId>3</NodeId>
			<DataSetMemberId>146191</DataSetMemberId>
			<DataSetMemberName>mold:/SP_Vol_Chiru_13Aug_1/-</DataSetMemberName>
			<VolumeTotalSpace>2926061477888</VolumeTotalSpace>
			<VolumeUsedSpace>22265856</VolumeUsedSpace>
			<VolumeFreeSpace>776814968832</VolumeFreeSpace>
			<LagTime>190921</LagTime>
			<ReserveField1>0</ReserveField1>
			<ReserveField2>0</ReserveField2>
			<ReserveFieldStr/>
		</SMDataSetNodeInfo>
	</SMDataSetDetailsInfo>
</SMDFMReportInfo>
*/
DECLARE @logMessage VARCHAR(MAX)
DECLARE @x_maId INTEGER = 0
DECLARE @x_jobId BIGINT
DECLARE @x_arrayId INTEGER = 0
DECLARE @refType INTEGER = 0
--RefType = SM_MRT_NONE = 0 :- None
--RefType = SM_MRT_ARRAY = 5 :- Control Host
--RefType = SM_MRT_STORAGE_ARRAY = 6 :- Array
SET @x_maId = ISNULL(@i_reserveParam, 0)
SET @x_jobId = ISNULL(( SELECT R.ref.value('.', 'BIGINT') FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/JobId') R(ref)), 0)
DECLARE @curTime DATETIME = GETUTCDATE()
DECLARE @dfmHostName NVARCHAR(1024) = '';
DECLARE @ControlHostId INTEGER = 0
DECLARE @SMProcessDFMReportEntries INT
SET @SMProcessDFMReportEntries = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION SMProcessDFMReportEntries
		SET @SMProcessDFMReportEntries = 1
	END
	SELECT @logMessage = 'XML Message for DFM Reporting'
	--INSERT INTO SMLogger(MediaAgentId, RefId, RefType, Message, XMLData)
	--	VALUES (0, 0, @refType, @logMessage, @i_xmlTextInput)
	SET @dfmHostName = ISNULL((SELECT R.ref.value('./DFMHostName[1]','NVARCHAR(1024)')
					FROM @i_xmlTextInput.nodes('/SMDFMReportInfo') R(ref)),'')
	--SELECT @dfmHostName
	SELECT @ControlHostId = ControlHostId
	FROM SMControlHost
	WHERE SMArrayId = @dfmHostName
	--SELECT @ControlHostId
	--Processing DFM DataSet Info data
	 --#####################################################################
	 -- Update and Insert data into SMDataSet, SMDataSetInfo tables
	 --#####################################################################
		DECLARE @dataSetInfoTbl TABLE (
			DataSetDbId					INTEGER NOT NULL,
			DataSetInfoDbId				INTEGER NOT NULL,
			DFMHostName					NVARCHAR(1024) NOT NULL,
			ControlHostId				INTEGER NOT NULL,
			ExtDataSetId				NVARCHAR(1024) NOT NULL,
			ExtDataSetName				NVARCHAR(510) NOT NULL,
			ArchGroupId					INTEGER NOT NULL,
			StorageServiceId			NVARCHAR(1024) NOT NULL,
			StorageServiceName			NVARCHAR(512) NOT NULL,
			DataSetDescription			NVARCHAR(510) NOT NULL,
			ProtectionPolicy			NVARCHAR(510) NOT NULL,
			ConformanceStatus			NVARCHAR(510) NOT NULL,
			Flags						INTEGER NOT NULL,
			CreationTime				DATETIME NOT NULL,
			UpdateTime					DATETIME NOT NULL,
			DeleteTime					DATETIME NOT NULL,
			Properties					XML NOT NULL,
			ReserveField1				INTEGER NOT NULL,
			ReserveField2				INTEGER NOT NULL,
			ReserveFieldStr				NVARCHAR(1024) NOT NULL
		)
		INSERT INTO @dataSetInfoTbl
				SELECT
				0,
				0,
				@dfmHostName,
				@ControlHostId,
				ISNULL(R.ref.value('./DataSetId[1]', 'NVARCHAR(1024)'), ''),
				ISNULL(R.ref.value('./DataSetName[1]', 'NVARCHAR(510)'), ''),
				R.ref.value('./StoragePolicyId[1]', 'int'),
				ISNULL(R.ref.value('./StorageServiceId[1]', 'NVARCHAR(1024)'), ''),
				ISNULL(R.ref.value('./StorageServiceName[1]', 'NVARCHAR(512)'), ''),
				ISNULL(R.ref.value('./DataSetDescription[1]', 'NVARCHAR(510)'), ''),
				ISNULL(R.ref.value('./ProtectionPolicy[1]', 'NVARCHAR(510)'), ''),
				ISNULL(R.ref.value('./ConformanceStatus[1]', 'NVARCHAR(510)'), ''),
				0, -- flags
				@curTime,
				@curTime,
				@curTime,
				@i_xmlTextInput,
				ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0),
				ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0),
				ISNULL(R.ref.value('./ReserveFieldStr[1]', 'NVARCHAR(1024)'), '')
			FROM @i_xmlTextInput.nodes('/SMDFMReportInfo/SMDataSetDetailsInfo') R(ref)
		UPDATE @dataSetInfoTbl
		SET DataSetDbId = a.DataSetId
		FROM SMDataSet AS a
			INNER JOIN @dataSetInfoTbl AS b
				ON  a.ExtDataSetId= b.ExtDataSetId
				AND a.ControlHostId = b.ControlHostId
		--select * from @dataSetInfoTbl
		UPDATE @dataSetInfoTbl
		SET DataSetInfoDbId = a.DataSetId
		FROM SMDataSetInfo AS a
			INNER JOIN @dataSetInfoTbl AS b
				ON  a.DataSetId= b.DataSetDbId
		UPDATE SMDataSetInfo
		SET
			DataSetDescription = b.DataSetDescription,
			ConformanceStatus = b.ConformanceStatus,
			LastModifiedTime = b.CreationTime,
			Properties = b.Properties
		FROM SMDataSetInfo AS a
			INNER JOIN @dataSetInfoTbl AS b
			ON b.DataSetInfoDbId > 0
			AND b.DataSetInfoDbId = a.DataSetId
		INSERT INTO SMDataSetInfo(
			DataSetId,
			DataSetDescription,
			ConformanceStatus,
			CreationTime,
			LastModifiedTime,
			--DeleteTime,
			Properties)
		SELECT
			DataSetDbId,
			DataSetDescription,
			ConformanceStatus,
			CreationTime,
			UpdateTime,
			--NULL,--by default NULL column
			Properties
		FROM
			@dataSetInfoTbl a
		WHERE
			a.DataSetInfoDbId = 0
			AND a.DataSetDbId > 0 --Only for valid datasets (datasets matched with existing entries)
 --#####################################################################
 -- Update and Insert data into SMRelation, SMRelationInfo tables
 --#####################################################################
		DECLARE @SMRelationsTbl TABLE (
			DFMHostName				NVARCHAR(1024) NOT NULL,
			ControlHostId			INTEGER NOT NULL,
			SMRelationDbId			INTEGER NOT NULL,
			SMRelationInfoDbId		INTEGER NOT NULL,
			SMRelationNodeDbId		INTEGER NOT NULL,
			SMRelationNodeInfoDbId	INTEGER NOT NULL,
			StorageServiceId		NVARCHAR(1024) NOT NULL,
			StorageServiceName		NVARCHAR(512) NOT NULL,
			ProtectionPolicy		NVARCHAR(510) NOT NULL,
			ExtNodeId				NVARCHAR(1024) NOT NULL,
			NodeRelation			NVARCHAR(510) NOT NULL,
			ProvisionPolicy			NVARCHAR(510) NOT NULL,
			ResourcePool			NVARCHAR(510) NOT NULL,
			ArrayName				NVARCHAR(255) NOT NULL,
			vFilerUnit				NVARCHAR(510) NOT NULL,
			CurrentTime				DATETIME NOT NULL
			)
		INSERT INTO @SMRelationsTbl
			SELECT
				@dfmHostName,
				@ControlHostId,
				0,
				0,
				0,
				0,
				DataSetInfo.value('./StorageServiceId[1]', 'NVARCHAR(255)'),
				DataSetInfo.value('./StorageServiceName[1]', 'NVARCHAR(255)'),
				DataSetInfo.value('./ProtectionPolicy[1]', 'NVARCHAR(255)'),
				ISNULL(DataSetNodeInfo.value('./NodeId[1]', 'NVARCHAR(1024)'),'1'),
				ISNULL(DataSetNodeInfo.value('./Relation[1]', 'NVARCHAR(255)'), ''),
				ISNULL(DataSetNodeInfo.value('./ProvisioningPolicy[1]', 'NVARCHAR(255)'), ''),
				ISNULL(DataSetNodeInfo.value('./ResourcePool[1]', 'NVARCHAR(255)'), ''),
				ISNULL(DataSetNodeInfo.value('./FileServerName[1]', 'NVARCHAR(255)'), ''),
				ISNULL(DataSetNodeInfo.value('./vFilerUnit[1]', 'NVARCHAR(255)'), ''),
				@curTime
			FROM @i_xmlTextInput.nodes('/SMDFMReportInfo/SMDataSetDetailsInfo') DataSetInfo(DataSetInfo)
			CROSS APPLY DataSetInfo.nodes('SMDataSetNodeInfo') DataSetNodeInfo(DataSetNodeInfo)
			--select * from @SMRelationsTbl
 		-- Update RelationId in @SMRelationTbl
		UPDATE @SMRelationsTbl
		SET SMRelationDbId = a.SMRelationId
		FROM SMRelation AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  a.ExtRelationId = b.StorageServiceId
				AND a.ExtRelationName = b.StorageServiceName
				AND a.ControlHostId = b.ControlHostId
		-- Update RelationInfoId in @SMRelationTbl
		UPDATE @SMRelationsTbl
		SET SMRelationInfoDbId = a.SMRelationId
		FROM SMRelationInfo AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  a.SMRelationId = b.SMRelationDbId
		-- Update SMRelationInfo for existing entries.
		UPDATE SMRelationInfo
		SET ProtectionPolicy = b.ProtectionPolicy,
			LastModifiedTime = @curTime,
			DeleteTime = NULL
		FROM SMRelationInfo AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  b.SMRelationInfoDbId > 0
				AND a.SMRelationId = b.SMRelationInfoDbId
		INSERT INTO SMRelationInfo(
			SMRelationId,
			ProtectionPolicy,
			CreationTime,
			LastModifiedTime,
			DeleteTime)
		SELECT DISTINCT
			a.SMRelationDbId,
			a.ProtectionPolicy,
			@curTime,
			@curTime,
			NULL
		FROM
			@SMRelationsTbl a
		WHERE
			a.SMRelationInfoDbId = 0
			AND a.SMRelationDbId > 0 -- Only for valid Relations
		-- Update RelationInfoId in @SMRelationTbl
		UPDATE @SMRelationsTbl
		SET SMRelationInfoDbId = a.SMRelationId
		FROM SMRelationInfo AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  a.SMRelationId = b.SMRelationDbId
		--select * from @SMRelationsTbl
 --#####################################################################
 -- Update and Insert data into SMRelatinNode, SMRelationNodeInfo tables
 --#####################################################################
		-- Ideally we should not insert, but current architecture, does not have primary node info.
		-- Hence inserting Primary Nodes (ExtNodeId = 1)
		-- Make sure even for OC6, we have the value 1 for primary node
		INSERT INTO SMRelationNode(
			SMRelationId,
			ExtNodeId,
			vFiler,
			Flags,
			OrigCCId)
		SELECT DISTINCT
			a.SMRelationDbId,
			a.ExtNodeId,
			'',
4, -- DFM Data collection created nodes, which MM will not prune
			2 -- Check with Pawan/Gnana
		FROM @SMRelationsTbl a
			LEFT OUTER JOIN SMRelationNode b
				ON a.SMRelationDbId = b.SMRelationId
				AND a.SMRelationDbId > 0
				AND a.ExtNodeId = b.ExtNodeId
		WHERE b.ExtNodeId IS NULL
		--use SMCopyToRelationMap for valied SMRelationNode
		UPDATE @SMRelationsTbl
		SET
			SMRelationNodeDbId = a.SMRelationNodeId
		FROM SMRelationNode AS a,
			SMCopyToRelationMap b,
			@SMRelationsTbl AS c
		WHERE
			a.SMRelationId = b.SMRelationId
			AND a.SMRelationNodeId = b.SMRelationNodeId
			AND a.SMRelationId = c.SMRelationDbId
			AND a.ExtNodeId = c.ExtNodeId
		--Update only primary node entry, which is added from here
		UPDATE @SMRelationsTbl
		SET
			SMRelationNodeDbId = a.SMRelationNodeId
		FROM SMRelationNode AS a,
			@SMRelationsTbl AS c
		WHERE
			a.SMRelationId = c.SMRelationDbId
			AND a.ExtNodeId = c.ExtNodeId
			--AND a.ExtNodeId = '1'
			AND c.NodeRelation = 'Primary data'	 -- Check if this is not required.
								--As we hae seen where ther are duplicate, invalid entries in SMRelationNode table
								-- which is taken care by using SMCopyToRelationMap table. Primay would be unique.. no duplicate possible
		-- Update RelationNodeInfoId in @SMRelationTbl
		UPDATE @SMRelationsTbl
		SET SMRelationNodeInfoDbId = a.SMRelationNodeId
		FROM SMRelationNodeInfo AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  a.SMRelationNodeId = b.SMRelationNodeDbId
		-- Update SMRelationNodeInfo for existing entries.
		UPDATE SMRelationNodeInfo
		SET
			ProvisionPolicy = b.ProvisionPolicy,
			NodeRelation = b.NodeRelation,
			ResourcePools = b.ResourcePool
		FROM SMRelationNodeInfo AS a
			INNER JOIN @SMRelationsTbl AS b
				ON  b.SMRelationNodeInfoDbId > 0
				AND a.SMRelationNodeId = b.SMRelationNodeInfoDbId
		-- Insert new entries in SMRelationNodeInfo
		INSERT INTO SMRelationNodeInfo(
			SMRelationNodeId,
			ProvisionPolicy,
			NodeRelation,
			ResourcePools)
		SELECT DISTINCT
			a.SMRelationNodeDbId,
			a.ProvisionPolicy,
			a.NodeRelation,
			a.ResourcePool
		FROM
			@SMRelationsTbl a
		WHERE
			a.SMRelationNodeInfoDbId = 0
			AND a.SMRelationNodeDbId > 0
		--select * from @SMRelationsTbl
	 --########################################################################
	 -- Update and Insert data into SMDataSetMember, SMDataSetMemberInfo tables
	 --########################################################################
		DECLARE @SMDataSetMembersTbl TABLE (
			DFMHostName					NVARCHAR(1024) NOT NULL,
			ControlHostId				INTEGER NOT NULL,
			DataSetMemberDbId			INTEGER NOT NULL,
			DataSetMemberInfoDbId		INTEGER NOT NULL,
			ExtDataSetMemberId			NVARCHAR(1024) NOT NULL,
			ExtDataSetMemberName		NVARCHAR(510) NOT NULL,
			ExtDataSetMemberType		NVARCHAR(255) NOT NULL,
			srcDataSetMemberDbId		INTEGER NOT NULL, --Required?
			srcExtDataSetMemberId		NVARCHAR(1024) NOT NULL,
			srcExtDataSetMemberName		NVARCHAR(510) NOT NULL,
			SMArrayDbId					INTEGER NOT NULL,
			ArrayName					NVARCHAR(255) NOT NULL,
			SMArrayVolumeDbId			INTEGER NOT NULL,
			VolumeName					NVARCHAR(255) NOT NULL,
			vFilerUnitDbId				INTEGER NOT NULL,
			vFilerUnit					NVARCHAR(255) NOT NULL,
			LagTime						BIGINT NOT NULL,
			CreationTime				DATETIME NOT NULL,
			UpdateTime					DATETIME NOT NULL,
			DataSetDbId					INTEGER NOT NULL,
			ExtDataSetId				NVARCHAR(1024) NOT NULL,
			ExtDataSetName				NVARCHAR(510) NOT NULL,
			AppId						INTEGER NOT NULL, -- SMDataSetToSubClientMap
			SMRelationDbId				INTEGER NOT NULL,
			ExtRelationId				NVARCHAR(1024) NOT NULL,
			ExtRelationName				NVARCHAR(512) NOT NULL,
			SMRelationNodeDbId			INTEGER NOT NULL,
			ExtNodeId					NVARCHAR(1024) NOT NULL
			)
		INSERT INTO @SMDataSetMembersTbl
			SELECT
				@dfmHostName,
				@ControlHostId,
				0,
				0,
				ISNULL(DataSetNodeMember.value('./DataSetMemberId[1]', 'NVARCHAR(1024)'), ''),
				ISNULL(DataSetNodeMember.value('./DataSetMemberName[1]', 'NVARCHAR(510)'), ''),
				ISNULL(DataSetNodeMember.value('./DataSetMemberType[1]', 'NVARCHAR(255)'), ''),
				0,
				ISNULL(DataSetNodeMember.value('./srcDataSetMemberId[1]', 'NVARCHAR(1024)'), ''),
				ISNULL(DataSetNodeMember.value('./srcDataSetMemberName[1]', 'NVARCHAR(510)'), ''),
				0,
				ISNULL(DataSetNodeMember.value('./FileServerName[1]', 'NVARCHAR(255)'), ''),
				0,
				ISNULL(DataSetNodeMember.value('./VolumeName[1]', 'NVARCHAR(255)'), ''),
				0,
				ISNULL(DataSetNodeMember.value('./vFilerUnit[1]', 'NVARCHAR(255)'), ''),
				ISNULL(DataSetNodeMember.value('./LagTime[1]', 'BIGINT'), 0),
				@curTime,
				@curTime,
				0,
				DataSetInfo.value('./DataSetId[1]', 'NVARCHAR(1024)'),
				DataSetInfo.value('./DataSetName[1]', 'NVARCHAR(510)'),
				0, --AppId
				0,
				DataSetInfo.value('./StorageServiceId[1]', 'NVARCHAR(1024)'),
				DataSetInfo.value('./StorageServiceName[1]', 'NVARCHAR(512)'),
				0,
				ISNULL(DataSetNodeInfo.value('./NodeId[1]', 'NVARCHAR(1024)'),'1')
			FROM @i_xmlTextInput.nodes('/SMDFMReportInfo/SMDataSetDetailsInfo') DataSetInfo(DataSetInfo)
			CROSS APPLY DataSetInfo.nodes('SMDataSetNodeInfo') DataSetNodeInfo(DataSetNodeInfo)
			CROSS APPLY DataSetNodeInfo.nodes('SMDataSetMember') DataSetNodeMember(DataSetNodeMember)
	--
		UPDATE @SMDataSetMembersTbl
		SET DataSetDbId = b.DataSetId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMDataSet b
			ON a.ExtDataSetId = b.ExtDataSetId
			AND a.ExtDataSetName = b.ExtDataSetName
			AND a.ControlHostId = b.ControlHostId
		-- Update SMRelationId
		UPDATE @SMDataSetMembersTbl
		SET SMRelationDbId = b.SMRelationId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMRelation b
			ON a.ExtRelationId = b.ExtRelationId
			AND a.ExtRelationName = b.ExtRelationName
			AND a.ControlHostId = b.ControlHostId
		-- Update AppId
		UPDATE @SMDataSetMembersTbl
		SET AppId = b.AppId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMDataSetToSubClientMap b
			ON a.SMRelationDbId = b.SMRelationId
			AND a.DataSetDbId = b.DataSetId
			AND a.ControlHostId = b.ControlHostId
		-- TODO
		-- For LREP, we have multiple subclients belonging to same dataset.
		-- So, we cannot set AppId based on datasetId, as we do for regular OC5(non-lrep) and OC6.
		-- So, set AppID for secondary and tertiary dataset members , same as its parents datasetMember's AppId
		-- Update DataSetMemberId
		UPDATE @SMDataSetMembersTbl
		SET DataSetMemberDbId = b.DataSetMemberId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMDataSetMember b
			ON a.ExtDataSetMemberId = b.ExtDataSetMemberId
			AND a.ExtDataSetMemberName = b.ExtDataSetMemberName
			AND a.DataSetDbId= b.DataSetId
			AND a.SMRelationDbId = b.SMRelationId
	   /****************** Begin : Prune Externally deleted DataSet Members ***************************/
		if object_id('tempdb.dbo.#tmpExtDeletedDSMemberTbl') is not null DROP TABLE #tmpExtDeletedDSMemberTbl
       -- Delete DataSet Members which are earlier collected by DFM Reporting (Flags=4), for current DataSet, and not collected in this run.
	   CREATE TABLE #tmpExtDeletedDSMemberTbl
	   (
          ExtDataSetMemberId NVARCHAR(1024),
		  DataSetId INTEGER
       ) ;
	   --GET all DataSetMembers belonging to datasets of current data collection (existing entries from SMDataSetMember)
	   INSERT INTO #tmpExtDeletedDSMemberTbl
	   SELECT a.ExtDataSetMemberId,a.DataSetId
	   FROM SMDataSetMember a
	   WHERE DataSetId IN (SELECT DISTINCT DataSetDbId FROM @SMDataSetMembersTbl)
AND Flags & 4 = 4
		--Exclude DataSetMembers which are part of current data collection
		DELETE #tmpExtDeletedDSMemberTbl
		FROM #tmpExtDeletedDSMemberTbl a, @SMDataSetMembersTbl b
		WHERE a.ExtDataSetMemberId = b.ExtDataSetMemberId
			AND a.DataSetId = b.DataSetDbId
		-- Now we have externally deleted datasetmembers in #tmpExtDeletedDSMemberTbl
		-- i.e datasetmembers for datasets collected in previous runs, but not found in DFM server in current collection.
		--REMOVE the dataset members which are externally deleted
		DELETE SMDataSetMember
		FROM SMDataSetMember a, #tmpExtDeletedDSMemberTbl b
		WHERE a.ExtDataSetMemberId = b.ExtDataSetMemberId
			AND a.DataSetId = b.DataSetId
AND a.Flags & 4 = 4
	   /****************** End : Prune Externally deleted DataSet Members ***************************/
		-- Insert the new DataSetMembers
		INSERT INTO SMDataSetMember(
			DataSetId,
			AppId,
			ExtDataSetMemberId,
			ExtDataSetMemberName,
			SMRelationId,
			Flags,
			OrigCCId,
			AgedTime,
			AgedBy,
			CreatedTime,
			ModifiedTime)
		SELECT DISTINCT
			DataSetDbId,
			AppId,
			ExtDataSetMemberId,
			ExtDataSetMemberName,
			SMRelationDbId,
4,
			2,
			0,
			0,
			dbo.GetUnixTime(@curTime),
			dbo.GetUnixTime(@curTime)
		FROM
			@SMDataSetMembersTbl
		WHERE
			DataSetMemberDbId = 0
			AND DataSetDbId <> 0
			AND SMRelationDbId <> 0
		-- Update the inserted datasetmemberid
		-- Update DataSetMemberId
		UPDATE @SMDataSetMembersTbl
		SET DataSetMemberDbId = b.DataSetMemberId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMDataSetMember b
			ON a.ExtDataSetMemberId = b.ExtDataSetMemberId
			AND a.ExtDataSetMemberName = b.ExtDataSetMemberName
			AND a.DataSetDbId= b.DataSetId
			AND a.SMRelationDbId = b.SMRelationId
		-- As we have inserted new SMDataSetMembers and updated their DataSetMemberDbId in temporary table
		-- Update srcDataSetMemberDbId by Id and Name
		-- Update the inserted datasetmemberid
		-- Update DataSetMemberId
		UPDATE @SMDataSetMembersTbl
		SET srcDataSetMemberDbId = b.DataSetMemberId
		FROM @SMDataSetMembersTbl a
			INNER JOIN SMDataSetMember b
			ON a.srcExtDataSetMemberId = b.ExtDataSetMemberId
			AND a.srcExtDataSetMemberName = b.ExtDataSetMemberName
			AND a.srcExtDataSetMemberId <> ''
			AND a.srcExtDataSetMemberName <> ''
			AND a.DataSetDbId= b.DataSetId
			AND a.SMRelationDbId = b.SMRelationId
		-- ***********************************************
		-- Update / Insert entries in SMDataSetMemberInfo
		-- ***********************************************
		-- Update SMRelationNodeDbId in @SMDataSetMembersTbl
		-- First Update only entries matching in SMCopyToRelationMap
		UPDATE @SMDataSetMembersTbl
		SET SMRelationNodeDbId = b.SMRelationNodeId
		FROM
			@SMDataSetMembersTbl a,
			SMRelationNode b,
			SMCopyToRelationMap c
		WHERE
			a.SMRelationDbId = b.SMRelationId
			AND a.ExtNodeId = b.ExtNodeId
			AND b.SMRelationNodeId = c.SMRelationNodeId
		-- Update only primary nodes we added in SMRelationNode
		UPDATE @SMDataSetMembersTbl
		SET SMRelationNodeDbId = b.SMRelationNodeId
		FROM
			@SMDataSetMembersTbl a
			INNER JOIN SMRelationNode b
				ON	a.SMRelationDbId = b.SMRelationId
				AND a.ExtNodeId = b.ExtNodeId
			INNER JOIN SMRelationNodeInfo c
			--AND a.ExtNodeId = '1'
				ON b.SMRelationNodeId= c.SMRelationNodeId
				AND c.NodeRelation = 'Primary data'
		-- Update SMArrayId
		UPDATE @SMDataSetMembersTbl
		SET SMArrayDbId = b.Id
		FROM
			@SMDataSetMembersTbl a,
			SMArray b
		WHERE
			a.ArrayName = b.ArrayName
		-- Update SMArrayVolumeId
		-- Update/Insert only volumes which are having entries in SMArrayVolume, though we collect more info
		UPDATE @SMDataSetMembersTbl
		SET SMArrayVolumeDbId = c.Id
		FROM
			@SMDataSetMembersTbl a,
			SMArray b,
			SMArrayVolume c
		WHERE
			a.SMArrayDbId = b.Id
			AND b.ClientId = c.ClientId
			AND a.VolumeName = c.Name
		--select * from @SMDataSetMembersTbl
		-- Update /Insert entries in SMDataSetMemberInfo
		-- Mark existing entries in @SMDataSetMembersTbl from SMDataSetMemberInfo
		UPDATE @SMDataSetMembersTbl
		SET
			DataSetMemberInfoDbId = b.DataSetMemberId
		FROM
			@SMDataSetMembersTbl a
			INNER JOIN 	SMDataSetMemberInfo b
			ON a.DataSetMemberDbId = b.DataSetMemberId
			AND a.DataSetDbId <> 0
			AND a.SMRelationDbId <> 0
		-- Update existing entries in SMDataSetMemberInfo, using DataSetMemberInfoDbId
		UPDATE SMDataSetMemberInfo
		SET
			vFilerUnit = b.vFilerUnit,
			LagTime = b.LagTime,
			MemberType = b.ExtDataSetMemberType,
			SourceMemberId = b.srcDataSetMemberDbId,
			UpdateTime = b.UpdateTime,
			DeleteTime = NULL
		FROM
			SMDataSetMemberInfo a
			INNER JOIN 	@SMDataSetMembersTbl b
			ON a.DataSetMemberId = b.DataSetMemberInfoDbId
			AND a.ArrayId = b.SMArrayDbId
		-- INSERT entries in SMDataSetMemberInfo(non-existing), only with valied SMArrayVolumeDbId (non zero entries)
		INSERT INTO SMDataSetMemberInfo (
			DataSetMemberId,
			SMRelationNodeId,
			ArrayId,
			ArrayVolumeId,
			vFilerUnit,
			LagTIme,
			SourceMemberId,
			MemberType,
			CreationTime,
			UpdateTime)
		SELECT	DISTINCT
			DataSetMemberDbId,
			SMRelationNodeDbId,
			SMArrayDbId,
			SMArrayVolumeDbId,
			vFilerUnitDbId,
			LagTime,
			srcDataSetMemberDbId,
			ExtDataSetMemberType,
			CreationTime,
			UpdateTime
		FROM @SMDataSetMembersTbl
		WHERE
			DataSetMemberInfoDbId = 0
			AND DataSetDbId <> 0
			AND SMRelationDbId <> 0
			--AND SMArrayVolumeDbId <> 0 -- Commenting out for LREP
			AND SMArrayDbId <> 0
	IF (@SMProcessDFMReportEntries = 1)
		BEGIN
			COMMIT TRANSACTION SMProcessDFMReportEntries
			SET @SMProcessDFMReportEntries = 0
		END
	SELECT	@logMessage = 'Processing XML Done for the given DFM DataSets'
	--INSERT INTO SMLogger(MediaAgentId, RefId, RefType, Message, XMLData)
	--	VALUES (@x_maId, @x_arrayId, @refType, @logMessage, @i_xmlTextInput)
	SELECT 0, @logMessage
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0 AND @SMProcessDFMReportEntries = 1)
		BEGIN
			ROLLBACK TRANSACTION SMProcessDFMReportEntries
			SET  @SMProcessDFMReportEntries = 0
		END
	SELECT	@logMessage = 'Processing XML for a given DataSet failed'
	--INSERT INTO SMLogger(MediaAgentId, RefId, RefType, Message, XMLData)
	--	-VALUES (@x_maId, @x_arrayId, @refType, @logMessage, @i_xmlTextInput)
	SELECT 1, @logMessage
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SMProcessDFMReportEntries')
	delete from GxQscripts where name = 'SMProcessDFMReportEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMProcessDFMReportEntries')
	delete from GXDBVersions where aliasname = 'SMProcessDFMReportEntries'
GO

insert into GXDBVersions values(2, 'SMProcessDFMReportEntries',  '00010006000200050000', 'SMProcessDFMReportEntries', '00010006000200050000')
GO

