

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMProcessArrayEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMProcessArrayEntries.sp,v $ $Id: SMProcessArrayEntries.sp,v 1.18.12.4 2018/03/20 00:00:00 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMProcessArrayEntries <<<'

IF EXISTS (select * from sysobjects where name='SMProcessArrayEntries')
	drop procedure SMProcessArrayEntries
IF EXISTS (select * from GxQscripts where name='SMProcessArrayEntries')
	delete from GxQscripts where name = 'SMProcessArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMProcessArrayEntries')
	delete from GXDBVersions where aliasname = 'SMProcessArrayEntries'
GO
print '... Creating Procedure: SMProcessArrayEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMProcessArrayEntries
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/* Input XML Format
	<SMVolSnapInfo2>
		<JobId></JobId> -- <=0 for FULL DC
	</SMVolSnapInfo2>
*/
DECLARE @logMessage VARCHAR(MAX)
DECLARE @x_maId INTEGER = 0
DECLARE @x_jobId BIGINT
DECLARE @x_arrayId INTEGER = 0
DECLARE @refType INTEGER = 0
--RefType = SM_MRT_NONE = 0 :- None
--RefType = SM_MRT_ARRAY = 5 :- Control Host
--RefType = SM_MRT_STORAGE_ARRAY = 6 :- Array
SET @x_maId = ISNULL(@i_reserveParam, 0)
SET @x_jobId = ISNULL(( SELECT R.ref.value('.', 'BIGINT') FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/JobId') R(ref)), 0)
DECLARE @curTime DATETIME = GETUTCDATE()
DECLARE @SMProcessArrayEntries INT
SET @SMProcessArrayEntries = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION SMProcessArrayEntries
		SET @SMProcessArrayEntries = 1
	END
	--Processing Array Info	(Only for FULL DC)
	IF @x_jobId <= 0
	BEGIN
		UPDATE SMArray
		SET
			SoftState = b.SoftState,
			IsEnabled = b.IsEnabled,
			IsActive = b.IsActive,
			BrokenCode = b.BrokenCode,
			ReasonCode = b.ReasonCode,
			Flags = b.Flags,
			TotalSpaceMB = b.TotalSpaceMB,
			FreeSpaceMB = b.FreeSpaceMB,
			UniqueID = b.UniqueID,
			SerialNumber = b.SerialNumber,
			ProductOSVersion = b.ProductOSVersion,
			ProductFirmwareVersion = b.ProductFirmwareVersion,
			ProductModel = b.ProductModel,
			UpdateTime = b.UpdateTime,
			AdminConsole = b.AdminConsole,
			Properties = b.Properties,
			ReserveField1 = b.ReserveField1,
			ReserveField2 = b.ReserveField2,
			ReserveField3 = b.ReserveField3,
			ReserveField4 = b.ReserveField4,
			ReserveFieldStr = b.ReserveFieldStr
		FROM SMArray AS a
			INNER JOIN
			(SELECT
				R.ref.value('./Id[1]', 'int') AS Id,
				ISNULL(R.ref.value('./SoftState[1]', 'int'), 0) AS SoftState,
				ISNULL(R.ref.value('./IsEnabled[1]', 'int'), 0) AS IsEnabled,
				ISNULL(R.ref.value('./IsActive[1]', 'int'), 0) AS IsActive,
				ISNULL(R.ref.value('./BrokenCode[1]', 'int'), 0) AS BrokenCode,
				ISNULL(R.ref.value('./ReasonCode[1]', 'int'), 0) AS ReasonCode,
				ISNULL(R.ref.value('./Flags[1]', 'int'), 0) AS Flags,
				ISNULL(R.ref.value('./TotalSpaceMB[1]', 'int'), -1) AS TotalSpaceMB,
				ISNULL(R.ref.value('./FreeSpaceMB[1]', 'BIGINT'), -1) AS FreeSpaceMB,
				ISNULL(R.ref.value('./UniqueId[1]', 'NVARCHAR(255)'), '') AS UniqueID,
				ISNULL(R.ref.value('./SerialNumber[1]', 'NVARCHAR(255)'), '') AS SerialNumber,
				ISNULL(R.ref.value('./ProductOSVersion[1]', 'NVARCHAR(255)'), '') AS ProductOSVersion,
				ISNULL(R.ref.value('./ProductFirmwareVersion[1]', 'NVARCHAR(255)'), '') AS ProductFirmwareVersion,
				ISNULL(R.ref.value('./ProductModel[1]', 'NVARCHAR(255)'), '') AS ProductModel,
				@curTime AS UpdateTime,
				ISNULL(R.ref.value('./AdminConsole[1]', 'NVARCHAR(1024)'), '') AS AdminConsole,
				ISNULL(R.ref.query('./Properties/*'),'') AS Properties,
				ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0) AS ReserveField1,
				ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0) AS ReserveField2,
				ISNULL(R.ref.value('./ReserveField3[1]', 'int'), 0) AS ReserveField3,
				ISNULL(R.ref.value('./ReserveField4[1]', 'int'), 0) AS ReserveField4,
				ISNULL(R.ref.value('./ReserveFieldStr[1]', 'NVARCHAR(255)'), '') AS ReserveFieldStr
			FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMArrayArray/SMArrayInfo') R(ref)) AS b
				ON b.Id = a.Id
				AND a.DeleteTime IS NULL
				AND b.SoftState = 1
				AND b.Flags & 1 <> 1 --Ignore the Arrays that are not related to the Media Agent that sends this response
		UPDATE SMArray
		SET
			SoftState = b.SoftState,
			IsEnabled = b.IsEnabled,
			IsActive = b.IsActive,
			BrokenCode = b.BrokenCode,
			ReasonCode = b.ReasonCode,
			Flags = b.Flags,
			UpdateTime = b.UpdateTime
		FROM SMArray AS a
			INNER JOIN
			(SELECT
				R.ref.value('./Id[1]', 'int') AS Id,
				ISNULL(R.ref.value('./SoftState[1]', 'int'), 0) AS SoftState,
				ISNULL(R.ref.value('./IsEnabled[1]', 'int'), 0) AS IsEnabled,
				ISNULL(R.ref.value('./IsActive[1]', 'int'), 0) AS IsActive,
				ISNULL(R.ref.value('./BrokenCode[1]', 'int'), 0) AS BrokenCode,
				ISNULL(R.ref.value('./ReasonCode[1]', 'int'), 0) AS ReasonCode,
				ISNULL(R.ref.value('./Flags[1]', 'int'), 0) AS Flags,
				@curTime AS UpdateTime
			FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMArrayArray/SMArrayInfo') R(ref)) AS b
				ON b.Id = a.Id
				AND a.DeleteTime IS NULL
				AND b.SoftState = 0
				AND b.Flags & 1 <> 1 --Ignore the Arrays that are not related to the Media Agent that sends this response
	END
	--End Processing Array Info
	--Processing Storage Pool Info
	DECLARE @storagePoolTbl TABLE (
		Id							INTEGER NOT NULL,
		DbId						INTEGER NOT NULL,
		ClientId					INTEGER NOT NULL,
		SoftState					INTEGER NOT NULL,
		IsEnabled					INTEGER NOT NULL,
		IsActive					INTEGER NOT NULL,
		BrokenCode					INTEGER NOT NULL,
		ReasonCode					INTEGER NOT NULL,
		Flags						INTEGER NOT NULL,
		TotalSpaceMB				BIGINT NOT NULL,
		UsedSpaceMB					BIGINT NOT NULL,
		FreeSpaceMB					BIGINT NOT NULL,
		VolumeCount					BIGINT NOT NULL,
		Type						INTEGER NOT NULL,
		Name						NVARCHAR(1024) NOT NULL,
		UniqueID					NVARCHAR(255) NOT NULL,
		CreationTime				DATETIME NOT NULL,
		UpdateTime					DATETIME NOT NULL,
		DeleteTime					DATETIME NOT NULL,
		Properties					XML NOT NULL,
		GUID						nvarchar(64),
		ReserveField1				INTEGER NOT NULL,
		ReserveField2				INTEGER NOT NULL,
		ReserveField3				INTEGER NOT NULL,
		ReserveField4				INTEGER NOT NULL,
		ReserveFieldStr				NVARCHAR(255) NOT NULL
	)
	INSERT INTO @storagePoolTbl
		SELECT
			R.ref.value('./Id[1]', 'int'),
			0,
			ISNULL(R.ref.value('./ClientId[1]', 'int'), 0),
			ISNULL(R.ref.value('./SoftState[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsEnabled[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsActive[1]', 'int'), 0),
			ISNULL(R.ref.value('./BrokenCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReasonCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./Flags[1]', 'int'), 0),
			ISNULL(R.ref.value('./TotalSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./UsedSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./FreeSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./VolumeCount[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./Type[1]', 'int'), 0),
			ISNULL(R.ref.value('./Name[1]', 'NVARCHAR(1024)'), ''),
			ISNULL(R.ref.value('./UniqueId[1]', 'NVARCHAR(255)'), ''),
			@curTime,
			@curTime,
			@curTime,
			ISNULL(R.ref.query('./Properties/*'),''),
			ISNULL(R.ref.value('./GUID[1]', 'nvarchar(64)'), ''),
			ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField3[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField4[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveFieldStr[1]', 'NVARCHAR(255)'), '')
		FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMStoragePoolArray/SMStoragePoolInfo') R(ref)
	UPDATE @storagePoolTbl
	SET	GUID = CONVERT(NVARCHAR(64), NEWID())
	WHERE LEN(GUID) = 0
	UPDATE @storagePoolTbl
	SET DbId = a.Id
	FROM SMStoragePool AS a
		INNER JOIN @storagePoolTbl AS b
			ON a.ClientId = b.ClientId --AND a.UniqueID = b.UniqueID
			AND a.GUID =  CONVERT(uniqueidentifier, b.GUID)
	--Update already existing storage pools, when DbId > 0
	UPDATE SMStoragePool
	SET
		SoftState = b.SoftState,
		IsEnabled = b.IsEnabled,
		IsActive = b.IsActive,
		BrokenCode = b.BrokenCode,
		ReasonCode = b.ReasonCode,
		Flags = b.Flags,
		TotalSpaceMB = b.TotalSpaceMB,
		UsedSpaceMB = b.UsedSpaceMB,
		FreeSpaceMB = b.FreeSpaceMB,
		VolumeCount = b.VolumeCount,
		Type = b.Type,
		Name = b.Name,
		UniqueID = b.UniqueId,
		UpdateTime = b.UpdateTime,
		DeleteTime = NULL,
		Properties = b.Properties,
		ReserveField1 = b.ReserveField1,
		ReserveField2 = b.ReserveField2,
		ReserveField3 = b.ReserveField3,
		ReserveField4 = b.ReserveField4,
		ReserveFieldStr = b.ReserveFieldStr
	FROM SMStoragePool AS a
		INNER JOIN @storagePoolTbl AS b
			ON b.DbId > 0 AND b.DbId = a.Id
		WHERE (b.Flags & 0x02) = 0
	UPDATE SMStoragePool
	SET
		SoftState = b.SoftState,
		Flags = b.Flags,
		DeleteTime = @curTime
	FROM SMStoragePool AS a
		INNER JOIN @storagePoolTbl AS b
			ON b.DbId > 0 AND b.DbId = a.Id
		WHERE (b.Flags & 0x02) = 0x02
	--Create new storage pools, when DbId = 0
	INSERT INTO SMStoragePool(ClientId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, VolumeCount, Type, Name, UniqueID, CreationTime, UpdateTime, Properties, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr)
		SELECT ClientId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, VolumeCount, Type, Name, UniqueID, CreationTime, UpdateTime, Properties, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr
			FROM @storagePoolTbl WHERE DbId = 0
	UPDATE @storagePoolTbl
	SET DbId = a.Id
	FROM SMStoragePool AS a
		INNER JOIN @storagePoolTbl AS b
			ON b.DbId = 0 AND a.UniqueID = b.UniqueID AND a.ClientId = b.ClientId
	--End Processing Storage Pool Info
	--Processing Array Volume Info
	DECLARE @arrayVolTbl TABLE (
		Id							INTEGER NOT NULL,
		DbId						INTEGER NOT NULL,
		ClientId					INTEGER NOT NULL,
		StoragePoolId				INTEGER NOT NULL,
		SoftState					INTEGER NOT NULL,
		IsEnabled					INTEGER NOT NULL,
		IsActive					INTEGER NOT NULL,
		BrokenCode					INTEGER NOT NULL,
		ReasonCode					INTEGER NOT NULL,
		Flags						INTEGER NOT NULL,
		TotalSpaceMB				BIGINT NOT NULL,
		UsedSpaceMB					BIGINT NOT NULL,
		FreeSpaceMB					BIGINT NOT NULL,
		Name						NVARCHAR(1024) NOT NULL,
		Path						NVARCHAR(255) NOT NULL,
		UniqueID					NVARCHAR(255) NOT NULL,
		CreationTime				DATETIME NOT NULL,
		UpdateTime					DATETIME NOT NULL,
		Properties					XML NOT NULL,
		GUID						nvarchar(64),
		ReserveField1				INTEGER NOT NULL,
		ReserveField2				INTEGER NOT NULL,
		ReserveField3				INTEGER NOT NULL,
		ReserveField4				INTEGER NOT NULL,
		ReserveFieldStr				NVARCHAR(255) NOT NULL,
		PRIMARY KEY (Id)
	)
	INSERT INTO @arrayVolTbl
		SELECT
			R.ref.value('./Id[1]', 'int'),
			0,
			ISNULL(R.ref.value('./ClientId[1]', 'int'), 0),
			ISNULL(R.ref.value('./StoragePoolId[1]', 'int'), 0),
			ISNULL(R.ref.value('./SoftState[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsEnabled[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsActive[1]', 'int'), 0),
			ISNULL(R.ref.value('./BrokenCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReasonCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./Flags[1]', 'int'), 0),
			ISNULL(R.ref.value('./TotalSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./UsedSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./FreeSpaceMB[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./Name[1]', 'NVARCHAR(1024)'), ''),
			ISNULL(R.ref.value('./Path[1]', 'NVARCHAR(255)'), ''),
			ISNULL(R.ref.value('./UniqueId[1]', 'NVARCHAR(255)'), ''),
			@curTime,
			@curTime,
			ISNULL(R.ref.query('./Properties/*'),''),
			ISNULL(R.ref.value('./GUID[1]', 'nvarchar(64)'), ''),
			ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField3[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField4[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveFieldStr[1]', 'NVARCHAR(255)'), '')
		FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMArrayVolumeArray/SMArrayVolumeInfo') R(ref)
	--Update Storage Pool id for the newly discoverd Storage Pools
	UPDATE @arrayVolTbl
	SET		GUID = CONVERT(NVARCHAR(64), NEWID())
	WHERE	LEN(GUID) = 0
	UPDATE @arrayVolTbl
	SET	 StoragePoolId = b.DbId
	FROM @arrayVolTbl AS a
		INNER JOIN @storagePoolTbl AS b
			ON a.StoragePoolId = b.Id AND a.StoragePoolId < 0
	UPDATE @arrayVolTbl
	SET DbId = a.Id
	FROM SMArrayVolume AS a
		INNER JOIN @arrayVolTbl AS b
			ON a.ClientId = b.ClientId
			AND a.GUID =  CONVERT(uniqueidentifier, b.GUID)
	--Update already existing Array Volumes, when DbId > 0
	UPDATE SMArrayVolume
	SET
		StoragePoolId = b.StoragePoolId,
		SoftState = b.SoftState,
		IsEnabled = b.IsEnabled,
		IsActive = b.IsActive,
		BrokenCode = b.BrokenCode,
		ReasonCode = b.ReasonCode,
		Flags = b.Flags,
		TotalSpaceMB = b.TotalSpaceMB,
		UsedSpaceMB = b.UsedSpaceMB,
		FreeSpaceMB = b.FreeSpaceMB,
		Path = b.Path,
		UniqueID = b.UniqueId,
		UpdateTime = b.UpdateTime,
		DeleteTime = NULL,
		Properties = b.Properties,
		ReserveField1 = b.ReserveField1,
		ReserveField2 = b.ReserveField2,
		ReserveField3 = b.ReserveField3,
		ReserveField4 = b.ReserveField4,
		ReserveFieldStr = b.ReserveFieldStr
	FROM SMArrayVolume AS a
		INNER JOIN @arrayVolTbl AS b
			ON b.DbId > 0 AND b.DbId = a.Id
		WHERE (b.Flags & 0x02) = 0
	UPDATE SMArrayVolume
	SET
		SoftState = b.SoftState,
		Flags = b.Flags,
		DeleteTime = @curTime
	FROM SMArrayVolume AS a
		INNER JOIN @arrayVolTbl AS b
			ON b.DbId > 0 AND b.DbId = a.Id
		WHERE (b.Flags & 0x02) = 0x02
	----Create new Array Volumes, when DbId = 0
	INSERT INTO SMArrayVolume(ClientId, StoragePoolId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Path, UniqueID, CreationTime, UpdateTime, Properties, GUID, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr)
		SELECT ClientId, StoragePoolId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceMB, UsedSpaceMB, FreeSpaceMB, Name, Path, UniqueID, CreationTime, UpdateTime, Properties, CONVERT(uniqueidentifier, GUID), ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr
			FROM @arrayVolTbl WHERE DbId = 0
	UPDATE @arrayVolTbl
	SET DbId = a.Id
	FROM SMArrayVolume AS a
		INNER JOIN @arrayVolTbl AS b
			ON b.DbId = 0
			AND a.GUID =  CONVERT(uniqueidentifier, b.GUID)
			AND a.ClientId = b.ClientId
	--End Processing Array Volume Info
	--Processing LUN Info
	DECLARE @lunTbl TABLE (
		Id							INTEGER NOT NULL,
		DbId						INTEGER NOT NULL,
		ArrayVolumeId				INTEGER NOT NULL,
		SoftState					INTEGER NOT NULL,
		IsEnabled					INTEGER NOT NULL,
		IsActive					INTEGER NOT NULL,
		BrokenCode					INTEGER NOT NULL,
		ReasonCode					INTEGER NOT NULL,
		Flags						INTEGER NOT NULL,
		TotalSpaceBytes				BIGINT NOT NULL,
		UsedSpaceBytes				BIGINT NOT NULL,
		FreeSpaceBytes				BIGINT NOT NULL,
		Name						NVARCHAR(1024) NOT NULL,
		HostType					INTEGER NOT NULL,
		Path						NVARCHAR(255) NOT NULL,
		Description					NVARCHAR(255) NOT NULL,
		UniqueID					NVARCHAR(255) NOT NULL,
		CreationTime				DATETIME NOT NULL,
		UpdateTime					DATETIME NOT NULL,
		Properties					XML NOT NULL,
		GUID						nvarchar(64),
		ReserveField1				INTEGER NOT NULL,
		ReserveField2				INTEGER NOT NULL,
		ReserveField3				INTEGER NOT NULL,
		ReserveField4				INTEGER NOT NULL,
		ReserveFieldStr				NVARCHAR(255) NOT NULL,
		PRIMARY KEY (Id)
	)
	INSERT INTO @lunTbl
		SELECT
			R.ref.value('./Id[1]', 'int'),
			0,
			ISNULL(R.ref.value('./ArrayVolumeId[1]', 'int'), 0),
			ISNULL(R.ref.value('./SoftState[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsEnabled[1]', 'int'), 0),
			ISNULL(R.ref.value('./IsActive[1]', 'int'), 0),
			ISNULL(R.ref.value('./BrokenCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReasonCode[1]', 'int'), 0),
			ISNULL(R.ref.value('./Flags[1]', 'int'), 0),
			ISNULL(R.ref.value('./TotalSpaceBytes[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./UsedSpaceBytes[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./FreeSpaceBytes[1]', 'BIGINT'), -1),
			ISNULL(R.ref.value('./Name[1]', 'NVARCHAR(1024)'), ''),
			ISNULL(R.ref.value('./HostType[1]', 'int'), 0),
			ISNULL(R.ref.value('./Path[1]', 'NVARCHAR(255)'), ''),
			ISNULL(R.ref.value('./Description[1]', 'NVARCHAR(255)'), ''),
			ISNULL(R.ref.value('./UniqueId[1]', 'NVARCHAR(255)'), ''),
			@curTime,
			@curTime,
			ISNULL(R.ref.query('./Properties/*'),''),
			ISNULL(R.ref.value('./GUID[1]', 'nvarchar(64)'), ''),
			ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField3[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReserveField4[1]', 'int'), 0),
			ISNULL(R.ref.value('./ReservedFieldStr[1]', 'NVARCHAR(255)'), '')
		FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMLUNArray/SMLUNInfo') R(ref)
	--Set new GUID's for new LUNs
	UPDATE @lunTbl
	SET		GUID = CONVERT(NVARCHAR(64), NEWID())
	WHERE	LEN(GUID) = 0
	--Update Array Volume id for the newly created Array Volumes
	UPDATE @lunTbl
	SET ArrayVolumeId = b.DbId
	FROM @lunTbl AS a
		INNER JOIN @arrayVolTbl AS b
		ON a.ArrayVolumeId = b.Id AND a.ArrayVolumeId < 0
	--Update the actual DBId's for existing LUNs from SMLUN table to @luntbl
	UPDATE @lunTbl
	SET DbId = a.Id
	FROM SMLUN AS a
		INNER JOIN @lunTbl AS b
			ON a.ArrayVolumeId = b.ArrayVolumeId AND a.GUID = CONVERT(uniqueidentifier, b.GUID)
	--Delete invalid LUNs when DbId > 0 and UniqueId not found
	--DELETE a
	--FROM SMLUN AS a
	--	INNER JOIN @lunTbl AS b
	--		ON b.DbId > 0
	--		AND b.DbId = a.Id
	--		AND b.UniqueID = ''
	--		AND b.ArrayVolumeId = a.ArrayVolumeId
	--Update already existing LUNs, when DbId > 0
	UPDATE SMLUN
	SET
		SoftState = b.SoftState,
		IsEnabled = b.IsEnabled,
		IsActive = b.IsActive,
		BrokenCode = b.BrokenCode,
		ReasonCode = b.ReasonCode,
		Flags = b.Flags,
		TotalSpaceBytes = b.TotalSpaceBytes,
		UsedSpaceBytes = b.UsedSpaceBytes,
		FreeSpaceBytes = b.FreeSpaceBytes,
		Name = b.Name,
		HostType = b.HostType,
		Description = b.Description,
		UniqueId = b.UniqueId,
		UpdateTime = b.UpdateTime,
		DeleteTime = NULL,
		Properties = b.Properties,
		ReserveField1 = b.ReserveField1,
		ReserveField2 = b.ReserveField2,
		ReserveField3 = b.ReserveField3,
		ReserveField4 = b.ReserveField4,
		ReserveFieldStr = b.ReserveFieldStr
	FROM SMLUN AS a
		INNER JOIN @lunTbl AS b
			ON b.DbId > 0
			AND b.DbId = a.Id
			--AND b.UniqueID <> ''
			AND b.ArrayVolumeId = a.ArrayVolumeId
		WHERE (b.Flags & 0x02) = 0
	UPDATE SMLUN
	SET
		SoftState = b.SoftState,
		Flags = b.Flags,
		DeleteTime = @curTime
	FROM SMLUN AS a
		INNER JOIN @lunTbl AS b
			ON b.DbId > 0 AND b.DbId = a.Id AND /*b.UniqueID <> '' AND*/ b.ArrayVolumeId = a.ArrayVolumeId
		WHERE (b.Flags & 0x02) = 0x02
	--Create new LUNs, when DbId < 0
	INSERT INTO SMLUN(ArrayVolumeId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceBytes, UsedSpaceBytes, FreeSpaceBytes, Name, HostType, Path, Description, UniqueID, CreationTime, UpdateTime, Properties, GUID, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr)
		SELECT ArrayVolumeId, SoftState, IsEnabled, IsActive, BrokenCode, ReasonCode, Flags, TotalSpaceBytes, UsedSpaceBytes, FreeSpaceBytes, Name, HostType, Path, Description, UniqueID, CreationTime, UpdateTime, Properties, CONVERT(uniqueidentifier, GUID), ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr
		FROM @lunTbl WHERE DbId = 0
	UPDATE @lunTbl
	SET DbId = a.Id
	FROM SMLUN AS a
		INNER JOIN @lunTbl AS b
			ON b.DbId = 0 AND a.GUID = CONVERT(uniqueidentifier, b.GUID) AND a.ArrayVolumeId = b.ArrayVolumeId
	--End Processing LUN Info
	----Processing Snap Info
	--/*
	--UPDATE SMSnap
	--SET
	--	UsedSpaceBytes = b.UsedSpaceBytes
	--FROM SMSnap AS a
	--	INNER JOIN
	--		(SELECT
	--			R.ref.value('./SMSnapId[1]', 'int') AS snapId,
	--			ISNULL(R.ref.value('./UsedSpaceBytes[1]', 'BIGINT'), -1) AS UsedSpaceBytes
	--		FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMSnapArray/SMSnapInfo') R(ref)) AS b
	--	ON b.snapId = a.SMSnapId
	--*/
	----End Processing Snap Info
	----Processing MountPath Info, Use ReserveField1 for MediaAgentId and ReserveFieldStr for Mount Path Name
	--DECLARE @mountPathMapTbl TABLE(
	--	Id							INTEGER NOT NULL,
	--	ArrayVolumeId				INTEGER NOT NULL,
	--	LunId						INTEGER NOT NULL,
	--	MountPathId					INTEGER NOT NULL,
	--	Flags						INTEGER NOT NULL,
	--	CreationTime				DATETIME NOT NULL,
	--	ReserveField1				INTEGER NOT NULL,
	--	ReserveField2				INTEGER NOT NULL,
	--	ReserveField3				INTEGER NOT NULL,
	--	ReserveField4				INTEGER NOT NULL,
	--	ReserveFieldStr				NVARCHAR(255) NOT NULL
	--)
	--INSERT INTO @mountPathMapTbl
	--	SELECT
	--		R.ref.value('./Id[1]', 'int'),
	--		ISNULL(R.ref.value('./ArrayVolumeId[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./LunId[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./MountPathId[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./Flags[1]', 'int'), 0),
	--		@curTime,
	--		ISNULL(R.ref.value('./ReserveField1[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./ReserveField2[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./ReserveField3[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./ReserveField4[1]', 'int'), 0),
	--		ISNULL(R.ref.value('./ReserveFieldStr[1]', 'NVARCHAR(255)'), '')
	--	FROM @i_xmlTextInput.nodes('/SMVolSnapInfo2/SMVolSnapArrayInfo/SMArrayMountPathMapArray/SMArrayMountPathMap') R(ref)
	----Mapping Array Volume and Mount Path
	--UPDATE @mountPathMapTbl
	--SET ArrayVolumeId = b.DbId
	--FROM @mountPathMapTbl AS a
	--	INNER JOIN @arrayVolTbl AS b
	--		ON a.ArrayVolumeId < 0
	--		AND a.ArrayVolumeId = b.Id
	--		--AND (a.Flags & 1 = 1)
	----Mapping LUN and Mount Path
	--UPDATE @mountPathMapTbl
	--SET LunId = b.DbId
	--FROM @mountPathMapTbl AS a
	--	INNER JOIN @lunTbl AS b
	--		ON a.LunId < 0
	--		AND a.LunId = b.Id
	--		AND (a.Flags & 1 <> 1)
	--UPDATE @mountPathMapTbl
	--SET Id = a.Id
	--FROM SMArrayMountPathMap AS a
	--	INNER JOIN @mountPathMapTbl AS b
	--		ON a.ArrayVolumeId = b.ArrayVolumeId
	--		AND a.LunId = b.LunId
	--		AND a.MountPathId = b.MountPathId
	--		AND a.Flags = b.Flags
	----Update Mount Path Map entry if Id > 0
	--UPDATE SMArrayMountPathMap
	--SET DeleteTime = NULL
	--FROM SMArrayMountPathMap AS a
	--	INNER JOIN @mountPathMapTbl AS b
	--		ON a.ArrayVolumeId = b.ArrayVolumeId
	--		AND a.LunId = b.LunId
	--		AND a.MountPathId = b.MountPathId
	--		AND a.Flags = b.Flags
	--		AND b.Id > 0
	----Create new Mount Path Map entry if Id = 0
	--INSERT INTO SMArrayMountPathMap(ArrayVolumeId, LunId, MountPathId, Flags, CreationTime, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr)
	--	SELECT ArrayVolumeId, LunId, MountPathId, Flags, CreationTime, ReserveField1, ReserveField2, ReserveField3, ReserveField4, ReserveFieldStr
	--		FROM @mountPathMapTbl WHERE Id = 0 AND ArrayVolumeId <> 0
	----End Processing MountPath Inf
	IF (@SMProcessArrayEntries = 1)
		BEGIN
			COMMIT TRANSACTION SMProcessArrayEntries
			SET @SMProcessArrayEntries = 0
		END
	DELETE FROM SMLogger WHERE MediaAgentId = @x_maId AND MediaAgentId <> 0
	SELECT	@logMessage = 'Processing XML Done for the given Array'
--	INSERT INTO SMLogger(MediaAgentId, RefId, RefType, Message, XMLData)
--		VALUES (@x_maId, @x_arrayId, @refType, @logMessage, @i_xmlTextInput)
	SELECT 0, @logMessage
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0 AND @SMProcessArrayEntries = 1)
		BEGIN
			ROLLBACK TRANSACTION SMProcessArrayEntries
			SET  @SMProcessArrayEntries = 0
		END
	SELECT	@logMessage = 'Processing XML failed'
--	INSERT INTO SMLogger(MediaAgentId, RefId, RefType, Message, XMLData)
--		VALUES (@x_maId, @x_arrayId, @refType, @logMessage, @i_xmlTextInput)
	SELECT 1, @logMessage
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SMProcessArrayEntries')
	delete from GxQscripts where name = 'SMProcessArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMProcessArrayEntries')
	delete from GXDBVersions where aliasname = 'SMProcessArrayEntries'
GO

insert into GXDBVersions values(2, 'SMProcessArrayEntries',  '00010018001200040000', 'SMProcessArrayEntries', '00010018001200040000')
GO

