

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMMasterConfigsCreateXMLFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMMasterConfigsCreateXMLFile.sp,v $ $Id: SMMasterConfigsCreateXMLFile.sp,v 1.2.2.2 2020/07/06 22:15:40 mnatarajan Exp $";
-- +-----------------------------------------------------------------------+
-- | PROCEDURE: SMMasterConfigsCreateXMLFile
-- | Description: This Stored Procedure will create SnapTestSMMasterConfig.xml on given input location.
-- | Usage: EXEC SMMasterConfigsCreateXMLFile <FilePath>
-- | Example: EXEC SMMasterConfigsCreateXMLFile 'C:\'
-- |    --This will create SnapTestSMMasterConfig.xml on give location [C:\SnapTestSMMasterConfig.xml]
-- +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SMMasterConfigsCreateXMLFile')
BEGIN
	print '>>> Drop Stored Procedure: SMMasterConfigsCreateXMLFile <<<'
	drop procedure SMMasterConfigsCreateXMLFile
END
IF EXISTS (select * from GxQscripts where name='SMMasterConfigsCreateXMLFile')
	delete from GxQscripts where name = 'SMMasterConfigsCreateXMLFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMMasterConfigsCreateXMLFile')
	delete from GXDBVersions where aliasname = 'SMMasterConfigsCreateXMLFile'
GO
print '... Creating Procedure: SMMasterConfigsCreateXMLFile'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMMasterConfigsCreateXMLFile
  @FilePath varchar(8000) = '--**--'
AS
DECLARE		@RetCode				int = 0
DECLARE		@FileSystem				int = 0
DECLARE		@FileID				    int = 0
DECLARE		@TextToWrite		    varchar(MAX)
IF(@FilePath = '--**--')
BEGIN
    PRINT 'ERROR : File Path Missing.'
    PRINT 'Usage: EXEC SMMasterConfigsCreateXMLFile <FilePath>'
    PRINT 'Example: EXEC SMMasterConfigsCreateXMLFile ''C:\'''
END
ELSE
    BEGIN
        SET @FilePath = @FilePath + 'SnapTestSMMasterConfigs.xml'
        SELECT @TextToWrite = ( select Id,Name,Type,Min,Max,CheckRange,ShowInGUI,IsValid,VendorId,EngineId,OverrideBitMap,DefaultInt,DefaultLL,DefaultStr,Created,Modified,OrigCCId,ReserveFieldInt1 = 0, ReserveFieldInt2,ReserveFieldInt3,ReserveFieldInt4,ReserveFieldStr,KeyName from CommServ..SMMasterConfigs FOR XML RAW ('row'), ROOT ('SMMasterConfigs'), ELEMENTS)
		DECLARE @isOsWindows BIT = dbo.IsOSOnCSWindows()
		DECLARE @errorMessage NVARCHAR(MAX) = ''
		IF @isOsWindows = 1
		BEGIN
			--ESTABLISH CONNECTION TO OBJECT
			EXECUTE @RetCode = sp_OACreate 'Scripting.FileSystemObject' , @FileSystem OUTPUT
			IF @RetCode <> 0
			BEGIN
				  PRINT 'Error while instancing Scripting.FileSystemObject'
				  GOTO ErrorExit
			END
			--OPEN FILE SPECIFIED BY @FilePath AND RETRIEVE @FileID LINK
			EXECUTE @RetCode = sp_OAMethod @FileSystem, 'OpenTextFile', @FileID OUTPUT, @FilePath, 2, true
			IF @RetCode <> 0
			BEGIN
				  PRINT 'Error while executing method OpenTextFile'
				  GOTO ErrorExit
			END
			--WRITE @TextToWrite TO FILE
			EXECUTE @RetCode = sp_OAMethod @FileID, 'WriteLine', Null, @TextToWrite
			IF @RetCode <> 0
			BEGIN
				  PRINT 'Error while executing method WriteLine'
				  GOTO ErrorExit
			END
		END
		ELSE
		BEGIN
			EXECUTE cv_spWriteToFile @filePath , @TextToWrite, @errorMessage OUTPUT, 0
			IF LEN(@errorMessage)>0
			BEGIN
				PRINT 'Error while executing method WriteLine'
				PRINT @errorMessage
				GOTO ErrorExit
			END
		END
        PRINT 'File will be created at location [' + @FilePath + ']. Please make sure that location exist and have write permission.';
        PRINT 'Move file to "/vaultcx/Source/Common/CVSnapHandler/" location and check-in the file.';
        ErrorExit:
        --DEALLOCATE
		IF @isOsWindows = 1
		BEGIN
			EXECUTE @RetCode = sp_OADestroy @FileID
			EXECUTE @RetCode = sp_OADestroy @FileSystem
		END
    END
GO

IF EXISTS (select * from GxQscripts where name = 'SMMasterConfigsCreateXMLFile')
	delete from GxQscripts where name = 'SMMasterConfigsCreateXMLFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMMasterConfigsCreateXMLFile')
	delete from GXDBVersions where aliasname = 'SMMasterConfigsCreateXMLFile'
GO

insert into GXDBVersions values(2, 'SMMasterConfigsCreateXMLFile',  '00010002000200020000', 'SMMasterConfigsCreateXMLFile', '00010002000200020000')
GO

