

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMMapSnapArrayEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMMapSnapArrayEntries.sp,v $ $Id: SMMapSnapArrayEntries.sp,v 1.13.40.2 2018/03/20 00:12:21 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMMapSnapArrayEntries <<<'

IF EXISTS (select * from sysobjects where name='SMMapSnapArrayEntries')
	drop procedure SMMapSnapArrayEntries
IF EXISTS (select * from GxQscripts where name='SMMapSnapArrayEntries')
	delete from GxQscripts where name = 'SMMapSnapArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMMapSnapArrayEntries')
	delete from GXDBVersions where aliasname = 'SMMapSnapArrayEntries'
GO
print '... Creating Procedure: SMMapSnapArrayEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMMapSnapArrayEntries
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/* Input XML Format
	<SMMapSnapArrayEntries>
		<ValidFlags></ValidFlags>
		<ControlHostId></ControlHostId>
		<SnapId></SnapId>
	</SMMapSnapArrayEntries>
*/
DECLARE @x_validFlags INTEGER
DECLARE @x_controlHostId INTEGER
DECLARE @x_snapJobId BIGINT
DECLARE @x_snapId INTEGER
DECLARE @SnapIdTbl TABLE(snapId INTEGER)
SET @x_validFlags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMMapSnapArrayEntries/ValidFlags') R(ref)), 0)
IF @x_validFlags = 0
BEGIN
	SELECT	1, 'Valid Flags used in SMMapSnapArrayEntries SQL SP is zero.'
	RETURN
END
IF @x_validFlags & 1 = 1
BEGIN
	SET @x_controlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMMapSnapArrayEntries/ControlHostId') R(ref)), 0)
	IF @x_controlHostId = 0
	BEGIN
		SELECT	2, 'Control Host Id is set as valid in SMMapSnapArrayEntries SQL SP but it is zero.'
		RETURN
	END
	IF NOT EXISTS (SELECT * FROM SMControlHost WHERE ControlHostId = @x_controlHostId)
	BEGIN
		SELECT	2, 'Control Host Id given in SMMapSnapArrayEntries SQL SP is not valid'
		RETURN
	END
	INSERT INTO @SnapIdTbl
		SELECT SMSnapId FROM SMSnap WITH (NOLOCK) WHERE ControlHostId = @x_controlHostId AND ArrayVolumeId = 0
END
IF @x_validFlags & 2 = 2
BEGIN
	SET @x_snapJobId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMMapSnapArrayEntries/SnapJobId') R(ref)), 0)
	IF @x_snapJobId = 0
	BEGIN
		SELECT	3, 'Snap Job Id is set as valid in SMMapSnapArrayEntries SQL SP but it is zero.'
		RETURN
	END
	INSERT INTO @snapIdTbl
		SELECT snap.SMSnapId
		FROM SMSnap AS snap
			INNER JOIN SMVolSnapMap AS map
				ON map.SMSnapId = snap.SMSnapId
				AND snap.ArrayVolumeId = 0
			INNER JOIN SMVolume AS vol
				ON vol.SMVolumeId = map.SMVolumeId
				AND vol.JobId = @x_snapJobId
END
IF @x_validFlags & 4 = 4
BEGIN
	SET @x_snapId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMMapSnapArrayEntries/SnapId') R(ref)), 0)
	IF @x_snapId = 0
	BEGIN
		SELECT	4, 'Snap Id is set as valid in SMMapSnapArrayEntries SQL SP but it is zero.'
		RETURN
	END
	INSERT INTO @snapIdTbl VALUES(@x_snapId)
END
DECLARE @SMMapArrayEntries INT
SET @SMMapArrayEntries = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION SMMapArrayEntries
		SET @SMMapArrayEntries = 1
	END
	DECLARE snap_cursor CURSOR FOR
		SELECT snapId FROM @SnapIdTbl
	OPEN snap_cursor
	FETCH NEXT FROM snap_cursor INTO @x_snapId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @UpdateTime DATETIME = GETDATE()
		DECLARE @MetaData XML = NULL
		SELECT @MetaData = md.MetaData
			FROM SMSnap snap WITH (NOLOCK)
				INNER JOIN SMMetaData md WITH (NOLOCK) ON
					snap.SMSnapId = @x_snapId
					AND md.RefId = snap.SMSnapId
					AND md.RefType = 2 --identify snap
					AND	md.MetaDataType = 29 --snapvault/snapmirror snap
		IF (@MetaData IS NULL) --Snap Vault or Mirror is not found, try to get primary snap info
		BEGIN
			SELECT @MetaData = md.MetaData
				FROM SMSnap snap WITH (NOLOCK)
					INNER JOIN SMMetaData md WITH (NOLOCK) ON
						snap.SMSnapId = @x_snapId
						AND md.RefId = snap.SMSnapId
						AND md.RefType = 2 --identify snap
						AND	md.MetaDataType = 6 --snap uid
		END
		IF (@MetaData IS NULL) --Snap or MetaData not Found, continue with next SnapId
			GOTO SNAP_END
		DECLARE @MetaDataRows AS TABLE (Id INTEGER, Data VARCHAR(MAX))
		INSERT INTO @MetaDataRows
			SELECT Id, Data FROM dbo.SplitString(CAST(@MetaData AS VARCHAR(MAX)), '|')
		--Pick up Array Id
		DECLARE @ArrayId INTEGER = NULL
		DECLARE @ArrayClientId INTEGER = NULL
		DECLARE @ArrayName VARCHAR(MAX) = NULL
		SELECT @ArrayName = Data FROM @MetaDataRows WHERE Id = 1
		SELECT @ArrayId = Id, @ArrayClientId = ClientId FROM SMArray WITH (NOLOCK)
			WHERE ArrayName = @ArrayName
			AND DeleteTime IS NULL
		IF (@ArrayId IS NULL) --Rare case, shouldn't happen
			GOTO SNAP_END
		--Pick up Array Volume Id, Add entry if not found
		DECLARE @ArrayVolId INTEGER = NULL
		DECLARE @ArrayVolName VARCHAR(MAX) = NULL
		SELECT @ArrayVolName = Data FROM @MetaDataRows WHERE Id = 2
		DECLARE @ArrayVolPathTmp VARCHAR(MAX) = NULL
		SELECT @ArrayVolPathTmp = Data FROM @MetaDataRows WHERE Id = 4
		DECLARE @ArrayVolPath VARCHAR(MAX) = NULL
		SELECT @ArrayVolPath= COALESCE(@ArrayVolPath + '/', '') + Data FROM dbo.SplitString(@ArrayVolPathTmp, '/') WHERE Id IN (1, 2, 3)
		SELECT @ArrayVolId = Id FROM SMArrayVolume WITH (NOLOCK)
			WHERE Name = @ArrayVolName
			AND ClientID = @ArrayClientId
		IF (@ArrayVolId IS NULL)
			BEGIN
				INSERT INTO SMArrayVolume(ClientId, Name, Path) VALUES(@ArrayClientId, @ArrayVolName, @ArrayVolPath)
				SELECT @ArrayVolId = @@IDENTITY
			END
		ELSE
			BEGIN
				UPDATE SMArrayVolume SET Path = @ArrayVolPath, UpdateTime = @UpdateTime, DeleteTime = NULL WHERE Id = @ArrayVolId
			END
		--Add LUN entry if not found
		DECLARE @LunId INTEGER = NULL
		DECLARE @Path VARCHAR(MAX) = NULL
		SELECT @Path = Data FROM @MetaDataRows WHERE Id = 4
		IF ((SELECT COUNT(*) FROM dbo.SplitString(@Path, '/')) IN (4, 5)) --current snap is taken for a LUN
		BEGIN
			SELECT @LunId = Id FROM SMLUN WITH (NOLOCK)
				WHERE Path = @Path
				AND ArrayVolumeId = @ArrayVolId
			IF (@LunId IS NULL)
				BEGIN
					INSERT INTO SMLUN(ArrayVolumeId, Path) VALUES(@ArrayVolId, @Path)
					SELECT @LunId = @@IDENTITY
				END
			ELSE
				BEGIN
					UPDATE SMLUN SET UpdateTime = @UpdateTime, DeleteTime = NULL WHERE Id = @LunId
				END
		END
		--Update SMSnap's Array Volume
		--Update SMSnap SET ArrayVolumeId = @ArrayVolId, LunId = ISNULL(@LunId, 0) WHERE SMSnapId = @x_snapId
		SNAP_END:
		FETCH NEXT FROM snap_cursor INTO @x_snapId
	END
	CLOSE snap_cursor
	DEALLOCATE snap_cursor
	IF (@SMMapArrayEntries = 1)
		BEGIN
			COMMIT TRANSACTION SMMapArrayEntries
			SET @SMMapArrayEntries = 0
		END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0 AND @SMMapArrayEntries = 1)
		BEGIN
			ROLLBACK TRANSACTION SMMapArrayEntries
			SET  @SMMapArrayEntries = 0
		END
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SMMapSnapArrayEntries')
	delete from GxQscripts where name = 'SMMapSnapArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMMapSnapArrayEntries')
	delete from GXDBVersions where aliasname = 'SMMapSnapArrayEntries'
GO

insert into GXDBVersions values(2, 'SMMapSnapArrayEntries',  '00010013004000020000', 'SMMapSnapArrayEntries', '00010013004000020000')
GO

