

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetMediaAgentsForCleanupCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetMediaAgentsForCleanupCheck <<<'

IF EXISTS (select * from sysobjects where name='SMGetMediaAgentsForCleanupCheck')
	drop procedure SMGetMediaAgentsForCleanupCheck
IF EXISTS (select * from GxQscripts where name='SMGetMediaAgentsForCleanupCheck')
	delete from GxQscripts where name = 'SMGetMediaAgentsForCleanupCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetMediaAgentsForCleanupCheck')
	delete from GXDBVersions where aliasname = 'SMGetMediaAgentsForCleanupCheck'
GO
print '... Creating Procedure: SMGetMediaAgentsForCleanupCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetMediaAgentsForCleanupCheck
  @dummy integer
AS
  DECLARE @o_smVolumeId integer
  DECLARE @o_smVolActionId integer
  DECLARE @o_mountHostId integer
  DECLARE @o_mountStatus integer
  DECLARE @o_cvmaProcessID integer
  DECLARE @o_cvmaThreadID integer
  DECLARE @o_bMoreVolumesForRegularUnmount integer
declare  @tblVolListForCleanupCheck table
(
	smVolumeId		integer,
	smVolActionId	integer,
	mountHostId		integer,
	mountStatus		integer,
	cvmaProcessID	integer,
	cvmaThreadID	integer,
	updateTime		integer,
	expirationTime	integer,
	checkCount		integer
)
-- get all the volumes that are currently being processed for other snap operations in running, waiting and suspended states.
declare  @tblRunningVol table (smVolumeId integer)
insert into @tblRunningVol
select distinct smvolumeID
from SMSnapResource A with (nolock) , JMJobInfo B with (nolock)
where A.JobId = B.jobId
and B.state in (1,3,5)
-- insert to the table the volumes that are eligible for unmount, that includes mounted, partially mounted and partially unmounted.
insert into @tblVolListForCleanupCheck
select A.SMVolumeId, B.SMVolActionId, A.MountHostId, A.MountStatus, B.CVMAProcessId, B.CVMAThreadId,0,0,B.CheckCount
from SMVolume A with (nolock), SMVolAction B with (nolock)
where A.SMVolumeId = B.SMVolumeId
and  A.MountStatus > 40 and MountStatus < 79
and A.SMVolumeId not in (select T.smVolumeId from @tblRunningVol T)
-- smvolaction IDs for which check count is non-zero, expiration time should be based on Check Expiry Interval In SMSnapShotEngine and Modify Time.
update @tblVolListForCleanupCheck
set expirationTime = E.ModifyTime + D.CleanupCheckExpiryInterval
from @tblVolListForCleanupCheck A, SMVolSnapMap B with (nolock), SMSnap C with (nolock), SMSnapShotEngine D with (nolock), SMVolAction E with (nolock)
where A.smVolumeId = B. SMVolumeId and B.SMSnapId = C.SMSnapId and C.SnapShotEngineId = D.SnapShotEngineId
and A.CheckCount > 0
-- smVolActionIDs for which check count is zero, the first check message should be sent at MountStatusUpdateTime + MountStatusUpdateExpiryInterval
update @tblVolListForCleanupCheck
set expirationTime = F.MountStatusUpdateTime + D.MountStatusUpdateExpiryInterval
from @tblVolListForCleanupCheck A, SMVolSnapMap B with (nolock), SMSnap C with (nolock), SMSnapShotEngine D with (nolock), SMVolAction E with (nolock),
SMVolume F with (nolock)
where F.smvolumeId = A.smvolumeId and A.smVolumeId = B. SMVolumeId and B.SMSnapId = C.SMSnapId and C.SnapShotEngineId = D.SnapShotEngineId
and A.CheckCount = 0
declare @checkRequestCount integer = 0
select @checkRequestCount = count(*)
from @tblVolListForCleanupCheck where expirationTime < dbo.GetUnixTime(GetUTCDate())
declare @totalTableRowCount integer = 0
select count(*) from @tblVolListForCleanupCheck
if(@checkRequestCount < @totalTableRowCount)
BEGIN
	select smVolumeId,smVolActionId,mountHostId,mountStatus,cvmaProcessID,cvmaThreadID, 1 from @tblVolListForCleanupCheck where expirationTime < dbo.GetUnixTime(GetUTCDate())
END
ELSE
BEGIN
	select smVolumeId,smVolActionId,mountHostId,mountStatus,cvmaProcessID,cvmaThreadID, 0 from @tblVolListForCleanupCheck where expirationTime < dbo.GetUnixTime(GetUTCDate())
END

IF EXISTS (select * from GxQscripts where name = 'SMGetMediaAgentsForCleanupCheck')
	delete from GxQscripts where name = 'SMGetMediaAgentsForCleanupCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetMediaAgentsForCleanupCheck')
	delete from GXDBVersions where aliasname = 'SMGetMediaAgentsForCleanupCheck'
GO

insert into GXDBVersions values(2, 'SMGetMediaAgentsForCleanupCheck',  '00000000000000000000', 'SMGetMediaAgentsForCleanupCheck', '00000000000000000000')
GO

