

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetDataSetsOfStoragePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetDataSetsOfStoragePolicy.sp,v $ $Id: SMGetDataSetsOfStoragePolicy.sp,v 1.3.42.4 2018/03/19 23:59:35 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetDataSetsOfStoragePolicy <<<'

IF EXISTS (select * from sysobjects where name='SMGetDataSetsOfStoragePolicy')
	drop procedure SMGetDataSetsOfStoragePolicy
IF EXISTS (select * from GxQscripts where name='SMGetDataSetsOfStoragePolicy')
	delete from GxQscripts where name = 'SMGetDataSetsOfStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetDataSetsOfStoragePolicy')
	delete from GXDBVersions where aliasname = 'SMGetDataSetsOfStoragePolicy'
GO
print '... Creating Procedure: SMGetDataSetsOfStoragePolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetDataSetsOfStoragePolicy
  @i_archGroupId INTEGER
AS
  DECLARE @o_StoragePolicyId INTEGER
  DECLARE @o_DFMHostName NVARCHAR(1024)
  DECLARE @o_DataSetId NVARCHAR(512)
  DECLARE @o_RelationId NVARCHAR(512)
  DECLARE @o_StoragePolicyCopyId INTEGER
  DECLARE @o_MediaAgentId INTEGER
SET NOCOUNT ON
	SELECT		AG.id AS StoragePolicyId,
				HOST.SMArrayId AS DFMHostName,
				DATASET.ExtDataSetId AS DataSetId,
				REL.ExtRelationId AS RelationId,
				AGC.copy,
				MMDP.HostClientId AS MediaAgentId
	FROM		ArchGroupControlHost(NOLOCK) AG_HOST
				INNER JOIN SMControlHost(NOLOCK) HOST ON AG_HOST.ControlHostId = HOST.ControlHostId
				INNER JOIN SMRelation(NOLOCK) REL ON REL.ControlHostId = AG_HOST.ControlHostId
				INNER JOIN archGroup(NOLOCK) AG ON AG_HOST.ArchGroupId = AG.id
				INNER JOIN archGroupCopy(NOLOCK) AGC ON AGC.archGroupId = AG_HOST.ArchGroupId
				INNER JOIN MMDataPath(NOLOCK) MMDP
					ON MMDP.CopyId = AGC.id
					AND MMDP.Flag = 7 -- default path MA
				INNER JOIN SMCopyToRelationMap(NOLOCK) MAP
					ON MAP.SMRelationId = REL.SMRelationId
					AND MAP.ArchGroupCopyId = AGC.id
				INNER JOIN APP_Application(NOLOCK) APP ON (APP.dataArchGrpId = AG_HOST.ArchGroupId)
				INNER JOIN APP_Client(NOLOCK) CLIENT ON CLIENT.id = APP.clientId
				INNER JOIN SMDataSetToSubClientMap(NOLOCK) DS
					ON DS.SMRelationId = MAP.SMRelationId
					AND DS.AppId = APP.id
AND (DS.Flags & 512) = 0
				INNER JOIN SMDataSet(NOLOCK) DATASET ON DATASET.DataSetId = DS.DataSetId
				LEFT OUTER JOIN APP_Client(NOLOCK) MACLIENT
					ON MACLIENT.id = MMDP.HostClientId
	WHERE		AG.id = @i_archGroupId
				AND MACLIENT.releaseId >= 16
				--AND AG_HOST.SMReplicationProtocolType = 0 -- NON LREP
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetDataSetsOfStoragePolicy')
	delete from GxQscripts where name = 'SMGetDataSetsOfStoragePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetDataSetsOfStoragePolicy')
	delete from GXDBVersions where aliasname = 'SMGetDataSetsOfStoragePolicy'
GO

insert into GXDBVersions values(2, 'SMGetDataSetsOfStoragePolicy',  '00010003004200040000', 'SMGetDataSetsOfStoragePolicy', '00010003004200040000')
GO

