

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetConflictingArrayInfo.sp] ---------- 

-- 	+------------------------------------------------------------------------------------------+
--	| 			Procedure : "SMGetConflictingArrayInfo"
--	|	This Procedure is used to get the list of conflicting arrays in a MultiSite environment
-- 	+------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SMGetConflictingArrayInfo')
BEGIN
	print '>>> Drop Stored Procedure: SMGetConflictingArrayInfo <<<'
	drop procedure SMGetConflictingArrayInfo
END
IF EXISTS (select * from GxQscripts where name='SMGetConflictingArrayInfo')
	delete from GxQscripts where name = 'SMGetConflictingArrayInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetConflictingArrayInfo')
	delete from GXDBVersions where aliasname = 'SMGetConflictingArrayInfo'
GO
print '... Creating Procedure: SMGetConflictingArrayInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetConflictingArrayInfo
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_ArrayId INTEGER
  DECLARE @o_ArrayName NVARCHAR(1024)
  DECLARE @o_ClientId INTEGER
  DECLARE @o_ClientName NVARCHAR(1024)
  DECLARE @o_ConflictArrayId INTEGER
  DECLARE @o_ConflictingArrayName NVARCHAR(1024)
  DECLARE @o_ConflictingClientId INTEGER
  DECLARE @o_ConflictingClientName NVARCHAR(1024)
  DECLARE @o_AliasName NVARCHAR(MAX)
BEGIN
SET NOCOUNT ON
DECLARE @conflictArrayInfo TABLE
(
	ArrayId INTEGER,
	ArrayName NVARCHAR(1024),
	ClientId INTEGER,
	ClientName NVARCHAR(1024),
	ConflictingArrayId INTEGER,
	ConflictingArrayName NVARCHAR(1024),
	ConflictingClientId INTEGER,
	ConflictingClientName NVARCHAR(1024),
	ConflictingArrayList NVARCHAR(MAX)
)
INSERT INTO @conflictArrayInfo
SELECT	T1.RefId,
		CHOST.SMArrayId,
		CHOST.ClientId,
		CLIENT.name,
		T2.RefId,
		NULL,
		0,
		NULL,
		T2.AliasName
FROM
(SELECT DISTINCT RefId, AliasName FROM SMHostAlias WHERE AliasName IN(
SELECT AliasName FROM SMHostAlias GROUP BY AliasName HAVING COUNT(*) > 1)) T1
INNER JOIN SMHostAlias T2 ON T1.AliasName = T2.AliasName AND T1.RefId != T2.Refid
INNER JOIN SMControlHost CHOST ON T1.RefId = CHOST.ControlHostId
INNER JOIN APP_Client CLIENT ON CHOST.ClientId = CLIENT.id
IF EXISTS (SELECT 1 FROM @conflictArrayInfo)
BEGIN
	--Update the conflicting arrayname and client details
	UPDATE TEMP1
	SET ConflictingArrayName = CHOST.SMArrayId, ConflictingClientId = CHOST.ClientId
	FROM @conflictArrayInfo TEMP1 INNER JOIN SMControlHost CHOST ON TEMP1.ConflictingArrayId = CHOST.ControlHostId
	UPDATE TEMP1
	SET ConflictingClientName = CLIENT.name
	FROM @conflictArrayInfo TEMP1 INNER JOIN App_Client CLIENT ON TEMP1.ConflictingClientId = CLIENT.Id
	SELECT	T1.ArrayId,
			T1.ArrayName,
			T1.ClientId,
			T1.ClientName,
			T1.ConflictingArrayId,
			T1.ConflictingArrayName,
			T1.ConflictingClientId,
			T1.ConflictingClientName,
			STUFF((SELECT '| ' + T2.ConflictingArrayList
					FROM @conflictArrayInfo T2
					WHERE  T1.ArrayId = T2.ArrayId
					FOR XML PATH('')), 1, 1, '') [Conflicting Aliases]
	FROM @conflictArrayInfo T1
	GROUP BY T1.ArrayId, T1.ArrayName,T1.ClientId,T1.ClientName, T1.ConflictingArrayId, T1.ConflictingArrayName, T1.ConflictingClientId, T1.ConflictingClientName
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetConflictingArrayInfo')
	delete from GxQscripts where name = 'SMGetConflictingArrayInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetConflictingArrayInfo')
	delete from GXDBVersions where aliasname = 'SMGetConflictingArrayInfo'
GO

insert into GXDBVersions values(2, 'SMGetConflictingArrayInfo',  '00000000000000000000', 'SMGetConflictingArrayInfo', '00000000000000000000')
GO

