

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayVolumes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayVolumes.sp,v $ $Id: SMGetArrayVolumes.sp,v 1.21 2013/11/14 09:09:19 dnavaneethan Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayVolumes <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayVolumes')
	drop procedure SMGetArrayVolumes
IF EXISTS (select * from GxQscripts where name='SMGetArrayVolumes')
	delete from GxQscripts where name = 'SMGetArrayVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayVolumes')
	delete from GXDBVersions where aliasname = 'SMGetArrayVolumes'
GO
print '... Creating Procedure: SMGetArrayVolumes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayVolumes
  @type integer,
  @Id integer,
  @deep integer
AS
  DECLARE @outputXML XML
DECLARE @arrayVolumeDetails		XML
DECLARE @arrayVolHostDetails		XML
DECLARE @arrayVolLUNDetails		xml
DECLARE @arrayVolSnapDetails		xml
IF ((@type <= 0) OR (@type >= 7) OR (@Id <= 0))
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
IF (@type = 3)
BEGIN
SET @arrayVolumeDetails =
	(	SELECT
			StoragePoolId AS [@storagePoolId],
			CASE (Flags & 1)
				WHEN 1 THEN 'Offline'
				ELSE 'Online'
			END AS [@status],
			TotalSpaceMB AS [@totalSpaceMB],
			FreeSpaceMB AS [@freeSpaceMB],
			UsedSpaceMB AS [@usedSpaceMB],
			dbo.GetUnixTime(UpdateTime) AS [@lastUpdateTime],
			properties AS [properties],
			Id AS [volumeEntity/@volumeId],
			107 AS [volumeEntity/@_type_],
			Name AS [volumeEntity/@volumeName]
		FROM SMArrayVolume WITH (NOLOCK)
		WHERE StoragePoolId = @Id AND Id > 0 AND DeleteTime IS NULL
		FOR XML PATH('volumes')
	)
END
IF (@type = 4)
BEGIN
	IF (@deep = 1)
	BEGIN
	SET @arrayVolHostDetails =
		(SELECT
		client.name AS [@clientName],
		snapTable.snapshotCount AS [@snapshotCount],
		snapTable.snapshotusedspacebytes AS [@snapshotUsedSpaceBytes],
		luntable.lunCount AS [@lunCount]
		FROM
		(SELECT
			sub.[clientId] AS [clientId],
			COUNT(sub.[UniqueIdentifier]) AS [snapshotCount],
			SUM(sub.[snapshotusedspacebytes]) AS [snapshotUsedSpaceBytes]
		 FROM
			(SELECT
				ctrlHost.ClientId AS [clientId],
				snap.UniqueIdentifier AS [UniqueIdentifier],
				snap.UsedSpaceBytes AS [snapshotUsedSpaceBytes]
			 FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsmap.SMSnapId = snap.SMSnapId
					AND snap.ArrayVolumeId = @Id
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId = 13
				INNER JOIN SMControlHost AS ctrlHost WITH (NOLOCK)
					ON ctrlHost.ControlHostId = snap.ControlHostId
			 UNION
			 SELECT
				vol.SourceClientId AS [clientId],
				snap.UniqueIdentifier AS [UniqueIdentifier],
				snap.UsedSpaceBytes AS [snapshotUsedSpaceBytes]
			 FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsmap.SMSnapId = snap.SMSnapId
					AND snap.ArrayVolumeId = @Id
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId <> 13) AS sub
		GROUP BY sub.[clientId]) AS snapTable
		FULL OUTER JOIN
		(SELECT
			sub.[clientId] AS [clientId],
			sub.[lunCount] AS [lunCount]
		 FROM
			(SELECT
				ctrlHost.ClientId AS [clientId],
				COUNT (DISTINCT lun.Id) AS [lunCount]
			 FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMArrayVolume AS ArrayVol WITH (NOLOCK)
					ON ArrayVol.Id = snap.ArrayVolumeId
					AND ArrayVol.Id = @Id
					AND ArrayVol.DeleteTime IS NULL
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsmap.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId = 13
				INNER JOIN SMLUN AS lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = ArrayVol.Id
					AND lun.DeleteTime IS NULL
					AND snap.LunId = lun.Id
				INNER JOIN SMControlHost AS ctrlHost WITH (NOLOCK)
					ON ctrlHost.ControlHostId = snap.ControlHostId
			 GROUP BY ctrlHost.ClientId
			 UNION
			 SELECT
				vol.SourceClientId AS [clientId],
				COUNT (DISTINCT lun.Id) AS [lunCount]
			 FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMArrayVolume AS ArrayVol WITH (NOLOCK)
					ON ArrayVol.Id = snap.ArrayVolumeId
					AND ArrayVol.Id = @Id
					AND ArrayVol.DeleteTime IS NULL
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsmap.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId <> 13
				INNER JOIN SMLUN AS lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = ArrayVol.Id
					AND lun.DeleteTime IS NULL
					AND snap.LunId = lun.Id
			GROUP BY vol.SourceClientId) AS sub) AS luntable
			ON snapTable.clientId = luntable.clientId
		INNER JOIN App_Client AS client WITH (NOLOCK)
			ON client.id = snapTable.clientId
		FOR XML PATH('hostDetails'))
	SET @arrayVolLUNDetails =
		(	SELECT
				lun.Id AS [@id],
				lun.Name AS [@name],
				lun.Path AS [@path],
				CASE (lun.Flags & 1)
					WHEN 1 THEN 'Offline'
					ELSE 'Online'
				END AS [@status],
				lun.TotalSpaceBytes AS [@totalSpaceBytes],
				lun.UsedSpaceBytes AS [@usedSpaceBytes],
				lun.FreeSpaceBytes AS [@freeSpaceBytes],
				lun.Description AS [@description]
			FROM SMLUN AS lun WITH (NOLOCK)
			WHERE ArrayVolumeId = @Id AND lun.DeleteTime IS NULL
			FOR XML PATH('lunDetails')
		)
	SET @arrayVolSnapDetails =
		(	SELECT
				SMSnapId AS [@smSnapId],
				CreationTime AS [@creationTime],
				UniqueIdentifier AS [@uniqueIdentifier],
				ReserveFieldStr AS [@reserveFieldStr],
				UsedSpaceBytes AS [@usedSpaceBytes],
				ArrayVolumeId AS [@arrayVolumeId]
			FROM SMSnap WITH (NOLOCK)
			WHERE ArrayVolumeId = @Id
			FOR XML PATH('snapDetails')
		)
	END
	DECLARE @totalSnapSpace	BIGINT = 0
	DECLARE @totalSnapCount	BIGINT = 0
	SELECT @totalSnapSpace = SUM(sub.UsedSpaceBytes), @totalSnapCount = COUNT(sub.UniqueIdentifier)
		FROM (SELECT DISTINCT UniqueIdentifier, UsedSpaceBytes FROM SMSnap WHERE ArrayVolumeId = @Id) AS sub
	SET @arrayVolumeDetails =
	(	SELECT
			StoragePoolId AS [@storagePoolId],
			CASE (Flags & 1)
				WHEN 1 THEN 'Offline'
				ELSE 'Online'
			END AS [@status],
			TotalSpaceMB AS [@totalSpaceMB],
			FreeSpaceMB AS [@freeSpaceMB],
			UsedSpaceMB AS [@usedSpaceMB],
			@totalSnapSpace AS [@snapshotUsedSpaceBytes],
			@totalSnapCount AS [@snapProtectSnapshotCount],
			dbo.GetUnixTime(UpdateTime) AS [@lastUpdateTime],
			properties AS [properties],
			Id AS [volumeEntity/@volumeId],
			107 AS [volumeEntity/@_type_],
			Name AS [volumeEntity/@volumeName],
			@arrayVolHostDetails,
			@arrayVolLUNDetails,
			@arrayVolSnapDetails
		FROM SMArrayVolume WITH (NOLOCK)
		WHERE Id = @Id AND DeleteTime IS NULL
		FOR XML PATH('volumes')
	)
END
SELECT @arrayVolumeDetails FOR XML PATH('EVGui_GetArrayVolumesResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayVolumes')
	delete from GxQscripts where name = 'SMGetArrayVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayVolumes')
	delete from GXDBVersions where aliasname = 'SMGetArrayVolumes'
GO

insert into GXDBVersions values(2, 'SMGetArrayVolumes',  '00010021000000000000', 'SMGetArrayVolumes', '00010021000000000000')
GO

