

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayStoragePools.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayStoragePools.sp,v $ $Id: SMGetArrayStoragePools.sp,v 1.7 2012/01/24 08:17:13 vimalkumar Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayStoragePools <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayStoragePools')
	drop procedure SMGetArrayStoragePools
IF EXISTS (select * from GxQscripts where name='SMGetArrayStoragePools')
	delete from GxQscripts where name = 'SMGetArrayStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayStoragePools')
	delete from GXDBVersions where aliasname = 'SMGetArrayStoragePools'
GO
print '... Creating Procedure: SMGetArrayStoragePools'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayStoragePools
  @type integer,
  @controlHostId integer
AS
  DECLARE @arrayStoragePoolDetails xml
IF ( @type<>1 OR @controlHostId <= 0)
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
DECLARE @controlHostClientId INTEGER
SELECT @controlHostClientId = ClientId FROM SMControlHost WITH (NOLOCK) WHERE ControlHostId = @controlHostId
SET @arrayStoragePoolDetails =
	(	SELECT
			TotalSpaceMB AS [@totalSpaceMB],
			UsedSpaceMB AS [@usedSpaceMB],
			FreeSpaceMB AS [@freeSpaceMB],
			volumeCount AS [@volumeCount],
			CASE (Flags & 1)
				WHEN 1 THEN 'Offline'
				ELSE 'Online'
			END AS [@status],
			dbo.GetUnixTime(UpdateTime) AS [@lastUpdateTime],
			Properties AS [properties],
			Id AS [storagePoolEntity/@storagePoolId],
			108 AS [storagePoolEntity/@_type_],
			Name AS [storagePoolEntity/@storagePoolName]
		FROM SMStoragePool WITH (NOLOCK)
		WHERE ClientId = @controlHostClientId AND DeleteTime IS NULL
		FOR XML PATH('storagePools')
	)
SELECT @arrayStoragePoolDetails FOR XML PATH('EVGui_GetArrayStoragePoolsResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayStoragePools')
	delete from GxQscripts where name = 'SMGetArrayStoragePools'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayStoragePools')
	delete from GXDBVersions where aliasname = 'SMGetArrayStoragePools'
GO

insert into GXDBVersions values(2, 'SMGetArrayStoragePools',  '00010007000000000000', 'SMGetArrayStoragePools', '00010007000000000000')
GO

