

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayMediaAgents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayMediaAgents.sp,v $ $Id: SMGetArrayMediaAgents.sp,v 1.16 2012/01/24 08:17:13 vimalkumar Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayMediaAgents <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayMediaAgents')
	drop procedure SMGetArrayMediaAgents
IF EXISTS (select * from GxQscripts where name='SMGetArrayMediaAgents')
	delete from GxQscripts where name = 'SMGetArrayMediaAgents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayMediaAgents')
	delete from GXDBVersions where aliasname = 'SMGetArrayMediaAgents'
GO
print '... Creating Procedure: SMGetArrayMediaAgents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetArrayMediaAgents
  @i_xmlText XML
-- Input
AS
  DECLARE @arrayMediaAgentDetails xml
DECLARE @i_scope				NVARCHAR(MAX)
DECLARE @i_arrayId				INT
DECLARE @i_mediaAgentId			INT
SET	@i_scope 	= ISNULL( (SELECT ref.value('@deep', 'NVARCHAR(MAX)')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayMediaAgentsReq') R(ref)),0)
SET	@i_arrayId = ISNULL ( (SELECT ref.value('@arrayControlId', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayMediaAgentsReq') R(ref)), 0)
SET	@i_mediaAgentId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayMediaAgentsReq/mediaAgent') R(ref)), 0)
IF ( @i_scope = 0 )
BEGIN
	SELECT @arrayMediaAgentDetails =
	(
		SELECT DISTINCT
			sub.clientId AS [mediaAgent/@clientId],
			sub.clientName AS [mediaAgent/@clientName],
			sub.hostName AS [mediaAgent/@hostname]
		FROM
		(
			SELECT
				c.id [clientId],
				c.name AS [clientName],
				c.csHostName AS [hostName]
			FROM SMArrayMountPathMap AS mpMap WITH (NOLOCK)
			INNER JOIN SMArrayVolume AS vol WITH (NOLOCK)
					ON mpMap.Flags & 1 = 1
					AND mpMap.ArrayVolumeId = vol.Id
					AND mpMap.LunId = 0
					AND mpMap.DeleteTime IS NULL
					AND vol.DeleteTime IS NULL
			INNER JOIN SMArray AS array WITH (NOLOCK)
					ON array.ClientId = vol.ClientId
					AND array.DeleteTime IS NULL
			INNER JOIN SMArrayCtrlHostMap AS csMap WITH (NOLOCK)
					ON csMap.ArrayId = array.Id
			INNER JOIN SMControlHost AS cs WITH (NOLOCK)
					ON cs.ControlHostId = csMap.ControlHostId
					AND cs.ControlHostId = @i_arrayId
			INNER JOIN MMMountPathToStorageDevice AS mpsd
					ON mpsd.MountPathId = mpMap.MountPathId
			INNER JOIN MMDeviceController AS dc
					ON dc.DeviceId = mpsd.DeviceId
			INNER JOIN APP_Client as c WITH (NOLOCK)
					ON c.id = dc.ClientId
		UNION
			SELECT
				c.id [clientId],
				c.name AS [clientName],
				c.csHostName AS [hostName]
			FROM SMArrayMountPathMap AS mpMap WITH (NOLOCK)
			INNER JOIN SMLUN AS lun WITH (NOLOCK)
					ON mpMap.Flags & 1 <> 1
					AND mpMap.LunId = lun.Id
					AND mpMap.DeleteTime IS NULL
					AND lun.DeleteTime IS NULL
			INNER JOIN SMArrayVolume AS vol WITH (NOLOCK)
					ON vol.Id = lun.ArrayVolumeId
					AND vol.DeleteTime IS NULL
			INNER JOIN SMArray AS array WITH (NOLOCK)
					ON array.ClientId = vol.ClientId
					AND array.DeleteTime IS NULL
			INNER JOIN SMArrayCtrlHostMap AS csMap WITH (NOLOCK)
					ON csMap.ArrayId = array.Id
			INNER JOIN SMControlHost AS cs WITH (NOLOCK)
					ON cs.ControlHostId = csMap.ControlHostId
					AND cs.ControlHostId = @i_arrayId
			INNER JOIN MMMountPathToStorageDevice AS mpsd
					ON mpsd.MountPathId = mpMap.MountPathId
			INNER JOIN MMDeviceController AS dc
					ON dc.DeviceId = mpsd.DeviceId
			INNER JOIN APP_Client as c WITH (NOLOCK)
					ON c.id = dc.ClientId
		) AS sub
		FOR XML PATH ('mediaAgentDetails')
	)
	SELECT @i_arrayId as [@arrayControlId],@arrayMediaAgentDetails FOR XML PATH('EVGui_GetArrayMediaAgentsResp')
END
ELSE
BEGIN
	DECLARE @volumeXML as XML
	SET @volumeXML =
	(SELECT
		(mSide.TotalSpaceMB - mSide.FreeBytesMB) AS [@usedSpaceMB],
		mSide.FreeBytesMB AS [@freeSpaceMB],
		( SELECT
	  		mpMap.MountPathId AS [@id],
			CASE
				WHEN (mPath.MountPathTypeId = 1)
					THEN mPath.MountPathName
				WHEN (mPath.MountPathTypeId IN (4, 5) AND (SUBSTRING(dc.Folder, LEN(dc.Folder), 1) NOT IN ('\', '/')))
					THEN dc.Folder + '\' + mPath.MountPathName
				WHEN (mPath.MountPathTypeId IN (4, 5) AND (SUBSTRING(dc.Folder, LEN(dc.Folder), 1) IN ('\', '/')))
					THEN dc.Folder + mPath.MountPathName
			END AS [@name]
		FOR XML PATH('mountPath'), TYPE),
		( SELECT
	  		vol.TotalSpaceMB AS [@totalSpaceMB],
			vol.UsedSpaceMB AS [@usedSpaceMB],
			vol.FreeSpaceMB AS [@freeSpaceMB],
		  	vol.Id  AS [volumeEntity/@volumeId],
	  		vol.Name  AS [volumeEntity/@volumeName]
		FOR XML PATH('volume'), TYPE),
		( SELECT
	  		library.LibraryId AS [@libraryId],
	  		library.AliasName AS [@libraryName]
		FOR XML PATH('libraryEntity'), TYPE)
	FROM
		SMArrayMountPathMap AS mpMap WITH (NOLOCK)
		INNER JOIN SMArrayVolume AS vol WITH (NOLOCK)
				ON mpMap.Flags & 1 = 1
				AND mpMap.ArrayVolumeId = vol.Id
				AND mpMap.LunId = 0
				AND mpMap.DeleteTime IS NULL
				AND vol.DeleteTime IS NULL
		INNER JOIN SMArray AS array WITH (NOLOCK)
				ON array.ClientId = vol.ClientId
				AND array.DeleteTime IS NULL
		INNER JOIN SMArrayCtrlHostMap AS csMap WITH (NOLOCK)
				ON csMap.ArrayId = array.Id
		INNER JOIN SMControlHost AS cs WITH (NOLOCK)
				ON cs.ControlHostId = csMap.ControlHostId
				AND cs.ControlHostId = @i_arrayId
		INNER JOIN MMMountPath AS mPath WITH (NOLOCK)
				ON mPath.MountPathId = mpMap.MountPathId
		INNER JOIN MMLibrary AS library WITH (NOLOCK)
				ON library.LibraryId = mPath.LibraryId
		INNER JOIN MMMediaSide AS mSide WITH (NOLOCK)
				ON mPath.MediaSideId = mSide.MediaSideId
		INNER JOIN MMMountPathToStorageDevice AS mpsd
			ON mpsd.MountPathId = mPath.MountPathId
		INNER JOIN MMDeviceController AS dc
			ON dc.DeviceId = mpsd.DeviceId
			AND dc.ClientId = @i_mediaAgentId
	FOR XML PATH('MountPathDetails'), TYPE)
	DECLARE @lunXML as XML
	SET @lunXML =
	(SELECT
		(mSide.TotalSpaceMB - mSide.FreeBytesMB) AS [@usedSpaceMB],
		mSide.FreeBytesMB AS [@freeSpaceMB],
		( SELECT
	  		mpMap.MountPathId AS [@id],
			CASE
				WHEN (mPath.MountPathTypeId = 1)
					THEN mPath.MountPathName
				WHEN (mPath.MountPathTypeId IN (4, 5) AND (SUBSTRING(dc.Folder, LEN(dc.Folder), 1) NOT IN ('\', '/')))
					THEN dc.Folder + '\' + mPath.MountPathName
				WHEN (mPath.MountPathTypeId IN (4, 5) AND (SUBSTRING(dc.Folder, LEN(dc.Folder), 1) IN ('\', '/')))
					THEN dc.Folder + mPath.MountPathName
			END AS [@name]
		FOR XML PATH('mountPath'), TYPE),
		( SELECT
		  	lun.Id AS [@id],
	  		lun.Path  AS [@path],
	  		lun.TotalSpaceBytes AS [@totalSpaceBytes],
			lun.UsedSpaceBytes AS [@usedSpaceBytes],
			lun.FreeSpaceBytes AS [@freeSpaceBytes]
		FOR XML PATH('lun'), TYPE),
		( SELECT
	  		library.LibraryId AS [@libraryId],
	  		library.AliasName AS [@libraryName]
		FOR XML PATH('libraryEntity'), TYPE)
	from
		SMArrayMountPathMap AS mpMap WITH (NOLOCK)
		INNER JOIN SMLUN AS lun WITH (NOLOCK)
				ON mpMap.Flags & 1 <> 1
				AND mpMap.LunId = lun.Id
				AND mpMap.DeleteTime IS NULL
				AND lun.DeleteTime IS NULL
		INNER JOIN SMArrayVolume AS vol WITH (NOLOCK)
				ON vol.Id = lun.ArrayVolumeId
				AND vol.DeleteTime IS NULL
		INNER JOIN SMArray AS array WITH (NOLOCK)
				ON array.ClientId = vol.ClientId
				AND array.DeleteTime IS NULL
		INNER JOIN SMArrayCtrlHostMap AS csMap WITH (NOLOCK)
				ON csMap.ArrayId = array.Id
		INNER JOIN SMControlHost AS cs WITH (NOLOCK)
				ON cs.ControlHostId = csMap.ControlHostId
				AND cs.ControlHostId = @i_arrayId
		INNER JOIN MMMountPath AS mPath WITH (NOLOCK)
				ON mPath.MountPathId = mpMap.MountPathId
		INNER JOIN MMLibrary AS library WITH (NOLOCK)
				ON library.LibraryId = mPath.LibraryId
		INNER JOIN MMMediaSide AS mSide WITH (NOLOCK)
				ON mPath.MediaSideId = mSide.MediaSideId
		INNER JOIN MMMountPathToStorageDevice AS mpsd
			ON mpsd.MountPathId = mPath.MountPathId
		INNER JOIN MMDeviceController AS dc
			ON dc.DeviceId = mpsd.DeviceId
			AND dc.ClientId = @i_mediaAgentId
	FOR XML PATH('MountPathDetails'), TYPE)
	SET @arrayMediaAgentDetails =
	( SELECT
		@volumeXML AS "*", @lunXML AS "*"
		FOR XML PATH('mediaAgentDetails') )
	SELECT @i_arrayId as [@arrayControlId],@arrayMediaAgentDetails FOR XML PATH('EVGui_GetArrayMediaAgentsResp')
END
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayMediaAgents')
	delete from GxQscripts where name = 'SMGetArrayMediaAgents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayMediaAgents')
	delete from GXDBVersions where aliasname = 'SMGetArrayMediaAgents'
GO

insert into GXDBVersions values(2, 'SMGetArrayMediaAgents',  '00010016000000000000', 'SMGetArrayMediaAgents', '00010016000000000000')
GO

