

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayEntries.sp,v $ $Id: SMGetArrayEntries.sp,v 1.19.12.8 2018/12/19 23:57:52 macharya Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SMGetArrayEntries')
BEGIN
	print '>>> Drop Stored Procedure: SMGetArrayEntries <<<'
	drop procedure SMGetArrayEntries
END
IF EXISTS (select * from GxQscripts where name='SMGetArrayEntries')
	delete from GxQscripts where name = 'SMGetArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayEntries')
	delete from GXDBVersions where aliasname = 'SMGetArrayEntries'
GO
print '... Creating Procedure: SMGetArrayEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetArrayEntries
  @i_xmlTextInput XML,
  @i_reserveParam INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_Type INTEGER
  DECLARE @o_Id INTEGER
  DECLARE @o_Str VARCHAR(1024)
  DECLARE @o_MediaAgentId INTEGER
  DECLARE @o_SnapEngineId INTEGER
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
/* Input XML Format
	<SMGetArrayEntries>
		<ValidFlags></ValidFlags>
		<ControlHostId></ControlHostId>
		<ArrayId></ArrayId>
		<MapArrayEntries></MapArrayEntries>
	</SMGetArrayEntries>
*/
DECLARE @resultTable TABLE (idtmp integer IDENTITY(1,1) PRIMARY KEY CLUSTERED,Type INTEGER, Id INTEGER, MountPath VARCHAR(1024), MAId INTEGER,SEId INTEGER)
/*
Type = 0 :- Media Agent
Type = 1 :- Mount Path
Type = 5 :- Control Host
Type = 6 :- Array
Type = 7 :- Storage Pool
Type = 8 :- Array Volume
Type = 9 :- LUN
Type = 2 :- Snap
*/
DECLARE @mediaAgentType INTEGER = 0
DECLARE @mountPathType INTEGER = 1
DECLARE @controlHostType INTEGER = 5
DECLARE @arrayType INTEGER = 6
DECLARE @storagePoolType INTEGER = 7
DECLARE @arrayVolumeType INTEGER = 8
DECLARE @lunType INTEGER = 9
DECLARE @snapType INTEGER = 2
DECLARE @x_validFlags INTEGER
DECLARE @x_controlHostId INTEGER
DECLARE @x_snapJobId BIGINT
DECLARE @x_doMapping INTEGER = 1
DECLARE @CVSM_CTRLHOST_7MODE_FILER_DB INTEGER = 16
DECLARE @tblInputArrays TABLE (ArrayId INT)
SET @x_validFlags = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMGetArrayEntries/ValidFlags') R(ref)), 0)
IF (@x_validFlags = 0)
BEGIN
	SELECT	0, 0, '', 0, 1, 'Valid Flags used to SMGetArrayEntries SQL SP is zero.'
	RETURN
END
IF (@x_validFlags & 1 = 1)
BEGIN
	SET @x_controlHostId = ISNULL(( SELECT R.ref.value('.', 'int') FROM @i_xmlTextInput.nodes('/SMGetArrayEntries/ControlHostId') R(ref)), 0)
	IF (NOT EXISTS (SELECT * FROM SMControlHost WITH (NOLOCK) WHERE ControlHostId = @x_controlHostId))
	BEGIN
		SELECT	0, 0, '', 0, 2, 'Control Host Id given in SMGetArrayEntries SQL SP is not valid'
		RETURN
	END
END
IF (@x_validFlags & 4 = 4)
BEGIN
	INSERT INTO @tblInputArrays
	SELECT ref.value('.', 'int')
	FROM @i_xmlTextInput.nodes('/SMGetArrayEntries/ArrayId') R(ref)
	IF NOT EXISTS (SELECT * FROM @tblInputArrays)
	BEGIN
		SELECT	0, 0, '', 0, 4, 'No Array ID given in input.'
		RETURN
	END
END
DECLARE @tmpArrayTbl TABLE(idtemp integer IDENTITY(1,1) PRIMARY KEY CLUSTERED,arrayId INTEGER, controlHostId INTEGER, MediaAgentId INTEGER,SnapEngineId INTEGER)
--Use the 'useForProvisioning' column to identify the client that supports V11 or V11 with S6 highest sp or something else!!
DECLARE @tblArrayMA TABLE
  (
     ClientId           int,
     ReleaseId          int,
     SPMajor            int,
	 SPMinor			int,
     useForProvisioning int
  )
INSERT INTO @tblArrayMA
SELECT DISTINCT AC.MMHostId,
                0,
                0,
				0,
                0
FROM   MMHost HOST
       INNER JOIN SMArrayController AC (nolock)
               ON AC.MMHostId = HOST.ClientId;
WITH clientsplevel
     AS (SELECT C.ClientId
                AS
                   ClientId,
                CLIENT.ReleaseId
                   AS ReleaseId,
                PKG.HighestSP
                   AS SPMajor,
                PKG.SpMinorVersion
                   AS SPMinor,
                ROW_NUMBER()
                  OVER (
                    partition BY C.ClientId
                    ORDER BY C.ClientId, CLIENT.ReleaseId, PKG.HighestSP,
                  PKG.SpMinorVersion) AS
                RowNum
         FROM   @tblArrayMA C
                LEFT OUTER JOIN APP_VMToPMMap MAP
                             ON MAP.VMClientId = C.ClientId
                INNER JOIN SimInstalledPackages PKG
                        ON PKG.ClientId = ISNULL(MAP.PMClientId, C.ClientId)
                INNER JOIN APP_Client CLIENT
                        ON CLIENT.id = ISNULL(MAP.PMClientId, C.ClientId)
WHERE  PKG.simPackageID IN (51, 1301))
UPDATE @tblArrayMA
SET    ReleaseId = SPL.ReleaseId,
       SPMajor = SPL.SPMajor,
	   SPMinor = SPL.SPMinor
FROM   @tblArrayMA C,
       clientsplevel SPL
WHERE  SPL.RowNum = 1
       AND C.ClientId = SPL.ClientId
UPDATE @tblArrayMA
SET    useForProvisioning = ( CASE
WHEN ReleaseId = 16 AND (SPMajor > 5 OR(SPMajor = 5 AND SPMinor = 1))
								THEN 2
WHEN ReleaseId = 16
								THEN 1
                              END )
IF (@x_validFlags & 1 = 1)
BEGIN
	INSERT	INTO @tmpArrayTbl
	SELECT	*
	FROM	(
				SELECT	ARR.Id, HOST.ControlHostId, MIN(CLNT.ClientId) AS MediaAgentId,temp.SnapEngineId
				FROM	SMArray AS ARR (NOLOCK)
				            INNER JOIN SProvArray AS SPROVARR (NOLOCK)
								ON ARR.Id = SPROVARR.ArrayNum AND SPROVARR.Enabled = 1
							INNER JOIN SMArrayCtrlHostMap AS MAP (NOLOCK)
								ON ARR.Id = MAP.ArrayId AND ARR.DeleteTime IS NULL
							INNER JOIN SMControlHost AS HOST (NOLOCK)
								ON HOST.ControlHostId = MAP.ControlHostId
								AND (@x_controlHostId = 0 OR HOST.ControlHostId = @x_controlHostId)
							INNER JOIN SMArrayController CTRL (NOLOCK)
								ON CTRL.ArrayNum = HOST.ControlHostId
							INNER JOIN MMHost CLNT (NOLOCK) ON CTRL.MMHostId = CLNT.ClientId
								AND CLNT.MmHostEnabled = 1
								AND CLNT.MmHostSoftState = 1 AND CLNT.OfflineReason = 0
							INNER JOIN APP_Client ACLNT (NOLOCK) ON ACLNT.Id = CTRL.MMHostId
							INNER JOIN @tblArrayMA MA ON MA.clientid = ACLNT.id
							--To make sure that VServers without tunneling is not selected
LEFT JOIN (SELECT ControlHostId AS ControlHostId FROM SMControlHost HOST (NOLOCK) INNER JOIN SMConfigs (NOLOCK) CNF ON HOST.ControlHostId = CNF.ArrayId AND CNF.AssocType = 3
																											  INNER JOIN SMMasterConfigs (NOLOCK) MCNF ON MCNF.Id = CNF.MasterConfigId
																									 WHERE MCNF.Id = 31 AND
																									 (
(HOST.SnapVendorName = 'NetApp'
																											AND
(((HOST.SMHostFlags & 8) = 8) AND CNF.ValueInt = 1)
																										OR
																										(((HOST.SMHostFlags & @CVSM_CTRLHOST_7MODE_FILER_DB) = @CVSM_CTRLHOST_7MODE_FILER_DB))
																										OR
(((HOST.SMHostFlags & 32) = 32)))
																									 )
									   ) AS TEMP1 ON TEMP1.ControlHostId = HOST.ControlHostId
							INNER JOIN (SELECT MIN(SnapShotEngineId) AS SnapEngineId,SnapVendorName from SMSnapShotEngine GROUP BY SnapVendorName) as temp ON temp.SnapVendorName = HOST.SnapVendorName
							WHERE
							(
								(
									(MA.useForProvisioning = 1 OR MA.useForProvisioning = 2)
									AND
HOST.SnapVendorName = 'NetApp'
									AND TEMP1.ControlHostId IS NOT NULL
								)
								OR
								(
									MA.useForProvisioning = 2
									AND
HOST.SnapVendorName IN ('IBM XIV',
'Dell EqualLogic',
'HPE EVA',
'HPE 3PAR StoreServ')
								)
							)
				GROUP BY ARR.Id, HOST.ControlHostId,temp.SnapEngineId
			) T
	WHERE	T.Id NOT IN (SELECT arrayId FROM @tmpArrayTbl)
END
IF (@x_validFlags & 4 = 4)
BEGIN
	INSERT	INTO @tmpArrayTbl
	SELECT	*
	FROM	(
				SELECT	ARR.Id, HOST.ControlHostId, MIN(CLNT.ClientId) AS MediaAgentId,temp.SnapEngineId
				FROM	@tblInputArrays INPUT
							INNER JOIN SMArray AS ARR (NOLOCK) ON INPUT.ArrayId = ARR.Id
							INNER JOIN SProvArray AS SPROVARR (NOLOCK)
								ON ARR.Id = SPROVARR.ArrayNum AND SPROVARR.Enabled = 1
							INNER JOIN SMArrayCtrlHostMap AS MAP (NOLOCK)
								ON ARR.Id = MAP.ArrayId AND ARR.DeleteTime IS NULL
							INNER JOIN SMControlHost AS HOST (NOLOCK)
ON HOST.ControlHostId = MAP.ControlHostId --AND HOST.SnapVendorName = 'NetApp'
							INNER JOIN SMArrayController CTRL (NOLOCK)
								ON CTRL.ArrayNum = HOST.ControlHostId
							INNER JOIN MMHost CLNT (NOLOCK) ON CTRL.MMHostId = CLNT.ClientId
								AND CLNT.MmHostEnabled = 1
								AND CLNT.MmHostSoftState = 1 AND CLNT.OfflineReason = 0
							INNER JOIN APP_Client ACLNT (NOLOCK) ON ACLNT.Id = CTRL.MMHostId
							INNER JOIN @tblArrayMA MA ON MA.clientid = ACLNT.id
							--To make sure that VServers without tunneling is not selected
LEFT JOIN (SELECT ControlHostId AS ControlHostId FROM SMControlHost HOST (NOLOCK) INNER JOIN SMConfigs (NOLOCK) CNF ON HOST.ControlHostId = CNF.ArrayId AND CNF.AssocType = 3
																											  INNER JOIN SMMasterConfigs (NOLOCK) MCNF ON MCNF.Id = CNF.MasterConfigId
																									 WHERE MCNF.Id = 31 AND
																									 (
(HOST.SnapVendorName = 'NetApp'
																											AND
(((HOST.SMHostFlags & 8) = 8) AND CNF.ValueInt = 1)
																										OR
																										(((HOST.SMHostFlags & @CVSM_CTRLHOST_7MODE_FILER_DB) = @CVSM_CTRLHOST_7MODE_FILER_DB))
																										OR
(((HOST.SMHostFlags & 32) = 32)))
																									 )
									   ) AS TEMP1 ON TEMP1.ControlHostId = HOST.ControlHostId
							INNER JOIN (SELECT MIN(SnapShotEngineId) AS SnapEngineId,SnapVendorName from SMSnapShotEngine GROUP BY SnapVendorName) as temp ON temp.SnapVendorName = HOST.SnapVendorName
							WHERE
							(
								(
									(MA.useForProvisioning = 1 OR MA.useForProvisioning = 2)
									AND
HOST.SnapVendorName = 'NetApp'
									AND TEMP1.ControlHostId IS NOT NULL
								)
								OR
								(
									MA.useForProvisioning = 2
									AND
HOST.SnapVendorName IN ('IBM XIV',
'Dell EqualLogic',
'HPE EVA',
'HPE 3PAR StoreServ')
								)
							)
				GROUP BY ARR.Id, HOST.ControlHostId,temp.SnapEngineId
			) T
END
DELETE FROM @tblArrayMA
DECLARE @arrayId INTEGER
DECLARE @ctrlHostId INTEGER
DECLARE @maId INTEGER
DECLARE @seId INTEGER
DECLARE array_cursor CURSOR FOR
	SELECT arrayId, controlHostId, MediaAgentId, SnapEngineId FROM @tmpArrayTbl
OPEN array_cursor
FETCH NEXT FROM array_cursor INTO @arrayId, @ctrlHostId, @maId, @seId
WHILE @@FETCH_STATUS = 0
BEGIN
		--Insert Control Host entry into result table
		INSERT INTO @resultTable VALUES (@controlHostType, @ctrlHostId, NULL, @maId, @seId)
		--Insert Array entries into result table
		INSERT INTO @resultTable VALUES (@arrayType, @arrayId, NULL, @maId, @seId)
		--Insert Storage Pool entries into result table
		INSERT INTO @resultTable(Type, Id, MountPath, MAId, SEId)
			SELECT @storagePoolType, sp.Id, NULL, @maId,@seId
				FROM @resultTable rTbl
				INNER JOIN SMArray array WITH (NOLOCK)
					ON rTbl.Type = @arrayType
					AND rTbl.Id = array.Id
					AND array.Id = @arrayId
					AND array.DeleteTime IS NULL
				INNER JOIN SMStoragePool sp WITH (NOLOCK)
					ON sp.ClientId = array.ClientId
					AND sp.DeleteTime IS NULL
		--Insert Array Volume entries into result table
		INSERT INTO @resultTable(Type, Id, MountPath, MAId, SEId)
			SELECT @arrayVolumeType, av.Id, NULL, @maId, @seId
				FROM @resultTable rTbl
				INNER JOIN SMArray array WITH (NOLOCK)
					ON rTbl.Type = @arrayType
					AND rTbl.Id = array.Id
					AND array.Id = @arrayId
					AND array.DeleteTime IS NULL
				INNER JOIN SMArrayVolume av WITH (NOLOCK)
					ON av.ClientId = array.ClientId
					AND av.DeleteTime IS NULL
		--Insert LUN entries into result table
		INSERT INTO @resultTable(Type, Id, MountPath, MAId, SEId)
			SELECT @lunType, lun.Id, NULL, @maId, @seId
				FROM @resultTable rTbl
				INNER JOIN SMLUN lun WITH (NOLOCK)
					ON rTbl.Type = @arrayVolumeType
					AND lun.ArrayVolumeId = rTbl.Id
					AND lun.DeleteTime IS NULL
				INNER JOIN SMArrayVolume AS av WITH (NOLOCK)
					ON av.Id = lun.ArrayVolumeId
					AND av.DeleteTime IS NULL
				INNER JOIN SMArray AS array WITH (NOLOCK)
					ON array.ClientId = av.ClientId
					AND array.Id = @arrayId
	FETCH NEXT FROM array_cursor INTO @arrayId, @ctrlHostId, @maId, @seId
END
CLOSE array_cursor
DEALLOCATE array_cursor
SELECT Type, Id, isnull(MountPath, ''), MAId,SEId, 0, 'Success' FROM @resultTable
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayEntries')
	delete from GxQscripts where name = 'SMGetArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayEntries')
	delete from GXDBVersions where aliasname = 'SMGetArrayEntries'
GO

insert into GXDBVersions values(2, 'SMGetArrayEntries',  '00010019001200080000', 'SMGetArrayEntries', '00010019001200080000')
GO

