

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayDetails.sp,v $ $Id: SMGetArrayDetails.sp,v 1.17 2013/11/14 09:09:19 dnavaneethan Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayDetails <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayDetails')
	drop procedure SMGetArrayDetails
IF EXISTS (select * from GxQscripts where name='SMGetArrayDetails')
	delete from GxQscripts where name = 'SMGetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayDetails')
	delete from GXDBVersions where aliasname = 'SMGetArrayDetails'
GO
print '... Creating Procedure: SMGetArrayDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayDetails
  @controlHostId integer
-- Input
AS
  DECLARE @outputXML XML
DECLARE @arrayHostDetails XML
DECLARE @arrayAppDetails XML
DECLARE @arrayVolumeDetails XML
IF (@controlHostId <= 0)
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
SET @arrayHostDetails =
(
	SELECT
		client.name AS [@clientName],
		snaptable.arrayVolumeCount AS [@arrayVolumeCount],
		luntable.lunCount AS [@lunCount],
		snapTable.snapshotCount AS [@snapshotCount],
		snapTable.snapshotusedspacebytes AS [@snapshotUsedSpaceBytes]
	FROM
		(SELECT
			sub.clientId AS clientId,
			COUNT(DISTINCT sub.arrayVolumeId) AS arrayVolumeCount,
			count(sub.UniqueIdentifier)  AS snapshotCount,
			sum(sub.snapshotusedspacebytes) AS snapshotusedspacebytes
		FROM
			(SELECT DISTINCT
				ctrlHost.ClientId AS [clientId],
				snap.ArrayVolumeId AS [arrayVolumeId],
				snap.UniqueIdentifier AS [UniqueIdentifier],
				snap.UsedSpaceBytes AS [snapshotusedspacebytes]
			FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON snap.ControlHostId = @controlHostId
					AND vsmap.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId = 13
				INNER JOIN SMArrayVolume AS ArrayVol WITH (NOLOCK)
					ON ArrayVol.Id = snap.ArrayVolumeId
					AND ArrayVol.DeleteTime IS NULL
				INNER JOIN SMControlHost AS ctrlHost WITH (NOLOCK)
					ON ctrlHost.ControlHostId = snap.ControlHostId
					AND ctrlHost.ControlHostId = @controlHostId
			UNION
			SELECT DISTINCT
				vol.SourceClientId AS [clientId],
				snap.ArrayVolumeId AS [arrayVolumeId],
				snap.UniqueIdentifier AS [UniqueIdentifier],
				snap.UsedSpaceBytes AS [snapshotusedspacebytes]
			FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON snap.ControlHostId = @controlHostId
					AND vsmap.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId <> 13
				INNER JOIN SMArrayVolume AS ArrayVol WITH (NOLOCK)
					ON ArrayVol.Id = snap.ArrayVolumeId
					AND ArrayVol.DeleteTime IS NULL) AS sub
		GROUP BY sub.clientId) AS snapTable
		FULL OUTER JOIN
		(SELECT
			sub.[clientId] AS [clientId],
			sub.[lunCount] AS [lunCount]
		FROM
			(SELECT
				ctrlHost.ClientId AS [clientId],
				COUNT (DISTINCT lun.Id) AS [lunCount]
			FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMLUN AS lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = snap.ArrayVolumeId
					AND lun.DeleteTime is NULL
					AND snap.LunId = lun.Id
					AND snap.ControlHostId = @controlHostId
				INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
					ON map.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vol.SMVolumeId = map.SMVolumeId
					AND vol.AppTypeId = 13
				INNER JOIN SMControlHost AS ctrlHost WITH (NOLOCK)
					ON ctrlHost.ControlHostId = snap.ControlHostId
					AND ctrlHost.ControlHostId = @controlHostId
			GROUP BY ctrlHost.ClientId
			UNION
			SELECT
				vol.SourceClientId AS [clientId],
				COUNT (DISTINCT lun.Id) AS [lunCount]
			FROM SMSnap AS snap	WITH (NOLOCK)
				INNER JOIN SMLUN lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = snap.ArrayVolumeId
					AND lun.DeleteTime is NULL
					AND snap.LunId = lun.Id
					AND snap.ControlHostId = @controlHostId
				INNER JOIN SMVolSnapMap map WITH (NOLOCK)
					ON map.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume vol WITH (NOLOCK)
					ON vol.SMVolumeId = map.SMVolumeId
					AND vol.AppTypeId <> 13
			GROUP BY vol.SourceClientId) AS sub)
			AS luntable
		ON snapTable.clientId = luntable.clientId
		INNER JOIN App_Client AS client WITH (NOLOCK)
			ON client.id = snapTable.clientId
	 FOR XML PATH('hostDetails'))
SET @arrayAppDetails =
	(
	 SELECT
		app.name AS [@applicationName],
		snaptable.[@clientCount],
		snapTable.[@arrayVolumeCount],
		LUNTable.lunCount as [@lunCount],
		snapTable.[@snapshotCount],
		snapTable.[@snapshotUsedSpaceBytes]
	FROM
		((SELECT vol.AppTypeId,
				CASE vol.AppTypeId
					WHEN 13 THEN 1	--consider the controlhost as one client
					ELSE COUNT(DISTINCT vol.SourceClientId)
				END AS [@clientCount],
				COUNT (DISTINCT ArrayVol.Id) AS [@arrayVolumeCount],
				COUNT(snap.UniqueIdentifier) AS [@snapshotCount],
				SUM(snap.UsedSpaceBytes) AS [@snapshotUsedSpaceBytes]
			FROM (SELECT MAX(SMSnapId) AS SMSnapId, ArrayVolumeId, UniqueIdentifier, UsedSpaceBytes, ControlHostId FROM SMSnap WITH (NOLOCK)
					GROUP BY ArrayVolumeId, UniqueIdentifier, UsedSpaceBytes, ControlHostId) as snap
				INNER JOIN SMVolSnapMap as vsMap
					ON snap.ControlHostId = @controlHostId
					and vsMap.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume as vol
					on vol.SMVolumeId = vsMap.SMVolumeId
				INNER JOIN SMArrayVolume as ArrayVol
					on ArrayVol.Id = snap.ArrayVolumeId
					AND ArrayVol.DeleteTime IS NULL
			GROUP BY vol.AppTypeId) AS snapTable
		FULL OUTER JOIN
			(SELECT vol.AppTypeId,
				COUNT (DISTINCT lun.Id) AS [lunCount]
			FROM SMSnap AS snap	WITH (NOLOCK)
				INNER JOIN SMLUN lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = snap.ArrayVolumeId
					AND lun.DeleteTime is NULL
					AND snap.LunId = lun.Id
					AND snap.ControlHostId = @controlHostId
				INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
					ON map.SMSnapId = snap.SMSnapId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vol.SMVolumeId = map.SMVolumeId
				GROUP BY vol.AppTypeId) AS LUNTable
			ON snapTable.AppTypeId = LUNTable.AppTypeId
				INNER JOIN APP_iDAType AS app WITH (NOLOCK)
					on app.type = snapTable.AppTypeId )
	 FOR XML PATH('appDetails')
	)
SET @arrayVolumeDetails =
	(
		SELECT
			arrayVol.UniqueId AS [@uniqueId],
			arrayVol.TotalSpaceMB AS [@totalSpaceMB],
			arrayVol.FreeSpaceMB AS [@freeSpaceMB],
			arrayVol.UsedSpaceMB AS [@usedSpaceMB],
			dbo.GetUnixTime(arrayVol.UpdateTime) AS [@lastUpdateTime],
			COUNT(lun.Id) AS [@lunCount],
			arrayVol.Id AS [volumeEntity/@volumeId],
			107 AS [volumeEntity/@_type_],
			arrayVol.Name AS [volumeEntity/@volumeName]
		FROM SMArrayVolume AS arrayVol WITH (NOLOCK)
			INNER JOIN SMArray AS array WITH (NOLOCK)
				ON array.ClientId = arrayVol.ClientId
				AND arrayVol.DeleteTime IS NULL
				AND array.DeleteTime IS NULL
			INNER JOIN SMArrayCtrlHostMap AS map WITH (NOLOCK)
				ON map.ArrayId = array.Id
			INNER JOIN SMControlHost AS ctrlHost WITH (NOLOCK)
				ON ctrlHost.ControlHostId = map.ControlHostId
				AND ctrlHost.ControlHostId = @controlHostId
			LEFT OUTER JOIN SMLUN AS lun WITH (NOLOCK)
				ON lun.ArrayVolumeId = arrayVol.Id
		GROUP BY arrayVol.UniqueId,
			arrayVol.TotalSpaceMB,
			arrayVol.FreeSpaceMB,
			arrayVol.UsedSpaceMB,
			arrayVol.UpdateTime,
			arrayVol.Id,
			arrayVol.Name
	FOR XML PATH('volumeDetails')
	)
DECLARE @totalSnapSpace	BIGINT = 0
DECLARE @totalSnapCount	BIGINT = 0
SELECT @totalSnapSpace = SUM(sub.UsedSpaceBytes), @totalSnapCount = COUNT(sub.UniqueIdentifier)
	FROM (SELECT DISTINCT snap.UniqueIdentifier, snap.UsedSpaceBytes, snap.ArrayVolumeId
			FROM SMSnap AS snap
				INNER JOIN SMArrayVolume As arrayVol
					ON snap.ArrayVolumeId = arrayVol.Id
					AND snap.ControlHostId = @controlHostId
					AND arrayVol.DeleteTime IS NULL) AS sub
SELECT
	cs.ControlHostId AS [@arrayControlId],
	array.Id AS [@arrayId],
	array.ClientId AS [@arrayClientId],
	array.ArrayName AS [@arrayName],
	array.UniqueID AS [@systemId],
	array.SerialNumber AS [@serialNo],
	array.ProductModel AS [@model],
	array.ProductOSVersion AS [@osVersion],
	array.ProductFirmwareVersion AS [@biosVersion],
	array.AdminConsole AS [@adminConsole],
	CASE array.SoftState
		WHEN 1 THEN 'Online'
		ELSE 'Offline'
	END AS [@status],
	array.TotalSpaceMB AS [@totalSpaceMB],
	(array.TotalSpaceMB - array.FreeSpaceMB) AS [@usedSpaceMB],
	array.FreeSpaceMB AS [@freeSpaceMB],
	@totalSnapSpace AS [@snapshotUsedSpaceBytes],
	@totalSnapCount AS [@snapProtectSnapshotCount],
	dbo.GetUnixTime(array.UpdateTime) AS [@lastUpdateTime],
	array.Properties AS [properties],
	@arrayHostDetails,
	@arrayAppDetails,
	@arrayVolumeDetails
FROM SMControlHost AS cs WITH (NOLOCK)
	INNER JOIN SMArrayCtrlHostMap AS csMap WITH (NOLOCK)
		ON cs.ControlHostId = @controlHostId
		AND csMap.ControlHostId = cs.ControlHostId
	INNER JOIN SMArray AS array WITH (NOLOCK)
		ON array.Id = csMap.ArrayId
FOR XML PATH ('EVGui_GetArrayDetailsResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayDetails')
	delete from GxQscripts where name = 'SMGetArrayDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayDetails')
	delete from GXDBVersions where aliasname = 'SMGetArrayDetails'
GO

insert into GXDBVersions values(2, 'SMGetArrayDetails',  '00010017000000000000', 'SMGetArrayDetails', '00010017000000000000')
GO

