

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayDataStores.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayDataStores.sp,v $ $Id: SMGetArrayDataStores.sp,v 1.19 2014/09/23 07:11:11 dkraplanee Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayDataStores <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayDataStores')
	drop procedure SMGetArrayDataStores
IF EXISTS (select * from GxQscripts where name='SMGetArrayDataStores')
	delete from GxQscripts where name = 'SMGetArrayDataStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayDataStores')
	delete from GXDBVersions where aliasname = 'SMGetArrayDataStores'
GO
print '... Creating Procedure: SMGetArrayDataStores'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMGetArrayDataStores
  @i_xmlText XML
-- Input
AS
  DECLARE @arrayDataStoreDetails xml
DECLARE @i_scope				INT
DECLARE @i_arrayId				INT
DECLARE @i_vCenterClientId		INT
DECLARE @i_dataStoreId			INT
DECLARE @i_dataStoreName		NVARCHAR(MAX)
DECLARE @i_vCenterClientName			NVARCHAR(256)
SET	@i_scope 	= ISNULL( (SELECT ref.value('@deep', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq') R(ref)),0)
SET	@i_arrayId = ISNULL ( (SELECT ref.value('@arrayId', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq') R(ref)), 0)
SET	@i_vCenterClientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq/vCenterClient') R(ref)), 0)
IF ( @i_vCenterClientId IS NULL )
BEGIN
SET	@i_vCenterClientName = ISNULL (( SELECT ref.value('@clientName', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq/vCenterClient') R(ref)), 0)
	SELECT @i_vCenterClientId =  id FROM APP_Client where name = @i_vCenterClientName
END
SET	@i_dataStoreId = ISNULL (( SELECT ref.value('@dataStoreId', 'INT')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq/dataStore') R(ref)), 0)
SET	@i_dataStoreName = (SELECT ref.value('@dataStoreName', 'NVARCHAR(MAX)')
					FROM  @i_xmlText.nodes ('EVGui_GetArrayDataStoresReq/dataStore') R(ref))
IF ( @i_scope = 0 )
BEGIN
SET @arrayDataStoreDetails =
		(
		SELECT DISTINCT
			DS.vxml.value('datastores[1]/@freeSpace', 'BIGINT')/(1024*1024) as [@freeSpaceMb],
			DS.vxml.value('datastores[1]/@spaceUsed', 'BIGINT')/(1024*1024) as [@usedSpaceMb],
			dbo.GetUnixTime(DS.timeStamp) as [@lastUpdateTime],
			DS.id as [entity/@dataStoreId],
			subTbl.SourceDevice as [entity/@dataStoreName]
			FROM
			(SELECT DISTINCT vol.AppId, vol.SourceDevice
			FROM SMSnap AS snap WITH (NOLOCK)
			INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
				ON vsmap.SMSnapId = snap.SMSnapId
				AND snap.ControlHostId = @i_arrayId
			INNER JOIN SMVolume AS vol WITH (NOLOCK)
				ON vsMap.SMVolumeId = vol.SMVolumeId
				AND vol.AppTypeId = 106) AS subTbl
			INNER JOIN APP_Application AS app WITH (NOLOCK)
				ON app.id = subTbl.AppId
			INNER JOIN APP_InstanceName as instance WITH (NOLOCK)
				ON app.instance = instance.id
			INNER JOIN App_InstanceProp AS prop WITH (NOLOCK)
				ON prop.componentNameId = instance.id
				AND prop.attrName ='Virtual Server Host'
			INNER JOIN APP_Client AS C WITH (NOLOCK)
				ON (prop.attrVal = C.net_hostname OR
				    prop.attrVal = C.name )
				AND C.id = @i_vCenterClientId
			LEFT OUTER JOIN ( SELECT * from App_VMDataStore where id in ( select MAX(DS.id) FROM App_VMDataStore DS WITH (NOLOCK) GROUP by uniqueName)
				) DS
				ON DS.name = subTbl.SourceDevice
			FOR XML PATH('dataStores')
		)
END
ELSE
BEGIN
	DECLARE @arrayDSSnapDetails XML
	DECLARE @arrayDSLUNDetails XML
	DECLARE @arrayDSSubClientDetails XML
	DECLARE @arrayDSVMDetails XML
	SET @arrayDSSnapDetails =
			(
				SELECT
					snap.SMSnapId AS [@smSnapId],
					snap.UniqueIdentifier AS [@uniqueIdentifier],
					snap.ReserveFieldStr AS [@reserveFieldStr],
					snap.CreationTime AS [@creationTime],
					snap.UsedSpaceBytes AS [@usedSpaceBytes],
					snap.arrayVolumeId AS [@arrayVolumeId]
				FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsmap.SMSnapId = snap.SMSnapId
					AND snap.ControlHostId = @i_arrayId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
					AND vol.AppTypeId = 106
					AND vol.SourceDevice = @i_dataStoreName
				FOR XML PATH('snaps')
			)
	SET @arrayDSLUNDetails =
			(
				SELECT DISTINCT
					lun.Id AS [@id],
					lun.Name AS [@name],
					lun.Path AS [@path],
					CASE (lun.Flags & 1)
						WHEN 1 THEN 'Offline'
						ELSE 'Online'
					END AS [@status],
					lun.ArrayVolumeId AS [@arrayvolumeid],
					lun.TotalSpaceBytes AS [@totalSpaceBytes],
					lun.UsedSpaceBytes AS [@usedSpaceBytes],
					lun.FreeSpaceBytes AS [@freeSpaceBytes],
					lun.Description AS [@description]
				FROM SMSnap AS snap WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
						ON vsmap.SMSnapId = snap.SMSnapId
						AND snap.ControlHostId = @i_arrayId
					INNER JOIN SMVolume AS vol WITH (NOLOCK)
						ON vsMap.SMVolumeId = vol.SMVolumeId
						AND vol.AppTypeId = 106
						AND vol.SourceDevice = @i_dataStoreName
					INNER JOIN SMLUN AS lun WITH (NOLOCK)
						ON lun.ArrayVolumeId = snap.ArrayVolumeId
						AND lun.Id = snap.LunId
						AND lun.DeleteTime IS NULL
				FOR XML PATH('luns')
			)
	SET @arrayDSSubClientDetails =
		    (
				SELECT DISTINCT
					app.subclientName as [name/@subclientName],
					app.id as [name/@subclientId],
				    bkpSet.name as [backupset/@backupsetName],
					bkpSet.id as [backupset/@backupsetId],
					AG.id AS [storagePolicy/@storagePolicyId],
					AG.name AS [storagePolicy/@storagePolicyName]
				FROM SMSnap AS snap WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
						ON vsmap.SMSnapId = snap.SMSnapId
						AND snap.ControlHostId = @i_arrayId
					INNER JOIN SMVolume AS vol WITH (NOLOCK)
						ON vsMap.SMVolumeId = vol.SMVolumeId
						AND vol.AppTypeId = 106
						AND vol.SourceDevice = @i_dataStoreName
					INNER JOIN APP_Application AS app WITH (NOLOCK)
						ON vol.AppTypeId = 106
						AND app.id = vol.AppId
					INNER JOIN APP_BackupSetName as bkpSet WITH (NOLOCK)
						ON bkpSet.id = app.backupSet
					INNER JOIN archGroup AG WITH (NOLOCK)
						ON 	AG.id = app.dataArchGrpID
				FOR XML PATH('subclient')
			)
	SET @arrayDSVMDetails =
		(
			SELECT DISTINCT
				vmDS.allotedSpaceMb AS [@allotedSpaceMb],
				vmDS.dataUsedSpaceMb AS [@dataUsedSpaceMb],
				vmDS.snapShotUsedSpaceMb AS [@snapshotUsedSpaceMb],
				vmDS.otherFilesUsedSpaceMb AS [@otherFilesSpaceMb],
				SUBSTRING(scProp.attrVal, 1, CHARINDEX(' ', scProp.attrVal) - 1) as [entity/@vmName],
				SUBSTRING(scProp.attrName, 2, LEN(scProp.attrName)) as [entity/@vmGUID]
			FROM SMSnap AS snap WITH (NOLOCK)
			INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
				ON vsmap.SMSnapId = snap.SMSnapId
				AND snap.ControlHostId = @i_arrayId
			INNER JOIN SMVolume AS vol WITH (NOLOCK)
				ON vsMap.SMVolumeId = vol.SMVolumeId
				AND vol.AppTypeId = 106
				AND vol.SourceDevice = @i_dataStoreName
			INNER JOIN APP_Application AS app WITH (NOLOCK)
				ON vol.AppTypeId = 106
				AND app.id = vol.AppId
			INNER JOIN APP_SubClientProp as scProp WITH (NOLOCK)
				ON scProp.componentNameId = app.id
				AND scProp.attrType =121
				AND scProp.modified =0
			INNER JOIN App_VM vm WITH (NOLOCK)
				ON vm.GUID = SUBSTRING(scProp.attrName, 2, LEN(scProp.attrName))
			INNER JOIN APP_VMToDataStores AS vmDS WITH (NOLOCK)
				ON vmDS.vmId = vm.id
			INNER JOIN App_VMDataStore AS DS WITH (NOLOCK)
				ON DS.id = vmDS.vDataStoreId
				AND DS.name = @i_dataStoreName
			FOR XML PATH ('vms')
		)
SET @arrayDataStoreDetails =
	(
		SELECT
			DS.vxml.value('datastores[1]/@freeSpace', 'BIGINT')/(1024*1024) as [@freeSpaceMb],
			DS.vxml.value('datastores[1]/@spaceUsed', 'BIGINT')/(1024*1024) as [@usedSpaceMb],
			dbo.GetUnixTime(DS.timeStamp) as [@lastUpdateTime],
			DS.id as [entity/@dataStoreId],
			subTbl.SourceDevice as [entity/@dataStoreName],
			@arrayDSSnapDetails,
			@arrayDSLUNDetails,
			@arrayDSSubClientDetails,
			@arrayDSVMDetails
			FROM
			(SELECT DISTINCT vol.AppId, vol.SourceDevice
			FROM SMSnap AS snap WITH (NOLOCK)
			INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
				ON vsmap.SMSnapId = snap.SMSnapId
				AND snap.ControlHostId = @i_arrayId
			INNER JOIN SMVolume AS vol WITH (NOLOCK)
				ON vsMap.SMVolumeId = vol.SMVolumeId
				AND vol.AppTypeId = 106
				AND vol.SourceDevice = @i_dataStoreName) AS subTbl
			LEFT OUTER JOIN ( SELECT * from App_VMDataStore where id in ( select MAX(DS.id) FROM App_VMDataStore DS WITH (NOLOCK) GROUP by uniqueName)
				) DS
				ON DS.name = subTbl.SourceDevice
			FOR XML PATH('dataStores')
	)
END
		SELECT @arrayDataStoreDetails FOR XML PATH('EVGui_GetArrayDataStoresResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayDataStores')
	delete from GxQscripts where name = 'SMGetArrayDataStores'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayDataStores')
	delete from GXDBVersions where aliasname = 'SMGetArrayDataStores'
GO

insert into GXDBVersions values(2, 'SMGetArrayDataStores',  '00010019000000000000', 'SMGetArrayDataStores', '00010019000000000000')
GO

