

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayClients.sp,v $ $Id: SMGetArrayClients.sp,v 1.7 2011/12/28 13:05:47 dnavaneethan Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayClients <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayClients')
	drop procedure SMGetArrayClients
IF EXISTS (select * from GxQscripts where name='SMGetArrayClients')
	delete from GxQscripts where name = 'SMGetArrayClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayClients')
	delete from GXDBVersions where aliasname = 'SMGetArrayClients'
GO
print '... Creating Procedure: SMGetArrayClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayClients
  @controlHostId integer,
  @apptype integer
-- Input
AS
  DECLARE @arrayClientDetails xml
IF ( @controlHostId <= 0 OR @apptype <= 0)
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
IF (@apptype = 13)
BEGIN
SET @arrayClientDetails =
	(
		SELECT
			client.id AS [@clientId],
			client.name AS [@clientName],
			client.net_hostname AS [@hostName],
			3 AS [@_type_]
		FROM SMControlHost AS ch WITH (NOLOCK)
			INNER JOIN App_Client AS client WITH (NOLOCK)
				ON ch.ControlHostId = @controlHostId
				AND ch.ClientId = client.id
		FOR XML PATH('clients')
	)
END
ELSE IF ( @apptype = 106 )
BEGIN
SET @arrayClientDetails =
	(
		SELECT DISTINCT
			C.id AS [@clientId],
			C.name AS [@clientName],
			C.net_hostname AS [@hostName]
		FROM SMSnap AS snap WITH (NOLOCK)
			INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
				ON vsmap.SMSnapId = snap.SMSnapId
				AND snap.ControlHostId =  @controlHostId
			INNER JOIN SMVolume AS vol WITH (NOLOCK)
				ON vsMap.SMVolumeId = vol.SMVolumeId
				AND vol.AppTypeId = @apptype
			INNER JOIN APP_Application AS app WITH (NOLOCK)
				ON app.id = vol.AppId
			INNER JOIN APP_InstanceName as instance WITH (NOLOCK)
				ON app.instance = instance.id
			INNER JOIN App_InstanceProp AS prop WITH (NOLOCK)
				ON prop.componentNameId = instance.id
				AND prop.attrName ='Virtual Server Host'
			INNER JOIN APP_Client AS C WITH(NOLOCK)
				ON (prop.attrVal = C.net_hostname OR
				    prop.attrVal = C.name )
		FOR XML PATH('clients')
	)
END
ELSE
BEGIN
SET @arrayClientDetails =
	(
		SELECT DISTINCT
			vol.SourceClientId AS [@clientId],
			client.name AS [@clientName],
			client.net_hostname AS [@hostName],
			3 AS [@_type_]
		FROM SMSnap AS snap WITH (NOLOCK)
			INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
				ON vsmap.SMSnapId = snap.SMSnapId
				AND snap.ControlHostId = @controlHostId
			INNER JOIN SMVolume AS vol WITH (NOLOCK)
				ON vsMap.SMVolumeId = vol.SMVolumeId
				AND vol.AppTypeId = @apptype
			INNER JOIN App_Client AS client WITH (NOLOCK)
				ON client.id = vol.SourceClientId
		FOR XML PATH('clients')
	)
END
SELECT @arrayClientDetails FOR XML PATH('EVGui_GetArrayClientsResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayClients')
	delete from GxQscripts where name = 'SMGetArrayClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayClients')
	delete from GXDBVersions where aliasname = 'SMGetArrayClients'
GO

insert into GXDBVersions values(2, 'SMGetArrayClients',  '00010007000000000000', 'SMGetArrayClients', '00010007000000000000')
GO

