

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayClientVolumes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayClientVolumes.sp,v $ $Id: SMGetArrayClientVolumes.sp,v 1.16 2012/01/24 08:17:13 vimalkumar Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayClientVolumes <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayClientVolumes')
	drop procedure SMGetArrayClientVolumes
IF EXISTS (select * from GxQscripts where name='SMGetArrayClientVolumes')
	delete from GxQscripts where name = 'SMGetArrayClientVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayClientVolumes')
	delete from GXDBVersions where aliasname = 'SMGetArrayClientVolumes'
GO
print '... Creating Procedure: SMGetArrayClientVolumes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayClientVolumes
  @controlHostId integer,
  @clientId integer,
  @appType integer,
  @volume nvarchar(1024),
  @deep integer
-- Input
AS
  DECLARE @arrayClientVolumeDetails xml
DECLARE @usedSpace bigint = -1
DECLARE @freeSpace bigint = -1
DECLARE @totalSpace bigint = -1
DECLARE @description nvarchar(1024) ='N/A'
DECLARE @uniquieId	nvarchar(1024)='N/A'
IF ( @controlHostId <= 0 OR @clientId <= 0 OR @appType <= 0)
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
IF (@deep = 1)
BEGIN
	DECLARE @arrayClientVolSnapDetails XML
	DECLARE @arrayClientVolLUNDetails XML
	DECLARE @arrayClientVolSubClientDetails XML
	IF (@appType <> 13)
	BEGIN
		SET  @arrayClientVolSnapDetails =
			(
				SELECT
					snap.SMSnapId AS [@smSnapId],
					snap.UniqueIdentifier AS [@uniqueIdentifier],
					snap.ReserveFieldStr AS [@reserveFieldStr],
					snap.CreationTime AS [@creationTime],
					snap.UsedSpaceBytes AS [@usedSpaceBytes],
					snap.ArrayVolumeId AS [@arrayVolumeId]
				FROM SMVolume AS vol WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
							ON map.SMVolumeId = vol.SMVolumeId
							AND vol.SourceClientId = @clientId
							AND vol.appTypeId = @appType
							AND vol.SourcePath LIKE @volume
						INNER JOIN SMSnap AS snap WITH (NOLOCK)
							ON snap.SMSnapId = map.SMSnapId
							AND snap.ControlHostId = @controlHostId
				FOR XML PATH('snaps')
			)
		SET @arrayClientVolLUNDetails =
		(
			SELECT DISTINCT
				lun.Id AS [@id],
				lun.ArrayVolumeId AS [@arrayvolumeid],
				lun.TotalSpaceBytes AS [@totalSpaceBytes],
				lun.UsedSpaceBytes AS [@usedSpaceBytes],
				lun.FreeSpaceBytes AS [@freeSpaceBytes],
				lun.Name AS [@name],
				lun.Path AS [@path],
				lun.Description AS [@description],
				CASE (lun.Flags & 1)
					WHEN 1 THEN 'Offline'
					ELSE 'Online'
				END AS [@status]
			FROM SMVolume AS vol WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
					ON map.SMVolumeId = vol.SMVolumeId
					AND vol.SourceClientId = @clientId
					AND vol.appTypeId = @appType
					AND vol.SourcePath LIKE @volume
				INNER JOIN SMSnap AS snap WITH (NOLOCK)
					ON snap.SMSnapId = map.SMSnapId
					AND snap.ControlHostId = @controlHostId
				INNER JOIN SMLUN AS lun WITH (NOLOCK)
					ON lun.ArrayVolumeId = snap.ArrayVolumeId
					AND lun.Id = snap.LunId
					AND lun.DeleteTime IS NULL
			FOR XML PATH('luns')
		)
		IF (@appType = 81) --SQL Server agent subclient content stored in App_SubclientProp table
		SET @arrayClientVolSubClientDetails =
				(SELECT
						sub.scId AS [name/@subclientId],
						sub.scname AS [name/@subclientName],
						sub.bksId AS [backupset/@backupsetId],
						sub.bksname AS [backupset/@backupsetName],
						sub.spId AS [storagePolicy/@storagePolicyId],
						sub.spname AS [storagePolicy/@storagePolicyName],
						scProp.attrName AS [contents/@val]
						--(SELECT SUBSTRING(scProp.attrName , 1, LEN(scProp.attrName)) as [@val] FOR XML PATH('contents'), TYPE)
					FROM
						(SELECT DISTINCT
							app.id AS scId,
							app.subclientName AS scname,
							bkpSet.id AS bksId,
							bkpSet.name AS bksname,
							AG.id AS spId,
							AG.name AS spname
							FROM SMVolume AS vol WITH (NOLOCK)
								INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
									ON map.SMVolumeId = vol.SMVolumeId
									AND vol.SourceClientId = @clientId
									AND vol.appTypeId = @appType
									AND vol.SourcePath LIKE @volume
								INNER JOIN SMSnap AS snap WITH (NOLOCK)
									ON snap.SMSnapId = map.SMSnapId
									AND snap.ControlHostId = @controlHostId
								INNER JOIN APP_Application AS app WITH (NOLOCK)
									ON vol.AppTypeId =  @appType
									AND app.id = vol.AppId
								INNER JOIN APP_BackupSetName AS bkpSet WITH (NOLOCK)
									ON bkpSet.id = app.backupSet
								INNER JOIN archGroup AG WITH (NOLOCK)
									ON 	AG.id = app.dataArchGrpID) AS sub
							INNER JOIN App_SubclientProp scProp WITH (NOLOCK)
								ON scProp.componentNameId = sub.scId
								AND scProp.attrType = 118
								AND scProp.modified = 0
						FOR XML PATH('subclient'))
		ELSE
		SET @arrayClientVolSubClientDetails =
				(SELECT
					sub.scId AS [name/@subclientId],
					sub.scname AS [name/@subclientName],
					sub.bksId AS [backupset/@backupsetId],
					sub.bksname AS [backupset/@backupsetName],
					sub.spId AS [storagePolicy/@storagePolicyId],
					sub.spname AS [storagePolicy/@storagePolicyName],
					scFilter.fileName AS [contents/@val]
					--(SELECT SUBSTRING(scFilter.fileName , 1, LEN(scFilter.fileName )) as [@val]	FOR XML PATH('contents'), TYPE)
				FROM
					(SELECT DISTINCT
						app.id AS scId,
						app.subclientName AS scname,
						bkpSet.id AS bksId,
						bkpSet.name AS bksname,
						AG.id AS spId,
						AG.name AS spname
						FROM SMVolume AS vol WITH (NOLOCK)
							INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
								ON map.SMVolumeId = vol.SMVolumeId
								AND vol.SourceClientId = @clientId
								AND vol.appTypeId = @appType
								AND vol.SourcePath LIKE @volume
							INNER JOIN SMSnap AS snap WITH (NOLOCK)
								ON snap.SMSnapId = map.SMSnapId
								AND snap.ControlHostId = @controlHostId
							INNER JOIN APP_Application AS app WITH (NOLOCK)
								ON vol.AppTypeId =  @appType
								AND app.id = vol.AppId
							INNER JOIN APP_BackupSetName AS bkpSet WITH (NOLOCK)
								ON bkpSet.id = app.backupSet
							INNER JOIN archGroup AG WITH (NOLOCK)
								ON 	AG.id = app.dataArchGrpID) AS sub
						INNER JOIN APP_ScFilterFile scFilter WITH(NOLOCK)
							ON scFilter.componentNameId = sub.scId
							AND scFilter.type = 1
							AND scFilter.modified = 0
					FOR XML PATH('subclient'))
		SET @arrayClientVolumeDetails =
			(
			 SELECT (
					SELECT
						@volume AS [@volumeName]
						FOR XML PATH('volumes'), TYPE),
					@arrayClientVolSnapDetails,
					@arrayClientVolLUNDetails,
					@arrayClientVolSubClientDetails
			   FOR XML PATH('EVGui_GetArrayClientVolumesResp')
			)
	END
	ELSE IF (@appType = 13)
	BEGIN
		SET  @arrayClientVolSnapDetails =
		(
				SELECT
					snap.SMSnapId AS [@smSnapId],
					snap.UniqueIdentifier AS [@uniqueIdentifier],
					snap.ReserveFieldStr AS [@reserveFieldStr],
					snap.CreationTime AS [@creationTime],
					snap.UsedSpaceBytes AS [@usedSpaceBytes],
					snap.ArrayVolumeId AS [@arrayVolumeId]
				FROM SMVolume AS vol WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
						ON map.SMVolumeId = vol.SMVolumeId
						--AND vol.OriginClientId = @clientId
						AND vol.appTypeId = @appType
					INNER JOIN SMSnap AS snap WITH (NOLOCK)
						ON snap.SMSnapId = map.SMSnapId
						AND snap.ControlHostId = @controlHostId
					INNER JOIN SMArrayVolume AS arrayVol WITH (NOLOCK)
						ON arrayVol.Id = snap.ArrayVolumeId
						AND arrayVol.Name LIKE @volume
						AND arrayVol.DeleteTime IS NULL
				FOR XML PATH('snaps')
		)
		SET @arrayClientVolSubClientDetails =
		(
			SELECT
				sub.scId AS [name/@subclientId],
				sub.scname AS [name/@subclientName],
				sub.bksId AS [backupset/@backupsetId],
				sub.bksname AS [backupset/@backupsetName],
				sub.spId AS [storagePolicy/@storagePolicyId],
				sub.spname AS [storagePolicy/@storagePolicyName],
				scFilter.fileName AS [contents/@val]
				--(SELECT SUBSTRING(scFilter.fileName , 1, LEN(scFilter.fileName )) as [@val]	FOR XML PATH('contents'), TYPE)
			FROM
				(SELECT DISTINCT
					app.id AS scId,
					app.subclientName AS scname,
					bkpSet.id AS bksId,
					bkpSet.name AS bksname,
					AG.id AS spId,
					AG.name AS spname
				FROM SMVolume AS vol WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
						ON map.SMVolumeId = vol.SMVolumeId
						AND vol.AppTypeId = @appType
						--AND vol.OriginClientId = @clientId
					INNER JOIN SMSnap AS snap WITH (NOLOCK)
						ON snap.SMSnapId = map.SMSnapId
					INNER JOIN SMArrayVolume AS arrayVol WITH (NOLOCK)
						ON arrayVol.Id = snap.ArrayVolumeId
						AND arrayVol.Name LIKE @volume
						AND arrayVol.DeleteTime IS NULL
					INNER JOIN APP_Application AS app WITH (NOLOCK)
						ON app.id = vol.AppId
					INNER JOIN APP_BackupSetName AS bkpSet WITH (NOLOCK)
						ON bkpSet.id = app.backupSet
					INNER JOIN archGroup AG WITH (NOLOCK)
						ON 	AG.id = app.dataArchGrpID) AS sub
					INNER JOIN APP_ScFilterFile scFilter WITH(NOLOCK)
						ON scFilter.componentNameId = sub.scId
						AND scFilter.type = 1
						AND scFilter.modified = 0
				FOR XML PATH('subclient')
		)
		SET @arrayClientVolumeDetails =
		(
	     SELECT (SELECT	@volume AS [@volumeName] FOR XML PATH('volumes'), TYPE),
				@arrayClientVolSnapDetails,
				@arrayClientVolLUNDetails,
				@arrayClientVolSubClientDetails
		   FOR XML PATH('EVGui_GetArrayClientVolumesResp')
		)
	END
END
ELSE IF ( @deep = 0)
BEGIN
	IF (@appType <> 13)
		SET @arrayClientVolumeDetails =
			(
				SELECT DISTINCT
					vol.SourcePath AS [@volumeName]
				FROM SMVolume AS vol WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
						ON map.SMVolumeId = vol.SMVolumeId
						AND vol.SourceClientId = @clientId
						AND vol.appTypeId = @appType
					INNER JOIN SMSnap AS snap WITH (NOLOCK)
						ON snap.SMSnapId = map.SMSnapId
						AND snap.ControlHostId = @controlHostId
				FOR XML PATH('volumes')
			)
	ELSE IF (@appType = 13)
		SET @arrayClientVolumeDetails =
			(
				SELECT DISTINCT
					arrayVol.Name AS [@volumeName]
				FROM SMVolume AS vol WITH (NOLOCK)
					INNER JOIN SMVolSnapMap AS map WITH (NOLOCK)
						ON map.SMVolumeId = vol.SMVolumeId
						--AND vol.OriginClientId = @clientId
						AND vol.appTypeId = @appType
					INNER JOIN SMSnap AS snap WITH (NOLOCK)
						ON snap.SMSnapId = map.SMSnapId
						AND snap.ControlHostId = @controlHostId
					INNER JOIN SMArrayVolume AS arrayVol WITH (NOLOCK)
						ON arrayVol.Id = snap.ArrayVolumeId
						AND arrayVol.Id > 0
						AND arrayVol.DeleteTime IS NULL
				FOR XML PATH('volumes')
			)
END
IF ( @deep = 0 )
SELECT
	@arrayClientVolumeDetails
FOR XML PATH('EVGui_GetArrayClientVolumesResp')
ELSE
SELECT
	@arrayClientVolumeDetails
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayClientVolumes')
	delete from GxQscripts where name = 'SMGetArrayClientVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayClientVolumes')
	delete from GXDBVersions where aliasname = 'SMGetArrayClientVolumes'
GO

insert into GXDBVersions values(2, 'SMGetArrayClientVolumes',  '00010016000000000000', 'SMGetArrayClientVolumes', '00010016000000000000')
GO

