

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMGetArrayApplications.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMGetArrayApplications.sp,v $ $Id: SMGetArrayApplications.sp,v 1.4 2011/10/03 17:26:24 dscott Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMGetArrayApplications <<<'

IF EXISTS (select * from sysobjects where name='SMGetArrayApplications')
	drop procedure SMGetArrayApplications
IF EXISTS (select * from GxQscripts where name='SMGetArrayApplications')
	delete from GxQscripts where name = 'SMGetArrayApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayApplications')
	delete from GXDBVersions where aliasname = 'SMGetArrayApplications'
GO
print '... Creating Procedure: SMGetArrayApplications'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure SMGetArrayApplications
  @type integer,
  @controlHostId integer
-- Input
AS
  DECLARE @arrayApplDetails xml
IF ( @type <> 1 OR @controlHostId <= 0)
BEGIN
	RAISERROR ('Invalid arguments!', 16, 1)
END
SET @arrayApplDetails =
	(
		SELECT DISTINCT
			vol.AppTypeId AS [@appTypeId],
			app.name AS [@appTypeName],
			79 AS [@_type_]
			FROM SMSnap AS snap WITH (NOLOCK)
				INNER JOIN SMVolSnapMap AS vsMap WITH (NOLOCK)
					ON vsMap.SMSnapId = snap.SMSnapId
					AND snap.ControlHostId = @controlHostId
				INNER JOIN SMVolume AS vol WITH (NOLOCK)
					ON vsMap.SMVolumeId = vol.SMVolumeId
				INNER JOIN APP_iDAType app WITH (NOLOCK)
					ON vol.AppTypeId = app.type
		FOR XML PATH('appTypes')
	)
SELECT @arrayApplDetails FOR XML PATH('EVGui_GetArrayApplicationsResp')
GO

IF EXISTS (select * from GxQscripts where name = 'SMGetArrayApplications')
	delete from GxQscripts where name = 'SMGetArrayApplications'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMGetArrayApplications')
	delete from GXDBVersions where aliasname = 'SMGetArrayApplications'
GO

insert into GXDBVersions values(2, 'SMGetArrayApplications',  '00010004000000000000', 'SMGetArrayApplications', '00010004000000000000')
GO

