

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SMDeconfigArrayEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SMDeconfigArrayEntries.sp,v $ $Id: SMDeconfigArrayEntries.sp,v 1.10.12.4 2018/03/19 23:57:09 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SMDeconfigArrayEntries <<<'

IF EXISTS (select * from sysobjects where name='SMDeconfigArrayEntries')
	drop procedure SMDeconfigArrayEntries
IF EXISTS (select * from GxQscripts where name='SMDeconfigArrayEntries')
	delete from GxQscripts where name = 'SMDeconfigArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMDeconfigArrayEntries')
	delete from GXDBVersions where aliasname = 'SMDeconfigArrayEntries'
GO
print '... Creating Procedure: SMDeconfigArrayEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SMDeconfigArrayEntries
  @i_controlHostId INTEGER,
  @i_arrayId INTEGER
AS
  DECLARE @o_ErrorCode INTEGER
  DECLARE @o_ErrorStr VARCHAR(1024)
SET NOCOUNT ON
DECLARE @SMDeconfigArrayEntries INT
SET @SMDeconfigArrayEntries = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION SMDeconfigArrayEntries
		SET @SMDeconfigArrayEntries = 1
	END
	DECLARE @arrayClientId INTEGER
	DECLARE @arrayNum INTEGER
	SELECT @arrayClientId = array.ClientId, @arrayNum = array.Id
		FROM SMArray AS array WITH (NOLOCK)
			INNER JOIN SMArrayCtrlHostMap AS acMap WITH (NOLOCK)
				ON acMap.ArrayId = array.Id
				AND acMap.ControlHostId = @i_controlHostId
	IF EXISTS (SELECT * FROM SProvLUN (NOLOCK) WHERE ArrayNum = @arrayNum)
		OR EXISTS (SELECT * FROM SProvArrayVolume (NOLOCK) WHERE ArrayNum = @arrayNum)
	BEGIN
		SET @o_ErrorCode = 2
		SET @o_ErrorStr = 'There are still LUNs/Volumes provisioned on the array. Please delete them and then delete the array.'
		RAISERROR (@o_ErrorStr, 16, 1)
	END
DELETE FROM SMHostAlias WHERE RefId = @i_controlHostId and RefType = 5
	DELETE FROM SMEndPoint WHERE ClientId = @arrayClientId
	DELETE FROM SprovAllocationPolicyFilerProp WHERE arrayNum = @arrayNum
	DELETE FROM SprovAllocationPolicyFilerFilter WHERE arrayNum = @arrayNum
	DELETE FROM SprovAllocationPolicyResourcePool WHERE arrayNum = @arrayNum
	DELETE FROM SprovAllocationPolicyResourcePoolFilter WHERE arrayNum = @arrayNum
	DELETE FROM SProvStoragePool WHERE ArrayNum = @arrayNum
	DELETE FROM SProvArrayCapabilities WHERE ArrayNum = @arrayNum
	DELETE FROM SProvArray WHERE ArrayNum = @arrayNum
	DELETE FROM SMArrayVolume WHERE ClientId = @arrayClientId AND Id > 0
	DELETE FROM SMStoragePool WHERE ClientId = @arrayClientId AND Id > 0
	DELETE FROM SMArray WHERE ClientId = @arrayClientId
	DELETE FROM SMArrayCtrlHostMap WHERE ControlHostId = @i_controlHostId
	IF (@SMDeconfigArrayEntries = 1)
		BEGIN
			COMMIT TRANSACTION SMDeconfigArrayEntries
			SET @SMDeconfigArrayEntries = 0
		END
	SELECT 0, 'Success'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF (XACT_STATE() <> 0 AND @SMDeconfigArrayEntries = 1)
		BEGIN
			ROLLBACK TRANSACTION SMDeconfigArrayEntries
			SET  @SMDeconfigArrayEntries = 0
		END
	IF @o_ErrorCode = 0
		SELECT 1, 'Failed to deconfigure the array.'
	ELSE
		SELECT @o_ErrorCode, @o_ErrorStr
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'SMDeconfigArrayEntries')
	delete from GxQscripts where name = 'SMDeconfigArrayEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SMDeconfigArrayEntries')
	delete from GXDBVersions where aliasname = 'SMDeconfigArrayEntries'
GO

insert into GXDBVersions values(2, 'SMDeconfigArrayEntries',  '00010010001200040000', 'SMDeconfigArrayEntries', '00010010001200040000')
GO

