

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SIMIsClientUpgradable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SIMIsClientUpgradable.sp,v $ $Id: SIMIsClientUpgradable.sp,v 1.1.2.1 2017/03/27 17:33:58 stelagamsetti Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppAddProps   - Add properties for the APP_SubClientProp table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SIMIsClientUpgradable <<<'

IF EXISTS (select * from sysobjects where name='SIMIsClientUpgradable')
	drop procedure SIMIsClientUpgradable
IF EXISTS (select * from GxQscripts where name='SIMIsClientUpgradable')
	delete from GxQscripts where name = 'SIMIsClientUpgradable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SIMIsClientUpgradable')
	delete from GXDBVersions where aliasname = 'SIMIsClientUpgradable'
GO
print '... Creating Procedure: SIMIsClientUpgradable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SIMIsClientUpgradable
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ClientID integer,
  @ApptypeID integer
AS
  DECLARE @errorCode integer
  DECLARE @errorMessage varchar(1024)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @mysqlMajor INT = 5
DECLARE @mysqlMinor INT = 1
DECLARE @postgresMajor INT = 9
DECLARE @postgresMinor INT = 2
DECLARE @mysqlVersion		TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @postgresVersion	TABLE (t_clientId INT, t_client NVARCHAR(1024), t_instanceId INT, t_instanceName NVARCHAR(1024), dbVersion NVARCHAR(512))
DECLARE @minorVersion INT
DECLARE @majorVersion INT
DECLARE @tempVer NVARCHAR(32)
DECLARE @tempBuffer NVARCHAR(512) = N''
DECLARE @clientName NVARCHAR(1024)
DECLARE @instanceName NVARCHAR(1024)
DECLARE @version NVARCHAR(512)
SET @errorCode = 0
SET @errorMessage = ''
-- MySQL
IF @ApptypeID = 104 --CV_APPTYPE_MYSQL
BEGIN
	INSERT	INTO @mysqlVersion
	SELECT  DISTINCT A.clientID, C.name, IP.componentNameId, I.name,
		CASE WHEN CHARINDEX('Distrib ', IP.attrVal) > 0
			 THEN SUBSTRING(IP.attrVal, CHARINDEX('Distrib ', IP.attrVal) + 8, 5)
			 ELSE IP.attrVal
		END
	FROM    APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id AND C.id = @ClientID
	WHERE   A.appTypeId = 104
		AND     IP.modified = 0
		AND IP.attrName = 'MySQL version'
		AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
	DECLARE	mysqlInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @mysqlVersion WHERE t_clientId > 2
	OPEN mysqlInstCur
	FETCH NEXT FROM mysqlInstCur INTO @clientName, @instanceName, @version
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @minorVersion = 0
		SET @majorVersion = 0
		SET @tempVer = ''
		SET @tempBuffer = ''
		-- Calculate Major Version & Minor version numbers
		IF @version IS NOT NULL
		BEGIN
			IF CHARINDEX('.', @version) > 0
			BEGIN
				SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
				IF ISNUMERIC(@tempVer) = 1
					SET @majorVersion = CAST (@tempVer AS INT)
			END
			SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))
			IF CHARINDEX('.', @tempBuffer) > 0
			BEGIN
				SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
				IF ISNUMERIC(@tempVer) = 1
					SET @minorVersion = CAST (@tempVer AS INT)
			END
		END
		IF @majorVersion < @mysqlMajor OR (@majorVersion = @mysqlMajor AND @minorVersion < @mysqlMinor)
			SET @errorCode = 1
		ELSE
			SET @errorCode = 0
		IF @errorCode = 1
		BEGIN
			SET @errorMessage = 'Client: [' + @clientName + '] Instance: [' + @instanceName + '] MySQL Database version ' + @version + ' is not supported in the latest software version. Please upgrade the DB version before client upgrade.'
		END
		FETCH NEXT FROM mysqlInstCur INTO @clientName, @instanceName, @version
	END
	CLOSE mysqlInstCur
	DEALLOCATE mysqlInstCur
END
-- PostgreSQL
IF @ApptypeID = 125 --CV_APPTYPE_POSTGRE
BEGIN
	INSERT	INTO @postgresVersion
	SELECT  DISTINCT A.clientID, C.name, IP.componentNameId, I.name, IP.attrVal
	FROM    APP_Application A
		INNER JOIN APP_InstanceProp IP ON A.instance = IP.componentNameId
		INNER JOIN APP_InstanceName I ON A.instance = I.id
		INNER JOIN APP_Client C ON A.clientID = C.id
	WHERE   A.appTypeId = 125
		AND     IP.modified = 0
		AND IP.attrName = 'PostgreSQL version'
		AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
	DECLARE	postgresInstCur CURSOR STATIC FOR SELECT t_client, t_instanceName, dbVersion FROM @postgresVersion WHERE t_clientId > 2
	OPEN postgresInstCur
	FETCH NEXT FROM postgresInstCur INTO @clientName, @instanceName, @version
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @minorVersion = 0
		SET @majorVersion = 0
		SET @tempVer = ''
		SET @tempBuffer = ''
		-- Calculate Major Version & Minor version numbers
		IF @version IS NOT NULL
		BEGIN
			IF CHARINDEX('.', @version) > 0
			BEGIN
				SET @tempVer= SUBSTRING(@version, 1, CHARINDEX('.', @version) - 1)
				IF ISNUMERIC(@tempVer) = 1
					SET @majorVersion = CAST (@tempVer AS INT)
			END
			SET @tempBuffer = SUBSTRING(@version, CHARINDEX('.', @version) + 1, LEN(@version))
			IF CHARINDEX('.', @tempBuffer) > 0
			BEGIN
				SET @tempVer= SUBSTRING(@tempBuffer, 1, CHARINDEX('.', @tempBuffer) - 1)
				IF ISNUMERIC(@tempVer) = 1
					SET @minorVersion = CAST (@tempVer AS INT)
			END
		END
		IF @majorVersion < @postgresMajor OR (@majorVersion = @postgresMajor AND @minorVersion < @postgresMinor)
			SET @errorCode = 1
		ELSE
			SET @errorCode = 0
		IF @errorCode = 1
		BEGIN
			SET @errorMessage = 'Client: [' + @clientName + '] Instance: [' + @instanceName + '] PostgreSQL Database version ' + @version + ' is not supported in the latest software version. Please upgrade the DB version before client upgrade.'
		END
		FETCH NEXT FROM postgresInstCur INTO @clientName, @instanceName, @version
	END
	CLOSE postgresInstCur
	DEALLOCATE postgresInstCur
END
SELECT @errorCode, @errorMessage
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'SIMIsClientUpgradable')
	delete from GxQscripts where name = 'SIMIsClientUpgradable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SIMIsClientUpgradable')
	delete from GXDBVersions where aliasname = 'SIMIsClientUpgradable'
GO

insert into GXDBVersions values(2, 'SIMIsClientUpgradable',  '00010001000200010000', 'SIMIsClientUpgradable', '00010001000200010000')
GO

