

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SFGetSaaSOrgInfrastructure.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SFGetSaaSOrgInfrastructure.sp,v $ $Id: SFGetSaaSOrgInfrastructure.sp,v 1.1.2.3 2020/01/27 11:15:06 stelagamsetti Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SFGetSaaSOrgInfrastructure')
BEGIN
	print '>>> Drop Stored Procedure: SFGetSaaSOrgInfrastructure <<<'
	drop procedure SFGetSaaSOrgInfrastructure
END
IF EXISTS (select * from GxQscripts where name='SFGetSaaSOrgInfrastructure')
	delete from GxQscripts where name = 'SFGetSaaSOrgInfrastructure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SFGetSaaSOrgInfrastructure')
	delete from GXDBVersions where aliasname = 'SFGetSaaSOrgInfrastructure'
GO
print '... Creating Procedure: SFGetSaaSOrgInfrastructure'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SFGetSaaSOrgInfrastructure
  @i_userId INT
AS
  DECLARE @o_xml XML;
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#proxyList') is not null DROP TABLE #proxyList
	DECLARE @infraClientGroup INT
	SELECT @infraClientGroup = CAST(attrVal AS INT)
	FROM	APP_CompanyProp C
		INNER JOIN UMDSProviders P
			ON C.componentNameId = P.id and C.attrName = 'Salesforce infrastructure group'
		INNER JOIN UMUsers U
			ON U.umDSproviderId = P.id AND U.id = @i_userID
	DECLARE @syncDB XML
	DECLARE @downloadCachePath NVARCHAR(MAX) = '/tmp'
	DECLARE @backupStreams INT = 1
	DECLARE @selectedProxy INT
	CREATE TABLE #proxyList (clientID INT, sfInstCount INT)
	INSERT INTO #proxyList(clientID)
	SELECT clientID
	FROM	APP_ClientGroupAssoc
	WHERE	clientGroupId = @infraClientGroup
	UPDATE	#proxyList
	SET		sfInstCount = I.instCount
	FROM	#proxyList L
		INNER JOIN (SELECT	CAST(attrVal AS INT) cID, count(*) as instCount
					FROM	APP_InstanceProp
					WHERE	attrName = 'Salesforce backup client'
					GROUP BY attrVal) AS I
			ON L.clientID = I.cID
	SET @selectedProxy = (SELECT TOP 1 clientId FROM #proxyList ORDER BY sfInstCount ASC)
	SELECT	@syncDB = CAST(stringVal AS XML)
	FROM	APP_ComponentProp
	WHERE	componentId = @infraClientGroup
AND	componentType = 8
AND	propertyTypeId = 1043
		AND modified = 0
	SELECT	@downloadCachePath = stringVal
	FROM	APP_ComponentProp
	WHERE	componentId = @infraClientGroup
AND	componentType = 8
AND	propertyTypeId = 1044
		AND modified = 0
	SELECT	@backupStreams = longVal
	FROM	APP_ComponentProp
	WHERE	componentId = @infraClientGroup
AND	componentType = 8
AND	propertyTypeId = 1045
		AND modified = 0
	SET @o_xml =
		(
			(SELECT	@backupStreams AS '@numberOfBackupStreams',
					@downloadCachePath AS '@downloadCachePath',
					(SELECT @selectedProxy AS '@clientId'
						FOR XML PATH('proxyClient'), TYPE),
					(SELECT @syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbEnabled)', 'integer') AS '@dbEnabled',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbHost)', 'NVARCHAR(MAX)') AS '@dbHost',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbInstance)', 'NVARCHAR(MAX)') AS '@dbInstance',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbName)', 'NVARCHAR(MAX)') AS '@dbName',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbPort)', 'integer') AS '@dbPort',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/@dbType)', 'integer') AS '@dbType',
						@syncDB.value('(/App_SalesforceSyncDatabase[1]/dbUserPassword[1]/@userName)', 'NVARCHAR(MAX)') AS 'dbUserPassword/@userName'
						FOR XML PATH('syncDB'), TYPE)
					FOR XML PATH('App_SalesforceSaaSInfra'), TYPE
			)
		)
	/*SET @o_xml = '<App_SalesforceSaaSInfra numberOfBackupStreams="3" downloadCachePath="/var/tmp">
  <proxyClient clientId="4098" />
  <syncDB dbEnabled="1" dbHost="lepakshi2008.testlab.commvault.com" dbInstance="commvault" dbName="CVDEV_DB" dbPort="58661" dbType="2">
    <dbUserPassword password="3072693b913a5521e13feb63d5b4543ea" userName="sa" />
  </syncDB>
</App_SalesforceSaaSInfra>'*/
	SELECT @o_xml
	IF object_id('tempdb.dbo.#proxyList') is not null DROP TABLE #proxyList
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'SFGetSaaSOrgInfrastructure')
	delete from GxQscripts where name = 'SFGetSaaSOrgInfrastructure'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SFGetSaaSOrgInfrastructure')
	delete from GXDBVersions where aliasname = 'SFGetSaaSOrgInfrastructure'
GO

insert into GXDBVersions values(2, 'SFGetSaaSOrgInfrastructure',  '00010001000200030000', 'SFGetSaaSOrgInfrastructure', '00010001000200030000')
GO

