

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEUpdateDataSourceSchedule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEUpdateDataSourceSchedule <<<'

IF EXISTS (select * from sysobjects where name='SEUpdateDataSourceSchedule')
	drop procedure SEUpdateDataSourceSchedule
IF EXISTS (select * from GxQscripts where name='SEUpdateDataSourceSchedule')
	delete from GxQscripts where name = 'SEUpdateDataSourceSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEUpdateDataSourceSchedule')
	delete from GXDBVersions where aliasname = 'SEUpdateDataSourceSchedule'
GO
print '... Creating Procedure: SEUpdateDataSourceSchedule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEUpdateDataSourceSchedule
  @i_datasourceId INT,
  @i_repeatUnits INT,
  @i_status INT = 0,
  @i_hour INT = 0,
  @i_minute INT = 0,
  @i_day INT = 0
AS
	DECLARE @o_errorCode INT =0,
			@o_errorMsg		VARCHAR(MAX) = '',
			@o_scheduleId	INT =0
	--check if datasource id exists
	IF EXISTS ( SELECT TOP 1 * FROM SEDataSource AS DS WITH (NOLOCK) WHERE DS.DataSourceId = @i_datasourceId)
	BEGIN
		SELECT @o_scheduleId = S.ScheduleId FROM SEDataSourceSchedule AS S WITH (NOLOCK) WHERE S.DataSourceId = @i_datasourceId
		--case when entry already exists
		IF @o_scheduleId > 0
		BEGIN
			UPDATE SEDataSourceSchedule SET
				RepeatUnits = @i_repeatUnits,
				Status = @i_status,
				SHour= @i_hour,
				SMinute = @i_minute,
				SDay = @i_day,
				UpdateTime = GETUTCDATE()
			WHERE DataSourceId = @i_datasourceId
		END
		ELSE
		BEGIN
			INSERT INTO SEDataSourceSchedule ( DataSourceId, RepeatUnits, SHour, SMinute, SDay, Status)
			SELECT @i_datasourceId, @i_repeatUnits, @i_hour, @i_minute, @i_day, @i_status
			SET @o_scheduleId  = @@IDENTITY
		END
	END
	ELSE
		SELECT @o_errorCode = 10627, @o_errorMsg = 'Input datasourceid ' + CONVERT(VARCHAR(10),@i_datasourceId) + ' doesnt exists.'
	SELECT @o_scheduleId 'ScheduleId', @o_errorCode 'ErrorCode', @o_errorMsg 'ErrorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SEUpdateDataSourceSchedule')
	delete from GxQscripts where name = 'SEUpdateDataSourceSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEUpdateDataSourceSchedule')
	delete from GXDBVersions where aliasname = 'SEUpdateDataSourceSchedule'
GO

insert into GXDBVersions values(2, 'SEUpdateDataSourceSchedule',  '00000000000000000000', 'SEUpdateDataSourceSchedule', '00000000000000000000')
GO

