

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEUpdateDSProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEUpdateDSProperties <<<'

IF EXISTS (select * from sysobjects where name='SEUpdateDSProperties')
	drop procedure SEUpdateDSProperties
IF EXISTS (select * from GxQscripts where name='SEUpdateDSProperties')
	delete from GxQscripts where name = 'SEUpdateDSProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEUpdateDSProperties')
	delete from GXDBVersions where aliasname = 'SEUpdateDSProperties'
GO
print '... Creating Procedure: SEUpdateDSProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEUpdateDSProperties
  @i_userId INT,
  @i_xmlText XML
AS
BEGIN
	/*
		Stored proc to update datasource external properties.
		This currently, doesnt have security on datasourceId. Assuming this property can be updated by any one.
	*/
	DECLARE @o_errorCode	INT = 0,
			@o_errorMsg		NVARCHAR(MAX) = ''
	DECLARE @EXCLUDE_ATTRIBUTE	INT=2,
			@dataSourceType	INT	= 0,
			@dataSourceId	INT = 0,
			@typeGuid		VARCHAR(36) = '',
			@parentTypeGuid		VARCHAR(36) = ''
	SELECT @dataSourceId = ISNULL(R.ref.value('@datasourceId','INT'),0)
	FROM @i_xmlText.nodes('DM2ContentIndexing_SEDataSource') R ( ref )
	--basic validation, check if datasource/type exists..
	--
	SELECT @dataSourceType = DataSourceType  FROM SEDataSource WITH (NOLOCK)
	WHERE DataSourceId = @dataSourceId AND @dataSourceId > 0 AND (Attribute & 4) = 0
	IF @dataSourceType = 0
	BEGIN
		SELECT @o_errorCode = 10627, @o_errorMsg = 'Input datasourceId doesnt exists. Value ' + CONVERT(VARCHAR(10),@dataSourceId)
		GOTO _EXIT;
	END
	--fetch dsType guids
	--
	SELECT @typeGuid = T.TypeGuid, @parentTypeGuid = T.ParentTypeGuid  FROM SEDataSourceType as T WHERE T.TypeId = @dataSourceType
	-- retrieve properties fields
	--
	IF object_id('tempdb.dbo.#tmpDSProperties') IS NOT NULL
		DROP TABLE #tmpDSProperties
	CREATE TABLE #tmpDSProperties
	(
		PropertyId		int DEFAULT 0,
		PropertyName	VARCHAR(256) ,
		PropertyValue	NVARCHAR(MAX),
		IsExists		BIT DEFAULT 0,
		Attribute		INT DEFAULT 0
	);
	INSERT INTO #tmpDSProperties (PropertyName, PropertyValue)
	SELECT R.ref.value('@propertyName','VARCHAR(1024)'), R.ref.value('@propertyValue','NVARCHAR(MAX)')
	FROM @i_xmlText.nodes('DM2ContentIndexing_SEDataSource/properties') R ( ref )
	--Update properties table which ever belong to input satisfies condition
	--
	UPDATE t
		SET PropertyId = SP.PropertyId,
			Attribute = SP.Attribute
	FROM #tmpDSProperties as t
		INNER JOIN 	SEProperty AS SP
	ON t.PropertyName = SP.PropertyName AND
		(SP.Attribute & 4)  = 0 AND
		(SP.DSTypeAttribute = -1 OR
			EXISTS ( SELECT TOP 1 * FROM SEDataSourceTypePropertyMap AS M WITH (NOLOCK)
			WHERE SP.PropertyGuid = M.PropertyGuid AND M.TypeGuid IN (@typeGuid, @parentTypeGuid) AND (M.Attribute & 4)  = 0) )
	--delete ones that is not exclude attributes
	--DELETE #tmpDSProperties WHERE Attribute & @EXCLUDE_ATTRIBUTE != @EXCLUDE_ATTRIBUTE
	--insert or update the value.
	 IF EXISTS (SELECT TOP 1 PropertyId FROM #tmpDSProperties)
	 BEGIN
		MERGE SEDataSourceProperty as DS
		USING (SELECT * FROM #tmpDSProperties) as P
		ON DS.DataSourceId = @datasourceId AND DS.PropertyId = P.PropertyId
		WHEN MATCHED THEN
			UPDATE SET PropertyValue = P.PropertyValue,
						ModifiedTime = GETUTCDATE()
		WHEN NOT MATCHED THEN
			INSERT (DataSourceId, PropertyId, PropertyValue)
			values( @datasourceId,P.PropertyId, P.PropertyValue);
	 END
_EXIT:
	SELECT  @o_errorCode 'o_errorCode', @o_errorMsg 'o_errorMsg'
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEUpdateDSProperties')
	delete from GxQscripts where name = 'SEUpdateDSProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEUpdateDSProperties')
	delete from GXDBVersions where aliasname = 'SEUpdateDSProperties'
GO

insert into GXDBVersions values(2, 'SEUpdateDSProperties',  '00000000000000000000', 'SEUpdateDSProperties', '00000000000000000000')
GO

