

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SESaveSearchServerDataStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SESaveSearchServerDataStats.sp,v $ $Id: SESaveSearchServerDataStats.sp,v 1.1.2.7 2020/10/14 17:33:05 canand Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SESaveSearchServerDataStats')
BEGIN
	print '>>> Drop Stored Procedure: SESaveSearchServerDataStats <<<'
	drop procedure SESaveSearchServerDataStats
END
IF EXISTS (select * from GxQscripts where name='SESaveSearchServerDataStats')
	delete from GxQscripts where name = 'SESaveSearchServerDataStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveSearchServerDataStats')
	delete from GXDBVersions where aliasname = 'SESaveSearchServerDataStats'
GO
print '... Creating Procedure: SESaveSearchServerDataStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SESaveSearchServerDataStats
  @i_InputXml XML
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @curTime			DATETIME
	DECLARE @curUnixTime		BIGINT
	DECLARE @result INT = -1
	DECLARE @errMsg NVARCHAR(MAX) = ''
	DECLARE @errorCode	INTEGER = 0
	DECLARE @outputXML XML
	DECLARE @debug INT = 0
	IF OBJECT_ID('tempdb.dbo.#SearchServerDataStats') IS NOT NULL
		DROP TABLE #SearchServerDataStats
	CREATE TABLE #SearchServerDataStats (
		nodeClientId					int,
		serverPort						int,
		coreName						nvarchar(256),
		propertyName					nvarchar(256),
		entityType						int,
		entityId						int,
		propertyValue					nvarchar(max),
		valueType						int,
		ShardId							int,
		DataSourceId					int,
		serverType						int,
		searchServerCoreId				int,
		cloudId							int
	)
	IF OBJECT_ID('tempdb.dbo.#tmpAction') IS NOT NULL
		DROP TABLE #tmpAction
	--
	create table #tmpAction (ShardId INT, PropertyName nvarchar(100), NewLongValue bigint, NewValue nvarchar(max), EntityId INT, EntityType INT)
	--
	INSERT INTO #SearchServerDataStats (nodeClientId, serverPort, serverType, coreName, propertyName, propertyValue, valueType, entityType, entityId, DataSourceId)
	SELECT
		ISNULL(K.ch.value('@clientId', 'INT'), 0) AS nodeClientId,
		ISNULL(K.ch.value('@basePort', 'INT'), 0) AS serverPort,
		ISNULL(K.ch.value('@serverType', 'INT'), 0) as serverType,
		dbo.DecodeInvalidXMLChar(ISNULL(K.ch.value('@coreName', 'nvarchar(256)'), '')) AS coreName,
		dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@propertyName', 'nvarchar(256)'), '')) AS propertyName,
		dbo.DecodeInvalidXMLChar(T.ref.value('@propertyValue', 'nvarchar(max)')) AS propertyValue,
		ISNULL(T.ref.value('@valueType', 'INT'), 0) AS valueType,
		ISNULL(T.ref.value('@entityType', 'INT'), 0) AS entityType,
		ISNULL(T.ref.value('@entityId', 'INT'), 0) as entityId,
		ISNULL(T.ref.value('@datasourceId', 'INT'), 0) as DataSourceId
	FROM @i_InputXml.nodes('/DM2ContentIndexing_SearchServerNodeShardProp/shardInfo') K(ch)
	CROSS APPLY ch.nodes('dataStats') T(ref)
	--
	-- basic validation: check node client id and port number given for all records
	--
	IF EXISTS (SELECT 1 FROM #SearchServerDataStats WHERE nodeClientId = 0 OR serverPort = 0 OR propertyValue IS NULL)
	BEGIN
		SET @errorCode = 1001 -- validation error
		SET @errMsg = 'ClientId, serverPort and property value is mandatory for all entries'
		GOTO CX_EXIT
	END
	IF EXISTS (SELECT 1 FROM #SearchServerDataStats WHERE valueType IN (0, 2) AND ISNUMERIC(propertyValue) = 0)
	BEGIN
		SET @errorCode = 1001 -- validation error
		SET @errMsg = 'Invalid data type values given'
		GOTO CX_EXIT
	END
	--
	-- check if core name given on all entries..
	--
	IF EXISTS (SELECT 1 FROM #SearchServerDataStats WHERE ISNULL(coreName, '') = '')
	BEGIN
		SET @errorCode = 1001 -- validation error
		SET @errMsg = 'collection name is mandatory for all entries'
		GOTO CX_EXIT
	END
	--
	-- As of now, we expect for index server data to be already synchronized to parent table SEIndexServerNodeStats
	-- But for search engine, we take care of inserting into table SEIndexServerNodeStats if record not found here itself
	--
	UPDATE I
	SET I.ShardId = J.ShardId,
	I.searchServerCoreId = C.CoreId,
	I.cloudid = c.CloudId,
	I.DataSourceId = CASE WHEN I.DataSourceId <> 0 THEN I.DataSourceId ELSE J.DataSourceId END
	FROM #SearchServerDataStats I
	JOIN DM2SearchServerCoreInfo C WITH(NOLOCK) ON (C.ClientId = I.nodeClientId AND C.PortNo = I.serverPort)
	LEFT JOIN SEIndexServerNodeStats J WITH(NOLOCK) ON C.CoreId = J.SearchServerCoreId AND I.coreName = J.CoreName
	IF @DEBUG = 1
	BEGIN
		SELECT * FROM #SearchServerDataStats
	END
	--
	-- Init current datetime value..
	--
	SET @curTime = getutcdate()
	SET @curUnixTime = dbo.getUnixTime(@curTime)
	--
	-- For search engine, we may not be inserting data to SEIndexServerNodeStats and hence we insert it here if not already exist..
	--
IF EXISTS (SELECT 1 FROM #SearchServerDataStats WHERE ISNULL(ShardId, 0) = 0 AND serverType = 3)
	BEGIN
		INSERT INTO SEIndexServerNodeStats (SearchServerCoreId, DataSourceId, CollectionName, ShardName, CoreName, ItemCount, Size, IndexDirectory, IsLeader, IsActive, [Status], Attribute, CreatedTime)
		SELECT searchServerCoreId, NULL, CoreName, CoreName, coreName, 0, 0, dbo.SEGetIndexLocation(I.cloudid, I.nodeClientId), 0, 0, 0, 0, @curUnixTime FROM #SearchServerDataStats I
WHERE I.serverType = 3 AND NOT EXISTS (SELECT 1 FROM SEIndexServerNodeStats D WHERE D.coreName = I.CoreName AND D.SearchServerCoreId = I.SearchServerCoreId)
		--
		-- now re-map shardid..
		--
		UPDATE I
		SET I.ShardId = J.ShardId
		FROM #SearchServerDataStats I
JOIN SEIndexServerNodeStats J WITH(NOLOCK) ON I.coreName = J.coreName AND I.searchServerCoreId = J.SearchServerCoreId AND I.serverType = 3
	END
	--
	-- If search server's core (ShardId) can't be mapped, return error unless there is setting to bypass such errors..
	--
	IF EXISTS (SELECT 1 FROM #SearchServerDataStats WHERE ISNULL(ShardId, 0) = 0)
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM GxGlobalParam WHERE name = 'IgnoreOrphanCollectionStats' and value in ('1', 'true'))
		BEGIN
			DECLARE @CoreNamesInvalid nvarchar(max) = ''
			SET @CoreNamesInvalid = STUFF((SELECT ',' + CoreName + ' of client # ' + CONVERT(VARCHAR(10), nodeClientId) AS [text()] FROM #SearchServerDataStats WHERE ISNULL(ShardId, 0) = 0 order by nodeClientId FOR XML PATH('')), 1, 1, '')
			SET @errorCode = 1001 -- validation error
			SET @errMsg = 'Invalid inputs: ['+@CoreNamesInvalid+']'
			GOTO CX_EXIT
		END
		ELSE
		BEGIN
			DELETE #SearchServerDataStats WHERE ISNULL(ShardId, 0) = 0
		END
	END
	--
	-- All validations done, merge data into main table now..
	--
	BEGIN TRY
	BEGIN TRAN
		--Add lock so that we dont attempt duplicate insertion to SEIndexServerNodeStatsProp table (when parallel execution happens)
		EXEC @result = sp_getapplock @Resource = 'SESaveSearchServerDataStats', @LockMode = 'Exclusive', @LockTimeout = 600000
		IF @result < 0
		BEGIN
			SET @errMsg = CASE @result
									when -1 then 'Explicit Raise Error: Applock request timed out.'
									when -2 then 'Applock request canceled.'
									when -3 then 'Explicit Raise Error: Applock involved in deadlock'
									else 'Parameter validation or other call error.'
								end
			SET @errorCode = 1001 -- validation error
			RAISERROR (@errMsg,16,1)
		END
		--
		-- Set the Attribute for all shardIds part of the request to be marked for deletion.
		-- The valid records would be reverted as part of the MERGE statement.
		--
		UPDATE SEIndexServerNodeStatsProp
		SET Attribute = Attribute | 4 WHERE ShardId IN (SELECT DISTINCT ShardId FROM #SearchServerDataStats)
		--
		-- Merge condition is primarily based on shardid, propertyname and entityid when input entitytype > 0
		-- if input entitytype = 0 then merge condition is effecitvely based on shardid, propertyname and datasourceid
		--
		MERGE SEIndexServerNodeStatsProp AS ST
		USING (SELECT ShardId, DataSourceId, PropertyName, EntityType, EntityId, PropertyValue, ValueType FROM #SearchServerDataStats) as I
			ON ST.ShardId = I.ShardId
			AND ST.PropertyName = I.PropertyName
			AND (ISNULL(I.EntityType, 0) = 0 AND (ISNULL(I.DataSourceId, 0) > 0 AND ST.DataSourceId = I.DataSourceId)
				OR
				(ISNULL(I.DataSourceId, 0) = 0 AND ISNULL(I.EntityType, 0) > 0 AND ISNULL(I.EntityId, 0) > 0 AND ST.EntityType = I.EntityType AND ST.EntityId = I.EntityId)
				OR
				(ISNULL(I.EntityType, 0) > 0 AND ISNULL(I.EntityId, 0) > 0 AND ISNULL(I.DataSourceId, 0) > 0 AND ST.EntityType = I.EntityType AND ST.EntityId = I.EntityId AND ST.DataSourceId = I.DataSourceId)
				)
		WHEN NOT MATCHED THEN
			INSERT (ShardId, DataSourceId, PropertyName, EntityType, EntityId, PropertyValue, PropertyLongValue, ValueType, CreatedTime, LastUpdateTime)
			VALUES (I.ShardId,
			(CASE WHEN I.DataSourceId = 0 THEN NULL ELSE I.DataSourceId END),
			I.PropertyName, I.EntityType, I.EntityId,
			(CASE WHEN I.ValueType IN (0, 2) THEN NULL ELSE I.PropertyValue END),
			(CASE WHEN I.ValueType IN (0, 2) THEN CONVERT(BIGINT, I.PropertyValue) ELSE NULL END),
			I.ValueType, @curUnixTime, @curUnixTime)
		WHEN MATCHED THEN
			UPDATE SET
			PropertyValue = (CASE WHEN I.ValueType IN (0, 2) THEN NULL ELSE I.PropertyValue END),
			PropertyLongValue = (CASE WHEN I.ValueType IN (0, 2) THEN CONVERT(BIGINT, I.PropertyValue) ELSE NULL END),
			LastUpdateTime = @curUnixTime,
			Attribute = Attribute & ~4
		output
			(case when deleted.ShardId is not null and deleted.ShardId > 0 THEN deleted.shardid else inserted.shardid end) AS ShardId,
			(case when inserted.propertyname is not null then inserted.propertyname else deleted.propertyname end) as propertyname,
			inserted.PropertyLongValue as NewLongValue,
			inserted.PropertyValue as NewValue,
			(case
			when inserted.DataSourceId is not null and inserted.DataSourceId > 0 then inserted.DataSourceId
			when deleted.DataSourceId is not null and deleted.DataSourceId > 0 then deleted.DataSourceId
			when inserted.EntityId is not null and inserted.EntityId > 0 then inserted.EntityId
			when deleted.Entityid is not null and deleted.Entityid > 0 then deleted.Entityid
			else 0 end) as EntityId,
			(case
				when inserted.EntityType is not null and inserted.EntityType > 0 then inserted.EntityType
				when deleted.EntityType is not null and deleted.EntityType > 0 then deleted.EntityType
				else 132 end) as EntityType
		into #tmpAction;
		--
		-- Delete the records from the prop table where client information isn't available anymore in the App_Client table.
		--
		DELETE FROM SEIndexServerNodeStatsProp
WHERE EntityType = 3 AND EntityId NOT IN (SELECT AC.id FROM App_Client AS AC WITH(NOLOCK))
		IF @DEBUG = 1
		BEGIN
			SELECT * FROM #tmpAction
		END
		/*
		--Refer enum for valuetype meaning in dm2contentindexing.x below structure
		enum PropertyType
		{
			Long = 0,
			String = 1,
			UnixTime = 2
		}
		*/
		EXEC @result = sp_releaseapplock @Resource = 'SESaveSearchServerDataStats'
		if @@ERROR = 0
			COMMIT TRANSACTION
		else
			ROLLBACK TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		if @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
		SET @errMsg = ERROR_MESSAGE()
		SET @errorCode = ERROR_NUMBER()
	END CATCH
	CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#SearchServerDataStats') IS NOT NULL
		DROP TABLE #SearchServerDataStats
	IF OBJECT_ID('tempdb.dbo.#tmpAction') IS NOT NULL
		DROP TABLE #tmpAction
	SET @outputXML = (SELECT @errorCode AS '@errorCode', @errMsg AS '@errLogMessage' FOR XML PATH('DM2ContentIndexing_Error'), TYPE)
	SELECT @outputXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'SESaveSearchServerDataStats')
	delete from GxQscripts where name = 'SESaveSearchServerDataStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveSearchServerDataStats')
	delete from GXDBVersions where aliasname = 'SESaveSearchServerDataStats'
GO

insert into GXDBVersions values(2, 'SESaveSearchServerDataStats',  '00010001000200070000', 'SESaveSearchServerDataStats', '00010001000200070000')
GO

