

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SESaveIndexScaleJobInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SESaveIndexScaleJobInfo')
BEGIN
	print '>>> Drop Stored Procedure: SESaveIndexScaleJobInfo <<<'
	drop procedure SESaveIndexScaleJobInfo
END
IF EXISTS (select * from GxQscripts where name='SESaveIndexScaleJobInfo')
	delete from GxQscripts where name = 'SESaveIndexScaleJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveIndexScaleJobInfo')
	delete from GXDBVersions where aliasname = 'SESaveIndexScaleJobInfo'
GO
print '... Creating Procedure: SESaveIndexScaleJobInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SESaveIndexScaleJobInfo
  @i_InputXml XML
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @outputXML				XML
	DECLARE @errorCode				INTEGER = 0
	DECLARE @errMsg					NVARCHAR(MAX) = ''
	DECLARE @popertyId				INT
	DECLARE @curUnixTime			BIGINT
	DECLARE @i_newNodeClientId		INT = ISNULL(@i_InputXml.value('(/DM2ContentIndexing_ScaleIndexReq/destinationClient/@clientId)[1]', 'INT'), 0)
	DECLARE @i_jobId				BIGINT = ISNULL(@i_InputXml.value('(/DM2ContentIndexing_ScaleIndexReq/@jobId)[1]', 'BIGINT'), 0)
	DECLARE @i_indexServerClientId	INT = ISNULL(@i_InputXml.value('(/DM2ContentIndexing_ScaleIndexReq/indexServerClient/@clientId)[1]', 'INT'), 0)
	--
	-- Verify if the indexserverClientId is supplied in the request
	--
	IF @i_indexServerClientId = 0
	BEGIN
		SET @errorCode = 1001 --validation error
		SET @errMsg = 'Failed to provide indexserver client id'
		GOTO CX_EXIT
	END
	IF OBJECT_ID('tempdb.dbo.#ScaleIndexCoreInfo') IS NOT NULL
		DROP TABLE #ScaleIndexCoreInfo
	CREATE TABLE #ScaleIndexCoreInfo (
		DatasourceId		INT,
		CoreId				INT,
		CoreStatus			INT
	)
	IF OBJECT_ID('tempdb.dbo.#ScaleIndexProperties') IS NOT NULL
		DROP TABLE #ScaleIndexProperties
	CREATE TABLE #ScaleIndexProperties (
		DatasourceId		INT,
		PropertyId			INT,
		PropertyValue		NVARCHAR(128)
	)
	INSERT INTO #ScaleIndexCoreInfo(DatasourceId, CoreId, CoreStatus)
	SELECT SED.DataSourceId, SED.CoreId, SIC.CoreStatus
	FROM SEDataSource AS SED WITH(NOLOCK)
	INNER JOIN SECollectionInfo AS SEC WITH(NOLOCK) ON SED.CoreId = SEC.CoreId
	INNER JOIN DM2Cloud AS DMC WITH(NOLOCK) ON SEC.CloudID = DMC.cloudId AND DMC.pseudoClientId = @i_indexServerClientId
	INNER JOIN (SELECT ISNULL(K.ch.value('@coreName', 'NVARCHAR(256)'), '') AS CoreName,
					   ISNULL(K.ch.value('@coreStatus', 'INT'), 0) AS CoreStatus
				FROM @i_InputXml.nodes('/DM2ContentIndexing_ScaleIndexReq/coresInfo') AS K(ch)) AS SIC ON SEC.ActualCoreName = SIC.CoreName
	--
	-- Add the indexscalingjobid property to the temp table if jobId is available
	--
	IF @i_jobId <> 0
	BEGIN
		SET @popertyId = (SELECT PropertyId from SEProperty WHERE PropertyGuid = '83661EB7-3E3B-4C69-A07F-7103714AE221')
		INSERT INTO #ScaleIndexProperties(DatasourceId, PropertyId, PropertyValue)
		SELECT SIC.DataSourceId, @popertyId, CAST(@i_jobId AS NVARCHAR) FROM #ScaleIndexCoreInfo AS SIC
	END
	--
	-- Add the indexscalingcorestatus property to the temp table
	--
	SET @popertyId = (SELECT PropertyId from SEProperty WHERE PropertyGuid = '50C23A5D-70EA-4BB7-81D6-22027BD82E16')
	INSERT INTO #ScaleIndexProperties(DatasourceId, PropertyId, PropertyValue)
	SELECT SIC.DataSourceId, @popertyId, CAST(SIC.CoreStatus AS NVARCHAR) FROM #ScaleIndexCoreInfo AS SIC
	--
	-- Add the indexscalingperformedat property to the temp table
	--
	SET @popertyId = (SELECT PropertyId from SEProperty WHERE PropertyGuid = '1BC7C40D-1E4F-4809-8A85-E8786A93CB73')
	SET @curUnixTime = dbo.GetUnixTime(GETUTCDATE())
	INSERT INTO #ScaleIndexProperties(DatasourceId, PropertyId, PropertyValue)
	SELECT SIC.DataSourceId, @popertyId, CAST(@curUnixTime AS NVARCHAR) FROM #ScaleIndexCoreInfo AS SIC
	--
	-- Now perform the actual manipulations
	-- 1. Set the new nodeClientId if provided for succeeded cores
	-- 2. MERGE the data source properties
	--
	IF @i_newNodeClientId <> 0
	BEGIN
		UPDATE SECollectionInfo
		SET ClientId = @i_newNodeClientId FROM SECollectionInfo SEC, #ScaleIndexCoreInfo SIC
		WHERE SEC.CoreId = SIC.CoreId AND SIC.CoreStatus = 4
	END
	MERGE SEDataSourceProperty AS SDP
	USING #ScaleIndexProperties AS SIP
	ON SDP.DataSourceId = SIP.DatasourceId AND SDP.PropertyId = SIP.PropertyId
	WHEN MATCHED THEN
		UPDATE SET SDP.PropertyValue = SIP.PropertyValue, SDP.ModifiedTime = GETUTCDATE()
	WHEN NOT MATCHED THEN
		INSERT(DataSourceId, PropertyId, PropertyValue)
		VALUES(SIP.DatasourceId, SIP.PropertyId, SIP.PropertyValue);
	CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#ScaleIndexCoreInfo') IS NOT NULL
		DROP TABLE #ScaleIndexCoreInfo
	IF OBJECT_ID('tempdb.dbo.#ScaleIndexProperties') IS NOT NULL
		DROP TABLE #ScaleIndexProperties
	SET @outputXML = (SELECT @errorCode AS '@errorCode', @errMsg AS '@errLogMessage' FOR XML PATH('DM2ContentIndexing_Error'), TYPE)
	SELECT @outputXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'SESaveIndexScaleJobInfo')
	delete from GxQscripts where name = 'SESaveIndexScaleJobInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveIndexScaleJobInfo')
	delete from GXDBVersions where aliasname = 'SESaveIndexScaleJobInfo'
GO

insert into GXDBVersions values(2, 'SESaveIndexScaleJobInfo',  '00000000000000000000', 'SESaveIndexScaleJobInfo', '00000000000000000000')
GO

