

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SESaveIndexNodeStatInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SESaveIndexNodeStatInfo.sp,v $ $Id: SESaveIndexNodeStatInfo.sp,v 1.1.2.8 2020/09/23 03:31:44 canand Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SESaveIndexNodeStatInfo')
BEGIN
	print '>>> Drop Stored Procedure: SESaveIndexNodeStatInfo <<<'
	drop procedure SESaveIndexNodeStatInfo
END
IF EXISTS (select * from GxQscripts where name='SESaveIndexNodeStatInfo')
	delete from GxQscripts where name = 'SESaveIndexNodeStatInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveIndexNodeStatInfo')
	delete from GXDBVersions where aliasname = 'SESaveIndexNodeStatInfo'
GO
print '... Creating Procedure: SESaveIndexNodeStatInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SESaveIndexNodeStatInfo
  @i_InputXml XML
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @DEBUG				INT = 0
	DECLARE @curTime			DATETIME
	DECLARE @curUnixTime		BIGINT
	DECLARE @result INT = -1
	DECLARE @errMsg NVARCHAR(MAX) = ''
	DECLARE @errorCode	INTEGER = 0
	DECLARE @coreInfoUnavailable TINYINT = 1 -- IndexServerNodeShardStatus.attribute = 1
	DECLARE @outputXML XML
	--
	IF OBJECT_ID('tempdb.dbo.#MultinodeDSIds') IS NOT NULL
		DROP TABLE #MultinodeDSIds
	CREATE TABLE #MultinodeDSIds (
		DataSourceId INT
	)
	IF OBJECT_ID('tempdb.dbo.#IndexServerNodeStats') IS NOT NULL
		DROP TABLE #IndexServerNodeStats
	CREATE TABLE #IndexServerNodeStats (
		HostName						NVARCHAR(1024),
		PortNumber						INT,
		ShardId							INT Default 0,
		CloudId 						INT Default 0,
		NodeClientId 					INT Default 0,
		DataSourceId					INT,
		CollectionName 					NVARCHAR(256),
		ShardName						NVARCHAR(256),
		CoreName						NVARCHAR(256),
		ItemCount	 					BIGINT,
		Size 							BIGINT,
		IndexDirectory					NVARCHAR(1024),
		IsLeader						TINYINT,
		IsActive						TINYINT,
		[Status]						INT,
		Attribute						TINYINT,
		SearchServerCoreId 				INT
	)
	INSERT INTO #IndexServerNodeStats (CollectionName, ShardName, CoreName, ItemCount, Size, IndexDirectory, IsLeader, IsActive, [Status], NodeClientId, Attribute, PortNumber)
	SELECT
	dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@collectionName', 'nvarchar(256)'), '')) AS CollectionName,
	dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@shardName', 'nvarchar(256)'), '')) AS ShardName,
	dbo.DecodeInvalidXMLChar(ISNULL(T.ref.value('@coreName', 'nvarchar(256)'), '')) AS CoreName,
	T.ref.value('@itemCount', 'BIGINT') AS ItemCount,
	T.ref.value('@indexSize', 'BIGINT') AS Size,
	dbo.DecodeInvalidXMLChar(T.ref.value('@indexLocation', 'nvarchar(1024)')) AS IndexDirectory,
	ISNULL(T.ref.value('@isLeader', 'TINYINT'), 0) AS IsLeader,
	ISNULL(T.ref.value('@isActive', 'TINYINT'), 0) AS IsActive,
	ISNULL(T.ref.value('@status', 'INT'), 0) AS [Status],
	ISNULL(T.ref.value('@clientId', 'INT'), 0) AS NodeClientId,
	ISNULL(T.ref.value('@attribute', 'INT'), 0) AS Attribute,
	ISNULL(T.ref.value('@basePort', 'INT'), 0) AS PortNumber
	FROM @i_InputXml.nodes('/DM2ContentIndexing_IndexServerNodeShards/shardInfo') T(ref)
	--
	-- basic validation: check client id given for all entries
	--
	IF EXISTS (SELECT TOP 1 1 FROM #IndexServerNodeStats WHERE ISNULL(NodeClientId, 0) = 0)
	BEGIN
		SET @errorCode = 1001 -- validation error
		SET @errMsg = 'ClientId is mandatory for all entries'
		GOTO CX_EXIT
	END
	--
	-- check if core name given on all entries..
	--
	IF EXISTS (SELECT TOP 1 1 FROM #IndexServerNodeStats WHERE ISNULL(CoreName, '') = '')
	BEGIN
		SET @errorCode = 1001 -- validation error
		SET @errMsg = 'Core Name is mandatory for all entries'
		GOTO CX_EXIT
	END
	--
	-- locate index server and data source info for given collections/cores..
	--
	UPDATE I
	SET I.CloudId = Col.CloudId,
	I.DataSourceId = DS.DataSourceId,
	I.ShardName = (CASE WHEN ShardName = '' THEN I.CoreName ELSE I.ShardName END),
	I.CollectionName = (CASE WHEN I.CollectionName = '' THEN COL.ActualCoreName ELSE I.CollectionName END)
	FROM #IndexServerNodeStats I
	JOIN DM2SearchServerCoreInfo DMC WITH(NOLOCK) ON DMC.ClientId = I.NodeClientId
JOIN SECollectionInfo COL WITH(NOLOCK) ON (COL.ActualCoreName = (CASE WHEN DMC.CloudType = 1 THEN I.CoreName WHEN DMC.CloudType = 5 THEN I.CollectionName END)) AND (COL.ClientId = (CASE WHEN DMC.CloudType = 1 THEN DMC.ClientId WHEN DMC.CloudType = 5 THEN 0 END)) AND (COL.CloudID = DMC.CloudId)
	LEFT JOIN SEDataSource DS WITH(NOLOCK) ON COL.CoreId = DS.CoreId
WHERE DMC.CloudType IN ( 1 , 5 )
	--
	-- all dynamic collections already mapped
	-- cloudid if not already mapped (these are most likely static cores/collections)
	-- using client id and port number, map correct cloudid for static collections..
	--
	UPDATE I
	SET I.CloudId = D.CloudId
	FROM #IndexServerNodeStats I
	JOIN DM2SearchServerCoreInfo D WITH(NOLOCK) ON I.NodeClientId = D.ClientID AND I.PortNumber = D.Portno
WHERE ISNULL(I.CloudId, 0) = 0 AND D.CloudType IN ( 1 , 5, 3 )
	--
	-- If Index Server info (cloudid) can't be mapped, return error
	--
	IF EXISTS (SELECT TOP 1 1 FROM #IndexServerNodeStats WHERE ISNULL(CloudId, 0) = 0)
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 1 FROM GxGlobalParam WHERE name = 'IgnoreOrphanCollectionStats' and value in ('1', 'true'))
		BEGIN
			DECLARE @CoreNamesNoCloudId nvarchar(max) = ''
			SELECT @CoreNamesNoCloudId = STUFF((SELECT ',' + CoreName AS [text()] FROM #IndexServerNodeStats WHERE ISNULL(CloudId, 0) = 0 FOR XML PATH('')), 1, 1, '')
			SELECT @CoreNamesNoCloudId = 'Unable to locate index server for following cores:' + @CoreNamesNoCloudId
			SET @errorCode = 1001 -- validation error
			SET @errMsg = @CoreNamesNoCloudId
			GOTO CX_EXIT
		END
		ELSE
		BEGIN
			DELETE #IndexServerNodeStats WHERE ISNULL(CloudId, 0) = 0
		END
	END
	---
	--- Populate multinode data sources information too
	---
	INSERT INTO #MultinodeDSIds(DataSourceId)
	SELECT DISTINCT SDR.FederatedDataSourceId from #IndexServerNodeStats I, SEDataSourceRoute SDR WITH(NOLOCK) where I.DataSourceId = SDR.DataSourceId
	INSERT INTO #IndexServerNodeStats(CloudId, NodeClientId, DataSourceId, CollectionName, ShardName, CoreName, ItemCount, Size, IndexDirectory, IsLeader, IsActive, [Status])
	SELECT SEC.CloudID, SEC.ClientId, SED.DataSourceId, SEC.ActualCoreName, SEC.ActualCoreName, SEC.ActualCoreName, 0, 0, '', 0, 1, 0 FROM SECollectionInfo AS SEC WITH(NOLOCK)
	INNER JOIN SEDataSource AS SED WITH(NOLOCK) ON SED.CoreId = SEC.CoreId
	INNER JOIN #MultinodeDSIds AS MDS ON MDS.DataSourceId = SED.DataSourceId
	--
	-- Capture CoreId FROM DM2SearchServerCoreInfo before merging data to main table SEIndexServerNodeStats
	--
	UPDATE I
	SET I.SearchServerCoreId = CoreId
	FROM #IndexServerNodeStats I
	JOIN DM2SearchServerCoreInfo S WITH(NOLOCK) ON I.CloudId = S.CloudId AND I.NodeClientId = S.ClientId AND
S.CloudType IN ( 1 , 5, 3 )
	--
	-- All validations done, merge data into main table now..
	--
	BEGIN TRY
	BEGIN TRAN
		--Add lock so that we dont attempt duplicate insertion to SEIndexServerNodeStats table (when parallel execution happens)
		EXEC @result = sp_getapplock @Resource = 'SESaveIndexNodeStatInfo', @LockMode = 'Exclusive', @LockTimeout = 60000
		IF @result < 0
		BEGIN
			SET @errMsg = CASE @result
									when -1 then 'Explicit Raise Error: Applock request timed out.'
									when -2 then 'Applock request canceled.'
									when -3 then 'Explicit Raise Error: Applock involved in deadlock'
									else 'Parameter validation or other call error.'
								end
			SET @errorCode = 1001 -- validation error
			RAISERROR (@errMsg,16,1)
		END
		SET @curTime = getutcdate()
		SET @curUnixTime = dbo.getUnixTime(@curTime)
		--
		-- insert new entries to permanent table and update size & item count for existing entries..
		-- Update ItemCount and Size only if the status isn't NotFound(3)
		--
		MERGE SEIndexServerNodeStats AS ST
		USING (SELECT SearchServerCoreId, DataSourceId, CollectionName, ShardName, CoreName, ItemCount, Size, IndexDirectory, IsLeader, IsActive, Status, @curTime CreatedTime, ShardId, Attribute FROM #IndexServerNodeStats) as I
			ON ST.CoreName = I.CoreName AND ST.SearchServerCoreId = I.SearchServerCoreId
		WHEN NOT MATCHED THEN
			INSERT (SearchServerCoreId, DataSourceId, CollectionName, ShardName, CoreName, ItemCount, Size, IndexDirectory, IsLeader, IsActive, [Status], Attribute, CreatedTime)
			VALUES (I.SearchServerCoreId, I.DataSourceId, I.CollectionName, I.ShardName, I.CoreName, I.ItemCount, I.Size, I.IndexDirectory, I.IsLeader, I.IsActive, I.Status, 0, @curUnixTime)
		WHEN MATCHED THEN
			UPDATE SET Size = CASE WHEN I.Attribute <> @coreInfoUnavailable THEN I.Size ELSE ST.Size END,
					   ItemCount = CASE WHEN I.Attribute <> @coreInfoUnavailable THEN I.ItemCount ELSE ST.ItemCount END,
					   IndexDirectory = CASE WHEN I.Attribute <> @coreInfoUnavailable THEN I.IndexDirectory ELSE ST.IndexDirectory END,
					   IsLeader = I.IsLeader, IsActive = I.IsActive, [Status] = I.[Status], LastUpdateTime = @curUnixTime;
		--
		-- Since we support scaling of cvcloud data sources, we might have stale entries after client information for the core changes
		-- Delete such stale entries
		--
		DELETE ST FROM SEIndexServerNodeStats ST, #IndexServerNodeStats I
		WHERE ISNULL(I.DataSourceId, 0) <> 0 AND I.DataSourceId = ST.DataSourceId AND I.SearchServerCoreId <> ST.SearchServerCoreId
		EXEC @result = sp_releaseapplock @Resource = 'SESaveIndexNodeStatInfo'
		if @@ERROR = 0
			COMMIT TRANSACTION
		else
			ROLLBACK TRANSACTION
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		if @@TRANCOUNT > 0
			ROLLBACK TRANSACTION
		SET @errMsg = ERROR_MESSAGE()
		SET @errorCode = ERROR_NUMBER()
	END CATCH
	CX_EXIT:
	IF OBJECT_ID('tempdb.dbo.#IndexServerNodeStats') IS NOT NULL
		DROP TABLE #IndexServerNodeStats
	IF OBJECT_ID('tempdb.dbo.#MultinodeDSIds') IS NOT NULL
		DROP TABLE #MultinodeDSIds
	SET @outputXML = (SELECT @errorCode AS '@errorCode', @errMsg AS '@errLogMessage' FOR XML PATH('DM2ContentIndexing_Error'), TYPE)
	SELECT @outputXML
END
GO

IF EXISTS (select * from GxQscripts where name = 'SESaveIndexNodeStatInfo')
	delete from GxQscripts where name = 'SESaveIndexNodeStatInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SESaveIndexNodeStatInfo')
	delete from GXDBVersions where aliasname = 'SESaveIndexNodeStatInfo'
GO

insert into GXDBVersions values(2, 'SESaveIndexNodeStatInfo',  '00010001000200080000', 'SESaveIndexNodeStatInfo', '00010001000200080000')
GO

