

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEManageConnectionProperty.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: SEManageConnectionProperty <<<'

IF EXISTS (select * from sysobjects where name='SEManageConnectionProperty')
	drop procedure SEManageConnectionProperty
IF EXISTS (select * from GxQscripts where name='SEManageConnectionProperty')
	delete from GxQscripts where name = 'SEManageConnectionProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEManageConnectionProperty')
	delete from GXDBVersions where aliasname = 'SEManageConnectionProperty'
GO
print '... Creating Procedure: SEManageConnectionProperty'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEManageConnectionProperty
  @i_connectionName NVARCHAR(1024),
  @i_userId INT,
  @i_connectionId INT = 0,
  @i_machineName NVARCHAR(1024) = '',
  @i_userName NVARCHAR(1024) = '',
  @i_password NVARCHAR(1024) = '',
  @i_domain NVARCHAR(1024) = '',
  @i_port INT = 0,
  @i_url NVARCHAR(2048) = '',
  @i_attribute INT = 0
AS
	DECLARE @o_connectionId	INT = 0,
			@o_errorCode	INT = 0,
			@o_errorMsg		NVARCHAR(MAX) = ''
	IF(@i_userId <= 0 OR NOT EXISTS (SELECT TOP 1 * FROM UMUsers WITH (NOLOCK) WHERE id = @i_userId))
	BEGIN
		SELECT @o_errorCode = 10551, @o_errorMsg = 'Input userinformation is not valid. UserID ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	IF(ISNULL(@i_connectionName,'') = '')
	BEGIN
		SELECT @o_errorCode = 10603, @o_errorMsg = 'Input connectionname is empty'
		GOTO _EXIT;
	END
	--case there shouldnt be another connection with same connection name for that user
	IF EXISTS( SELECT TOP 1 * FROM SEConnectionProperty WITH (NOLOCK)
				WHERE ( @i_connectionId = 0 OR  ConnPropId != @i_connectionId) AND OwnerUserID = @i_userId AND  ConnName = @i_connectionName)
	BEGIN
		SELECT @o_errorCode = 10604,
				@o_errorMsg = 'Connection name ' + @i_connectionName + ' already exists for user ' + CONVErT(vARCHAR(10),@i_userId)
		GOTO _EXIT;
	END
	IF @i_connectionId > 0
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 * FROM SEConnectionProperty WITH (NOLOCK) WHERE ConnPropId = @i_connectionId)
		BEGIN
			SELECT @o_errorCode = 10601, @o_errorMsg = 'Input connectionId ' + CONVErT(vARCHAR(10),@i_connectionId) + ' doesnt exists'
			GOTO _EXIT;
		END
		--check if user have permission
		IF NOT EXISTS (SELECT TOP 1 * FROM SEConnectionProperty WITH (NOLOCK) WHERE ConnPropId = @i_connectionId AND OwnerUserID = @i_userId)
		BEGIN
			SELECT @o_errorCode = 10602,
					@o_errorMsg = 'Input user ' + CONVErT(vARCHAR(10),@i_userId) +' doesnt have permission on connectionId ' + CONVErT(vARCHAR(10),@i_connectionId)
			GOTO _EXIT;
		END
		--update the entry
		UPDATE SEConnectionProperty SET
			ConnName = @i_connectionName,
			MachineName = @i_machineName,
			UserName = @i_userName,
			Password = @i_password,
			Domain		= @i_domain,
			Port= @i_port,
			URL= @i_url,
			attribute = @i_attribute,
			ModifiedTime = GETUTCDATE()
		WHERE ConnPropId = @i_connectionId
		SELECT @o_connectionId = @i_connectionId
	END
	ELSE
	BEGIN
		--INSERT NEW ENTRY
		INSERT INTO SEConnectionProperty(ConnName,MachineName, UserName, Password, Domain, Port, URL, attribute, OwnerUserID)
		SELECT @i_connectionName, @i_machineName, @i_userName, @i_password, @i_domain, @i_port, @i_url, @i_attribute, @i_userId
		SELECT @o_connectionId = @@IDENTITY
	END
_EXIT:
	SELECT @o_connectionId 'o_connectionId', @o_errorCode 'o_errorCode', @o_errorMsg 'o_errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'SEManageConnectionProperty')
	delete from GxQscripts where name = 'SEManageConnectionProperty'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEManageConnectionProperty')
	delete from GXDBVersions where aliasname = 'SEManageConnectionProperty'
GO

insert into GXDBVersions values(2, 'SEManageConnectionProperty',  '00000000000000000000', 'SEManageConnectionProperty', '00000000000000000000')
GO

