

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetSubClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/SEGetSubClientInfo.sp,v $ $Id: SEGetSubClientInfo.sp,v 1.1.2.11 2020/12/14 23:13:05 sgolla Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='SEGetSubClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetSubClientInfo <<<'
	drop procedure SEGetSubClientInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetSubClientInfo')
	delete from GxQscripts where name = 'SEGetSubClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetSubClientInfo')
	delete from GXDBVersions where aliasname = 'SEGetSubClientInfo'
GO
print '... Creating Procedure: SEGetSubClientInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure SEGetSubClientInfo
  @userId INT,
  @EntityIdList VARCHAR(MAX),
  @EntityType INT
AS
BEGIN
	SET NOCOUNT ON
	--
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	--
	DECLARE @AllData INT = 0
	DECLARE @debug INT = 0
DECLARE	@CLIENT_ENTITY int = 3
DECLARE	@SUBCLIENT_ENTITY int = 7
DECLARE	@BACKUPSET_ENTITY int = 6
DECLARE	@SEA_DATASOURCE_ENTITY int = 132
DECLARE	@CLIENT_GROUP_ENTITY int = 28
	IF (ISNULL(@EntityIdList, '') = 'all')
	BEGIN
		SET @AllData = 1
	END
	--
	-- drop necessary temp tables in case they already exist on this connection
	--
	if object_id('tempdb.dbo.#InputEntities') is not null
		drop table #InputEntities
	if object_id('tempdb.dbo.#InputClientGroups') is not null
		drop table #InputClientGroups
	IF object_id('tempdb.dbo.#AdminClientsOutputTable') is not null
		drop table #AdminClientsOutputTable
	IF object_id('tempdb.dbo.#EndUserClientsOutputTable') is not null
		drop table #EndUserClientsOutputTable
	if object_id('tempdb.dbo.#VSASubClients') is not null
		drop table #VSASubClients
	if object_id('tempdb.dbo.#GlobalSearchAppTypes') is not null
		drop table #GlobalSearchAppTypes
	--
	-- create necessary temp tables
	--
	CREATE TABLE #GlobalSearchAppTypes (AppTypeId INT)
	--
	CREATE TABLE #AdminClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	)
	--
	CREATE INDEX TempAdminIDX_ClientId ON #AdminClientsOutputTable(clientID)
	CREATE INDEX TempAdminIDX_BackupSetId ON #AdminClientsOutputTable(backupsetID)
	CREATE INDEX TempAdminIDX_SubClientId ON #AdminClientsOutputTable(subclientId)
	--
	CREATE TABLE #EndUserClientsOutputTable
	(
		clientID INT,
		appTypeId INT,
		instanceId INT,
		backupsetID INT,
		subclientId INT
	)
	--
	CREATE INDEX TempEndUserIDX_ClientId ON #EndUserClientsOutputTable(clientID)
	CREATE INDEX TempEndUserIDX_BackupSetId ON #EndUserClientsOutputTable(backupsetID)
	CREATE INDEX TempEndUserIDX_SubClientId ON #EndUserClientsOutputTable(subclientId)
	--
	CREATE TABLE #InputEntities (
		entityId INT
	);
	CREATE TABLE #InputClientGroups (
		clientGroupId INT
	);
	CREATE TABLE #VSASubClients
	(
		SubClientId INT,
		ClientId INT
	)
	CREATE INDEX TempIDX_EntityID ON #InputEntities(entityId)
	--
	INSERT INTO #GlobalSearchAppTypes
	SELECT AppTypeId FROM App_AppTypeGroups (NOLOCK) WHERE app = 'File System'
	--global search allowed either on vsa or on server plans storage whose indexing is enabled
	--this table gets us the storage policy ids used by server plans that have Enabled Indexing is turned on
	--
	IF OBJECT_ID('tempdb.dbo.#GlobalSearchStorage') IS NOT NULL  DROP TABLE #GlobalSearchStorage
	CREATE TABLE #GlobalSearchStorage (storagePolicyId INT)
	--
	IF @AllData = 1
	BEGIN
			/* Common logic to get global search enabled storage policies */
			IF OBJECT_ID('tempdb.dbo.#GlobalSearchPlans') IS NOT NULL DROP TABLE #GlobalSearchPlans
			IF OBJECT_ID('tempdb.dbo.#storageRulesTbl') IS NOT NULL DROP TABLE #storageRulesTbl
			CREATE TABLE #GlobalSearchPlans (planid INT)
			CREATE TABLE #storageRulesTbl (planid INT, storageRules XML)
			;WITH CTEGlobalSearchPlans
			as
			(
SELECT ISNULL(dbo.AppPlanGetEntityValueV2(Id, 'Enable Indexing', default), 0) IndexingEnabled, Id as planid FROM APP_Plan(NOLOCK)
			)
			INSERT INTO #GlobalSearchPlans (planid)
			SELECT planid FROM CTEGlobalSearchPlans WHERE IndexingEnabled = 1
			if @debug = 1
			SELECT * FROM #GlobalSearchPlans
			INSERT INTO #storageRulesTbl(planid, storageRules)
SELECT T.planid, dbo.AppPlanGetEntityValueV2(T.planid, 'Storage Rules', default) FROM #GlobalSearchPlans T
			INSERT INTO #GlobalSearchStorage (storagePolicyId)
SELECT dbo.AppPlanGetEntityValueV2(planid, 'Storage policy', default) FROM #GlobalSearchPlans
			UNION
			SELECT Z.ref.value('@storagePolicyId', 'INT') FROM #storageRulesTbl A CROSS APPLY A.storageRules.nodes('/Api_PlanRuleMaps/rules/policy') Z(ref)
			IF OBJECT_ID('tempdb.dbo.#GlobalSearchPlans') IS NOT NULL DROP TABLE #GlobalSearchPlans
			IF OBJECT_ID('tempdb.dbo.#storageRulesTbl') IS NOT NULL DROP TABLE #storageRulesTbl
			/* Common logic end */
	END
if @AllData = 0
BEGIN
	IF @EntityType = @CLIENT_GROUP_ENTITY
	BEGIN
		SET @EntityType = @CLIENT_ENTITY
		INSERT INTO #InputClientGroups (clientGroupId)
		SELECT _ID FROM dbo.SplitIDs(@EntityIdList)
		INSERT INTO #InputEntities (entityId)
		SELECT clientId FROM APP_ClientGroupAssoc CG
		JOIN #InputClientGroups ICG ON CG.clientGroupId= ICG.clientGroupId
	END
	ELSE IF @EntityType = @SEA_DATASOURCE_ENTITY
	BEGIN
		SET @EntityType = @SUBCLIENT_ENTITY
	END
	ELSE
	BEGIN
		INSERT INTO #InputEntities (entityId)
		SELECT _ID FROM dbo.SplitIDs(@EntityIdList)
	END
END
	--
	-- honor privacy and get permitted IDA objects for browse/compliance
	--
EXEC sec_getIDAObjectsForUserWithPrivacy @userId, @CLIENT_ENTITY, 0, 1, '#AdminClientsOutputTable', 1, 0, '13,25'
	--
	-- honor privacy and get permitted IDA objects for end user search
	--
EXEC sec_getIDAObjectsForUserWithPrivacy @userId, @CLIENT_ENTITY, 24, 1, '#EndUserClientsOutputTable', 1, 0
	--
	-- Return end user search permitted sub clients here
	-- For global search return fs sub clients where indexing is enabled along with vsa sub clients
	--
	SELECT DISTINCT A.id AS subclientId
	FROM #EndUserClientsOutputTable AP
	JOIN App_Application A (NOLOCK) ON (AP.clientid = A.clientid AND AP.subclientid = 0 AND AP.backupsetid = 0) OR (AP.subclientid = A.id AND AP.subclientid > 0)
	LEFT JOIN #GlobalSearchAppTypes TP ON A.AppTypeId = TP.AppTypeId
	LEFT JOIN #InputEntities B ON ((@EntityType = @SUBCLIENT_ENTITY AND A.id = b.entityId) OR (@EntityType = @BACKUPSET_ENTITY AND A.backupset = b.entityId) OR (@EntityType = @CLIENT_ENTITY AND A.clientId = b.entityId))
	LEFT JOIN #GlobalSearchStorage G ON G.storagePolicyId = A.dataArchGrpID
WHERE (B.entityId IS NOT NULL OR (@AllData = 1 AND ((TP.AppTypeId IS NOT NULL AND G.storagePolicyId IS NOT NULL) OR a.appTypeId = 106)))
	--
	-- Return admin ( compliance search or browse capability) permitted sub clients here
	--
	SELECT DISTINCT A.Id AS subclientId
	FROM #AdminClientsOutputTable AP
	JOIN App_Application A (NOLOCK) ON (AP.clientid = A.clientid AND AP.subclientid = 0 AND AP.backupsetid = 0) OR (AP.subclientid = A.id)
	LEFT JOIN #GlobalSearchAppTypes TP ON A.AppTypeId = TP.AppTypeId
	LEFT JOIN #InputEntities B ON ((@EntityType = @SUBCLIENT_ENTITY AND A.id = b.entityId) OR (@EntityType = @BACKUPSET_ENTITY AND A.backupset = b.entityId) OR (@EntityType = @CLIENT_ENTITY AND A.clientId = b.entityId))
	LEFT JOIN #GlobalSearchStorage G ON G.storagePolicyId = A.dataArchGrpID
WHERE (B.entityId IS NOT NULL OR (@AllData = 1 AND ((TP.AppTypeId IS NOT NULL AND G.storagePolicyId IS NOT NULL) OR a.appTypeId = 106)))
	--
	-- procedure to return v1 VM ClientIDs analyzed using old FLA style. We have to do this as we don't have any sub client under VM clients
	--
	DECLARE @i_clientIdTbl AS dbo.Identifiers
	--
	INSERT INTO @i_clientIdTbl
	SELECT DISTINCT A.clientId
	FROM #AdminClientsOutputTable A
	LEFT JOIN #InputEntities B ON ((@EntityType = @SUBCLIENT_ENTITY AND A.subclientId = b.entityId) OR (@EntityType = @BACKUPSET_ENTITY AND A.backupsetID = b.entityId) OR (@EntityType = @CLIENT_ENTITY AND A.clientId = b.entityId))
	WHERE (B.entityId IS NOT NULL OR @AllData = 1)
	-- if we are not searching globally for vsa then,
	-- vm group based filtering or hypervisor client based search will need
	-- additional expansion which is done here. This is because in solr index, we have vm's sub client id pushed for v2
	-- hence we will resort to clientid based query for such scenario..
	--
	IF ISNULL(@EntityIdList, '') <> 'all'
	BEGIN
		INSERT INTO #VSASubClients (SubClientId, ClientId)
		SELECT A.Id, A.clientId FROM APP_Application A
		INNER JOIN APP_InstanceProp I ON I.componentNameId = A.instance AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
WHERE A.appTypeId = 106
		DECLARE @i_xmlV2VSA XML
		IF @EntityType = @SUBCLIENT_ENTITY
		BEGIN
			SET @i_xmlV2VSA = (SELECT B.SubClientId '@subclientId' FROM #InputEntities A JOIN #VSASubClients B ON A.entityId = B.SubClientId  FOR XML PATH('entity'), ROOT('App_Associations'))
		END
		ELSE IF @EntityType = @CLIENT_ENTITY
		BEGIN
			SET @i_xmlV2VSA = (SELECT B.SubClientId '@subclientId' FROM #InputEntities A JOIN #VSASubClients B ON A.entityId = B.ClientId FOR XML PATH('entity'), ROOT('App_Associations'))
		END
		INSERT INTO @i_clientIdTbl
		SELECT DISTINCT a.clientId from dbo.scgV2VSADiscoveredClients('=', @i_xmlV2VSA, 0, 0) A JOIN #AdminClientsOutputTable B ON A.clientID = B.clientID
	END
	--
	exec DM2DetermineVSAClients @i_clientIdTbl
	--
	-- clean up temp tables
	--
	if object_id('tempdb.dbo.#InputEntities') is not null
		DROP TABLE #InputEntities
	if object_id('tempdb.dbo.#InputClientGroups') is not null
		DROP TABLE #InputClientGroups
	IF object_id('tempdb.dbo.#AdminClientsOutputTable') is not null
		drop table #AdminClientsOutputTable
	IF object_id('tempdb.dbo.#EndUserClientsOutputTable') is not null
		drop table #EndUserClientsOutputTable
	if object_id('tempdb.dbo.#VSASubClients') is not null
		drop table #VSASubClients
	if object_id('tempdb.dbo.#GlobalSearchStorage') is not null
		drop table #GlobalSearchStorage
	if object_id('tempdb.dbo.#GlobalSearchAppTypes') is not null
		drop table #GlobalSearchAppTypes
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetSubClientInfo')
	delete from GxQscripts where name = 'SEGetSubClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetSubClientInfo')
	delete from GXDBVersions where aliasname = 'SEGetSubClientInfo'
GO

insert into GXDBVersions values(2, 'SEGetSubClientInfo',  '00010001000200110000', 'SEGetSubClientInfo', '00010001000200110000')
GO

