

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/SEGetReportSearchInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='SEGetReportSearchInfo')
BEGIN
	print '>>> Drop Stored Procedure: SEGetReportSearchInfo <<<'
	drop procedure SEGetReportSearchInfo
END
IF EXISTS (select * from GxQscripts where name='SEGetReportSearchInfo')
	delete from GxQscripts where name = 'SEGetReportSearchInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetReportSearchInfo')
	delete from GXDBVersions where aliasname = 'SEGetReportSearchInfo'
GO
print '... Creating Procedure: SEGetReportSearchInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure SEGetReportSearchInfo
  @i_userId integer,
  @i_permissionIds NVARCHAR(64),
  @i_entityType INTEGER,
  @i_reportType NVARCHAR(64),
  @i_entityId NVARCHAR(8),
  @i_nodeClientId INTEGER=0,
  @o_ErrorCode VARCHAR(8) output,
  @o_ErrorMsg VARCHAR(128) output 
AS
BEGIN
IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
BEGIN
	DROP TABLE #permissionIdTable
END
IF OBJECT_ID('tempdb.dbo.#tempReportPermTable') IS NOT NULL
BEGIN
	DROP TABLE #tempReportPermTable
END
CREATE TABLE #tempReportPermTable(
	entityId INTEGER,
	permissionId INTEGER
);
CREATE TABLE #permissionIdTable(
	permissionId INTEGER
);
DECLARE @coreName NVARCHAR(64)
SET @o_ErrorCode=0
INSERT INTO #permissionIdTable
SELECT * FROM dbo.SplitIDs(@i_permissionIds)
--get all entities on which user has permission
INSERT INTO #tempReportPermTable exec [dbo].[sec_getObjectsWithPermissionsV2] @i_userID,@i_entityType,1
DECLARE @entityId INTEGER
DECLARE @CNT INT
IF @i_entityId='*' OR @i_entityId='ALL'
BEGIN
	SET @entityId=0
END
ELSE IF @i_entityId=''
BEGIN
	SET @entityId=-1
END
ELSE
BEGIN
	SET @entityId=cast(@i_entityId AS INTEGER)
END
IF (@i_reportType='IndexServerInfo') OR (@i_reportType='ComplianceAudit')
	BEGIN
        IF OBJECT_ID('tempdb.dbo.#tempReportDataTable') IS NOT NULL
			BEGIN
				DROP TABLE #tempReportDataTable
			END
		CREATE TABLE #tempReportDataTable(
			CloudID INTEGER,
			ClientId INTEGER,
			CoreName NVARCHAR(64),
			SolrUrl NVARCHAR(255)
		)
		IF (@i_reportType='IndexServerInfo')
		BEGIN
			SET @coreName='indexserverinfo'
		END
		ELSE IF (@i_reportType='ComplianceAudit')
		BEGIN
			SET @coreName='complianceaudit'
		END
		INSERT INTO #tempReportDataTable(CloudID, ClientId,CoreName, SolrUrl)
		(SELECT DMC.cloudId, DMSC.ClientId,@coreName, 'http://'+ AC.net_hostname + ':' + CAST(DMSC.Portno AS nvarchar(20)) FROM DM2Cloud DMC WITH(NOLOCK)
INNER JOIN DM2SearchServerCoreInfo DMSC WITH (NOLOCK) ON ((DMC.cloudId = DMSC.CloudId) AND (DMC.CloudType = 1 ) AND (@i_nodeClientId = 0 OR DMSC.ClientId = @i_nodeClientId))
		 INNER JOIN APP_Client AC WITH (NOLOCK) ON AC.id = DMSC.ClientId
		 INNER JOIN #tempReportPermTable TRP WITH (NOLOCK) ON ((TRP.entityId = DMC.pseudoClientId) AND (@entityId = 0 OR TRP.entityId = @entityId))
		)
        SELECT @CNT=count(*) FROM #tempReportDataTable
		IF @CNT=0
			BEGIN
				SET @o_ErrorCode=1001
				SET @o_ErrorMsg='Invalid Input'
			END
		SELECT * FROM #tempReportDataTable
	END
IF (@i_reportType='DownloadCenter')
	BEGIN
		SET @CNT=0
		SELECT @CNT=count(*) from #tempReportPermTable as TRP WITH (NOLOCK) WHERE  TRP.entityId=@i_entityId
		IF @CNT > 0
			BEGIN
				IF OBJECT_ID('tempdb.dbo.#tempTableForDc') IS NOT NULL
					BEGIN
						DROP TABLE #permissionIdTable
					END
				SET @coreName='downloadcenteraudit'
				create table #tempTableForDc
						(   serverURL NVARCHAR(512),
							clientId INT,
							clientName NVARCHAR(256),
							cloudId INT,
							hostName NVARCHAR(256),
							basePort INT,
							version NVARCHAR(256),
							engineName  NVARCHAR(256),
							context NVARCHAR(256)
						)
				INSERT INTO #tempTableForDc(serverURL,clientId,clientName,cloudId,hostName,baseport,version,engineName,context)  exec DCGetSearchServer
				SELECT @CNT=count(*) FROM #tempTableForDc
				IF @CNT=0
					BEGIN
						SET @o_ErrorCode=1001
						SET @o_ErrorMsg='Invalid Input'
					END
				SELECT TTDC.clientId as ClientId,TTDC.cloudId as CloudID,TTDC.serverURL as SolrUrl,@coreName as CoreName from #tempTableForDc as TTDC WITH (NOLOCK)
			END
		ELSE
			BEGIN
				SET @o_ErrorCode=11504
				SET @o_ErrorMsg='Insufficient User Permission'
			END
	END
IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
BEGIN
	DROP TABLE #permissionIdTable
END
IF OBJECT_ID('tempdb.dbo.#tempReportPermTable') IS NOT NULL
BEGIN
	DROP TABLE #tempReportPermTable
END
IF OBJECT_ID('tempdb.dbo.#tempReportDataTable') IS NOT NULL
BEGIN
	DROP TABLE #tempReportDataTable
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'SEGetReportSearchInfo')
	delete from GxQscripts where name = 'SEGetReportSearchInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='SEGetReportSearchInfo')
	delete from GXDBVersions where aliasname = 'SEGetReportSearchInfo'
GO

insert into GXDBVersions values(2, 'SEGetReportSearchInfo',  '00000000000000000000', 'SEGetReportSearchInfo', '00000000000000000000')
GO

